/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.XMLMergeRow;
import org.ttzero.excel.reader.XMLSheet;

class XMLMergeSheet
extends XMLSheet
implements MergeSheet {
    private Grid mergeCells;
    boolean ready;
    List<Dimension> dimensions;

    XMLMergeSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
        this.id = sheet.id;
        this.startRow = sheet.startRow;
        this.header = sheet.header;
        this.hidden = sheet.hidden;
        this.dimension = sheet.dimension;
        this.drawings = sheet.drawings;
        this.reader = sheet.reader;
        this.cb = sheet.cb;
        this.nChar = sheet.nChar;
        this.length = sheet.length;
        this.eof = sheet.eof;
        this.heof = sheet.heof;
        this.mark = sheet.mark;
        this.sRow = sheet.sRow;
        this.lastRowMark = sheet.lastRowMark;
        this.zipFile = sheet.zipFile;
        this.entry = sheet.entry;
        this.hrf = sheet.hrf;
        this.hrl = sheet.hrl;
        this.option = sheet.option;
        if (this.path != null && this.reader != null && !this.ready) {
            this.load0();
        }
    }

    @Override
    public XMLMergeSheet load() throws IOException {
        super.load();
        this.load0();
        return this;
    }

    void load0() {
        if (this.ready) {
            return;
        }
        if (this.mergeCells == null && !this.eof) {
            List<Dimension> mergeCells = this.parseMerge();
            if (mergeCells != null && !mergeCells.isEmpty()) {
                this.mergeCells = GridFactory.create(mergeCells);
                this.LOGGER.debug("Grid: {} ===> Size: {}", this.mergeCells.getClass(), (Object)this.mergeCells.size());
                this.dimensions = mergeCells;
            } else {
                this.dimensions = Collections.emptyList();
            }
        }
        if (!this.eof && !(this.sRow instanceof XMLMergeRow) && this.mergeCells != null) {
            this.sRow = this.sRow.asMergeRow().setCopyValueFunc(this.mergeCells, this::mergeCell);
        }
        this.ready = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    List<Dimension> parseMerge() {
        ArrayList<Dimension> list = null;
        try (InputStream is = this.zipFile.getInputStream(this.entry);){
            int n;
            if (this.lastRowMark > 0L) {
                is.skip(this.lastRowMark);
            }
            int offset = 0;
            int limit = 16384;
            byte[] buf = new byte[limit];
            while ((n = is.read(buf, offset, limit - offset)) > 0) {
                int len = n + offset;
                if (len < 11) {
                    offset = len;
                    continue;
                }
                int i = 0;
                --len;
                while (i < len && (buf[i++] != 60 || buf[i] != 109)) {
                }
                if (i >= len) {
                    if (buf[i] == 60) {
                        buf[0] = 60;
                        offset = 1;
                        continue;
                    }
                    if (buf[i - 1] == 60 && buf[i] == 109) {
                        buf[0] = 60;
                        buf[1] = 109;
                        offset = 2;
                        continue;
                    }
                    offset = 0;
                    continue;
                }
                if (++len - i < 11) {
                    offset = len - i;
                    System.arraycopy(buf, i, buf, 0, offset);
                    n = is.read(buf, offset, limit - offset);
                    if (n <= 0) {
                        List<Dimension> list2 = null;
                        return list2;
                    }
                    len = n + offset;
                    if (len < 11) {
                        while ((n = is.read(buf, offset, limit - offset)) > 0 && (len = n + offset) < 11) {
                            offset = len;
                        }
                    }
                    i = 0;
                }
                if (len < 11 || buf[i] != 109 || buf[i + 1] != 101 || buf[i + 2] != 114 || buf[i + 3] != 103 || buf[i + 4] != 101 || buf[i + 5] != 67 || buf[i + 6] != 101 || buf[i + 7] != 108 || buf[i + 8] != 108 || buf[i + 9] != 115 || buf[i + 10] > 32) {
                    List<Dimension> list3 = null;
                    return list3;
                }
                i += 11;
                n = len;
                list = new ArrayList<Dimension>();
                do {
                    if (n < 11) {
                        offset += n;
                        continue;
                    }
                    while (true) {
                        if (i < n - 11 && (buf[i] != 60 || buf[i + 1] != 109 || buf[i + 2] != 101 || buf[i + 3] != 114 || buf[i + 4] != 103 || buf[i + 5] != 101 || buf[i + 6] != 67 || buf[i + 7] != 101 || buf[i + 8] != 108 || buf[i + 9] != 108 || buf[i + 10] > 32)) {
                            ++i;
                            continue;
                        }
                        if (i >= n - 11) {
                            offset = n - i;
                            System.arraycopy(buf, i, buf, 0, offset);
                            break;
                        }
                        int t = i;
                        i += 11;
                        while (i < n - 5 && (buf[i] != 114 || buf[i + 1] != 101 || buf[i + 2] != 102 || buf[i + 3] != 61 || buf[i + 4] != 34)) {
                            ++i;
                        }
                        if (i >= n - 5) {
                            offset = n - t;
                            System.arraycopy(buf, t, buf, 0, offset);
                            break;
                        }
                        int f = i += 5;
                        while (i < n && buf[i] != 34) {
                            ++i;
                        }
                        if (i >= n) {
                            offset = n - t;
                            System.arraycopy(buf, t, buf, 0, offset);
                            break;
                        }
                        list.add(Dimension.of(new String(buf, f, i - f, StandardCharsets.US_ASCII)));
                    }
                    i = 0;
                } while ((n = is.read(buf, offset, limit - offset)) > 0 && (n += offset) > 0);
            }
            return list;
        }
        catch (IOException e) {
            this.LOGGER.warn("", (Throwable)e);
        }
        return list;
    }

    private void mergeCell(int row, Cell cell) {
        this.mergeCells.merge(row, cell);
    }

    @Override
    public Grid getMergeGrid() {
        return this.mergeCells;
    }

    @Override
    public List<Dimension> getMergeCells() {
        return this.dimensions != null ? this.dimensions : (this.dimensions = this.parseMerge());
    }
}

