/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.RowSetIterator;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLCalcRow;
import org.ttzero.excel.reader.XMLCalcSheet;
import org.ttzero.excel.reader.XMLMergeRow;
import org.ttzero.excel.reader.XMLMergeSheet;
import org.ttzero.excel.reader.XMLRow;

public class XMLSheet
implements Sheet {
    final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected String name;
    protected int index;
    protected String path;
    protected int id;
    protected SharedStrings sst;
    protected Styles styles;
    protected int startRow = -1;
    protected HeaderRow header;
    protected boolean hidden;
    protected Dimension dimension;
    protected Drawings drawings;
    protected int hrf;
    protected int hrl;
    protected ZipFile zipFile;
    protected ZipEntry entry;
    protected int option;
    protected Reader reader;
    protected char[] cb;
    protected int nChar;
    protected int length;
    protected boolean eof = false;
    protected boolean heof = false;
    protected long mark;
    protected XMLRow sRow;
    protected long lastRowMark;

    public XMLSheet() {
    }

    public XMLSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
        this.id = sheet.id;
        this.startRow = sheet.startRow;
        this.header = sheet.header;
        this.hidden = sheet.hidden;
        this.dimension = sheet.dimension;
        this.drawings = sheet.drawings;
        this.reader = sheet.reader;
        this.cb = sheet.cb;
        this.nChar = sheet.nChar;
        this.length = sheet.length;
        this.eof = sheet.eof;
        this.heof = sheet.heof;
        this.mark = sheet.mark;
        this.sRow = sheet.sRow instanceof XMLMergeRow || sheet.sRow instanceof XMLCalcRow ? this.createRow().init(this.sst, this.styles, this.startRow) : sheet.sRow;
        this.lastRowMark = sheet.lastRowMark;
        this.hrf = sheet.hrf;
        this.hrl = sheet.hrl;
        this.zipFile = sheet.zipFile;
        this.entry = sheet.entry;
        this.option = sheet.option;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    protected void setZipEntry(ZipEntry entry) {
        this.entry = entry;
    }

    protected void setSst(SharedStrings sst) {
        this.sst = sst;
    }

    protected void setStyles(Styles styles) {
        this.styles = styles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setDrawings(Drawings drawings) {
        this.drawings = drawings;
    }

    @Override
    @Deprecated
    public int getSize() {
        Dimension d = this.getDimension();
        return d != null ? d.lastRow - d.firstRow + 1 : -1;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension != null ? this.dimension : (this.dimension = this.parseDimension());
    }

    public int getFirstRow() {
        return this.startRow;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Sheet header(int fromRowNum, int toRowNum) {
        XMLSheet.rangeCheck(fromRowNum, toRowNum);
        this.hrf = fromRowNum;
        this.hrl = toRowNum;
        return this;
    }

    XMLSheet setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public Row getHeader() {
        if (this.header == null && !this.heof) {
            Row row;
            Row row2 = row = this.hrf == 0 ? this.findRow0(this::createHeader) : this.getHeader(this.hrf, this.hrl);
            if (row != null) {
                this.header = row instanceof HeaderRow ? (HeaderRow)row : row.asHeader();
                this.header.setOptions(this.option << 16 >>> 16);
                this.sRow.setHr(this.header);
            }
        } else if (this.hrl > 0 && this.hrl > this.sRow.getRowNum()) {
            Row row0 = this.findRow0(this::createHeader);
            if (row0 != null && row0.getRowNum() < this.hrl) {
                XMLRow row = this.nextRow();
                while (row != null && ((Row)row).getRowNum() < this.hrl) {
                    row = this.nextRow();
                }
            }
            if (this.sRow != null && this.sRow.hr != this.header) {
                this.sRow.setHr(this.header);
            }
        }
        return this.header;
    }

    protected Row getHeader(int fromRowNum, int toRowNum) {
        HeaderRow headerRow;
        if (this.header != null || this.eof) {
            return this.header;
        }
        XMLSheet.rangeCheck(fromRowNum, toRowNum);
        if (this.sRow.getRowNum() > -1 && fromRowNum < this.sRow.getRowNum()) {
            throw new IndexOutOfBoundsException("Current row num " + this.sRow.getRowNum() + " is great than fromRowNum " + fromRowNum + ". Use Sheet#reset() to reset cursor.");
        }
        if (toRowNum - fromRowNum > 0) {
            Row[] rows = new Row[toRowNum - fromRowNum + 1];
            int i = 0;
            int lc = -1;
            boolean changeLc = false;
            Object row = this.nextRow();
            while (row != null) {
                if (((Row)row).getRowNum() >= fromRowNum) {
                    if (((Row)row).lc > lc) {
                        lc = ((Row)row).lc;
                        if (i > 0) {
                            changeLc = true;
                        }
                    }
                    Row r = new Row(){};
                    r.fc = ((Row)row).fc;
                    r.lc = ((Row)row).lc;
                    r.index = ((Row)row).getRowNum();
                    r.sst = ((Row)row).sst;
                    r.cells = ((Row)row).copyCells();
                    rows[i++] = r;
                }
                if (((Row)row).getRowNum() >= toRowNum) break;
                row = this.nextRow();
            }
            if (changeLc) {
                for (Row row2 : rows) {
                    row2.lc = lc;
                    row2.cells = row2.copyCells(lc);
                }
            }
            if (i > 0) {
                List<Dimension> mergeCells;
                if (!(this instanceof MergeSheet)) {
                    XMLMergeSheet tmp = new XMLSheet(this).asMergeSheet();
                    tmp.reader = null;
                    mergeCells = tmp.parseMerge();
                } else {
                    mergeCells = ((MergeSheet)((Object)this)).getMergeCells();
                }
                if (mergeCells != null) {
                    mergeCells = mergeCells.stream().filter(dim -> dim.firstRow < toRowNum || dim.lastRow > fromRowNum).collect(Collectors.toList());
                }
                headerRow = new HeaderRow().with(mergeCells, rows).setOptions(this.option << 16 >>> 16);
            } else {
                headerRow = new HeaderRow().setOptions(this.option << 16 >>> 16);
            }
        } else {
            XMLRow row = this.nextRow();
            while (row != null && ((Row)row).getRowNum() < fromRowNum) {
                row = this.nextRow();
            }
            headerRow = row != null ? new HeaderRow().with(row).setOptions(this.option << 16 >>> 16) : new HeaderRow().setOptions(this.option << 16 >>> 16);
        }
        headerRow.styles = this.styles;
        return headerRow;
    }

    static void rangeCheck(int fromRowNum, int toRowNum) {
        if (fromRowNum <= 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromRowNum);
        }
        if (fromRowNum > toRowNum) {
            throw new IllegalArgumentException("fromIndex(" + fromRowNum + ") > toIndex(" + toRowNum + ")");
        }
    }

    @Override
    public XMLSheet bind(Class<?> clazz) {
        if (this.getHeader() != null) {
            try {
                this.header.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelReadException(e);
            }
        }
        return this;
    }

    @Override
    public Sheet bind(Class<?> clazz, Row row) {
        if (row == null) {
            throw new IllegalArgumentException("Specify the bind row must not be null.");
        }
        if (!row.equals(this.header)) {
            this.header = row instanceof HeaderRow ? (HeaderRow)row : row.asHeader();
            this.header.setOptions(this.option << 16 >>> 16);
            this.sRow.setHr(this.header);
        }
        try {
            this.header.setClassOnce(clazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExcelReadException(e);
        }
        return this;
    }

    public String toString() {
        return "Sheet id: " + this.getId() + ", name: " + this.getName();
    }

    @Override
    public XMLSheet load() throws IOException {
        if (this.sRow != null) {
            this.reset();
            return this;
        }
        this.LOGGER.debug("Load {}", (Object)this.path);
        this.reader = new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8);
        this.cb = new char[8192];
        this.nChar = 0;
        int left = 0;
        block0: while (true) {
            this.length = this.reader.read(this.cb, left, this.cb.length - left);
            if (this.length < 11) break;
            if (this.nChar == 0 && this.startRow < 1) {
                int end;
                String line = new String(this.cb, 56, 1024);
                String size = "<dimension ref=\"";
                int index = line.indexOf(size);
                int n = end = index > 0 ? line.indexOf(34, index += size.length()) : -1;
                if (end > 0) {
                    String l_ = line.substring(index, end);
                    Pattern pat = Pattern.compile("([A-Z]+)(\\d+):([A-Z]+)(\\d+)");
                    Matcher mat = pat.matcher(l_);
                    if (mat.matches()) {
                        this.dimension = Dimension.of(l_);
                        this.startRow = this.dimension.firstRow;
                    } else {
                        pat = Pattern.compile("([A-Z]+)(\\d+)");
                        mat = pat.matcher(l_);
                        if (mat.matches()) {
                            this.startRow = Integer.parseInt(mat.group(2));
                        }
                    }
                    this.nChar += end;
                }
            }
            int len = this.length - 12;
            while (this.nChar < len) {
                if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == 's' && this.cb[this.nChar + 2] == 'h' && this.cb[this.nChar + 3] == 'e' && this.cb[this.nChar + 4] == 'e' && this.cb[this.nChar + 5] == 't' && this.cb[this.nChar + 6] == 'D' && this.cb[this.nChar + 7] == 'a' && this.cb[this.nChar + 8] == 't' && this.cb[this.nChar + 9] == 'a' && (this.cb[this.nChar + 10] == '>' || this.cb[this.nChar + 10] == '/' && this.cb[this.nChar + 11] == '>')) {
                    this.nChar += 11;
                    break block0;
                }
                ++this.nChar;
            }
            left = this.nChar;
            while (left > 0 && this.cb[left--] != '>') {
            }
            if (left <= 0) continue;
            System.arraycopy(this.cb, left, this.cb, 0, this.length - left);
            this.mark += (long)this.nChar;
            this.nChar = 0;
        }
        if (this.cb[this.nChar] == '>') {
            this.mark += (long)this.length;
            this.eof = true;
            if (this.dimension == null) {
                this.dimension = new Dimension(1, 1);
            }
        } else {
            this.eof = false;
            this.mark += (long)this.nChar;
            this.sRow = this.createRow().init(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1);
        }
        if (this.dimension != null) {
            this.LOGGER.debug("Dimension-Range: {}", (Object)this.dimension);
        }
        return this;
    }

    private XMLRow nextRow() {
        if (this.eof) {
            return null;
        }
        boolean endTag = false;
        int start = this.nChar;
        while (++this.nChar < this.length && this.cb[this.nChar] != '>') {
        }
        if (this.cb[this.nChar++ - 1] == '/') {
            return this.sRow.empty(this.cb, start, this.nChar - start);
        }
        while (this.nChar < this.length - 6) {
            if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == '/' && this.cb[this.nChar + 2] == 'r' && this.cb[this.nChar + 3] == 'o' && this.cb[this.nChar + 4] == 'w' && this.cb[this.nChar + 5] == '>') {
                this.nChar += 6;
                endTag = true;
                break;
            }
            ++this.nChar;
        }
        if (!endTag) {
            int n;
            if (start == 0) {
                char[] _cb = new char[this.cb.length << 1];
                n = this.length - start;
                System.arraycopy(this.cb, start, _cb, 0, n);
                this.cb = _cb;
            } else {
                n = this.length - start;
                System.arraycopy(this.cb, start, this.cb, 0, n);
            }
            try {
                this.length = this.reader.read(this.cb, n, this.cb.length - n);
                if (this.length < 0) {
                    this.eof = true;
                    this.reader.close();
                    this.reader = null;
                    this.LOGGER.debug("end of file.");
                    if (this.dimension == null) {
                        this.dimension = new Dimension(1, (short)Math.max(this.sRow.fc, 1), Math.max(this.sRow.getRowNum(), 1), (short)Math.max(this.sRow.lc, 1));
                    }
                    return null;
                }
            }
            catch (IOException e) {
                throw new ExcelReadException("Parse row data error", e);
            }
            this.nChar = 0;
            this.length += n;
            return this.nextRow();
        }
        return this.sRow.with(this.cb, start, this.nChar - start);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Row findRow0(HeaderRowFunc func) {
        char[] cb = new char[8192];
        int nChar = 0;
        try (InputStreamReader reader = new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8);){
            Row row;
            block35: {
                int start;
                block34: {
                    boolean eof;
                    int length;
                    if (this.mark > 0L) {
                        reader.skip(this.mark);
                        length = reader.read(cb);
                    } else {
                        block19: while (true) {
                            length = reader.read(cb);
                            while (true) {
                                if (nChar >= length - 12) continue block19;
                                if (cb[nChar] == '<' && cb[nChar + 1] == 's' && cb[nChar + 2] == 'h' && cb[nChar + 3] == 'e' && cb[nChar + 4] == 'e' && cb[nChar + 5] == 't' && cb[nChar + 6] == 'D' && cb[nChar + 7] == 'a' && cb[nChar + 8] == 't' && cb[nChar + 9] == 'a' && (cb[nChar + 10] == '>' || cb[nChar + 10] == '/' && cb[nChar + 11] == '>')) {
                                    nChar += 11;
                                    break block19;
                                }
                                ++nChar;
                            }
                            break;
                        }
                    }
                    boolean bl = eof = length <= 0 || cb[nChar] == '>';
                    if (eof) {
                        this.heof = true;
                        Row row2 = null;
                        return row2;
                    }
                    start = nChar;
                    while (true) {
                        if (nChar < length - 6) {
                            if (cb[nChar] == '<' && cb[nChar + 1] == '/' && cb[nChar + 2] == 'r' && cb[nChar + 3] == 'o' && cb[nChar + 4] == 'w' && cb[nChar + 5] == '>') {
                                nChar += 6;
                                if (func != null) {
                                    break;
                                }
                                break block34;
                            } else {
                                ++nChar;
                                continue;
                            }
                        }
                        char[] _cb = new char[cb.length << 1];
                        int n = length - start;
                        System.arraycopy(cb, start, _cb, 0, n);
                        cb = _cb;
                        try {
                            length = ((Reader)reader).read(cb, n, cb.length - n);
                            if (length < 0) {
                                ((Reader)reader).close();
                                Row row3 = null;
                                return row3;
                            }
                        }
                        catch (IOException e) {
                            throw new ExcelReadException("Parse row data error", e);
                        }
                        start = 0;
                        length += n;
                    }
                    row = func.accept(cb, start, nChar - start);
                    break block35;
                }
                row = this.createHeader(cb, start, nChar - start);
            }
            Row row4 = row;
            return row4;
        }
        catch (IOException e) {
            this.LOGGER.error("Read header row error.");
            return null;
        }
    }

    @Override
    public Iterator<Row> iterator() {
        if (this.hrf > 0) {
            this.getHeader();
        }
        return new RowSetIterator(this::nextRow);
    }

    @Override
    public Iterator<Row> dataIterator() {
        if (this.hrf > 0) {
            this.getHeader();
        }
        RowSetIterator.NonBlankIterator nIter = new RowSetIterator.NonBlankIterator(this::nextRow);
        if (this.hrf == 0 && nIter.hasNext()) {
            Row row = (Row)nIter.next();
            if (this.header == null) {
                this.header = row.asHeader().setOptions(this.option << 16 >>> 16);
            }
            row.setHr(this.header);
        }
        return nIter;
    }

    @Override
    public List<Drawings.Picture> listPictures() {
        return this.drawings != null ? this.drawings.listPictures(this) : null;
    }

    @Override
    public void close() throws IOException {
        this.cb = null;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public Sheet setHeaderColumnReadOption(int option) {
        if (option >= 131072) {
            this.LOGGER.warn("Unrecognized options will be discarded");
        }
        int o = option & 0x1FFFF;
        this.option = this.option >>> 16 << 16 | o;
        if (this.header != null) {
            this.header.setOptions(o);
        }
        return this;
    }

    @Override
    public int getHeaderColumnReadOption() {
        return this.header != null ? this.header.option : this.option << 16 >>> 16;
    }

    @Override
    public XMLSheet reset() {
        this.LOGGER.debug("Reset {}", (Object)this.path);
        try {
            this.hrf = 0;
            this.hrl = 0;
            this.header = null;
            this.sRow.fc = 0;
            this.sRow.lc = -1;
            this.sRow.index = -1;
            this.sRow.from = this.sRow.to;
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.cb == null) {
                this.sRow = null;
                return this.load();
            }
            this.reader = new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8);
            this.reader.skip(this.mark);
            this.length = this.reader.read(this.cb);
            this.nChar = 0;
            this.eof = this.length <= 0;
        }
        catch (IOException e) {
            throw new ExcelReadException("Reset worksheet[" + this.getName() + "] error occur.", e);
        }
        return this;
    }

    @Override
    public XMLRow createRow() {
        return new XMLRow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Dimension parseDimension() {
        try (InputStream is = this.zipFile.getInputStream(this.entry);){
            int n;
            if (this.lastRowMark > 0L) {
                is.skip(this.lastRowMark);
            }
            long mark = 0L;
            long mark0 = 0L;
            int offset = 0;
            int limit = 16384;
            int size = 0;
            byte[] buf = new byte[limit];
            byte[] bytes = new byte[10];
            while ((n = is.read(buf, offset, limit - offset)) > 0) {
                mark += (long)n;
                int len = n + offset;
                if (len < 11) {
                    offset = len;
                    continue;
                }
                int i = len - 1;
                while (i > 1 && (buf[i--] != 32 || buf[i--] != 99 || buf[i] != 60)) {
                }
                if (i <= 1 && (buf[i] != 60 || buf[i + 1] != 99)) {
                    offset = 0;
                    continue;
                }
                if (i <= len - 9) {
                    n = i;
                    i += 3;
                    while (i < len && buf[i] != 114 && buf[i + 1] != 61 && buf[i + 2] != 34) {
                        ++i;
                    }
                    if (i < len - 3) {
                        int f = i += 3;
                        while (i < len && buf[i] != 34) {
                            ++i;
                        }
                        if (i < len) {
                            size = i - f;
                            System.arraycopy(buf, f, bytes, 0, size);
                            if (buf[len - 1] == 60) {
                                buf[0] = 60;
                                offset = 1;
                            } else {
                                offset = 0;
                            }
                            mark0 = mark - (long)(len - n);
                            continue;
                        }
                    }
                    i = n;
                }
                if (i >= len) continue;
                offset = len - i;
                System.arraycopy(buf, i, buf, 0, offset);
            }
            if (this.lastRowMark < mark0) {
                this.lastRowMark = mark0;
            }
            if (size <= 0) return Dimension.of("A1");
            long cr = ExcelReader.cellRangeToLong(new String(bytes, 0, size, StandardCharsets.US_ASCII));
            Dimension dimension = new Dimension(1, 1, (int)(cr >> 16), (short)(cr & 0x7FFFL));
            return dimension;
        }
        catch (IOException e) {
            this.LOGGER.warn("", (Throwable)e);
        }
        return Dimension.of("A1");
    }

    Row createHeader(char[] cb, int start, int n) {
        return this.createRow().init(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1).with(cb, start, n);
    }

    @Override
    public XMLSheet asSheet() {
        return this instanceof XMLCalcSheet || this instanceof XMLMergeSheet ? new XMLSheet(this) : this;
    }

    @Override
    public XMLCalcSheet asCalcSheet() {
        return !(this instanceof XMLCalcSheet) ? new XMLCalcSheet(this) : (XMLCalcSheet)this;
    }

    @Override
    public XMLMergeSheet asMergeSheet() {
        return !(this instanceof XMLMergeSheet) ? new XMLMergeSheet(this) : (XMLMergeSheet)this;
    }

    static interface HeaderRowFunc {
        public Row accept(char[] var1, int var2, int var3);
    }
}

