/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.TimeZone;

public class DateUtil {
    public static final int DAYS_1900_TO_1970 = ~((int)LocalDate.of(1900, 1, 1).toEpochDay()) + 3;
    public static final double SECOND_OF_DAY = 86400.0;
    public static final int tz = TimeZone.getDefault().getRawOffset();
    public static final ThreadLocal<SimpleDateFormat> utcDateTimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"));
    public static final ThreadLocal<SimpleDateFormat> dateTimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    public static final ThreadLocal<SimpleDateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    public static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();

    public static String toString(Date date) {
        return dateTimeFormat.get().format(date);
    }

    public static String toTString(Date date) {
        return utcDateTimeFormat.get().format(date);
    }

    public static String toDateString(Date date) {
        return dateFormat.get().format(date);
    }

    public static String today() {
        return LocalDate.now().toString();
    }

    private DateUtil() {
    }

    public static double toDateTimeValue(Timestamp ts) {
        LocalDateTime ldt = ts.toLocalDateTime();
        long day = ldt.toLocalDate().toEpochDay();
        int second = ldt.toLocalTime().toSecondOfDay();
        return (double)second / 86400.0 + (double)day + (double)DAYS_1900_TO_1970;
    }

    public static double toDateTimeValue(Date date) {
        return DateUtil.toDateTimeValue(new Timestamp(date.getTime()));
    }

    public static int toDateValue(Date date) {
        int n = date instanceof java.sql.Date ? (int)LocalDate.parse(DateUtil.toDateString(date)).toEpochDay() + DAYS_1900_TO_1970 : (int)date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate().toEpochDay() + DAYS_1900_TO_1970;
        return n;
    }

    public static double toTimeValue(Timestamp ts) {
        return DateUtil.toTimeValue(ts.toLocalDateTime().toLocalTime());
    }

    public static double toTimeValue(Date date) {
        return DateUtil.toTimeValue(new Timestamp(date.getTime()));
    }

    public static double toTimeValue(Time time) {
        return DateUtil.toTimeValue(time.toLocalTime());
    }

    public static double toDateTimeValue(LocalDateTime ldt) {
        long day = ldt.toLocalDate().toEpochDay();
        int second = ldt.toLocalTime().toSecondOfDay();
        return (double)second / 86400.0 + (double)day + (double)DAYS_1900_TO_1970;
    }

    public static int toDateValue(LocalDate date) {
        return (int)date.toEpochDay() + DAYS_1900_TO_1970;
    }

    public static double toTimeValue(LocalTime time) {
        return (double)time.toSecondOfDay() / 86400.0;
    }

    public static Date toDate(int n) {
        return Date.from(Instant.ofEpochSecond((long)(n - DAYS_1900_TO_1970) * 86400L).minusMillis(tz));
    }

    public static Date toDate(double d) {
        int n = (int)d;
        int m = (int)((d - (double)n) * 86400.0 + 0.5);
        return Date.from(Instant.ofEpochSecond((long)(n - DAYS_1900_TO_1970) * 86400L + (long)m).minusMillis(tz));
    }

    public static Date toDate(String dateStr) {
        return new Date(DateUtil.toTimestamp(dateStr).getTime());
    }

    public static Time toTime(double d) {
        int n = (int)d;
        int m = (int)((d - (double)n) * 86400.0 + 0.5);
        return Time.valueOf(LocalTime.ofSecondOfDay(m));
    }

    public static Time toTime(String s) {
        LocalTime time = DateUtil.toLocalTime(s);
        return time != null ? Time.valueOf(time) : null;
    }

    public static LocalTime toLocalTime(double d) {
        int n = (int)d;
        int m = (int)((d - (double)n) * 86400.0 + 0.5);
        return LocalTime.ofSecondOfDay(m);
    }

    public static LocalTime toLocalTime(String s) {
        try {
            return LocalTime.parse(s);
        }
        catch (NullPointerException | DateTimeParseException e) {
            return null;
        }
    }

    public static Timestamp toTimestamp(double d) {
        int n = (int)d;
        int m = (int)((d - (double)n) * 86400.0 + 0.5);
        return Timestamp.from(Instant.ofEpochSecond((long)(n - DAYS_1900_TO_1970) * 86400L + (long)m).minusMillis(tz));
    }

    public static LocalDateTime toLocalDateTime(double d) {
        int n = (int)d;
        int m = (int)((d - (double)n) * 86400.0 + 0.5);
        return LocalDateTime.ofInstant(Instant.ofEpochSecond((long)(n - DAYS_1900_TO_1970) * 86400L + (long)m).minusMillis(tz), ZoneId.systemDefault());
    }

    public static Timestamp toTimestamp(int n) {
        return Timestamp.from(Instant.ofEpochSecond((long)(n - DAYS_1900_TO_1970) * 86400L).minusMillis(tz));
    }

    public static LocalDate toLocalDate(int n) {
        return LocalDate.ofEpochDay(n - DAYS_1900_TO_1970);
    }

    public static Timestamp toTimestamp(String dateStr) {
        String v = dateStr.trim().replace('/', '-');
        int dividingSpace = v.indexOf(32);
        if (dividingSpace < 0) {
            v = v + " 00:00:00";
        } else {
            int i = 0;
            int idx = dividingSpace;
            while ((idx = v.indexOf(58, idx + 1)) > 0) {
                ++i;
            }
            boolean endOfp = v.charAt(v.length() - 1) == ':';
            switch (i) {
                case 0: {
                    v = v + ":0:0";
                    break;
                }
                case 1: {
                    v = v + (!endOfp ? ":0" : "0:0");
                    break;
                }
                case 2: {
                    if (!endOfp) break;
                    v = v + '0';
                    break;
                }
            }
        }
        return Timestamp.valueOf(v);
    }
}

