/*
 * Copyright (c) 2017-2023, guanquan.wang@yandex.com All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package org.ttzero.excel.entity;

import java.io.Closeable;
import java.io.IOException;

/**
 * Drawings writer
 *
 * @author guanquan.wang at 2023-03-07 09:09
 */
public interface IDrawingsWriter extends Closeable, Storable {
    /**
     * Direct drawing picture
     *
     * @param picture {@link Picture} info
     * @throws IOException if I/O error occur.
     */
    void drawing(Picture picture) throws IOException;

    /**
     * Asynchronous addition of picture
     *
     * @param picture {@link Picture} info
     * @throws IOException if I/O error occur.
     */
    void asyncDrawing(Picture picture) throws IOException;

    /**
     * Complete
     *
     * @param picture {@link Picture} info
     */
    void complete(Picture picture);
}
