/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.e7.ContentType;
import org.ttzero.excel.util.FileUtil;

public abstract class AbstractTemplate {
    protected Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    static final String inlineStr = "inlineStr";
    protected Workbook wb;
    protected Path zipPath;
    protected Map<String, String> map;

    public AbstractTemplate(Path zipPath, Workbook wb) {
        this.zipPath = zipPath;
        this.wb = wb;
    }

    public boolean check() {
        Document document;
        Path contentTypePath = this.zipPath.resolve("[Content_Types].xml");
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(Files.newInputStream(contentTypePath, new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            this.LOGGER.debug("{} loading error", (Object)"[Content_Types].xml");
            return false;
        }
        ArrayList<ContentType.Override> overrides = new ArrayList<ContentType.Override>();
        ArrayList<ContentType.Default> defaults = new ArrayList<ContentType.Default>();
        Iterator it = document.getRootElement().elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if ("Override".equals(e.getName())) {
                overrides.add(new ContentType.Override(e.attributeValue("ContentType"), e.attributeValue("PartName")));
                continue;
            }
            if (!"Default".equals(e.getName())) continue;
            defaults.add(new ContentType.Default(e.attributeValue("ContentType"), e.attributeValue("Extension")));
        }
        return this.checkDefault(defaults) && this.checkOverride(overrides);
    }

    protected boolean checkDefault(List<ContentType.Default> list) {
        if (list.isEmpty() || !this.checkDouble(list)) {
            this.LOGGER.debug("The attribute[Default] is empty or the same attribute exists");
        }
        return true;
    }

    protected boolean checkOverride(List<ContentType.Override> list) {
        if (list.isEmpty() || !this.checkDouble(list)) {
            this.LOGGER.debug("The attribute[Override] is empty or the same attribute exists");
        }
        for (ContentType.Override o : list) {
            Path subPath = this.zipPath.resolve(o.getPartName().substring(1));
            if (FileUtil.exists(subPath)) continue;
            this.LOGGER.debug("{} does not exists", (Object)subPath.toString());
            return false;
        }
        return true;
    }

    private boolean checkDouble(List<? extends ContentType.Type> list) {
        int i;
        list.sort(Comparator.comparing(ContentType.Type::getKey));
        int len = list.size() - 1;
        boolean boo = false;
        for (i = 0; i < len && !(boo = list.get(i).getKey().equals(list.get(i + 1).getKey())); ++i) {
        }
        return i >= len && !boo;
    }

    public void bind(Object o) {
        if (o != null) {
            this.map = new HashMap<String, String>();
            if (o instanceof Map) {
                Map map1 = (Map)o;
                map1.forEach((k, v) -> {
                    String vs = v != null ? v.toString() : "";
                    this.map.put(k.toString(), vs);
                });
            } else {
                Field[] fields;
                for (Field field : fields = o.getClass().getDeclaredFields()) {
                    String value;
                    field.setAccessible(true);
                    try {
                        Object v2 = field.get(o);
                        value = v2 != null ? v2.toString() : "";
                    }
                    catch (IllegalAccessException e) {
                        value = "";
                    }
                    this.map.put(field.getName(), value);
                }
            }
        }
        int n1 = this.bindSstData();
        int n2 = this.bindSheetData();
        this.LOGGER.debug("Found {} words that need to be replaced", (Object)(n1 + n2));
    }

    protected int bindSstData() {
        Document document;
        Path shareStringPath = this.zipPath.resolve("xl/sharedStrings.xml");
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(Files.newInputStream(shareStringPath, new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            this.LOGGER.debug("The file format is incorrect or corrupted. [shareStrings.xml]");
            return 0;
        }
        Element sst = document.getRootElement();
        Attribute countAttr = sst.attribute("count");
        if (countAttr == null || "0".equals(countAttr.getValue())) {
            return 0;
        }
        int n = 0;
        Iterator iterator = sst.elementIterator();
        while (iterator.hasNext()) {
            Element si = (Element)iterator.next();
            Element t = si.element("t");
            String txt = t.getText();
            if (!this.isPlaceholder(txt)) continue;
            t.setText(this.getValue(txt));
            ++n;
        }
        if (n > 0) {
            try {
                FileUtil.writeToDiskNoFormat(document, shareStringPath);
            }
            catch (IOException e) {
                this.LOGGER.debug("Write {} failed.", (Object)shareStringPath.toString());
            }
        }
        return n;
    }

    protected int bindSheetData() {
        Document document;
        Path contentTypePath = this.zipPath.resolve("[Content_Types].xml");
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(Files.newInputStream(contentTypePath, new OpenOption[0]));
        }
        catch (IOException | DocumentException e2) {
            this.LOGGER.debug("The file format is incorrect or corrupted. [[Content_Types].xml]");
            return 0;
        }
        List overrides = document.getRootElement().elements("Override");
        int[] result = overrides.stream().filter(e -> "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml".equals(e.attributeValue("ContentType"))).map(e -> this.zipPath.resolve(e.attributeValue("PartName").substring(1))).mapToInt(this::bindSheet).toArray();
        int n = 0;
        for (int i : result) {
            n += i;
        }
        return n;
    }

    int bindSheet(Path sheetPath) {
        Document document;
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(Files.newInputStream(sheetPath, new OpenOption[0]));
        }
        catch (IOException | DocumentException e) {
            this.LOGGER.debug("The file format is incorrect or corrupted. [{}]", (Object)sheetPath);
            return 0;
        }
        int n = 0;
        Element sheetData = document.getRootElement().element("sheetData");
        Iterator iterator = sheetData.elementIterator();
        while (iterator.hasNext()) {
            Element row = (Element)iterator.next();
            Iterator it = row.elementIterator();
            while (it.hasNext()) {
                Element tv;
                String txt;
                Element cell = (Element)it.next();
                Attribute t = cell.attribute("t");
                if (t == null || !inlineStr.equals(t.getValue()) || !this.isPlaceholder(txt = (tv = cell.element("is").element("t")).getText())) continue;
                tv.setText(this.getValue(txt));
                ++n;
            }
        }
        if (n > 0) {
            try {
                FileUtil.writeToDiskNoFormat(document, sheetPath);
            }
            catch (IOException e) {
                this.LOGGER.debug("Compression completed. {}", (Object)sheetData);
            }
        }
        return n;
    }

    protected abstract boolean isPlaceholder(String var1);

    protected abstract String getValue(String var1);
}

