/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.StringUtil;

public class ResultSetSheet
extends Sheet {
    protected ResultSet rs;
    private StyleProcessor<ResultSet> styleProcessor;

    public ResultSetSheet() {
    }

    public ResultSetSheet(String name) {
        super(name);
    }

    public ResultSetSheet(Column ... columns) {
        super(columns);
    }

    public ResultSetSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ResultSetSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public ResultSetSheet(ResultSet rs) {
        this(null, rs);
    }

    public ResultSetSheet(String name, ResultSet rs) {
        super(name);
        this.rs = rs;
    }

    public ResultSetSheet(ResultSet rs, Column ... columns) {
        this((String)null, rs, (WaterMark)null, columns);
    }

    public ResultSetSheet(String name, ResultSet rs, Column ... columns) {
        this(name, rs, (WaterMark)null, columns);
    }

    public ResultSetSheet(ResultSet rs, WaterMark waterMark, Column ... columns) {
        this(null, rs, waterMark, columns);
    }

    public ResultSetSheet(String name, ResultSet rs, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
        this.rs = rs;
    }

    public ResultSetSheet setResultSet(ResultSet resultSet) {
        this.rs = resultSet;
        return this;
    }

    public Sheet setStyleProcessor(StyleProcessor<ResultSet> styleProcessor) {
        this.styleProcessor = styleProcessor;
        this.putExtProp("style_design", styleProcessor);
        return this;
    }

    public StyleProcessor<ResultSet> getStyleProcessor() {
        StyleProcessor fromExtProp;
        if (this.styleProcessor != null) {
            return this.styleProcessor;
        }
        this.styleProcessor = fromExtProp = (StyleProcessor)this.getExtPropValue("style_design");
        return this.styleProcessor;
    }

    @Override
    public void close() throws IOException {
        if (this.shouldClose && this.rs != null) {
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                this.LOGGER.warn("Close ResultSet error.", (Throwable)e);
            }
        }
        super.close();
    }

    @Override
    protected void resetBlockData() {
        int len = this.columns.length;
        int n = 0;
        int limit = this.getRowLimit();
        boolean hasGlobalStyleProcessor = (this.extPropMark & 2) == 2;
        try {
            int rbs = this.rowBlock.capacity();
            while (n++ < rbs && this.rows < limit && this.rs.next()) {
                Row row = this.rowBlock.next();
                row.index = this.rows;
                row.height = this.getRowHeight();
                Cell[] cells = row.realloc(len);
                for (int i = 1; i <= len; ++i) {
                    Object e;
                    SQLColumn hc = (SQLColumn)this.columns[i - 1];
                    Cell cell = cells[i - 1];
                    cell.clear();
                    if (hc.ri > 0) {
                        switch (hc.sqlType) {
                            case -1: 
                            case 0: 
                            case 12: {
                                e = this.rs.getString(hc.ri);
                                break;
                            }
                            case -7: 
                            case -6: 
                            case 1: 
                            case 4: 
                            case 5: {
                                e = this.rs.getInt(hc.ri);
                                break;
                            }
                            case 91: {
                                e = this.rs.getDate(hc.ri);
                                break;
                            }
                            case 93: {
                                e = this.rs.getTimestamp(hc.ri);
                                break;
                            }
                            case 2: 
                            case 3: {
                                e = this.rs.getBigDecimal(hc.ri);
                                break;
                            }
                            case -5: {
                                e = this.rs.getLong(hc.ri);
                                break;
                            }
                            case 6: 
                            case 7: 
                            case 8: {
                                e = this.rs.getDouble(hc.ri);
                                break;
                            }
                            case 92: {
                                e = this.rs.getTime(hc.ri);
                                break;
                            }
                            default: {
                                e = this.rs.getObject(hc.ri);
                                break;
                            }
                        }
                    } else {
                        e = null;
                    }
                    this.cellValueAndStyle.reset(row, cell, e, hc);
                    if (!hasGlobalStyleProcessor) continue;
                    this.cellValueAndStyle.setStyleDesign(this.rs, cell, hc, this.getStyleProcessor());
                }
                ++this.rows;
            }
        }
        catch (SQLException e) {
            throw new ExcelWriteException(e);
        }
        if (this.rows >= limit) {
            this.shouldClose = false;
            ResultSetSheet copy = (ResultSetSheet)this.getClass().cast(this.clone());
            this.workbook.insertSheet(this.id, copy);
        } else {
            this.shouldClose = true;
        }
    }

    @Override
    protected Column[] getHeaderColumns() {
        int i;
        if (this.headerReady) {
            return this.columns;
        }
        if (this.rs == null) {
            throw new ExcelWriteException("Constructor worksheet error.\nMiss the parameter ResultSet");
        }
        try {
            ResultSetMetaData metaData = this.rs.getMetaData();
            int count = metaData.getColumnCount();
            if (this.hasHeaderColumns()) {
                SQLColumn[] newColumns = new SQLColumn[this.columns.length];
                for (i = 0; i < this.columns.length; ++i) {
                    SQLColumn column;
                    newColumns[i] = column = SQLColumn.of(this.columns[i]);
                    if (column.tail != null) {
                        column = (SQLColumn)column.tail;
                    }
                    if (i + 1 > count) {
                        this.LOGGER.warn("Column [{}] cannot be mapped.", (Object)this.columns[i].getName());
                        continue;
                    }
                    if (StringUtil.isEmpty(column.getName())) {
                        column.setName(metaData.getColumnLabel(i + 1));
                    }
                    int n = column.ri = StringUtil.isNotEmpty(column.key) ? this.findByKey(metaData, column.key) : i + 1;
                    if (column.ri < 0) {
                        this.LOGGER.warn("Column [{}] cannot be mapped.", (Object)this.columns[i].getName());
                        continue;
                    }
                    column.sqlType = metaData.getColumnType(i + 1);
                    Class<?> metaClazz = this.columnTypeToClass(column.sqlType);
                    if (column.clazz == metaClazz) continue;
                    this.LOGGER.warn("The specified type {} is different from metadata column type {}", (Object)column.clazz, metaClazz);
                }
                this.columns = newColumns;
            } else {
                this.columns = new Column[count];
                while (++i <= count) {
                    SQLColumn column = new SQLColumn(metaData.getColumnLabel(i), metaData.getColumnType(i), this.columnTypeToClass(metaData.getColumnType(i)));
                    column.ri = StringUtil.isNotEmpty(column.key) ? this.findByKey(metaData, column.key) : i;
                    this.columns[i - 1] = column;
                }
            }
        }
        catch (SQLException e) {
            this.LOGGER.warn("Get meta data occur error.", (Throwable)e);
        }
        if (this.hasHeaderColumns()) {
            for (i = 0; i < this.columns.length; ++i) {
                if (!StringUtil.isEmpty(this.columns[i].getName())) continue;
                this.columns[i].setName(String.valueOf(i));
            }
        }
        return this.columns;
    }

    protected int findByKey(ResultSetMetaData metaData, String key) throws SQLException {
        int len = metaData.getColumnCount();
        for (int i = 1; i <= len; ++i) {
            if (!key.equals(metaData.getColumnLabel(i))) continue;
            return i;
        }
        return -1;
    }

    protected Class<?> columnTypeToClass(int type) {
        Class clazz;
        switch (type) {
            case -1: 
            case 0: 
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case 4: {
                clazz = Integer.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case -7: {
                clazz = Boolean.class;
                break;
            }
            case -6: {
                clazz = Byte.class;
                break;
            }
            case 5: {
                clazz = Short.class;
                break;
            }
            case -5: {
                clazz = Long.class;
                break;
            }
            case 7: {
                clazz = Float.class;
                break;
            }
            case 6: 
            case 8: {
                clazz = Double.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            default: {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    public static class SQLColumn
    extends Column {
        public int sqlType;
        public int ri;

        public SQLColumn(String name, int sqlType, Class<?> clazz) {
            super(name, clazz);
            this.sqlType = sqlType;
        }

        public SQLColumn(Column other) {
            super.from(other);
            if (other instanceof SQLColumn) {
                SQLColumn o = (SQLColumn)other;
                this.sqlType = o.sqlType;
                this.ri = o.ri;
            }
            if (other.next != null) {
                this.addSubColumn(new SQLColumn(other.next));
            }
        }

        public static SQLColumn of(Column other) {
            return new SQLColumn(other);
        }
    }
}

