/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.imageio.ImageIO;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.util.FileSignatures;

public class WaterMark {
    private final Path imagePath;
    private boolean temp;
    private final FileSignatures.Signature signature;

    public WaterMark(String word) {
        this.imagePath = this.createWaterMark(word);
        this.signature = new FileSignatures.Signature("png", FileSignatures.whitelist.getOrDefault("png", "image/png"), 510, 300);
    }

    public WaterMark(Path imagePath) {
        this.imagePath = imagePath;
        this.signature = FileSignatures.test(imagePath);
    }

    public WaterMark(InputStream inputStream) throws IOException {
        this.imagePath = this.createTemp();
        Files.copy(inputStream, this.imagePath, StandardCopyOption.REPLACE_EXISTING);
        this.signature = FileSignatures.test(this.imagePath);
    }

    public Path get() {
        return this.canWrite() ? this.imagePath : null;
    }

    public static WaterMark of(String mark) {
        return new WaterMark(mark);
    }

    public static WaterMark of(Path path) {
        return new WaterMark(path);
    }

    public static WaterMark of(InputStream is) throws IOException {
        return new WaterMark(is);
    }

    private Path createWaterMark(String watermark) {
        try {
            Path temp = this.createTemp();
            int width = 510;
            int height = 300;
            BufferedImage bi = new BufferedImage(width, height, 1);
            int minx = bi.getMinX();
            int miny = bi.getMinY();
            for (int i = minx; i < width; ++i) {
                for (int j = miny; j < height; ++j) {
                    bi.setRGB(i, j, 0xFFFFFF);
                }
            }
            Graphics2D g2d = bi.createGraphics();
            g2d.setColor(new Color(230, 230, 230));
            g2d.setStroke(new BasicStroke(1.0f));
            g2d.setFont(new Font("\u534e\u6587\u7ec6\u9ed1", 2, 24));
            g2d.rotate(Math.toRadians(-25.0));
            g2d.drawString(watermark, 100, 250);
            g2d.setComposite(AlphaComposite.getInstance(3));
            g2d.dispose();
            ImageIO.write((RenderedImage)bi, "png", temp.toFile());
            return temp;
        }
        catch (IOException e) {
            throw new ExcelWriteException("\u521b\u5efa\u6c34\u5370\u5931\u8d25.", e);
        }
    }

    private Path createTemp() throws IOException {
        this.temp = true;
        return Files.createTempFile("waterMark", "png", new FileAttribute[0]);
    }

    public boolean delete() {
        if (this.imagePath != null && this.temp) {
            try {
                Files.deleteIfExists(this.imagePath);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public String getSuffix() {
        return "." + this.signature.extension;
    }

    public String getContentType() {
        return this.signature.contentType;
    }

    public boolean canWrite() {
        return this.signature.isTrusted();
    }
}

