/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import java.awt.FontMetrics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.Comments;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IDrawingsWriter;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Panes;
import org.ttzero.excel.entity.Picture;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.e7.ContentType;
import org.ttzero.excel.entity.e7.XMLDrawingsWriter;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileSignatures;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"", "r"}, value="worksheet", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main", "http://schemas.openxmlformats.org/officeDocument/2006/relationships"})
public class XMLWorksheetWriter
implements IWorksheetWriter {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Path workSheetPath;
    protected Path mediaPath;
    protected ExtBufferedWriter bw;
    protected Sheet sheet;
    protected Column[] columns;
    protected SharedStrings sst;
    protected Styles styles;
    protected Comments comments;
    protected int startRow;
    protected int startHeaderRow;
    protected int totalRows;
    protected int sheetDataReady;
    protected boolean includeAutoWidth;
    protected IDrawingsWriter drawingsWriter;
    protected BiConsumer<Sheet, Integer> progressConsumer;
    protected double[] columnWidths;
    protected Font[] fs = new Font[100];

    public XMLWorksheetWriter() {
    }

    public XMLWorksheetWriter(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public void writeTo(Path path, Supplier<RowBlock> supplier) throws IOException {
        Path sheetPath = this.initWriter(path);
        RowBlock rowBlock = supplier.get();
        this.writeBefore();
        this.beforeSheetData(this.sheet.getNonHeader() == 1);
        if (rowBlock != null && rowBlock.hasNext()) {
            if (this.progressConsumer == null) {
                do {
                    this.writeRowBlock(rowBlock);
                } while (!rowBlock.isEOF() && (rowBlock = supplier.get()) != null);
            } else {
                do {
                    this.writeRowBlockFireProgress(rowBlock);
                } while (!rowBlock.isEOF() && (rowBlock = supplier.get()) != null);
                if (rowBlock != null && rowBlock.lastRow() != null) {
                    this.progressConsumer.accept(this.sheet, rowBlock.lastRow().getIndex());
                }
            }
        }
        this.totalRows = rowBlock != null ? rowBlock.getTotal() : 0;
        this.writeAfter(this.totalRows);
        this.sheet.afterSheetAccess(this.workSheetPath);
        if (this.includeAutoWidth) {
            this.resizeColumnWidth(sheetPath.toFile(), this.totalRows);
        }
    }

    @Override
    public void writeTo(Path path) throws IOException {
        Path sheetPath = this.initWriter(path);
        RowBlock rowBlock = this.sheet.nextBlock();
        this.writeBefore();
        this.beforeSheetData(this.sheet.getNonHeader() == 1);
        if (rowBlock.hasNext()) {
            if (this.progressConsumer == null) {
                while (true) {
                    this.writeRowBlock(rowBlock);
                    if (!rowBlock.isEOF()) {
                        rowBlock = this.sheet.nextBlock();
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    this.writeRowBlockFireProgress(rowBlock);
                    if (rowBlock.isEOF()) break;
                    rowBlock = this.sheet.nextBlock();
                }
                if (rowBlock.lastRow() != null) {
                    this.progressConsumer.accept(this.sheet, rowBlock.lastRow().getIndex());
                }
            }
        }
        this.totalRows = rowBlock.getTotal();
        this.writeAfter(this.totalRows);
        this.sheet.afterSheetAccess(this.workSheetPath);
        if (this.includeAutoWidth) {
            this.resizeColumnWidth(sheetPath.toFile(), this.totalRows);
        }
    }

    protected Path initWriter(Path root) throws IOException {
        this.workSheetPath = root.resolve("worksheets");
        if (!FileUtil.exists(this.workSheetPath)) {
            FileUtil.mkdir(this.workSheetPath);
        }
        Path sheetPath = this.workSheetPath.resolve(this.sheet.getFileName());
        this.bw = new ExtBufferedWriter(Files.newBufferedWriter(sheetPath, StandardCharsets.UTF_8, new OpenOption[0]));
        if (this.sst == null) {
            this.sst = this.sheet.getWorkbook().getSharedStrings();
        }
        if (this.styles == null) {
            this.styles = this.sheet.getWorkbook().getStyles();
        }
        this.startHeaderRow = this.sheet.getStartRowIndex();
        if (this.startHeaderRow <= 0) {
            throw new IndexOutOfBoundsException("The start row index must be greater than 0, current = " + this.startHeaderRow);
        }
        if (this.getRowLimit() <= this.startHeaderRow) {
            throw new IndexOutOfBoundsException("The start row index must be less than row-limit, current(" + this.startHeaderRow + ") >= limit(" + this.getRowLimit() + ")");
        }
        this.startRow = this.startHeaderRow;
        this.progressConsumer = this.sheet.getProgressConsumer();
        if (this.progressConsumer != null) {
            this.progressConsumer.accept(this.sheet, 0);
        }
        this.LOGGER.debug("{} WorksheetWriter initialization completed.", (Object)this.sheet.getName());
        return sheetPath;
    }

    @Override
    public IWorksheetWriter setWorksheet(Sheet sheet) {
        this.sheet = sheet;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IWorksheetWriter clone() {
        IWorksheetWriter copy;
        try {
            copy = (IWorksheetWriter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(this);
                ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
                copy = (IWorksheetWriter)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e1) {
                try {
                    try {
                        copy = (IWorksheetWriter)this.getClass().getConstructor(Sheet.class).newInstance(this.sheet);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                        throw new ExcelWriteException(e2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.close(oos);
                    FileUtil.close(ois);
                    throw throwable;
                }
                FileUtil.close(oos);
                FileUtil.close(ois);
            }
            FileUtil.close(oos);
            FileUtil.close(ois);
        }
        XMLWorksheetWriter e = (XMLWorksheetWriter)copy;
        e.sheetDataReady = 0;
        e.totalRows = 0;
        e.drawingsWriter = null;
        e.comments = null;
        return copy;
    }

    @Override
    public String getFileSuffix() {
        return ".xml";
    }

    @Override
    public int getRowLimit() {
        return 0x100000;
    }

    @Override
    public int getColumnLimit() {
        return 16384;
    }

    protected void writeBefore() throws IOException {
        this.columns = this.sheet.getAndSortHeaderColumns();
        boolean nonHeader = this.sheet.getNonHeader() == 1;
        this.collectHeaderColumns();
        this.bw.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.bw.newLine();
        this.writeRootNode();
        this.writeDimension();
        this.writeSheetViews();
        int fillSpace = 17;
        BigDecimal width = BigDecimal.valueOf(!nonHeader ? this.sheet.getDefaultWidth() : 8.0).add(new BigDecimal("0.65"));
        if (width.compareTo(new BigDecimal(255)) > 0) {
            width = new BigDecimal(255);
        }
        String defaultWidth = width.setScale(2, 4).toString();
        this.writeCols(fillSpace, defaultWidth);
        this.initDrawingsWriter();
    }

    protected int writeHeaderRow() throws IOException {
        int rowIndex = 0;
        int subColumnSize = this.columns[0].subColumnSize();
        int defaultStyleIndex = this.sheet.defaultHeadStyleIndex();
        Column[][] columnsArray = new Column[this.columns.length][];
        for (int i = 0; i < this.columns.length; ++i) {
            columnsArray[i] = this.columns[i].toArray();
        }
        List mergeCells = (List)this.sheet.getExtPropValue("merge_cells");
        Grid mergedGrid = mergeCells != null && !mergeCells.isEmpty() ? GridFactory.create(mergeCells) : null;
        for (int i = subColumnSize - 1; i >= 0; --i) {
            int j;
            double ht = this.getHeaderHeight(columnsArray, i);
            if (ht < 0.0) {
                ht = this.sheet.getHeaderRowHeight();
            }
            int row = this.startRow(rowIndex++, this.columns.length, ht);
            int c = 0;
            for (j = 0; j < this.columns.length; ++j) {
                Column hc = columnsArray[j][i];
                String name = StringUtil.isNotEmpty(hc.getName()) ? hc.getName() : (mergedGrid != null && mergedGrid.test(i + 1, hc.getRealColIndex()) && !XMLWorksheetWriter.isFirstMergedCell(mergeCells, i + 1, hc.getRealColIndex()) ? null : hc.key);
                this.writeString(name, row, c++, hc.getHeaderStyleIndex() == -1 ? defaultStyleIndex : hc.getHeaderStyleIndex());
            }
            for (j = 0; j < this.columns.length; ++j) {
                Column hc = columnsArray[j][i];
                if (hc.headerComment == null) continue;
                if (this.comments == null) {
                    this.comments = this.sheet.createComments();
                }
                this.comments.addComment(new String(Sheet.int2Col(hc.getRealColIndex())) + row, hc.headerComment);
            }
            this.bw.write("</row>");
        }
        return subColumnSize;
    }

    protected void writeAfter(int total) throws IOException {
        this.bw.write("</sheetData>");
        Dimension autoFilter = (Dimension)this.sheet.getExtPropValue("auto_filter");
        if (autoFilter != null) {
            this.bw.write("<autoFilter ref=\"");
            this.bw.write(autoFilter.toString());
            this.bw.write("\"/>");
        }
        this.writeMergeCells();
        this.afterSheetData();
        if (this.getClass().isAnnotationPresent(TopNS.class)) {
            TopNS topNS = this.getClass().getAnnotation(TopNS.class);
            this.bw.write("</");
            this.bw.write(topNS.value());
            this.bw.write(62);
        } else {
            this.bw.write("</worksheet>");
        }
        this.LOGGER.debug("Sheet [{}] writing completed, total rows: {}", (Object)this.sheet.getName(), (Object)total);
    }

    protected void writeRowBlock(RowBlock rowBlock) throws IOException {
        while (rowBlock.hasNext()) {
            this.writeRow(rowBlock.next());
        }
    }

    protected void writeRowBlockFireProgress(RowBlock rowBlock) throws IOException {
        while (rowBlock.hasNext()) {
            Row row = rowBlock.next();
            this.writeRow(row);
            if (row.getIndex() % 1000 != 0) continue;
            this.progressConsumer.accept(this.sheet, row.getIndex());
        }
    }

    protected int startRow(int rows, int columns, Double rowHeight) throws IOException {
        int r = rows + this.startRow;
        this.bw.write("<row r=\"");
        this.bw.writeInt(r);
        if (rowHeight != null && rowHeight >= 0.0) {
            this.bw.write("\" customHeight=\"1\" ht=\"");
            this.bw.write(rowHeight);
        }
        this.bw.write("\" spans=\"");
        this.bw.writeInt(this.columns[0].realColIndex);
        this.bw.write(58);
        this.bw.writeInt(this.columns[this.columns.length - 1].realColIndex);
        this.bw.write("\">");
        return r;
    }

    protected void writeRow(Row row) throws IOException {
        Cell[] cells = row.getCells();
        int len = cells.length;
        int r = this.startRow(row.getIndex(), len, row.getHeight());
        block15: for (int i = 0; i < len; ++i) {
            Cell cell = cells[i];
            int xf = cell.xf;
            switch (cell.t) {
                case 'r': 
                case 's': {
                    this.writeString(cell.sv, r, i, xf);
                    continue block15;
                }
                case 'n': {
                    this.writeNumeric(cell.nv, r, i, xf);
                    continue block15;
                }
                case 'l': {
                    this.writeNumeric(cell.lv, r, i, xf);
                    continue block15;
                }
                case 'a': 
                case 'd': 
                case 'i': 
                case 't': {
                    this.writeDouble(cell.dv, r, i, xf);
                    continue block15;
                }
                case 'b': {
                    this.writeBool(cell.bv, r, i, xf);
                    continue block15;
                }
                case 'm': {
                    this.writeDecimal(cell.mv, r, i, xf);
                    continue block15;
                }
                case 'c': {
                    this.writeChar(cell.cv, r, i, xf);
                    continue block15;
                }
                case 'u': {
                    this.writeRemoteMedia(cell.sv, r, i, xf);
                    continue block15;
                }
                case 'y': {
                    this.writeBinary(cell.binary, r, i, xf);
                    continue block15;
                }
                case 'x': {
                    this.writeFile(cell.path, r, i, xf);
                    continue block15;
                }
                case 'p': {
                    this.writeStream(cell.isv, r, i, xf);
                    continue block15;
                }
                case 'o': {
                    this.writeBinary(cell.byteBuffer, r, i, xf);
                    continue block15;
                }
                case 'k': {
                    this.writeNull(r, i, xf);
                    continue block15;
                }
            }
        }
        this.bw.write("</row>");
    }

    protected void writeString(String s, int row, int column, int xf) throws IOException {
        int i;
        if (s != null && s.length() > Short.MAX_VALUE) {
            throw new ExcelWriteException("Characters per cell out of limit. size=" + s.length() + ", limit=" + Short.MAX_VALUE);
        }
        Column hc = this.getColumn(column);
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(hc.getRealColIndex()));
        this.bw.writeInt(row);
        if (StringUtil.isEmpty(s)) {
            this.bw.write("\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"/>");
        } else if (hc.isShare() && (i = this.sst.get(s)) >= 0) {
            this.bw.write("\" t=\"s\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"><v>");
            this.bw.writeInt(i);
            this.bw.write("</v></c>");
        } else {
            this.bw.write("\" t=\"inlineStr\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"><is><t>");
            this.bw.escapeWrite(s);
            this.bw.write("</t></is></c>");
        }
        if (hc.getAutoSize() == 1) {
            double d;
            double ln = this.stringWidth(s, xf);
            if (this.columnWidths[column] < d) {
                this.columnWidths[column] = ln;
            }
        }
    }

    protected void writeDouble(double d, int row, int column, int xf) throws IOException {
        Column hc = this.getColumn(column);
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(hc.getRealColIndex()));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.write(d);
        this.bw.write("</v></c>");
        if (hc.getAutoSize() == 1) {
            if (hc.getNumFmt() != null) {
                double d2;
                double n = hc.getNumFmt().calcNumWidth(Double.toString(d).length(), this.getFont(xf));
                if (this.columnWidths[column] < d2) {
                    this.columnWidths[column] = n;
                }
            } else {
                double d3;
                double n = this.stringWidth(Double.toString(d), xf);
                if (this.columnWidths[column] < d3) {
                    this.columnWidths[column] = n;
                }
            }
        }
    }

    protected void writeDecimal(BigDecimal bd, int row, int column, int xf) throws IOException {
        Column hc = this.getColumn(column);
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(hc.getRealColIndex()));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.write(bd.toString());
        this.bw.write("</v></c>");
        if (hc.getAutoSize() == 1) {
            if (hc.getNumFmt() != null) {
                double d;
                double n = hc.getNumFmt().calcNumWidth(bd.toString().length(), this.getFont(xf));
                if (this.columnWidths[column] < d) {
                    this.columnWidths[column] = n;
                }
            } else {
                double d;
                double n = this.stringWidth(bd.toString(), xf);
                if (this.columnWidths[column] < d) {
                    this.columnWidths[column] = n;
                }
            }
        }
    }

    protected void writeChar(char c, int row, int column, int xf) throws IOException {
        Column hc = this.getColumn(column);
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(hc.getRealColIndex()));
        this.bw.writeInt(row);
        if (hc.isShare()) {
            this.bw.write("\" t=\"s\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"><v>");
            this.bw.writeInt(this.sst.get(c));
            this.bw.write("</v></c>");
        } else {
            this.bw.write("\" t=\"inlineStr\" s=\"");
            this.bw.writeInt(xf);
            this.bw.write("\"><is><t>");
            this.bw.escapeWrite(c);
            this.bw.write("</t></is></c>");
        }
        if (hc.getAutoSize() == 1) {
            Font font = this.getFont(xf);
            double n = (double)(c > '\u4e00' ? font.getSize() : font.getFontMetrics().charWidth(c)) / 6.0 * 1.02;
            if (this.columnWidths[column] < n) {
                this.columnWidths[column] = n;
            }
        }
    }

    protected void writeNumeric(long l, int row, int column, int xf) throws IOException {
        Column hc = this.getColumn(column);
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(hc.getRealColIndex()));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.write(l);
        this.bw.write("</v></c>");
        if (hc.getAutoSize() == 1) {
            if (hc.getNumFmt() != null) {
                double d;
                double n = hc.getNumFmt().calcNumWidth(ExtBufferedWriter.stringSize(l), this.getFont(xf));
                if (this.columnWidths[column] < d) {
                    this.columnWidths[column] = n;
                }
            } else {
                double d;
                double n = this.stringWidth(Long.toString(l), xf);
                if (this.columnWidths[column] < d) {
                    this.columnWidths[column] = n;
                }
            }
        }
    }

    protected void writeBool(boolean bool, int row, int column, int xf) throws IOException {
        Column hc = this.getColumn(column);
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(hc.getRealColIndex()));
        this.bw.writeInt(row);
        this.bw.write("\" t=\"b\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"><v>");
        this.bw.writeInt(bool ? 1 : 0);
        this.bw.write("</v></c>");
        if (hc.getAutoSize() == 1) {
            double d;
            double ln = this.stringWidth(Boolean.toString(bool), xf);
            if (this.columnWidths[column] < d) {
                this.columnWidths[column] = ln;
            }
        }
    }

    protected void writeNull(int row, int column, int xf) throws IOException {
        this.bw.write("<c r=\"");
        this.bw.write(Sheet.int2Col(this.getColumn(column).getRealColIndex()));
        this.bw.writeInt(row);
        this.bw.write("\" s=\"");
        this.bw.writeInt(xf);
        this.bw.write("\"/>");
    }

    protected void writeBinary(byte[] bytes, int row, int column, int xf) throws IOException {
        this.writeNull(row, column, xf);
        FileSignatures.Signature signature = FileSignatures.test(ByteBuffer.wrap(bytes));
        if (signature == null || !signature.isTrusted()) {
            this.LOGGER.warn("File types that are not allowed");
            return;
        }
        int id = this.sheet.getWorkbook().incrementMediaCounter();
        String name = "image" + id + "." + signature.extension;
        Files.write(this.mediaPath.resolve(name), bytes, StandardOpenOption.CREATE_NEW);
        this.writePictureDirect(id, name, column, row, signature);
    }

    protected void writeBinary(ByteBuffer byteBuffer, int row, int column, int xf) throws IOException {
        this.writeNull(row, column, xf);
        int position = byteBuffer.position();
        FileSignatures.Signature signature = FileSignatures.test(byteBuffer);
        if (signature == null || !signature.isTrusted()) {
            this.LOGGER.warn("File types that are not allowed");
            return;
        }
        int id = this.sheet.getWorkbook().incrementMediaCounter();
        String name = "image" + id + "." + signature.extension;
        byteBuffer.position(position);
        SeekableByteChannel channel = Files.newByteChannel(this.mediaPath.resolve(name), StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        channel.write(byteBuffer);
        channel.close();
        this.writePictureDirect(id, name, column, row, signature);
    }

    protected void writeFile(Path path, int row, int column, int xf) throws IOException {
        this.writeNull(row, column, xf);
        FileSignatures.Signature signature = FileSignatures.test(path);
        if (!signature.isTrusted()) {
            this.LOGGER.warn("File types that are not allowed");
            return;
        }
        int id = this.sheet.getWorkbook().incrementMediaCounter();
        String name = "image" + id + "." + signature.extension;
        Files.copy(path, this.mediaPath.resolve(name), StandardCopyOption.REPLACE_EXISTING);
        this.writePictureDirect(id, name, column, row, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeStream(InputStream stream, int row, int column, int xf) throws IOException {
        this.writeNull(row, column, xf);
        byte[] bytes = new byte[8192];
        OutputStream os = null;
        try {
            int n = stream.read(bytes);
            if (n <= 0) {
                return;
            }
            FileSignatures.Signature signature = FileSignatures.test(ByteBuffer.wrap(bytes, 0, n));
            if (signature == null || !signature.isTrusted()) {
                this.LOGGER.warn("File types that are not allowed");
                return;
            }
            int id = this.sheet.getWorkbook().incrementMediaCounter();
            String name = "image" + id + "." + signature.extension;
            os = Files.newOutputStream(this.mediaPath.resolve(name), new OpenOption[0]);
            os.write(bytes, 0, n);
            if (n == bytes.length) {
                while ((n = stream.read(bytes)) > 0) {
                    os.write(bytes, 0, n);
                }
            }
            this.writePictureDirect(id, name, column, row, signature);
            return;
        }
        catch (IOException ex) {
            this.LOGGER.warn("Copy stream error.", (Throwable)ex);
            return;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void writeRemoteMedia(String url, int row, int column, int xf) throws IOException {
        this.writeNull(row, column, xf);
        Picture picture = this.createPicture(column, row);
        picture.id = this.sheet.getWorkbook().incrementMediaCounter();
        this.drawingsWriter.asyncDrawing(picture);
        this.downloadRemoteResource(picture, url);
    }

    protected void resizeColumnWidth(File path, int rows) throws IOException {
        if (this.columns.length <= 0 || rows <= 0) {
            return;
        }
        for (int i = 0; i < this.columns.length; ++i) {
            double len;
            Column hc = this.columns[i];
            int k = hc.getAutoSize();
            if (k == 2 || hc.getColumnType() == 1) {
                double width = hc.width >= 0.0 ? hc.width : this.sheet.getDefaultWidth();
                hc.width = BigDecimal.valueOf(Math.min(width + 0.65, 255.0)).setScale(2, 4).doubleValue();
                continue;
            }
            double d = len = this.columnWidths[i] > 0.0 ? this.columnWidths[i] : this.sheet.getDefaultWidth();
            double width = (this.sheet.getNonHeader() == 1 ? len : Math.max(this.stringWidth(hc.name, hc.getHeaderStyleIndex() == -1 ? this.sheet.defaultHeadStyleIndex() : hc.getHeaderStyleIndex()), len)) + 1.86;
            if (hc.width > 1.0E-6) {
                width = Math.min(width, hc.width + 0.65);
            }
            if (width > 255.0) {
                width = 255.0;
            }
            hc.width = BigDecimal.valueOf(width).setScale(2, 4).doubleValue();
        }
        if (this.bw != null) {
            try {
                this.bw.close();
            }
            catch (IOException i) {
                // empty catch block
            }
        }
        XMLWorksheetWriter _writer = new XMLWorksheetWriter(this.sheet){

            @Override
            protected boolean hasMedia() {
                return false;
            }
        };
        _writer.totalRows = this.totalRows;
        _writer.startRow = this.startRow;
        _writer.startHeaderRow = this.startHeaderRow;
        _writer.includeAutoWidth = this.includeAutoWidth;
        _writer.styles = this.styles;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        _writer.bw = new ExtBufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
        _writer.writeBefore();
        _writer.bw.close();
        try (SeekableByteChannel channel = Files.newByteChannel(path.toPath(), StandardOpenOption.WRITE, StandardOpenOption.READ);){
            ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            channel.write(buffer);
        }
    }

    @Override
    public void close() {
        FileUtil.close(this.bw);
        FileUtil.close(this.drawingsWriter);
    }

    protected void writeRootNode() throws IOException {
        if (this.getClass().isAnnotationPresent(TopNS.class)) {
            TopNS topNS = this.getClass().getAnnotation(TopNS.class);
            this.bw.write(60);
            this.bw.write(topNS.value());
            String[] prefixs = topNS.prefix();
            String[] urls = topNS.uri();
            int i = 0;
            int len = prefixs.length;
            while (i < len) {
                this.bw.write(" xmlns");
                if (prefixs[i] != null && !prefixs[i].isEmpty()) {
                    this.bw.write(58);
                    this.bw.write(prefixs[i]);
                }
                this.bw.write("=\"");
                this.bw.write(urls[i]);
                if (++i >= len) continue;
                this.bw.write(34);
            }
        } else {
            this.bw.write("<worksheet xmlns=\"");
            this.bw.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        }
        this.bw.write("\">");
    }

    protected void writeDimension() throws IOException {
        int size;
        this.bw.append("<dimension ref=\"");
        if (this.columns.length > 0) {
            this.bw.write(Sheet.int2Col(this.columns[0].getRealColIndex()));
        } else {
            this.bw.write(65);
        }
        this.bw.writeInt(this.startHeaderRow);
        int n = 11;
        int n2 = size = this.totalRows > 0 ? this.totalRows : this.sheet.size();
        if (size > 0 && this.columns.length > 0) {
            this.bw.write(58);
            --n;
            Column hc = this.columns[this.columns.length - 1];
            char[] col = Sheet.int2Col(hc.getRealColIndex());
            this.bw.write(col);
            n -= col.length;
            size = this.includeAutoWidth || this.sheet.getNonHeader() == 1 ? (size + this.startRow - 1) % this.getRowLimit() : size + this.startRow + this.columns[0].subColumnSize() - 1;
            this.bw.writeInt(size);
            n -= ExtBufferedWriter.stringSize(size);
        }
        this.bw.write(34);
        while (n-- > 0) {
            this.bw.write(32);
        }
        this.bw.write("/>");
    }

    protected void writeSheetViews() throws IOException {
        Object o;
        this.bw.write("<sheetViews>");
        this.bw.write("<sheetView workbookViewId=\"0\"");
        if (!this.sheet.isShowGridLines()) {
            this.bw.write(" showGridLines=\"0\"");
        }
        if (this.sheet.getId() == 1) {
            this.bw.write(" tabSelected=\"1\"");
        }
        if ((o = this.sheet.getExtPropValue("freeze")) instanceof Panes) {
            Panes freezePanes = (Panes)o;
            if (freezePanes.row < 0 || freezePanes.col < 0) {
                throw new IllegalArgumentException("Negative number occur in freeze panes settings.");
            }
            if ((freezePanes.col | freezePanes.row) == 0) {
                this.bw.write("/>");
            } else {
                this.bw.write(">");
                Dimension dim = new Dimension(freezePanes.row + 1, (short)(freezePanes.col + 1));
                if (freezePanes.col == 0) {
                    this.bw.write("<pane ySplit=\"" + freezePanes.row + "\" topLeftCell=\"" + dim + "\" activePane=\"bottomLeft\" state=\"frozen\"/>");
                    this.bw.write("<selection pane=\"bottomLeft\" activeCell=\"" + dim + "\" sqref=\"" + dim + "\"/>");
                } else if (freezePanes.row == 0) {
                    this.bw.write("<pane xSplit=\"" + freezePanes.col + "\" topLeftCell=\"" + dim + "\" activePane=\"topRight\" state=\"frozen\"/>");
                    this.bw.write("<selection pane=\"topRight\" activeCell=\"" + dim + "\" sqref=\"" + dim + "\"/>");
                } else {
                    this.bw.write("<pane xSplit=\"" + freezePanes.col + "\" ySplit=\"" + freezePanes.row + "\" topLeftCell=\"" + dim + "\" activePane=\"bottomRight\" state=\"frozen\"/>");
                    this.bw.write("<selection pane=\"topRight\" activeCell=\"" + new Dimension(1, dim.firstColumn) + "\" sqref=\"" + new Dimension(1, dim.firstColumn) + "\"/>");
                    this.bw.write("<selection pane=\"bottomLeft\" activeCell=\"" + new Dimension(dim.firstRow, 1) + "\" sqref=\"" + new Dimension(dim.firstRow, 1) + "\"/>");
                    this.bw.write("<selection pane=\"bottomRight\" activeCell=\"" + dim + "\" sqref=\"" + dim + "\"/>");
                }
                this.bw.write("</sheetView>");
            }
        } else if (this.sheet.isScrollToVisibleArea() && this.startHeaderRow > 1) {
            this.bw.write(" topLeftCell=\"");
            char[] cols = Sheet.int2Col(this.columns[0].realColIndex);
            this.bw.write(cols);
            this.bw.writeInt(this.startHeaderRow);
            this.bw.write("\">");
            this.bw.write("<selection activeCell=\"");
            this.bw.write(cols);
            this.bw.writeInt(this.startHeaderRow);
            this.bw.write("\" sqref=\"");
            this.bw.write(cols);
            this.bw.writeInt(this.startHeaderRow);
            this.bw.write("\"/></sheetView>");
        } else {
            this.bw.write("/>");
        }
        this.bw.write("</sheetViews>");
    }

    protected void writeSheetFormat(int fillSpace, String defaultWidth) throws IOException {
        this.bw.write("<sheetFormatPr defaultRowHeight=\"18.5\" defaultColWidth=\"");
        this.bw.write(defaultWidth);
        this.bw.write(34);
        int i = fillSpace - defaultWidth.length();
        while (i-- >= 0) {
            this.bw.write(32);
        }
        this.bw.write("/>");
    }

    protected void writeCols(int fillSpace, String defaultWidth) throws IOException {
        if (this.columns.length > 0) {
            this.bw.write("<cols>");
            for (int i = 0; i < this.columns.length; ++i) {
                Column col = this.columns[i];
                String width = col.width >= 1.0E-7 ? new BigDecimal(col.width).setScale(2, 4).toString() : defaultWidth;
                int w = width.length();
                this.bw.write("<col customWidth=\"1\" width=\"");
                this.bw.write(width);
                if (col.isHide()) {
                    this.bw.write("\" hidden=\"1");
                    w += 11;
                }
                this.bw.write(34);
                int j = fillSpace - w;
                while (j-- > 0) {
                    this.bw.write(32);
                }
                this.bw.write(" min=\"");
                this.bw.writeInt(col.getRealColIndex());
                this.bw.write("\" max=\"");
                this.bw.writeInt(col.getRealColIndex());
                this.bw.write("\" bestFit=\"1\"/>");
            }
            this.bw.write("</cols>");
        }
    }

    protected void beforeSheetData(boolean nonHeader) throws IOException {
        if (this.sheetDataReady > 0) {
            return;
        }
        this.bw.write("<sheetData>");
        int headerRow = 0;
        if (!nonHeader && this.columns.length > 0) {
            headerRow = this.writeHeaderRow();
        }
        this.startRow = this.startHeaderRow + headerRow;
        this.sheetDataReady = 1;
    }

    protected void afterSheetData() throws IOException {
        RelManager relManager;
        Relationship r = this.sheet.findRel("vmlDrawing");
        if (r != null) {
            this.bw.write("<legacyDrawing r:id=\"");
            this.bw.write(r.getId());
            this.bw.write("\"/>");
        } else if (this.comments != null) {
            r = new Relationship("../drawings/vmlDrawing" + this.sheet.getId() + ".vml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing");
            this.sheet.addRel(r);
            this.sheet.addRel(new Relationship("../comments" + this.sheet.getId() + ".xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments"));
            this.bw.write("<legacyDrawing r:id=\"");
            this.bw.write(r.getId());
            this.bw.write("\"/>");
        }
        this.writeWaterMark();
        if (this.drawingsWriter != null && (r = (relManager = this.sheet.getRelManager()).getByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing")) != null) {
            this.bw.write("<drawing r:id=\"");
            this.bw.write(r.getId());
            this.bw.write("\"/>");
        }
    }

    protected void writeWaterMark() throws IOException {
        WaterMark waterMark = this.sheet.getWaterMark();
        if (waterMark == null || !waterMark.canWrite()) {
            waterMark = this.sheet.getWorkbook().getWaterMark();
            this.sheet.setWaterMark(waterMark);
        }
        if (waterMark != null && waterMark.canWrite()) {
            Path media = this.workSheetPath.getParent().resolve("media");
            if (!FileUtil.exists(media)) {
                Files.createDirectory(media, new FileAttribute[0]);
            }
            Path image = media.resolve("image" + this.sheet.getWorkbook().incrementMediaCounter() + waterMark.getSuffix());
            Files.copy(waterMark.get(), image, new CopyOption[0]);
            Relationship r = new Relationship("../media/" + image.getFileName(), "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            this.sheet.addRel(r);
            this.bw.write("<picture r:id=\"");
            this.bw.write(r.getId());
            this.bw.write("\"/>");
        }
    }

    protected void writeMergeCells() throws IOException {
        List mergeCells = (List)this.sheet.getExtPropValue("merge_cells");
        if (mergeCells != null && !mergeCells.isEmpty()) {
            this.bw.write("<mergeCells count=\"");
            this.bw.writeInt(mergeCells.size());
            this.bw.write("\">");
            for (Dimension dim : mergeCells) {
                this.bw.write("<mergeCell ref=\"");
                this.bw.write(dim.toString());
                this.bw.write("\"/>");
            }
            this.bw.write("</mergeCells>");
        }
    }

    protected double stringWidth(String s, int xf) {
        int w;
        char c;
        if (StringUtil.isEmpty(s)) {
            return 0.0;
        }
        Font font = this.getFont(xf);
        int fs = font.getSize();
        FontMetrics fm = font.getFontMetrics();
        int len = s.length();
        int i = 0;
        for (w = 0; i < len && w < 1500 && (c = s.charAt(i++)) != '\n'; w += c > '\u4e00' ? fs : fm.charWidth(c)) {
        }
        if (i < len && w < 1500 && s.charAt(i - 1) == '\n') {
            int style = this.styles.getStyleByIndex(xf);
            if (Styles.hasWrapText(style)) {
                do {
                    int sectionWidth;
                    for (sectionWidth = 0; i < len && sectionWidth < 1500 && (c = s.charAt(i++)) != '\n'; sectionWidth += c > '\u4e00' ? fs : fm.charWidth(c)) {
                    }
                    if (sectionWidth <= w) continue;
                    w = sectionWidth;
                } while (i < len && w < 1500);
            } else {
                while (i < len && w < 1500) {
                    w += (c = s.charAt(i++)) > '\u4e00' ? fs : fm.charWidth(c);
                }
            }
        }
        return (double)w / 6.0 * 1.02;
    }

    public static boolean isFirstMergedCell(List<Dimension> mergeCells, int row, int col) {
        for (Dimension dim : mergeCells) {
            if (!dim.checkRange(row, col) || row != dim.firstRow || col != dim.firstColumn) continue;
            return true;
        }
        return false;
    }

    public double getHeaderHeight(Column[][] columnsArray, int row) {
        double h = -1.0;
        for (Column[] cols : columnsArray) {
            h = Math.max(cols[row].headerHeight, h);
        }
        return h;
    }

    protected boolean hasMedia() {
        boolean hasMedia = false;
        for (Column column : this.columns) {
            boolean bl = hasMedia = column.getColumnType() == 1;
            if (hasMedia) break;
        }
        return hasMedia;
    }

    protected void initDrawingsWriter() throws IOException {
        if (this.hasMedia()) {
            if (this.mediaPath == null) {
                this.mediaPath = Files.createDirectories(this.workSheetPath.getParent().resolve("media"), new FileAttribute[0]);
            }
            if (this.drawingsWriter == null) {
                this.drawingsWriter = this.createDrawingsWriter();
            }
        }
    }

    public IDrawingsWriter createDrawingsWriter() {
        int id = this.sheet.getWorkbook().incrementDrawingCounter();
        this.sheet.getWorkbook().addContentType(new ContentType.Override("application/vnd.openxmlformats-officedocument.drawing+xml", "/xl/drawings/drawing" + id + ".xml"));
        this.sheet.addRel(new Relationship("../drawings/drawing" + id + ".xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing"));
        return new XMLDrawingsWriter(this.workSheetPath.getParent().resolve("drawings").resolve("drawing" + id + ".xml"));
    }

    public void downloadRemoteResource(Picture picture, String url) throws IOException {
        try {
            if (url.charAt(0) == 'h') {
                HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
                con.connect();
                InputStream is = con.getInputStream();
                if (is != null) {
                    int i;
                    ByteArrayOutputStream bos = new ByteArrayOutputStream(262144);
                    byte[] bytes = new byte[262144];
                    while ((i = is.read(bytes)) > 0) {
                        bos.write(bytes, 0, i);
                    }
                    this.downloadCompleted(picture, bos.toByteArray());
                    return;
                }
                con.disconnect();
            }
            this.downloadCompleted(picture, null);
        }
        catch (IOException e) {
            this.LOGGER.error("Download remote resource [{}] error", (Object)url, (Object)e);
            throw e;
        }
    }

    public void downloadCompleted(Picture picture, byte[] body) throws IOException {
        this.LOGGER.debug("completed Row: {} len: {}", (Object)picture.row, (Object)(body != null ? body.length : 0));
        if (body == null || body.length == 0) {
            this.drawingsWriter.complete(picture);
            return;
        }
        FileSignatures.Signature signature = FileSignatures.test(ByteBuffer.wrap(body));
        if (signature != null && signature.isTrusted()) {
            String name = "image" + picture.id + "." + signature.extension;
            Files.write(this.mediaPath.resolve(name), body, StandardOpenOption.CREATE_NEW);
            picture.picName = name;
            picture.size = signature.width << 16 | signature.height;
            this.sheet.getWorkbook().addContentType(new ContentType.Default(signature.contentType, signature.extension));
        } else {
            this.LOGGER.warn("File types that are not allowed");
        }
        this.drawingsWriter.complete(picture);
    }

    protected void writePictureDirect(int id, String name, int column, int row, FileSignatures.Signature signature) throws IOException {
        Picture picture = this.createPicture(column, row);
        picture.id = id;
        picture.picName = name;
        picture.size = signature.width << 16 | signature.height;
        this.drawingsWriter.drawing(picture);
        this.sheet.getWorkbook().addContentType(new ContentType.Default(signature.contentType, signature.extension));
    }

    protected Picture createPicture(int column, int row) {
        Picture picture = new Picture();
        picture.col = column;
        picture.row = row;
        picture.setPadding(1);
        picture.effect = this.getColumn((int)column).effect;
        return picture;
    }

    protected void collectHeaderColumns() {
        boolean hasSharedString = false;
        for (Column col : this.columns) {
            this.includeAutoWidth |= col.getAutoSize() == 1;
            hasSharedString |= col.isShare();
        }
        if (hasSharedString) {
            this.sst.init();
        }
        if (this.includeAutoWidth) {
            this.columnWidths = new double[this.columns.length];
        }
    }

    protected Font getFont(int xf) {
        Font f;
        if (xf >= this.fs.length) {
            this.fs = Arrays.copyOf(this.fs, Math.max(xf, this.fs.length + 100));
        }
        if ((f = this.fs[xf]) == null) {
            int style = this.styles.getStyleByIndex(xf);
            this.fs[xf] = f = this.styles.getFont(style);
        }
        return f;
    }

    protected Column getColumn(int index) {
        Column hc;
        Column column = hc = index < this.columns.length ? this.columns[index] : null;
        if (hc == null) {
            hc = Column.UNALLOCATED_COLUMN;
            hc.realColIndex = index + 1;
        }
        return hc;
    }
}

