/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dom4j.Element;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.util.StringUtil;

public class NumFmt
implements Comparable<NumFmt> {
    public static final NumFmt DATETIME_FORMAT = new NumFmt("yyyy\\-mm\\-dd\\ hh:mm:ss");
    public static final NumFmt DATE_FORMAT = new NumFmt("yyyy\\-mm\\-dd");
    public static final NumFmt TIME_FORMAT = new NumFmt("hh:mm:ss");
    protected String code;
    protected int id = -1;
    static final Font SONG = new Font("\u5b8b\u4f53", 11);
    protected transient Map<String, Integer> codeWidthCache;

    public NumFmt() {
    }

    NumFmt(int id, String code) {
        this.id = id;
        this.code = code;
    }

    public NumFmt(String code) {
        this.code = NumFmt.clean(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    NumFmt setId(int id) {
        this.id = id;
        return this;
    }

    public int getId() {
        return this.id;
    }

    public static NumFmt valueOf(int id) {
        return new NumFmt().setId(id);
    }

    public static NumFmt of(String code) {
        return new NumFmt(code);
    }

    private static String clean(String code) {
        if (StringUtil.isEmpty(code)) {
            throw new NumberFormatException("The format code must not be null or empty.");
        }
        code = NumFmt.escape(code, '-');
        code = NumFmt.escape(code, ' ');
        return code;
    }

    private static String escape(String code, char c) {
        int i = code.indexOf(c);
        if (i > -1) {
            int j = 0;
            StringBuilder buf = new StringBuilder();
            do {
                if (i != j) {
                    buf.append(code, j, i);
                    j = i;
                }
                if (i != 0 && code.charAt(i - 1) == '\\') continue;
                buf.append('\\');
            } while ((i = code.indexOf(c, i + 1)) > -1);
            code = buf.append(code, j, code.length()).toString();
        }
        return code;
    }

    @Deprecated
    public double calcNumWidth(double base) {
        return this.calcNumWidth(base, SONG);
    }

    public double calcNumWidth(double base, Font font) {
        if (StringUtil.isBlank(this.code)) {
            return 0.0;
        }
        int widthCache = this.getCodeWidthFromCache(font);
        double width = 0.0;
        if ((widthCache & 1) == 1) {
            width = (double)(widthCache >> 2) / 10000.0;
        } else if (base >= 1.0) {
            int comma = widthCache >>> 1 & 1;
            int k = widthCache >>> 2 & 0x3F;
            double s = (double)(widthCache >>> 8) / 10000.0;
            width = (base + (comma == 1 ? (base - 1.0) / 3.0 : 1.0) + (double)k) * s;
        }
        return width;
    }

    protected int getCodeWidthFromCache(Font font) {
        if (this.codeWidthCache == null) {
            this.codeWidthCache = new HashMap<String, Integer>();
        }
        return this.codeWidthCache.computeIfAbsent(font.getSize() + font.getName(), key -> {
            int wc = 0;
            boolean isDate = Styles.testCodeIsDate(this.code);
            String[] codes = this.code.split(";");
            int[] ks = new int[codes.length];
            FontMetrics fm = font.getFontMetrics();
            double s = (double)fm.stringWidth("1234567890.,: %*-+<>") / 120.0;
            double d = font.getSize2() / 6.0;
            for (int i = 0; i < codes.length; ++i) {
                char c;
                String code = codes[i];
                double n = 0.0;
                boolean ignore = false;
                boolean comma = false;
                int len = code.length();
                for (int j = 0; j < len; ++j) {
                    c = code.charAt(j);
                    if (c == '\"' || c == '\\') continue;
                    if (ignore) {
                        if (c != ']' && c != ')') continue;
                        ignore = false;
                        continue;
                    }
                    if (c == '[' || c == '(') {
                        ignore = true;
                        continue;
                    }
                    if (c == ',') {
                        comma = true;
                    } else if (c == '/' && j >= 2 && j + 2 < len) {
                        char p1 = code.charAt(j - 2);
                        char p2 = code.charAt(j - 1);
                        char n1 = code.charAt(j + 1);
                        char n2 = code.charAt(j + 2);
                        if (!((p1 != '\u4e0a' || n1 != '\u4e0b' || p2 != '\u5348' || n2 != '\u5348') && (p1 != 'a' && p1 != 'A' || n1 != 'p' && n1 != 'P' || p2 != 'm' && p2 != 'M' || n2 != 'm' && n2 != 'M'))) {
                            j += 2;
                            continue;
                        }
                    }
                    n += c > '\u4e00' ? d : s;
                }
                if (isDate) {
                    wc = (int)(n * 10000.0 + 0.5) << 2;
                    wc |= comma ? 3 : 1;
                    break;
                }
                int k = code.lastIndexOf(46);
                if (k < 0) {
                    for (k = code.length(); k > 0 && ((c = code.charAt(k - 1)) == '_' || c == ' ' || c == '.'); --k) {
                    }
                }
                int _len = len;
                if (len >= 2 && code.charAt(len - 1) == ')' && code.charAt(len - 2) == '_') {
                    --_len;
                }
                k = k >= 0 && _len > k ? _len - k : 0;
                ks[i] = k << 1 | (comma ? 1 : 0);
            }
            if (!isDate) {
                int max = Arrays.stream(ks).max().orElse(0);
                wc = max << 1;
                wc |= (int)(s * 10000.0 + 0.5) << 8;
            }
            return wc;
        });
    }

    public int hashCode() {
        return this.code != null ? this.code.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o instanceof NumFmt) {
            NumFmt other = (NumFmt)o;
            return Objects.equals(other.code, this.code);
        }
        return false;
    }

    public String toString() {
        return "id: " + this.id + ", code: " + this.code;
    }

    public Element toDom(Element root) {
        if (StringUtil.isEmpty(this.code)) {
            return root;
        }
        return root.addElement(StringUtil.lowFirstKey(this.getClass().getSimpleName())).addAttribute("formatCode", this.code).addAttribute("numFmtId", String.valueOf(this.id));
    }

    public static List<NumFmt> domToNumFmt(Element root) {
        Element ele = root.element("numFmts");
        if (ele == null) {
            return new ArrayList<NumFmt>();
        }
        List sub = ele.elements();
        ArrayList<NumFmt> numFmts = new ArrayList<NumFmt>(sub.size());
        for (Element e : sub) {
            String id = Styles.getAttr(e, "numFmtId");
            String code = Styles.getAttr(e, "formatCode");
            numFmts.add(new NumFmt(Integer.parseInt(id), code));
        }
        numFmts.sort(Comparator.comparingInt(NumFmt::getId));
        return numFmts;
    }

    @Override
    public int compareTo(NumFmt o) {
        return Integer.compare(this.id, o.id);
    }
}

