/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.I18N;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.BorderStyle;
import org.ttzero.excel.entity.style.BuildInColor;
import org.ttzero.excel.entity.style.BuiltInNumFmt;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.HlsColor;
import org.ttzero.excel.entity.style.Horizontals;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.PatternType;
import org.ttzero.excel.entity.style.Verticals;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main"}, value="styleSheet")
public class Styles
implements Storable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Styles.class);
    private final Map<Integer, Integer> map = new HashMap<Integer, Integer>();
    private final AtomicInteger counter = new AtomicInteger();
    private int[] styleIndex = new int[10];
    private Document document;
    private List<Font> fonts;
    private List<NumFmt> numFmts;
    private List<Fill> fills;
    private List<Border> borders;
    private Set<Integer> dateFmtCache;
    public static final int INDEX_NUMBER_FORMAT = 24;
    public static final int INDEX_FONT = 18;
    public static final int INDEX_FILL = 12;
    public static final int INDEX_BORDER = 6;
    public static final int INDEX_VERTICAL = 4;
    public static final int INDEX_HORIZONTAL = 1;
    public static final int INDEX_WRAP_TEXT = 0;
    private static final String[] attrNames = new String[]{"numFmtId", "fontId", "fillId", "borderId", "vertical", "horizontal", "wrapText", "applyNumberFormat", "applyFont", "applyFill", "applyBorder", "applyAlignment"};

    private Styles() {
    }

    public int of(int s) {
        int n = this.map.getOrDefault(s, -1);
        if (n == -1) {
            n = this.counter.getAndIncrement();
            this.map.put(s, n);
            if (n >= this.styleIndex.length) {
                this.styleIndex = Arrays.copyOf(this.styleIndex, this.styleIndex.length << 1);
            }
            this.styleIndex[n] = s;
        }
        return n;
    }

    public int getStyleByIndex(int styleIndex) {
        if (styleIndex >= this.counter.get()) {
            return -1;
        }
        return styleIndex >= 0 ? this.styleIndex[styleIndex] : -1;
    }

    public int size() {
        return this.map.size();
    }

    public static Styles create(I18N i18N) {
        Styles self = new Styles();
        self.document = Styles.createDocument();
        self.numFmts = new ArrayList<NumFmt>();
        self.fonts = new ArrayList<Font>();
        Font font1 = new Font(i18N.get("en-font-family"), 11, Color.black);
        self.addFont(font1);
        String lang = Locale.getDefault().toLanguageTag();
        Font font2 = new Font(i18N.get("local-font-family"), 11);
        if ("zh-CN".equals(lang)) {
            font2.setCharset(134);
        } else if ("zh-TW".equals(lang)) {
            font2.setCharset(136);
        }
        self.addFont(font2);
        self.fills = new ArrayList<Fill>();
        self.addFill(new Fill(PatternType.none));
        self.addFill(new Fill(PatternType.gray125));
        self.borders = new ArrayList<Border>();
        self.addBorder(Border.parse("none"));
        self.addBorder(new Border(BorderStyle.THIN, new Color(191, 191, 191)));
        self.of(0);
        return self;
    }

    public int modifyBorder(int style, Border newBorder) {
        return Styles.clearBorder(style) | this.addBorder(newBorder);
    }

    public int modifyNumFmt(int style, NumFmt newNumFmt) {
        return Styles.clearNumFmt(style) | this.addNumFmt(newNumFmt);
    }

    public int modifyWrapText(int style, boolean newWrapText) {
        return newWrapText ? style | 1 : Styles.clearWrapText(style);
    }

    public int modifyVertical(int style, int newVertical) {
        return Styles.clearVertical(style) | newVertical;
    }

    public int modifyHorizontal(int style, int newHorizontal) {
        return Styles.clearHorizontal(style) | newHorizontal;
    }

    public int modifyFill(int style, Fill newFill) {
        return Styles.clearFill(style) | this.addFill(newFill);
    }

    public int modifyFont(int style, Font newFont) {
        return Styles.clearFont(style) | this.addFont(newFont);
    }

    public static Styles forReader() {
        Styles styles = new Styles();
        styles.numFmts = new ArrayList<NumFmt>();
        styles.fonts = new ArrayList<Font>();
        styles.fills = new ArrayList<Fill>();
        styles.borders = new ArrayList<Border>();
        return styles;
    }

    public static Styles load(InputStream is) {
        int i;
        Document document;
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(is);
        }
        catch (DocumentException e) {
            LOGGER.warn("Read the style failed and ignore the style to continue.", (Throwable)e);
            Styles self = Styles.forReader();
            self.addFont(new Font("Arial", 11, Color.black));
            return self;
        }
        Styles self = new Styles();
        Element root = document.getRootElement();
        self.numFmts = NumFmt.domToNumFmt(root);
        Element colors = root.element("colors");
        if (colors != null) {
            colors = colors.element("indexedColors");
        }
        if (colors != null && colors.nodeCount() > 0) {
            List sub = colors.elements();
            Color[] indexedColors = new Color[sub.size()];
            i = 0;
            for (Element e : sub) {
                indexedColors[i++] = Styles.parseColor(e);
            }
            self.fonts = Font.domToFont(root, indexedColors);
            self.fills = Fill.domToFill(root, indexedColors);
            self.borders = Border.domToBorder(root, indexedColors);
        } else {
            self.fonts = Font.domToFont(root);
            self.fills = Fill.domToFill(root);
            self.borders = Border.domToBorder(root);
        }
        Element cellXfs = root.element("cellXfs");
        List sub = cellXfs.elements();
        i = 0;
        for (Element e : sub) {
            Element alignment;
            String borderId;
            String fillId;
            String fontId;
            int style = 0;
            String numFmtId = Styles.getAttr(e, "numFmtId");
            if (StringUtil.isNotEmpty(numFmtId) && !"0".equals(numFmtId)) {
                style |= Integer.parseInt(numFmtId) << 24;
            }
            if (StringUtil.isNotEmpty(fontId = Styles.getAttr(e, "fontId")) && !"0".equals(fontId)) {
                style |= Integer.parseInt(fontId) << 18;
            }
            if (StringUtil.isNotEmpty(fillId = Styles.getAttr(e, "fillId")) && !"0".equals(fillId)) {
                style |= Integer.parseInt(fillId) << 12;
            }
            if (StringUtil.isNotEmpty(borderId = Styles.getAttr(e, "borderId")) && !"0".equals(borderId)) {
                style |= Integer.parseInt(borderId) << 6;
            }
            if ((alignment = e.element("alignment")) != null) {
                String vertical;
                int index;
                String horizontal = Styles.getAttr(alignment, "horizontal");
                if (StringUtil.isNotEmpty(horizontal) && (index = StringUtil.indexOf(Horizontals._names, horizontal)) >= 0) {
                    style |= index << 1;
                }
                style = StringUtil.isNotEmpty(vertical = Styles.getAttr(alignment, "vertical")) && (index = StringUtil.indexOf(Verticals._names, vertical)) >= 0 ? (style |= index << 4) : (style |= 0x10);
                String wrapText = Styles.getAttr(alignment, "wrapText");
                style |= ("1".equals(wrapText) || "true".equalsIgnoreCase(wrapText) ? 1 : 0) << 0;
            }
            self.map.put(style, i);
            if (i >= self.styleIndex.length) {
                self.styleIndex = Arrays.copyOf(self.styleIndex, self.styleIndex.length << 1);
            }
            self.styleIndex[i] = style;
            ++i;
        }
        self.counter.set(i);
        for (Integer styleIndex : self.map.values()) {
            self.isDate(styleIndex);
        }
        return self;
    }

    public final int addNumFmt(NumFmt numFmt) {
        if (numFmt.getId() < 0 || numFmt.getId() > 58) {
            if (StringUtil.isEmpty(numFmt.getCode())) {
                throw new NullPointerException("NumFmt code");
            }
            int index = BuiltInNumFmt.indexOf(numFmt.getCode());
            if (index > -1) {
                numFmt.setId(index);
            } else {
                int i = this.numFmts.indexOf(numFmt);
                if (i <= -1) {
                    int id = this.numFmts.isEmpty() ? 164 : this.numFmts.get(this.numFmts.size() - 1).getId() + 1;
                    numFmt.setId(id);
                    this.numFmts.add(numFmt);
                } else {
                    numFmt.setId(this.numFmts.get(i).getId());
                }
            }
        }
        return numFmt.getId() << 24;
    }

    public final int addFont(Font font) {
        if (StringUtil.isEmpty(font.getName())) {
            throw new IllegalArgumentException("Font name not support.");
        }
        int i = this.fonts.indexOf(font);
        if (i <= -1) {
            i = this.fonts.size();
            this.fonts.add(font);
        }
        return i << 18;
    }

    public final int addFill(Fill fill) {
        int i = this.fills.indexOf(fill);
        if (i <= -1) {
            i = this.fills.size();
            this.fills.add(fill);
        }
        return i << 12;
    }

    public final int addBorder(Border border) {
        int i = this.borders.indexOf(border);
        if (i <= -1) {
            i = this.borders.size();
            this.borders.add(border);
        }
        return i << 6;
    }

    public static int[] unpack(int style) {
        int[] styles = new int[]{style >>> 24, style << 8 >>> 26, style << 14 >>> 26, style << 20 >>> 26, style << 26 >>> 30, style << 28 >>> 29, style << 31 >>> 31};
        return styles;
    }

    public static int pack(int[] styles) {
        return styles[0] << 24 | styles[1] << 18 | styles[2] << 12 | styles[3] << 6 | styles[4] << 4 | styles[5] << 1 | styles[6] << 0;
    }

    @Override
    public void writeTo(Path styleFile) throws IOException {
        Element element;
        if (this.document == null) {
            this.document = Styles.createDocument();
        }
        Element root = this.document.getRootElement();
        if (!this.numFmts.isEmpty()) {
            element = this.document.getRootElement().element("numFmts");
            element.attribute("count").setValue(String.valueOf(this.numFmts.size()));
            for (NumFmt numFmt : this.numFmts) {
                numFmt.toDom(element);
            }
        }
        if (!this.fonts.isEmpty()) {
            element = this.document.getRootElement().element("fonts");
            element.attribute("count").setValue(String.valueOf(this.fonts.size()));
            for (Font font : this.fonts) {
                font.toDom(element);
            }
        }
        if (!this.fills.isEmpty()) {
            element = this.document.getRootElement().element("fills");
            element.attribute("count").setValue(String.valueOf(this.fills.size()));
            for (Fill fill : this.fills) {
                fill.toDom(element);
            }
        }
        if (!this.borders.isEmpty()) {
            element = this.document.getRootElement().element("borders");
            element.attribute("count").setValue(String.valueOf(this.borders.size()));
            for (Border border : this.borders) {
                border.toDom(element);
            }
        }
        Element cellXfs = root.element("cellXfs").addAttribute("count", String.valueOf(this.map.size()));
        int len = this.counter.get();
        for (int i = 0; i < len; ++i) {
            int[] styles = Styles.unpack(this.styleIndex[i]);
            Element newXf = cellXfs.addElement("xf");
            newXf.addAttribute(attrNames[0], String.valueOf(styles[0])).addAttribute(attrNames[1], String.valueOf(styles[1])).addAttribute(attrNames[2], String.valueOf(styles[2])).addAttribute(attrNames[3], String.valueOf(styles[3])).addAttribute("xfId", "0");
            int start = 7;
            if (styles[0] > 0) {
                newXf.addAttribute(attrNames[start], "1");
            }
            if (styles[1] > 0) {
                newXf.addAttribute(attrNames[start + 1], "1");
            }
            if (styles[2] > 0) {
                newXf.addAttribute(attrNames[start + 2], "1");
            }
            if (styles[3] > 0) {
                newXf.addAttribute(attrNames[start + 3], "1");
            }
            if ((styles[4] | styles[5] | styles[6]) > 0) {
                newXf.addAttribute(attrNames[start + 4], "1");
            }
            Element subEle = newXf.addElement("alignment").addAttribute(attrNames[4], Verticals._names[styles[4]]);
            if (styles[5] > 0) {
                subEle.addAttribute(attrNames[5], Horizontals._names[styles[5]]);
            }
            if (styles[6] <= 0) continue;
            subEle.addAttribute(attrNames[6], "1");
        }
        FileUtil.writeToDiskNoFormat(this.document, styleFile);
    }

    public static Document createDocument() {
        DocumentFactory factory = DocumentFactory.getInstance();
        TopNS ns = Styles.class.getAnnotation(TopNS.class);
        Element rootElement = ns != null ? factory.createElement(ns.value(), ns.uri()[0]) : factory.createElement("styleSheet", "http://schemas.openxmlformats.org/spreadsheetml/2006/main");
        rootElement.addElement("numFmts").addAttribute("count", "0");
        rootElement.addElement("fonts").addAttribute("count", "0");
        rootElement.addElement("fills").addAttribute("count", "0");
        rootElement.addElement("borders").addAttribute("count", "0");
        Element cellStyleXfs = rootElement.addElement("cellStyleXfs").addAttribute("count", "1");
        cellStyleXfs.addElement("xf").addAttribute("borderId", "0").addAttribute("fillId", "0").addAttribute("fontId", "0").addAttribute("numFmtId", "0").addElement("alignment").addAttribute("vertical", "center");
        rootElement.addElement("cellXfs").addAttribute("count", "0");
        Element cellStyles = rootElement.addElement("cellStyles").addAttribute("count", "1");
        cellStyles.addElement("cellStyle").addAttribute("builtinId", "0").addAttribute("name", "\u5e38\u89c4").addAttribute("xfId", "0");
        return factory.createDocument(rootElement);
    }

    public static int clearNumFmt(int style) {
        return style & 0xFFFFFF;
    }

    public static int clearFont(int style) {
        return style & 0xFF03FFFF;
    }

    public static int clearFill(int style) {
        return style & 0xFFFC0FFF;
    }

    public static int clearBorder(int style) {
        return style & 0xFFFFF03F;
    }

    public static int clearVertical(int style) {
        return style & 0xFFFFFFCF;
    }

    public static int clearHorizontal(int style) {
        return style & 0xFFFFFFF1;
    }

    public static int clearWrapText(int style) {
        return style & 0xFFFFFFFE;
    }

    @Deprecated
    public static int reset(int style, int newStyle) {
        int[] sub = Styles.unpack(style);
        int[] nsub = Styles.unpack(newStyle);
        for (int i = 0; i < sub.length; ++i) {
            if (nsub[i] <= 0) continue;
            sub[i] = nsub[i];
        }
        return Styles.pack(sub);
    }

    public static int defaultCharBorderStyle() {
        return 262214;
    }

    public static int defaultStringBorderStyle() {
        return 262210;
    }

    public static int defaultIntBorderStyle() {
        return 262212;
    }

    public static int defaultDoubleBorderStyle() {
        return 262212;
    }

    public static int defaultCharStyle() {
        return 262150;
    }

    public static int defaultStringStyle() {
        return 262146;
    }

    public static int defaultIntStyle() {
        return 262148;
    }

    public static int defaultDoubleStyle() {
        return 262148;
    }

    public static boolean hasNumFmt(int style) {
        return style >>> 24 != 0;
    }

    public static boolean hasFont(int style) {
        return true;
    }

    public static boolean hasFill(int style) {
        return style << 14 >>> 26 != 0;
    }

    public static boolean hasBorder(int style) {
        return style << 20 >>> 26 != 0;
    }

    public static boolean hasVertical(int style) {
        return style << 26 >>> 30 != 0;
    }

    public static boolean hasHorizontal(int style) {
        return style << 28 >>> 29 != 0;
    }

    public static boolean hasWrapText(int style) {
        return (style & 1) > 0;
    }

    public NumFmt getNumFmt(int style) {
        int n = style >>> 24;
        if (n <= 0) {
            return null;
        }
        NumFmt fmt = null;
        for (NumFmt e : this.numFmts) {
            if (e.id != n) continue;
            fmt = e;
            break;
        }
        if (fmt == null && (fmt = BuiltInNumFmt.get(n)) == null && n <= 58) {
            fmt = new NumFmt().setId(n);
        }
        return fmt;
    }

    public Fill getFill(int style) {
        return this.fills.get(style << 14 >>> 26);
    }

    public Font getFont(int style) {
        return this.fonts.get(Math.max(0, style << 8 >>> 26));
    }

    public Border getBorder(int style) {
        return this.borders.get(style << 20 >>> 26);
    }

    public int getVertical(int style) {
        return style << 26 >>> 30 << 4;
    }

    public int getHorizontal(int style) {
        return style << 28 >>> 29 << 1;
    }

    public int getWrapText(int style) {
        return style & 1;
    }

    public static String getAttr(Element element, String attr) {
        return element != null ? element.attributeValue(attr) : null;
    }

    public static Color parseColor(Element element) {
        if (element == null) {
            return null;
        }
        String rgb = Styles.getAttr(element, "rgb");
        String indexed = Styles.getAttr(element, "indexed");
        String auto = Styles.getAttr(element, "auto");
        String theme = Styles.getAttr(element, "theme");
        Color c = null;
        if (StringUtil.isNotEmpty(rgb)) {
            c = Styles.toColor(rgb);
        } else if (StringUtil.isNotEmpty(indexed)) {
            c = new BuildInColor(Integer.parseInt(indexed));
        } else if ("1".equals(auto) || "true".equalsIgnoreCase(auto)) {
            c = new BuildInColor(64);
        } else if (StringUtil.isNotEmpty(theme)) {
            int t = 0;
            try {
                t = Integer.parseInt(theme);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (t < 0 || t > 11) {
                LOGGER.warn("Unknown theme color index {}", (Object)t);
                t = 0;
            }
            Color themeColor = ColorIndex.themeColors[t];
            String tint = Styles.getAttr(element, "tint");
            c = HlsColor.calculateColor(themeColor, tint);
        }
        return c;
    }

    public boolean isDate(int styleIndex) {
        NumFmt numFmt;
        if (this.fastTestDateFmt(styleIndex)) {
            return true;
        }
        if (styleIndex > this.counter.get()) {
            return false;
        }
        int style = this.styleIndex[styleIndex];
        int nf = style >> 24 & 0xFF;
        if (nf == 0) {
            return false;
        }
        boolean isDate = Styles.isBuildInDateFormat(nf);
        if (!isDate && (numFmt = this.findFmtById(nf)) != null && StringUtil.isNotEmpty(numFmt.getCode())) {
            isDate = Styles.testCodeIsDate(numFmt.getCode());
        }
        if (isDate) {
            if (this.dateFmtCache == null) {
                this.dateFmtCache = new HashSet<Integer>();
            }
            this.dateFmtCache.add(styleIndex);
        }
        return isDate;
    }

    private static boolean isBuildInDateFormat(int nf) {
        return nf < 164 && (nf >= 14 && nf <= 22 || nf >= 27 && nf <= 36 || nf >= 45 && nf <= 47 || nf >= 50 && nf <= 58 || nf == 81);
    }

    public static boolean testCodeIsDate(String code) {
        char[] chars = code.toCharArray();
        int score = 0;
        byte[] byteScore = new byte[26];
        int i = 0;
        int size = chars.length;
        while (i < size) {
            char c = chars[i];
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            int a = ++i;
            if (c == '[') {
                while (i < size && chars[i] != ']') {
                    ++i;
                }
                int len = i - a + 1;
                if (len == 6 && chars[a] == 'D' && chars[a + 1] == 'B' && chars[a + 2] == 'N' && chars[a + 3] == 'u' && chars[a + 4] == 'm') {
                    int n = chars[a + 5] - 48;
                    if (n == 1 || n == 2 || n == 3) continue;
                    break;
                }
                if (i - a <= 2 || chars[a] != '$' || chars[a + 1] != '-') continue;
                score = 50;
                continue;
            }
            switch (c) {
                case 'd': 
                case 'h': 
                case 'm': 
                case 's': 
                case 'y': {
                    while (i < size && chars[i] == c) {
                        ++i;
                    }
                    int n = c - 97;
                    byteScore[n] = (byte)(byteScore[n] + (i - a + 1));
                    break;
                }
                case 'a': 
                case 'p': {
                    if (a >= size || chars[a] != 'm') break;
                    int n = c - 97;
                    byteScore[n] = (byte)(byteScore[n] + 1);
                    break;
                }
            }
        }
        if (byteScore[24] > 4 || byteScore[7] > 4 || byteScore[18] > 4 || byteScore[0] > 1 || byteScore[15] > 1) {
            return false;
        }
        score += byteScore[0] * 5;
        score += byteScore[3] * 5;
        score += byteScore[7] * 5;
        score += byteScore[12] * 5;
        score += byteScore[15] * 5;
        score += byteScore[18] * 5;
        score += byteScore[24] * 5;
        if (byteScore[24] > 0 && byteScore[12] > 0 && byteScore[3] > 0 && byteScore[24] + byteScore[12] + byteScore[3] >= 4) {
            score += 70;
        } else if (byteScore[24] > 0 && byteScore[12] > 0 && byteScore[24] + byteScore[12] >= 3) {
            score += 60;
        } else if (byteScore[12] > 0 && byteScore[3] > 0) {
            score += 60;
        } else if (byteScore[24] == chars.length) {
            score += 60;
        }
        if (byteScore[7] > 0 && byteScore[12] > 0 && byteScore[18] > 0 && byteScore[7] + byteScore[12] + byteScore[18] > 3) {
            score += 70;
        } else if (byteScore[7] > 0 && byteScore[12] > 0) {
            score += 60;
        } else if (byteScore[12] > 0 && byteScore[18] > 0) {
            score += 60;
        }
        if (byteScore[0] + byteScore[15] == 2) {
            score += 50;
        }
        return score >= 70;
    }

    private NumFmt findFmtById(int id) {
        if (this.numFmts == null || this.numFmts.isEmpty()) {
            return null;
        }
        NumFmt fmt = this.numFmts.get(this.numFmts.size() - 1);
        if (fmt.getId() > id) {
            int n = Collections.binarySearch(this.numFmts, new NumFmt(id, null));
            return n >= 0 ? this.numFmts.get(n) : null;
        }
        return fmt.getId() == id ? fmt : null;
    }

    public boolean fastTestDateFmt(int styleIndex) {
        return this.dateFmtCache != null && this.dateFmtCache.contains(styleIndex);
    }

    public void addDateFmtCache(int xf) {
        if (this.dateFmtCache == null) {
            this.dateFmtCache = new HashSet<Integer>();
        }
        this.dateFmtCache.add(xf);
    }

    public static Color toColor(String v) {
        Color color = null;
        String source = v;
        if (v.charAt(0) != '#') {
            try {
                Field field = Color.class.getDeclaredField(v);
                color = (Color)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                if (v.length() > 6) {
                    v = v.substring(v.length() - 6);
                }
                v = '#' + v;
            }
        }
        if (color == null) {
            try {
                color = Color.decode(v);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Color \"" + source + "\" not support.");
            }
        }
        return color;
    }
}

