/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.e7.ContentType;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.entity.style.Theme;
import org.ttzero.excel.manager.ExcelType;
import org.ttzero.excel.manager.NS;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.manager.docProps.App;
import org.ttzero.excel.manager.docProps.Core;
import org.ttzero.excel.reader.AppInfo;
import org.ttzero.excel.reader.CalcSheet;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLCalcSheet;
import org.ttzero.excel.reader.XMLDrawings;
import org.ttzero.excel.reader.XMLSheet;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public class ExcelReader
implements Closeable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ExcelReader.class);
    @Deprecated
    public static final int VALUE_ONLY = 0;
    @Deprecated
    public static final int VALUE_AND_CALC = 2;
    @Deprecated
    public static final int COPY_ON_MERGED = 4;
    protected Sheet[] sheets;
    private Path temp;
    private ExcelType type;
    private AppInfo appInfo;
    protected Path tempDir;
    private SharedStrings sst;
    @Deprecated
    protected int option;
    protected boolean hasFormula;
    protected Drawings drawings;
    protected Styles styles;
    protected ZipFile zipFile;
    public static final Set<String> MUST_CHECK_PART = new HashSet<String>(Arrays.asList("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml"));

    protected ExcelReader() {
    }

    public static ExcelReader read(Path path) throws IOException {
        return ExcelReader.read(path, 0, 0, 0);
    }

    public static ExcelReader read(InputStream stream) throws IOException {
        return ExcelReader.read(stream, 0, 0, 0);
    }

    @Deprecated
    public static ExcelReader read(Path path, int option) throws IOException {
        return ExcelReader.read(path, 0, 0, option);
    }

    @Deprecated
    public static ExcelReader read(InputStream stream, int option) throws IOException {
        return ExcelReader.read(stream, 0, 0, option);
    }

    @Deprecated
    public static ExcelReader read(Path path, int bufferSize, int option) throws IOException {
        return ExcelReader.read(path, bufferSize, 0, option);
    }

    @Deprecated
    public static ExcelReader read(InputStream stream, int bufferSize, int option) throws IOException {
        return ExcelReader.read(stream, bufferSize, 0, option);
    }

    @Deprecated
    public static ExcelReader read(InputStream stream, int bufferSize, int cacheSize, int option) throws IOException {
        ExcelReader reader;
        Path temp = FileUtil.mktmp("eec-");
        if (temp == null) {
            throw new IOException("Create temp directory error. Please check your permission");
        }
        FileUtil.cp(stream, temp);
        try {
            reader = ExcelReader.read(temp, bufferSize, cacheSize, option);
        }
        catch (IOException ex) {
            FileUtil.rm(temp);
            throw ex;
        }
        catch (Exception ex) {
            FileUtil.rm(temp);
            throw new IOException(ex);
        }
        reader.temp = temp;
        return reader;
    }

    public ExcelType getType() {
        return this.type;
    }

    public Stream<Sheet> sheets() {
        Iterator<Sheet> iter = new Iterator<Sheet>(){
            int n = 0;

            @Override
            public boolean hasNext() {
                return this.n < ExcelReader.this.sheets.length;
            }

            @Override
            public Sheet next() {
                try {
                    return ExcelReader.this.sheets[this.n++].load();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
        return StreamSupport.stream(Spliterators.spliterator(iter, (long)this.sheets.length, 272), false);
    }

    public Sheet sheet(int index) {
        try {
            return this.sheets[index].load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Sheet sheet(String sheetName) {
        try {
            for (Sheet t : this.sheets) {
                if (!sheetName.equals(t.getName())) continue;
                return t.load();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return null;
    }

    public Sheet[] all() {
        return this.sheets;
    }

    @Deprecated
    public int getSize() {
        return this.getSheetCount();
    }

    public int getSheetCount() {
        return this.sheets != null ? this.sheets.length : 0;
    }

    @Override
    public void close() throws IOException {
        if (this.sheets != null) {
            for (Sheet st : this.sheets) {
                st.close();
            }
        }
        if (this.sst != null) {
            this.sst.close();
        }
        if (this.zipFile != null) {
            this.zipFile.close();
        }
        if (this.temp != null) {
            FileUtil.rm(this.temp);
        }
        if (this.tempDir != null) {
            FileUtil.rm_rf(this.tempDir);
        }
    }

    public AppInfo getAppInfo() {
        return this.appInfo != null ? this.appInfo : (this.appInfo = this.getGeneralInfo());
    }

    @Deprecated
    public boolean hasFormula() {
        return this.hasFormula;
    }

    @Deprecated
    public ExcelReader parseFormula() {
        if (this.hasFormula) {
            ZipEntry entry = this.getEntry("xl/calcChain.xml");
            if (entry == null) {
                return this;
            }
            long[][] calcArray = null;
            try (InputStream is = this.zipFile.getInputStream(entry);){
                calcArray = ExcelReader.parseCalcChain(is);
            }
            catch (IOException ex) {
                LOGGER.warn("Part of `calcChain` has be damaged, It will be ignore all formulas.", (Throwable)ex);
            }
            if (calcArray == null) {
                return this;
            }
            for (int i = 0; i < this.sheets.length; ++i) {
                int n = this.sheets[i].getId();
                if (calcArray[n - 1] == null) continue;
                if (!(this.sheets[i] instanceof CalcSheet)) {
                    this.sheets[i] = this.sheets[i].asCalcSheet();
                }
                if (!(this.sheets[i] instanceof XMLCalcSheet)) continue;
                ((XMLCalcSheet)this.sheets[i]).setCalc(calcArray[n - 1]);
            }
        } else {
            for (Sheet sheet : this.sheets) {
                sheet.asCalcSheet();
            }
        }
        return this;
    }

    @Deprecated
    public ExcelReader copyOnMergeCells() {
        for (int i = 0; i < this.sheets.length; ++i) {
            if (this.sheets[i] instanceof MergeSheet) continue;
            this.sheets[i] = this.sheets[i].asMergeSheet();
        }
        return this;
    }

    protected ContentType checkContentType() {
        Document document;
        ZipEntry entry = this.getEntry("[Content_Types].xml");
        if (entry == null) {
            if (this.temp != null) {
                FileUtil.rm(this.temp);
            }
            throw new ExcelReadException("The file format is incorrect or corrupted. [[Content_Types].xml]");
        }
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(this.zipFile.getInputStream(entry));
        }
        catch (IOException | DocumentException e) {
            if (this.temp != null) {
                FileUtil.rm(this.temp);
            }
            throw new ExcelReadException("The file format is incorrect or corrupted. [[Content_Types].xml]");
        }
        ContentType contentType = new ContentType();
        List list = document.getRootElement().elements();
        for (Element e : list) {
            if ("Override".equals(e.getName())) {
                ContentType.Override override = new ContentType.Override(e.attributeValue("ContentType"), e.attributeValue("PartName"));
                entry = this.getEntry(override.getPartName());
                if (entry == null) {
                    if (MUST_CHECK_PART.contains(override.getContentType())) {
                        if (this.temp != null) {
                            FileUtil.rm(this.temp);
                        }
                        throw new ExcelReadException("The file format is incorrect or corrupted. [" + override.getPartName() + "]");
                    }
                    LOGGER.warn("{} is configured in [Content_Types].xml, but the corresponding file is missing.", (Object)override.getKey());
                }
                contentType.add(override);
                continue;
            }
            if (!"Default".equals(e.getName())) continue;
            contentType.add(new ContentType.Default(e.attributeValue("ContentType"), e.attributeValue("Extension")));
        }
        return contentType;
    }

    public ExcelReader(InputStream stream) throws IOException {
        this(stream, 0, 0, 0);
    }

    @Deprecated
    public ExcelReader(InputStream stream, int option) throws IOException {
        this(stream, 0, 0, option);
    }

    @Deprecated
    public ExcelReader(InputStream stream, int bufferSize, int cacheSize, int option) throws IOException {
        Path temp = FileUtil.mktmp("eec-");
        if (temp == null) {
            throw new IOException("Create temp directory error. Please check permission");
        }
        FileUtil.cp(stream, temp);
        this.temp = temp;
        this.init(temp, bufferSize, cacheSize, option);
    }

    public ExcelReader(Path path) throws IOException {
        this.init(path, 0, 0, 0);
    }

    @Deprecated
    public ExcelReader(Path path, int option) throws IOException {
        this.init(path, 0, 0, option);
    }

    @Deprecated
    public ExcelReader(Path path, int bufferSize, int cacheSize, int option) throws IOException {
        this.init(path, bufferSize, cacheSize, option);
    }

    protected ExcelReader init(Path path, int bufferSize, int cacheSize, int option) throws IOException {
        Document document;
        this.zipFile = new ZipFile(path.toFile());
        LOGGER.debug("Check file integrity.");
        ContentType contentType = this.checkContentType();
        if (contentType.hasDrawings()) {
            this.drawings = new XMLDrawings(this);
        }
        SAXReader reader = SAXReader.createDefault();
        ZipEntry entry = this.getEntry("xl/sharedStrings.xml");
        if (entry != null) {
            this.sst = new SharedStrings(this.zipFile.getInputStream(entry), bufferSize, cacheSize).load();
        }
        if ((entry = this.getEntry("xl/styles.xml")) != null) {
            try {
                this.styles = Styles.load(this.zipFile.getInputStream(entry));
                ZipEntry themeEntry = this.getEntry("theme/theme1.xml");
                if (themeEntry != null) {
                    Theme.load(this.zipFile.getInputStream(themeEntry));
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Parse style failed.", (Throwable)ex);
            }
        }
        if (this.styles == null) {
            this.styles = Styles.forReader();
        }
        this.option = option;
        this.hasFormula = this.getEntry("xl/calcChain.xml") != null;
        entry = this.getEntry("xl/_rels/workbook.xml.rels");
        if (entry == null) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [xl/_rels/workbook.xml.rels]");
        }
        try {
            document = reader.read(this.zipFile.getInputStream(entry));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [xl/_rels/workbook.xml.rels]");
        }
        List list = document.getRootElement().elements();
        Relationship[] rels = new Relationship[list.size()];
        int i = 0;
        for (Element e : list) {
            rels[i++] = new Relationship(e.attributeValue("Id"), e.attributeValue("Target"), e.attributeValue("Type"));
        }
        RelManager relManager = RelManager.of(rels);
        entry = this.getEntry("xl/workbook.xml");
        if (entry == null) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [xl/workbook.xml]");
        }
        try {
            document = reader.read(this.zipFile.getInputStream(entry));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [xl/workbook.xml]");
        }
        Element root = document.getRootElement();
        Namespace ns = root.getNamespaceForPrefix("r");
        ArrayList<XMLSheet> sheets = new ArrayList<XMLSheet>();
        Iterator sheetIter = root.element("sheets").elementIterator();
        int index = 0;
        while (sheetIter.hasNext()) {
            Element e = (Element)sheetIter.next();
            XMLSheet sheet = (XMLSheet)this.sheetFactory(option);
            sheet.setName(e.attributeValue("name"));
            sheet.setId(Integer.parseInt(e.attributeValue("sheetId")));
            String state = e.attributeValue("state");
            sheet.setHidden("hidden".equals(state));
            Relationship r = relManager.getById(e.attributeValue(QName.get((String)"id", (Namespace)ns)));
            if (r == null) {
                sheet.close();
                throw new ExcelReadException("The file format is incorrect or corrupted.");
            }
            sheet.setPath("xl/" + r.getTarget());
            entry = this.getEntry("xl/" + r.getTarget());
            if (entry == null) {
                sheet.close();
                throw new ExcelReadException("The file format is incorrect or corrupted.");
            }
            sheet.setZipFile(this.zipFile);
            sheet.setZipEntry(entry);
            sheet.setSharedStrings(this.sst);
            sheet.setStyles(this.styles);
            sheet.setDrawings(this.drawings);
            sheet.setIndex(index++);
            sheets.add(sheet);
        }
        if (sheets.isEmpty()) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [There has no worksheet]");
        }
        Sheet[] sheets1 = new Sheet[sheets.size()];
        sheets.toArray(sheets1);
        this.sheets = sheets1;
        if ((option >> 1 & 1) == 1) {
            this.parseFormula();
        }
        return this;
    }

    public static ExcelReader read(Path path, int bufferSize, int cacheSize, int option) throws IOException {
        ExcelReader er;
        if (!FileUtil.exists(path)) {
            throw new FileNotFoundException(path.toString());
        }
        ExcelType type = ExcelReader.getType(path);
        LOGGER.debug("File type: {}", (Object)type);
        switch (type) {
            case XLSX: {
                er = new ExcelReader(path, bufferSize, cacheSize, option);
                break;
            }
            case XLS: {
                try {
                    Class<?> clazz = Class.forName("org.ttzero.excel.reader.BIFF8Reader");
                    Constructor<?> constructor = clazz.getDeclaredConstructor(Path.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    er = (ExcelReader)constructor.newInstance(path, bufferSize, cacheSize, option);
                    break;
                }
                catch (ClassNotFoundException e) {
                    Properties pom = IWorkbookWriter.pom();
                    throw new ExcelReadException("Can not load 'org.ttzero.excel.reader.BIFF8Reader'. Please add dependency [" + pom.getProperty("groupId") + ":eec-e3-support:" + pom.getProperty("version") + "] to parse excel 97~2003.", e);
                }
                catch (InstantiationException | NoSuchMethodException e) {
                    Properties pom = IWorkbookWriter.pom();
                    throw new ExcelReadException("It may be an exception caused by eec-e3-support version error. Please add dependency [" + pom.getProperty("groupId") + ":eec-e3-support:" + pom.getProperty("version") + "]", e);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new ExcelReadException("Read excel failed.", e);
                }
            }
            default: {
                throw new ExcelReadException("Unknown file type.");
            }
        }
        er.type = type;
        return er;
    }

    protected Sheet sheetFactory(int option) {
        XMLSheet sheet;
        switch (option) {
            case 2: {
                sheet = new XMLSheet().asCalcSheet();
                break;
            }
            case 4: {
                sheet = new XMLSheet().asMergeSheet();
                break;
            }
            case 6: {
                sheet = new XMLSheet().asFullSheet();
                break;
            }
            default: {
                sheet = new XMLSheet();
            }
        }
        return sheet;
    }

    public static ExcelType getType(Path path) {
        ExcelType type;
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            byte[] bytes = new byte[8];
            int len = is.read(bytes);
            type = ExcelReader.typeOfStream(bytes, len);
        }
        catch (IOException e) {
            type = ExcelType.UNKNOWN;
        }
        return type;
    }

    private static ExcelType typeOfStream(byte[] bytes, int size) {
        ExcelType excelType = ExcelType.UNKNOWN;
        int length = Math.min(bytes.length, size);
        if (length < 4) {
            return excelType;
        }
        int type = bytes[0] & 0xFF;
        type += (bytes[1] & 0xFF) << 8;
        type += (bytes[2] & 0xFF) << 16;
        int zip = 67324752;
        int b1 = -535703600;
        int b2 = -518344287;
        if ((type += (bytes[3] & 0xFF) << 24) == zip) {
            excelType = ExcelType.XLSX;
        } else if (type == b1 && length >= 8) {
            type = bytes[4] & 0xFF;
            type += (bytes[5] & 0xFF) << 8;
            type += (bytes[6] & 0xFF) << 16;
            if ((type += (bytes[7] & 0xFF) << 24) == b2) {
                excelType = ExcelType.XLS;
            }
        }
        return excelType;
    }

    protected AppInfo getGeneralInfo() {
        Element root;
        Document document;
        SAXReader reader = SAXReader.createDefault();
        App app = null;
        Core core = null;
        ZipEntry entry = this.getEntry("docProps/app.xml");
        if (entry != null) {
            document = null;
            try {
                document = reader.read(this.zipFile.getInputStream(entry));
            }
            catch (IOException | DocumentException e) {
                LOGGER.warn("The file format is incorrect or corrupted. [docProps/app.xml]");
            }
            if (document != null) {
                root = document.getRootElement();
                app = new App();
                app.setCompany(root.elementText("Company"));
                app.setApplication(root.elementText("Application"));
                String v = root.elementText("AppVersion");
                if (StringUtil.isNotEmpty(v)) {
                    app.setAppVersion(v);
                }
            }
        } else {
            LOGGER.warn("The file format is incorrect or corrupted. [docProps/app.xml]");
        }
        entry = this.getEntry("docProps/core.xml");
        if (entry != null) {
            document = null;
            try {
                document = reader.read(this.zipFile.getInputStream(entry));
            }
            catch (IOException | DocumentException e) {
                LOGGER.warn("The file format is incorrect or corrupted. [docProps/core.xml]");
            }
            if (document != null) {
                root = document.getRootElement();
                core = new Core();
                Class<Core> clazz = Core.class;
                TopNS topNS = clazz.getAnnotation(TopNS.class);
                String[] prefixs = topNS.prefix();
                String[] urls = topNS.uri();
                Field[] fields = clazz.getDeclaredFields();
                SimpleDateFormat format = DateUtil.utcDateTimeFormat.get();
                for (Field f : fields) {
                    NS ns = f.getAnnotation(NS.class);
                    if (ns == null) continue;
                    f.setAccessible(true);
                    int nsIndex = StringUtil.indexOf(prefixs, ns.value());
                    if (nsIndex < 0) continue;
                    Namespace namespace = new Namespace(ns.value(), urls[nsIndex]);
                    Class<?> type = f.getType();
                    String v = root.elementText(new QName(f.getName(), namespace));
                    if (StringUtil.isEmpty(v)) continue;
                    if (type == String.class) {
                        try {
                            f.set(core, v);
                        }
                        catch (IllegalAccessException e) {
                            LOGGER.warn("Set field ({}) error.", (Object)f);
                        }
                        continue;
                    }
                    if (type != Date.class) continue;
                    try {
                        f.set(core, format.parse(v));
                    }
                    catch (IllegalAccessException | ParseException e) {
                        LOGGER.warn("Set field ({}) error.", (Object)f);
                    }
                }
            }
        } else {
            LOGGER.warn("The file format is incorrect or corrupted. [docProps/core.xml]");
        }
        return new AppInfo(app, core);
    }

    static long[][] parseCalcChain(InputStream is) {
        Element calcChain;
        SAXReader reader = SAXReader.createDefault();
        try {
            calcChain = reader.read(is).getRootElement();
        }
        catch (DocumentException e) {
            LOGGER.warn("Part of `calcChain` has be damaged, It will be ignore all formulas.");
            return null;
        }
        Iterator ite = calcChain.elementIterator();
        int i = 1;
        int n = 10;
        long[][] array = new long[n][];
        int[] indices = new int[n];
        while (ite.hasNext()) {
            long[] sub;
            Element e = (Element)ite.next();
            String si = e.attributeValue("i");
            String r = e.attributeValue("r");
            if (StringUtil.isNotEmpty(si)) {
                i = SharedStrings.toInt(si.toCharArray(), 0, si.length());
            }
            if (!StringUtil.isNotEmpty(r)) continue;
            if (n < i) {
                indices = Arrays.copyOf(indices, n <<= 1);
                long[][] _array = new long[n][];
                for (int j = 0; j < n; ++j) {
                    _array[j] = array[j];
                }
                array = _array;
            }
            if ((sub = array[i - 1]) == null) {
                array[i - 1] = sub = new long[10];
            }
            int n2 = i - 1;
            indices[n2] = indices[n2] + 1;
            if (indices[n2] > sub.length) {
                long[] _sub = new long[sub.length << 1];
                System.arraycopy(sub, 0, _sub, 0, sub.length);
                sub = _sub;
                array[i - 1] = _sub;
            }
            sub[indices[i - 1] - 1] = ExcelReader.coordinateToLong(r);
        }
        for (i = 0; i < n; ++i) {
            if (indices[i] > 0) {
                long[] a = Arrays.copyOf(array[i], indices[i]);
                Arrays.sort(a);
                array[i] = a;
                continue;
            }
            array[i] = null;
        }
        return array;
    }

    @Deprecated
    public static long cellRangeToLong(String r) {
        return ExcelReader.coordinateToLong(r);
    }

    public static long coordinateToLong(String r) {
        long v = 0L;
        int n = 0;
        int len = r.length();
        for (int i = 0; i < len; ++i) {
            char value = r.charAt(i);
            if (value >= 'A' && value <= 'Z') {
                v = v * 26L + (long)value - 65L + 1L;
                continue;
            }
            if (value >= '0' && value <= '9') {
                n = n * 10 + value - 48;
                continue;
            }
            if (value >= 'a' && value <= 'z') {
                v = v * 26L + (long)value - 97L + 1L;
                continue;
            }
            throw new ExcelReadException("Column mark out of range: " + r);
        }
        return v & 0x7FFFL | (long)n << 16;
    }

    public List<Drawings.Picture> listPictures() {
        return this.drawings != null ? this.drawings.listPictures() : null;
    }

    public Styles getStyles() {
        return this.styles;
    }

    public ZipEntry getEntry(String name) {
        return ExcelReader.getEntry(this.zipFile, ExcelReader.toZipPath(name));
    }

    public InputStream getEntryStream(String name) throws IOException {
        ZipEntry entry = ExcelReader.getEntry(this.zipFile, ExcelReader.toZipPath(name));
        return entry != null ? this.zipFile.getInputStream(entry) : null;
    }

    public static ZipEntry getEntry(ZipFile zipFile, String name) {
        ZipEntry entry;
        char c0 = name.charAt(0);
        if (c0 == '/' || c0 == '\\') {
            name = name.substring(1);
        }
        if ((entry = zipFile.getEntry(name)) == null) {
            entry = zipFile.getEntry(name.replace('/', '\\'));
        }
        if (entry == null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry e = entries.nextElement();
                String k = e.getName().replace('\\', '/');
                if (!k.equalsIgnoreCase(name)) continue;
                entry = e;
                break;
            }
        }
        return entry;
    }

    public static String toZipPath(String path) {
        int i = 0;
        if (path.startsWith("../") || path.startsWith("..\\")) {
            i = 3;
        } else if (path.startsWith("./") || path.startsWith(".\\")) {
            i = 2;
        } else if (path.charAt(0) == '/' || path.charAt(0) == '\\') {
            i = 1;
        }
        return i > 0 ? path.substring(i) : path;
    }
}

