/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.ttzero.excel.reader.Row;

public class RowSetIterator
implements Iterator<Row> {
    protected final Supplier<Row> supplier;
    protected Row nextRow = null;

    public RowSetIterator(Supplier<Row> supplier) {
        this.supplier = supplier;
    }

    @Override
    public boolean hasNext() {
        if (this.nextRow != null) {
            return true;
        }
        this.nextRow = this.supplier.get();
        return this.nextRow != null;
    }

    @Override
    public Row next() {
        if (this.nextRow != null || this.hasNext()) {
            Row next = this.nextRow;
            this.nextRow = null;
            return next;
        }
        throw new NoSuchElementException();
    }

    public static class NonBlankIterator
    extends RowSetIterator {
        public NonBlankIterator(Supplier<Row> supplier) {
            super(supplier);
        }

        @Override
        public boolean hasNext() {
            if (this.nextRow != null) {
                return true;
            }
            while ((this.nextRow = (Row)this.supplier.get()) != null && this.nextRow.isBlank()) {
            }
            return this.nextRow != null;
        }
    }
}

