/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.ttzero.excel.entity.Panes;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Col;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.FullSheet;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.XMLFullRow;
import org.ttzero.excel.reader.XMLRow;
import org.ttzero.excel.reader.XMLSheet;
import org.ttzero.excel.util.StringUtil;

class XMLFullSheet
extends XMLSheet
implements FullSheet {
    long[] calc;
    boolean ready;
    Grid mergeGrid;
    List<Dimension> mergeCells;
    int showGridLines = 1;
    Panes panes;
    double defaultColWidth = -1.0;
    double defaultRowHeight = -1.0;
    List<Col> cols;
    Dimension filter;

    XMLFullSheet(XMLSheet sheet) {
        super(sheet);
        if (this.path != null && this.reader != null && !this.ready) {
            this.load0();
        }
    }

    @Override
    public XMLFullSheet load() throws IOException {
        super.load();
        this.load0();
        return this;
    }

    void load0() {
        if (this.ready || this.eof) {
            return;
        }
        ZipEntry entry = ExcelReader.getEntry(this.zipFile, "xl/calcChain.xml");
        long[][] calcArray = null;
        try {
            calcArray = entry != null ? ExcelReader.parseCalcChain(this.zipFile.getInputStream(entry)) : (long[][])null;
        }
        catch (IOException e) {
            this.LOGGER.warn("Parse calcChain failed, formula will be ignored");
        }
        if (calcArray != null && calcArray.length >= this.id) {
            this.setCalc(calcArray[this.id - 1]);
        }
        if (!(this.sRow instanceof XMLFullRow)) {
            this.sRow = this.sRow.asFullRow();
        }
        if (this.calc != null) {
            ((XMLFullRow)this.sRow).setCalcFun(this::findCalc);
        }
        if ((this.option >> 17 & 1) == 1 && this.getMergeGrid() != null) {
            ((XMLFullRow)this.sRow).setCopyValueFunc(this.getMergeGrid(), this.mergeGrid::merge);
        } else {
            ((XMLFullRow)this.sRow).setCopyValueFunc(new Grid.FastGrid(Dimension.of("A1")), (row, cells) -> {});
        }
        this.ready = true;
        if (this.cols == null && this.defaultRowHeight < 0.0 && this.defaultColWidth < 0.0 && this.panes == null && this.showGridLines == 1) {
            XMLSheet.Marker marker = XMLSheet.Marker.of(this);
            try {
                super.load();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            marker.reset();
        }
    }

    XMLFullSheet setCalc(long[] calc) {
        this.calc = calc;
        return this;
    }

    @Override
    Row createHeader(char[] cb, int start, int n) {
        return ((XMLRow)super.createHeader(cb, start, n)).asFullRow().setCalcFun(this::findCalc);
    }

    void findCalc(int row, Cell[] cells, int n) {
        long r = (long)row << 16;
        int i = Arrays.binarySearch(this.calc, r);
        if (i < 0 && (i ^= 0xFFFFFFFF) >= this.calc.length) {
            return;
        }
        long a = this.calc[i];
        if ((int)(a >> 16) != row) {
            return;
        }
        cells[((int)a & Short.MAX_VALUE) - 1].f = true;
        int j = 1;
        if (n == -1) {
            n = cells.length;
        }
        n = Math.min(n, this.calc.length - i);
        while (j < n && this.calc[i + j] >> 16 == (long)row) {
            cells[((int)this.calc[i + j] & Short.MAX_VALUE) - 1].f = true;
            ++j;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Map<String, Object> parseTails() {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        ArrayList<Dimension> mergeCells = new ArrayList<Dimension>();
        tags.put("mergeCells", mergeCells);
        try (InputStream is = this.zipFile.getInputStream(this.entry);){
            int n;
            if (this.lastRowMark > 0L) {
                is.skip(this.lastRowMark);
            }
            int offset = 0;
            int limit = 16384;
            byte[] buf = new byte[limit];
            while ((n = is.read(buf, offset, limit - offset)) > 0) {
                int i;
                int len = n + offset;
                if (len < 11) {
                    offset = len;
                    continue;
                }
                n = len - 11;
                for (i = 0; !(i >= n || buf[i] == 60 && (buf[i + 1] == 109 && buf[i + 5] == 101 || buf[i + 1] == 97 && buf[i + 5] == 70 || buf[i + 1] == 100 && buf[i + 5] == 86)); ++i) {
                }
                if (i >= n) {
                    if (buf[i] == 60) {
                        offset = len - i;
                        System.arraycopy(buf, i, buf, 0, offset);
                        continue;
                    }
                    offset = 0;
                    continue;
                }
                if (len - i < 11) {
                    offset = len - i;
                    System.arraycopy(buf, i, buf, 0, offset);
                    n = is.read(buf, offset, limit - offset);
                    if (n <= 0) {
                        Map<String, Object> map = null;
                        return map;
                    }
                    len = n + offset;
                    if (len < 11) {
                        while ((n = is.read(buf, offset, limit - offset)) > 0 && (len = n + offset) < 11) {
                            offset = len;
                        }
                    }
                    i = 0;
                }
                if (len < 11) {
                    Map<String, Object> map = null;
                    return map;
                }
                block25: while (true) {
                    if (i < len && buf[i] != 60) {
                        ++i;
                        continue;
                    }
                    if (i == len) {
                        i = 0;
                        offset = 0;
                    } else {
                        int nChar;
                        for (nChar = ++i; nChar < len && buf[nChar] != 62; ++nChar) {
                        }
                        if (nChar == len) {
                            offset = len - i + 1;
                            System.arraycopy(buf, i - 1, buf, 0, offset);
                            i = 0;
                        } else {
                            int length = nChar - i;
                            switch (buf[i]) {
                                case 97: {
                                    if (length < 20 || buf[i + 1] != 117 || buf[i + 2] != 116 || buf[i + 3] != 111 || buf[i + 4] != 70 || buf[i + 5] != 105 || buf[i + 6] != 108 || buf[i + 7] != 116 || buf[i + 8] != 101 || buf[i + 9] != 114 || buf[i + 10] > 32) break;
                                    i += 11;
                                    int k = nChar - 8;
                                    while (i < k && buf[i] != 114 && buf[i + 1] != 101 && buf[i + 2] != 102 && buf[i + 3] != 61 && buf[i + 4] != 34) {
                                        ++i;
                                    }
                                    int a = i += 5;
                                    while (i < nChar && buf[i] != 34) {
                                        ++i;
                                    }
                                    if (i <= a) continue block25;
                                    tags.put("filter", Dimension.of(new String(buf, a, i - a, StandardCharsets.US_ASCII)));
                                    break;
                                }
                                case 109: {
                                    if (length < 20 || buf[i + 1] != 101 || buf[i + 2] != 114 || buf[i + 3] != 103 || buf[i + 4] != 101 || buf[i + 5] != 67 || buf[i + 6] != 101 || buf[i + 7] != 108 || buf[i + 8] != 108 || buf[i + 9] > 32) break;
                                    i += 10;
                                    int k = nChar - 8;
                                    while (i < k && buf[i] != 114 && buf[i + 1] != 101 && buf[i + 2] != 102 && buf[i + 3] != 61 && buf[i + 4] != 34) {
                                        ++i;
                                    }
                                    int a = i += 5;
                                    while (i < nChar && buf[i] != 34) {
                                        ++i;
                                    }
                                    if (i <= a) continue block25;
                                    mergeCells.add(Dimension.of(new String(buf, a, i - a, StandardCharsets.US_ASCII)));
                                    break;
                                }
                                case 100: {
                                    if (len < 35 || buf[i + 1] != 97 || buf[i + 2] != 116 || buf[i + 3] != 97 || buf[i + 4] != 86 || buf[i + 5] != 97 || buf[i + 6] != 108 || buf[i + 7] != 105 || buf[i + 8] != 100 || buf[i + 9] != 97 || buf[i + 10] != 116 || buf[i + 11] != 105 || buf[i + 12] != 111 || buf[i + 13] != 110 || buf[i + 14] > 32) break;
                                    continue block25;
                                }
                            }
                            continue;
                        }
                    }
                    if ((len = is.read(buf, offset, limit - offset)) <= 0 || (len += offset) <= 0) break;
                }
            }
            return tags;
        }
        catch (IOException e) {
            this.LOGGER.warn("", (Throwable)e);
        }
        return tags;
    }

    @Override
    public Grid getMergeGrid() {
        if (this.mergeGrid != null) {
            return this.mergeGrid;
        }
        List<Dimension> dims = this.getMergeCells();
        if (dims != null) {
            this.mergeGrid = GridFactory.create(dims);
            this.LOGGER.debug("Grid: {} ===> Size: {}", this.mergeGrid.getClass(), (Object)this.mergeGrid.size());
        }
        return this.mergeGrid;
    }

    @Override
    public List<Dimension> getMergeCells() {
        List dims = this.mergeCells;
        if (dims == null) {
            Map<String, Object> tags = this.parseTails();
            dims = (List)tags.get("mergeCells");
            this.filter = (Dimension)tags.get("filter");
            this.mergeCells = dims != null ? dims : (dims = Collections.emptyList());
        }
        return dims.isEmpty() ? null : dims;
    }

    @Override
    protected void subElement(char[] cb, int offset, int n) {
        String v = new String(cb, offset, n);
        v = v.replace("x14ac:", "").replace("r:", "").replace("mc:", "");
        if (cb[offset + n - 2] == '/') {
            try {
                Document doc = DocumentHelper.parseText((String)v);
                Element e = doc.getRootElement();
                switch (e.getName()) {
                    case "dimension": {
                        String ref = e.attributeValue("ref");
                        if (!StringUtil.isNotEmpty(ref)) break;
                        Dimension dim = Dimension.of(ref);
                        if (dim.width <= 1 && dim.height <= 1) break;
                        this.dimension = dim;
                        break;
                    }
                    case "col": {
                        String min = e.attributeValue("min");
                        String max = e.attributeValue("max");
                        String width = e.attributeValue("width");
                        String hidden = e.attributeValue("hidden");
                        if (this.cols == null) {
                            this.cols = new ArrayList<Col>();
                        }
                        this.cols.add(new Col(Integer.parseInt(min), Integer.parseInt(max), Double.parseDouble(width), "1".equals(hidden)));
                        break;
                    }
                    case "pane": {
                        String xSplit = e.attributeValue("xSplit");
                        String ySplit = e.attributeValue("ySplit");
                        if (StringUtil.isNotEmpty(ySplit) && Row.testNumberType(ySplit.toCharArray(), 0, ySplit.length()) == 1) {
                            this.panes = Panes.row(Integer.parseInt(ySplit));
                        }
                        if (!StringUtil.isNotEmpty(xSplit) || Row.testNumberType(xSplit.toCharArray(), 0, xSplit.length()) != 1) break;
                        int col = Integer.parseInt(xSplit);
                        if (this.panes != null) {
                            this.panes.col = col;
                            break;
                        }
                        this.panes = Panes.col(col);
                        break;
                    }
                    case "sheetFormatPr": {
                        String defaultColWidth = e.attributeValue("defaultColWidth");
                        String defaultRowHeight = e.attributeValue("defaultRowHeight");
                        if (StringUtil.isNotEmpty(defaultColWidth) && Row.testNumberType(defaultColWidth.toCharArray(), 0, defaultColWidth.length()) > 0) {
                            this.defaultColWidth = Double.parseDouble(defaultColWidth);
                        }
                        if (!StringUtil.isNotEmpty(defaultRowHeight) || Row.testNumberType(defaultRowHeight.toCharArray(), 0, defaultRowHeight.length()) <= 0) break;
                        this.defaultRowHeight = Double.parseDouble(defaultRowHeight);
                    }
                }
            }
            catch (DocumentException e) {
                this.LOGGER.warn("Parse header tag [" + v + "] failed.", (Throwable)e);
            }
        } else if (v.startsWith("<sheetView")) {
            char[] ncb = new char[n + 1];
            System.arraycopy(cb, offset, ncb, 0, n);
            ncb[n - 1] = 47;
            ncb[n] = 62;
            try {
                Document doc = DocumentHelper.parseText((String)new String(ncb, 0, n + 1));
                Element e = doc.getRootElement();
                String showGridLines = e.attributeValue("showGridLines");
                if ("0".equals(showGridLines)) {
                    this.showGridLines = 0;
                }
            }
            catch (DocumentException e) {
                this.LOGGER.warn("Parse header tag [" + v + "] failed.", (Throwable)e);
            }
        }
    }

    @Override
    public FullSheet copyOnMerged() {
        if (this.sRow != null && this.getMergeGrid() != null) {
            ((XMLFullRow)this.sRow).setCopyValueFunc(this.getMergeGrid(), this.mergeGrid::merge);
        } else {
            this.option |= 0x20000;
        }
        return this;
    }

    @Override
    public Panes getFreezePanes() {
        return this.panes;
    }

    @Override
    public List<Col> getCols() {
        return this.cols;
    }

    @Override
    public Dimension getFilter() {
        Dimension filter = this.filter;
        if (filter == null && this.mergeCells == null) {
            this.getMergeCells();
            filter = this.filter;
        }
        return filter;
    }

    @Override
    public boolean showGridLines() {
        return this.showGridLines == 1;
    }

    @Override
    public double getDefaultColWidth() {
        return this.defaultColWidth;
    }

    @Override
    public double getDefaultRowHeight() {
        return this.defaultRowHeight;
    }
}

