/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.math.BigDecimal;
import org.ttzero.excel.entity.TooManyColumnsException;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.XMLCalcRow;
import org.ttzero.excel.reader.XMLFullRow;
import org.ttzero.excel.reader.XMLMergeRow;

public class XMLRow
extends Row {
    protected int startRow;
    protected char[] cb;
    protected int from;
    protected int to;
    protected int cursor;
    protected int e;

    @Override
    public int getRowNum() {
        if (this.index == -1) {
            this.searchRowNum();
        }
        return this.index;
    }

    public XMLRow() {
        this.startRow = 1;
    }

    public XMLRow(SharedStrings sst, Styles styles, int startRow) {
        this.init(sst, styles, startRow);
    }

    public XMLRow init(SharedStrings sst, Styles styles, int startRow) {
        this.sst = sst;
        this.styles = styles;
        this.startRow = startRow;
        return this;
    }

    protected XMLRow with(char[] cb, int from, int size) {
        this.cb = cb;
        this.from = from;
        this.to = from + size;
        this.cursor = from;
        this.lc = -1;
        this.index = -1;
        this.parseCells();
        return this;
    }

    protected XMLRow empty(char[] cb, int from, int size) {
        this.cb = cb;
        this.from = from;
        this.to = from + size;
        this.cursor = from;
        this.index = -1;
        this.lc = -1;
        this.fc = -1;
        return this;
    }

    private void searchRowNum() {
        if (this.from >= this.to || this.cb == null) {
            return;
        }
        for (int _f = this.from + 4; this.cb[_f] != '>' && _f < this.to; ++_f) {
            if (this.cb[_f] > ' ' || this.cb[_f + 1] != 'r' || this.cb[_f + 2] != '=') continue;
            int a = _f += 4;
            while (this.cb[_f] != '\"' && _f < this.to) {
                ++_f;
            }
            if (_f <= a) break;
            this.index = SharedStrings.toInt(this.cb, a, _f);
            break;
        }
    }

    protected int searchSpan() {
        int len;
        int i = this.from + 4;
        int _lc = this.lc;
        while (this.cb[i] != '>') {
            if (this.cb[i] <= ' ' && this.cb[i + 1] == 's' && this.cb[i + 2] == 'p' && this.cb[i + 3] == 'a' && this.cb[i + 4] == 'n' && this.cb[i + 5] == 's' && this.cb[i + 6] == '=') {
                int j = i += 8;
                while (this.cb[i] != '\"' && this.cb[i] != '>') {
                    ++i;
                }
                int b = i - 1;
                while (this.cb[b] != ':') {
                    --b;
                }
                if (++b < i) {
                    this.lc = SharedStrings.toInt(this.cb, b, i);
                }
                if (j < --b) {
                    this.fc = SharedStrings.toInt(this.cb, j, b);
                }
            }
            ++i;
        }
        if (this.hr != null && this.lc < this.hr.lc) {
            this.lc = this.hr.lc;
        }
        if (this.fc <= 0 || this.fc >= this.lc) {
            this.fc = this.startRow;
        }
        --this.fc;
        if (this.cells == null || this.lc > this.cells.length) {
            this.cells = new Cell[this.lc > 0 ? this.lc : 100];
        }
        int n = len = this.lc > 0 ? Math.max(this.lc, _lc) : this.cells.length;
        for (int n2 = 0; n2 < len; ++n2) {
            if (this.cells[n2] != null) {
                this.cells[n2].clear();
                continue;
            }
            this.cells[n2] = new Cell((short)(n2 + 1));
        }
        return i;
    }

    protected void parseCells() {
        Cell cell;
        this.cursor = this.searchSpan();
        while (this.cb[this.cursor++] != '>') {
        }
        boolean bl = this.unknownLength = this.lc < 0;
        while ((cell = this.nextCell()) != null) {
            this.parseCellValue(cell);
        }
    }

    protected Cell nextCell() {
        while (this.cursor < this.to && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != 'c' || this.cb[this.cursor + 2] > ' ')) {
            ++this.cursor;
        }
        if (this.cursor >= this.to) {
            return null;
        }
        this.cursor += 2;
        this.e = this.cursor;
        while (this.e < this.to && (this.cb[this.e] != '<' || this.cb[this.e + 1] != 'c' || this.cb[this.e + 2] > ' ')) {
            ++this.e;
        }
        Cell cell = null;
        int t = 110;
        int xf = 0;
        int i = 0;
        while (this.cb[this.cursor] != '>') {
            int a;
            if (this.cb[this.cursor] <= ' ' && this.cb[this.cursor + 1] == 'r' && this.cb[this.cursor + 2] == '=') {
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                i = XMLRow.toCellIndex(this.cb, a, this.cursor);
                if (i - 1 >= this.cells.length) {
                    if (i - 1 > 16384) {
                        throw new TooManyColumnsException(i, 16384);
                    }
                    this.cells = this.copyCells(Math.min(i + 99, 16384));
                }
                cell = this.cells[i - 1];
            }
            if (this.cb[this.cursor] <= ' ' && this.cb[this.cursor + 1] == 't' && this.cb[this.cursor + 2] == '=') {
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                int n = this.cursor - a;
                if (n == 1) {
                    t = this.cb[a];
                } else if (n == 3 && this.cb[a] == 's' && this.cb[a + 1] == 't' && this.cb[a + 2] == 'r') {
                    t = 102;
                } else if (n == 9 && this.cb[a] == 'i' && this.cb[a + 1] == 'n' && this.cb[a + 2] == 'l' && this.cb[a + 6] == 'S' && this.cb[a + 8] == 'r') {
                    t = 114;
                }
            }
            if (this.cb[this.cursor] <= ' ' && this.cb[this.cursor + 1] == 's' && this.cb[this.cursor + 2] == '=') {
                a = this.cursor += 4;
                while (this.cb[this.cursor] != '\"') {
                    ++this.cursor;
                }
                xf = SharedStrings.toInt(this.cb, a, this.cursor);
            }
            ++this.cursor;
        }
        if (cell == null) {
            return null;
        }
        cell.xf = xf;
        cell.t = (char)t;
        if (this.lc < i) {
            this.lc = i;
        }
        return cell;
    }

    protected static long toLong(char[] cb, int a, int b) {
        boolean _n = cb[a] == '-';
        if (_n) {
            // empty if block
        }
        int n = ++a;
        ++a;
        long n2 = cb[n] - 48;
        while (b > a) {
            n2 = n2 * 10L + (long)cb[a++] - 48L;
        }
        return _n ? -n2 : n2;
    }

    protected int get(char c) {
        int a;
        while (this.cursor < this.e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != c || this.cb[this.cursor + 2] != '>' && this.cb[this.cursor + 2] > ' ' && this.cb[this.cursor + 2] != '/')) {
            ++this.cursor;
        }
        if (this.cursor == this.e) {
            return this.cursor;
        }
        if (this.cb[this.cursor + 2] == '>') {
            a = this.cursor += 3;
        } else if (this.cb[this.cursor + 2] == ' ') {
            while (this.cursor < this.e && this.cb[this.cursor] != '>') {
                ++this.cursor;
            }
            ++this.cursor;
            if (this.cb[this.cursor - 2] == '/' || this.cursor == this.e) {
                return this.cursor;
            }
            a = this.cursor;
        } else {
            if (this.cb[this.cursor + 2] == '/') {
                this.cursor += 3;
                return this.cursor;
            }
            a = this.cursor += 3;
        }
        while (this.cursor < this.e && (this.cb[this.cursor] != '<' || this.cb[this.cursor + 1] != '/' || this.cb[this.cursor + 2] != c || this.cb[this.cursor + 3] != '>')) {
            ++this.cursor;
        }
        return a;
    }

    protected int getT() {
        return this.get('t');
    }

    protected int getV() {
        return this.get('v');
    }

    protected void parseCellValue(Cell cell) {
        block0 : switch (cell.t) {
            case 'r': {
                int a = this.getT();
                if (a < this.cursor) {
                    cell.setSv(SharedStrings.escape(this.cb, a, this.cursor));
                    break;
                }
                cell.blank();
                break;
            }
            case 's': {
                int a = this.getV();
                cell.setNv(SharedStrings.toInt(this.cb, a, this.cursor));
                cell.setT('s');
                break;
            }
            case 'b': {
                int a = this.getV();
                if (this.cursor - a == 1) {
                    cell.setBv(SharedStrings.toInt(this.cb, a, this.cursor) == 1);
                    break;
                }
                cell.setBv(false);
                break;
            }
            case 'f': {
                int a = this.getV();
                if (a < this.cursor) {
                    cell.setSv(SharedStrings.escape(this.cb, a, this.cursor));
                    break;
                }
                cell.blank();
                break;
            }
            case '\u0000': {
                return;
            }
            default: {
                int a = this.getV();
                if (a < this.cursor) {
                    int t = XMLRow.testNumberType(this.cb, a, this.cursor);
                    switch (t) {
                        case 3: {
                            cell.setMv(new BigDecimal(this.cb, a, this.cursor - a));
                            break block0;
                        }
                        case 2: {
                            long l = XMLRow.toLong(this.cb, a, this.cursor);
                            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                                cell.setLv(l);
                                break block0;
                            }
                            cell.setNv((int)l);
                            break block0;
                        }
                        case 1: {
                            cell.setNv(SharedStrings.toInt(this.cb, a, this.cursor));
                            break block0;
                        }
                        case 0: {
                            cell.emptyTag();
                            break block0;
                        }
                    }
                    cell.setSv(SharedStrings.escape(this.cb, a, this.cursor));
                    break;
                }
                cell.emptyTag();
            }
        }
        this.cursor = this.e;
    }

    XMLCalcRow asCalcRow() {
        return !(this instanceof XMLCalcRow) ? new XMLCalcRow(this) : (XMLCalcRow)this;
    }

    XMLMergeRow asMergeRow() {
        return !(this instanceof XMLMergeRow) ? new XMLMergeRow(this) : (XMLMergeRow)this;
    }

    XMLFullRow asFullRow() {
        return this.getClass() != XMLFullRow.class ? new XMLFullRow(this) : (XMLFullRow)this;
    }
}

