/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.RowSetIterator;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLCalcSheet;
import org.ttzero.excel.reader.XMLFullSheet;
import org.ttzero.excel.reader.XMLMergeSheet;
import org.ttzero.excel.reader.XMLRow;

public class XMLSheet
implements Sheet {
    final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected String name;
    protected int index;
    protected String path;
    protected int id;
    protected SharedStrings sst;
    protected Styles styles;
    protected int startRow = -1;
    protected HeaderRow header;
    protected boolean hidden;
    protected Dimension dimension;
    protected Drawings drawings;
    protected int hrf;
    protected int hrl;
    protected ZipFile zipFile;
    protected ZipEntry entry;
    protected int option;
    protected Reader reader;
    protected char[] cb;
    protected int nChar;
    protected int length;
    protected boolean eof = false;
    protected boolean heof = false;
    protected long mark;
    protected XMLRow sRow;
    protected long lastRowMark;

    public XMLSheet() {
    }

    public XMLSheet(XMLSheet sheet) {
        this.name = sheet.name;
        this.index = sheet.index;
        this.path = sheet.path;
        this.sst = sheet.sst;
        this.styles = sheet.styles;
        this.id = sheet.id;
        this.startRow = sheet.startRow;
        this.header = sheet.header;
        this.hidden = sheet.hidden;
        this.dimension = sheet.dimension;
        this.drawings = sheet.drawings;
        this.reader = sheet.reader;
        this.cb = sheet.cb;
        this.nChar = sheet.nChar;
        this.length = sheet.length;
        this.eof = sheet.eof;
        this.heof = sheet.heof;
        this.mark = sheet.mark;
        this.sRow = sheet.sRow == null || sheet.sRow.getClass() != XMLRow.class ? this.createRow().init(this.sst, this.styles, this.startRow) : sheet.sRow;
        this.lastRowMark = sheet.lastRowMark;
        this.hrf = sheet.hrf;
        this.hrl = sheet.hrl;
        this.zipFile = sheet.zipFile;
        this.entry = sheet.entry;
        this.option = sheet.option;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setPath(String path) {
        this.path = path;
    }

    protected void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    protected void setZipEntry(ZipEntry entry) {
        this.entry = entry;
    }

    protected void setSharedStrings(SharedStrings sst) {
        this.sst = sst;
    }

    protected void setStyles(Styles styles) {
        this.styles = styles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    protected void setDrawings(Drawings drawings) {
        this.drawings = drawings;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension != null ? this.dimension : (this.dimension = this.parseDimension());
    }

    public int getFirstRow() {
        return this.startRow;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public Sheet header(int fromRowNum, int toRowNum) {
        XMLSheet.rangeCheck(fromRowNum, toRowNum);
        this.hrf = fromRowNum;
        this.hrl = toRowNum;
        return this;
    }

    XMLSheet setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Override
    public Row getHeader() {
        if (this.header == null && !this.heof) {
            Row row;
            Row row2 = row = this.hrf == 0 ? this.findRow0() : this.getHeader(this.hrf, this.hrl);
            if (row != null) {
                this.header = row instanceof HeaderRow ? (HeaderRow)row : row.asHeader();
                this.header.setOptions(this.option << 16 >>> 16);
                this.sRow.setHr(this.header);
            }
        } else if (this.hrl > 0 && this.hrl > this.sRow.getRowNum()) {
            Row row0 = this.findRow0();
            if (row0 != null && row0.getRowNum() < this.hrl) {
                XMLRow row = this.nextRow();
                while (row != null && ((Row)row).getRowNum() < this.hrl) {
                    row = this.nextRow();
                }
            }
            if (this.sRow != null && this.sRow.hr != this.header) {
                this.sRow.setHr(this.header);
            }
        }
        return this.header;
    }

    protected Row getHeader(int fromRowNum, int toRowNum) {
        HeaderRow headerRow;
        if (this.header != null || this.eof) {
            return this.header;
        }
        XMLSheet.rangeCheck(fromRowNum, toRowNum);
        if (this.sRow.getRowNum() > -1 && fromRowNum < this.sRow.getRowNum()) {
            throw new IndexOutOfBoundsException("Current row num " + this.sRow.getRowNum() + " is great than fromRowNum " + fromRowNum + ". Use Sheet#reset() to reset cursor.");
        }
        if (toRowNum - fromRowNum > 0) {
            Row[] rows = new Row[toRowNum - fromRowNum + 1];
            int i = 0;
            int lc = -1;
            boolean changeLc = false;
            Object row = this.nextRow();
            while (row != null) {
                if (((Row)row).getRowNum() >= fromRowNum) {
                    if (((Row)row).lc > lc) {
                        lc = ((Row)row).lc;
                        if (i > 0) {
                            changeLc = true;
                        }
                    }
                    Row r = new Row(){};
                    r.fc = ((Row)row).fc;
                    r.lc = ((Row)row).lc;
                    r.index = ((Row)row).getRowNum();
                    r.sst = ((Row)row).sst;
                    r.cells = ((Row)row).copyCells();
                    rows[i++] = r;
                }
                if (((Row)row).getRowNum() >= toRowNum) break;
                row = this.nextRow();
            }
            if (changeLc) {
                for (Row row2 : rows) {
                    row2.lc = lc;
                    row2.cells = row2.copyCells(lc);
                }
            }
            if (i > 0) {
                List mergeCells;
                if (!(this instanceof MergeSheet)) {
                    XMLMergeSheet tmp = new XMLSheet(this).asMergeSheet();
                    tmp.reader = null;
                    Map<String, Object> tags = tmp.parseTails();
                    mergeCells = (List)tags.get("mergeCells");
                } else {
                    mergeCells = ((MergeSheet)((Object)this)).getMergeCells();
                }
                if (mergeCells != null) {
                    mergeCells = mergeCells.stream().filter(dim -> dim.firstRow < toRowNum || dim.lastRow > fromRowNum).collect(Collectors.toList());
                }
                headerRow = new HeaderRow().with(mergeCells, rows).setOptions(this.option << 16 >>> 16);
            } else {
                headerRow = new HeaderRow().setOptions(this.option << 16 >>> 16);
            }
        } else {
            XMLRow row = this.nextRow();
            while (row != null && ((Row)row).getRowNum() < fromRowNum) {
                row = this.nextRow();
            }
            headerRow = row != null ? new HeaderRow().with(row).setOptions(this.option << 16 >>> 16) : new HeaderRow().setOptions(this.option << 16 >>> 16);
        }
        headerRow.styles = this.styles;
        return headerRow;
    }

    static void rangeCheck(int fromRowNum, int toRowNum) {
        if (fromRowNum <= 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromRowNum);
        }
        if (fromRowNum > toRowNum) {
            throw new IllegalArgumentException("fromIndex(" + fromRowNum + ") > toIndex(" + toRowNum + ")");
        }
    }

    @Override
    public XMLSheet bind(Class<?> clazz) {
        if (this.getHeader() != null) {
            try {
                this.header.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelReadException(e);
            }
        }
        return this;
    }

    @Override
    public Sheet bind(Class<?> clazz, Row row) {
        if (row == null) {
            throw new IllegalArgumentException("Specify the bind row must not be null.");
        }
        if (!row.equals(this.header)) {
            this.header = row instanceof HeaderRow ? (HeaderRow)row : row.asHeader();
            this.header.setOptions(this.option << 16 >>> 16);
            this.sRow.setHr(this.header);
        }
        try {
            this.header.setClassOnce(clazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExcelReadException(e);
        }
        return this;
    }

    public String toString() {
        return "Sheet id: " + this.getId() + ", name: " + this.getName();
    }

    @Override
    public XMLSheet load() throws IOException {
        if (this.sRow != null) {
            this.reset();
            return this;
        }
        this.LOGGER.debug("Load {}", (Object)this.path);
        this.reader = new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8);
        this.cb = new char[8192];
        this.nChar = 0;
        this.mark = 0L;
        this.parseBOF();
        if (this.length <= 0) {
            this.eof = true;
        }
        if (!this.eof) {
            this.sRow = this.createRow().init(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1);
        }
        this.LOGGER.debug("eof: {}, mark: {}", (Object)this.eof, (Object)this.mark);
        if (this.dimension != null) {
            this.LOGGER.debug("Dimension-Range: {}", (Object)this.dimension);
        }
        return this;
    }

    protected void parseBOF() throws IOException {
        int left = 0;
        block0: while ((this.length = this.reader.read(this.cb, left, this.cb.length - left)) > 0) {
            if ((this.length += left) < 11) {
                left = this.length;
                continue;
            }
            left = 0;
            while (true) {
                int n;
                if (this.nChar < this.length && this.cb[this.nChar] != '<') {
                    ++this.nChar;
                    continue;
                }
                if (this.nChar == this.length) {
                    this.mark += (long)this.nChar;
                    this.nChar = 0;
                    continue block0;
                }
                int offset = this.nChar++;
                if (this.nChar < this.length && this.cb[this.nChar] == '/') continue;
                while (this.nChar < this.length && this.cb[this.nChar] != '>') {
                    ++this.nChar;
                }
                if (this.nChar == this.length) {
                    if (offset != 0) {
                        left = this.nChar - offset;
                        System.arraycopy(this.cb, offset, this.cb, 0, left);
                        this.mark += (long)offset;
                    } else {
                        this.cb = Arrays.copyOf(this.cb, this.cb.length << 1);
                        left = this.length;
                    }
                    this.nChar = 0;
                    continue block0;
                }
                if ((n = ++this.nChar - offset) >= 11 && this.cb[offset + 1] == 's' && this.cb[offset + 2] == 'h' && this.cb[offset + 3] == 'e' && this.cb[offset + 4] == 'e' && this.cb[offset + 5] == 't' && this.cb[offset + 6] == 'D' && this.cb[offset + 7] == 'a' && this.cb[offset + 8] == 't' && this.cb[offset + 9] == 'a' && (this.cb[offset + 10] == '>' || this.cb[offset + 10] == '/')) {
                    this.mark += (long)(offset + 11);
                    this.eof = this.cb[offset + 10] == '/';
                    break block0;
                }
                if (n >= 5 && this.cb[offset + 1] == 'r' && this.cb[offset + 2] == 'o' && this.cb[offset + 3] == 'w' && (this.cb[offset + 4] == '>' || this.cb[offset + 4] == '/')) {
                    this.mark += (long)offset;
                    this.eof = false;
                    break block0;
                }
                this.subElement(this.cb, offset, n);
            }
        }
    }

    private XMLRow nextRow() {
        if (this.eof) {
            return null;
        }
        boolean endTag = false;
        int start = this.nChar;
        while (++this.nChar < this.length && this.cb[this.nChar] != '>') {
        }
        if (this.nChar < this.length && this.cb[this.nChar - 1] == '/') {
            return this.sRow.empty(this.cb, start, this.nChar - start);
        }
        while (this.nChar < this.length - 6) {
            if (this.cb[this.nChar] == '<' && this.cb[this.nChar + 1] == '/' && this.cb[this.nChar + 2] == 'r' && this.cb[this.nChar + 3] == 'o' && this.cb[this.nChar + 4] == 'w' && this.cb[this.nChar + 5] == '>') {
                this.nChar += 6;
                endTag = true;
                break;
            }
            ++this.nChar;
        }
        if (!endTag) {
            int n;
            if (start == 0) {
                char[] _cb = new char[this.cb.length << 1];
                n = this.length - start;
                System.arraycopy(this.cb, start, _cb, 0, n);
                this.cb = _cb;
            } else {
                n = this.length - start;
                System.arraycopy(this.cb, start, this.cb, 0, n);
            }
            try {
                this.length = this.reader.read(this.cb, n, this.cb.length - n);
                if (this.length < 0) {
                    this.eof = true;
                    this.reader.close();
                    this.reader = null;
                    this.LOGGER.debug("end of file.");
                    if (this.dimension == null) {
                        this.dimension = new Dimension(1, (short)Math.max(this.sRow.fc, 1), Math.max(this.sRow.getRowNum(), 1), (short)Math.max(this.sRow.lc, 1));
                    }
                    return null;
                }
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().contains("Stream closed")) {
                    this.eof = true;
                    return null;
                }
                throw new ExcelReadException("Parse row data error", e);
            }
            this.nChar = 0;
            this.length += n;
            return this.nextRow();
        }
        return this.sRow.with(this.cb, start, this.nChar - start);
    }

    protected Row findRow0() {
        Marker marker = Marker.of(this);
        Row firstRow = null;
        try {
            XMLRow row;
            this.load();
            if (!this.eof && (row = this.nextRow()) != null) {
                firstRow = this.createHeader(row.cb, row.from, row.to - row.from);
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            this.LOGGER.error("Read header row error.");
        }
        this.heof = firstRow == null;
        marker.reset();
        return firstRow;
    }

    @Override
    public Iterator<Row> iterator() {
        if (this.hrf > 0) {
            this.getHeader();
        }
        return new RowSetIterator(this::nextRow);
    }

    @Override
    public Iterator<Row> dataIterator() {
        if (this.hrf > 0) {
            this.getHeader();
        }
        RowSetIterator.NonBlankIterator nIter = new RowSetIterator.NonBlankIterator(this::nextRow);
        if (this.hrf == 0 && nIter.hasNext()) {
            Row row = (Row)nIter.next();
            if (this.header == null) {
                this.header = row.asHeader().setOptions(this.option << 16 >>> 16);
            }
            row.setHr(this.header);
        }
        return nIter;
    }

    @Override
    public List<Drawings.Picture> listPictures() {
        return this.drawings != null ? this.drawings.listPictures(this) : null;
    }

    @Override
    public void close() throws IOException {
        this.cb = null;
        if (this.reader != null) {
            this.reader.close();
        }
    }

    @Override
    public Sheet setHeaderColumnReadOption(int option) {
        if (option >= 131072) {
            this.LOGGER.warn("Unrecognized options will be discarded");
        }
        int o = option & 0x1FFFF;
        this.option = this.option >>> 16 << 16 | o;
        if (this.header != null) {
            this.header.setOptions(o);
        }
        return this;
    }

    @Override
    public int getHeaderColumnReadOption() {
        return this.header != null ? this.header.option : this.option << 16 >>> 16;
    }

    @Override
    public XMLSheet reset() {
        this.LOGGER.debug("Reset {}", (Object)this.path);
        try {
            this.hrf = 0;
            this.hrl = 0;
            this.header = null;
            this.sRow.fc = 0;
            this.sRow.lc = -1;
            this.sRow.index = -1;
            this.sRow.from = this.sRow.to;
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.cb == null) {
                this.sRow = null;
                return this.load();
            }
            this.reader = new InputStreamReader(this.zipFile.getInputStream(this.entry), StandardCharsets.UTF_8);
            this.reader.skip(this.mark);
            this.length = this.reader.read(this.cb);
            this.nChar = 0;
            this.eof = this.length <= 0;
        }
        catch (IOException e) {
            throw new ExcelReadException("Reset worksheet[" + this.getName() + "] error occur.", e);
        }
        return this;
    }

    public XMLRow createRow() {
        return new XMLRow();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Dimension parseDimension() {
        try (InputStream is = this.zipFile.getInputStream(this.entry);){
            int n;
            if (this.lastRowMark > 0L) {
                is.skip(this.lastRowMark);
            }
            long mark = 0L;
            long mark0 = 0L;
            int offset = 0;
            int limit = 16384;
            int row = 1;
            int col = 1;
            byte[] buf = new byte[limit];
            while ((n = is.read(buf, offset, limit - offset)) > 0) {
                mark += (long)n;
                int len = n + offset;
                if (len < 11) {
                    offset = len;
                    continue;
                }
                int i = len - 1;
                while (i > 1 && (buf[i--] != 32 || buf[i--] != 99 || buf[i] != 60)) {
                }
                if (i <= 1 && (buf[i] != 60 || buf[i + 1] != 99)) {
                    offset = 0;
                    continue;
                }
                if (i <= len - 9) {
                    n = i;
                    i += 3;
                    while (i < len && buf[i] != 114 && buf[i + 1] != 61 && buf[i + 2] != 34) {
                        ++i;
                    }
                    if (i < len - 3) {
                        int f = i += 3;
                        while (i < len && buf[i] != 34) {
                            ++i;
                        }
                        if (i < len) {
                            long v = XMLSheet.coordinateToLong(buf, f, i - f);
                            row = (int)(v >>> 16);
                            int c = (int)(v & 0x7FFFL);
                            if (c > col) {
                                col = c;
                            }
                            if (buf[len - 1] == 60) {
                                buf[0] = 60;
                                offset = 1;
                            } else {
                                offset = 0;
                            }
                            mark0 = mark - (long)(len - n);
                            continue;
                        }
                    }
                    i = n;
                }
                if (i >= len) continue;
                offset = len - i;
                System.arraycopy(buf, i, buf, 0, offset);
            }
            if (this.lastRowMark < mark0) {
                this.lastRowMark = mark0;
            }
            Dimension dimension = new Dimension(1, 1, row, (short)col);
            return dimension;
        }
        catch (IOException e) {
            this.LOGGER.warn("", (Throwable)e);
            return Dimension.of("A1");
        }
    }

    static long coordinateToLong(byte[] buf, int from, int len) {
        long v = 0L;
        int n = 0;
        for (int i = 0; i < len; ++i) {
            byte value = buf[i + from];
            if (value >= 65 && value <= 90) {
                v = v * 26L + (long)value - 65L + 1L;
                continue;
            }
            if (value >= 48 && value <= 57) {
                n = n * 10 + value - 48;
                continue;
            }
            if (value < 97 || value > 122) break;
            v = v * 26L + (long)value - 97L + 1L;
        }
        return v & 0x7FFFL | (long)n << 16;
    }

    protected void subElement(char[] cb, int offset, int n) {
        if (n < 20) {
            return;
        }
        if (cb[offset + 1] == 'd' && cb[offset + 2] == 'i' && cb[offset + 3] == 'm' && cb[offset + 4] == 'e' && cb[offset + 5] == 'n' && cb[offset + 6] == 's' && cb[offset + 7] == 'i' && cb[offset + 8] == 'o' && cb[offset + 9] == 'n') {
            int end = (offset += 10) + n + 1;
            while (offset < end && cb[offset] != '\"') {
                ++offset;
            }
            int i = ++offset;
            while (offset < end && cb[offset] != '\"') {
                ++offset;
            }
            if (offset < end && offset > i) {
                Dimension dim = Dimension.of(new String(cb, i, offset - i));
                if (dim.width > 1 || dim.height > 1) {
                    this.dimension = dim;
                }
            }
        }
    }

    Row createHeader(char[] cb, int start, int n) {
        return this.createRow().init(this.sst, this.styles, this.startRow > 0 ? this.startRow : 1).with(cb, start, n);
    }

    @Override
    public XMLSheet asSheet() {
        return this instanceof XMLCalcSheet || this instanceof XMLMergeSheet ? new XMLSheet(this) : this;
    }

    @Override
    public XMLCalcSheet asCalcSheet() {
        return !(this instanceof XMLCalcSheet) ? new XMLCalcSheet(this) : (XMLCalcSheet)this;
    }

    @Override
    public XMLMergeSheet asMergeSheet() {
        return !(this instanceof XMLMergeSheet) ? new XMLMergeSheet(this) : (XMLMergeSheet)this;
    }

    @Override
    public XMLFullSheet asFullSheet() {
        return this.getClass() != XMLFullSheet.class ? new XMLFullSheet(this) : (XMLFullSheet)this;
    }

    protected static class Marker {
        private final Reader reader;
        private final char[] cb;
        private final int nChar;
        private final int length;
        private final boolean eof;
        private final boolean heof;
        private final long mark;
        private final long lastRowMark;
        private final XMLRow sRow;
        private final XMLSheet sheet;

        public Marker(XMLSheet sheet) {
            this.sheet = sheet;
            this.reader = sheet.reader;
            this.cb = sheet.cb;
            this.nChar = sheet.nChar;
            this.length = sheet.length;
            this.eof = sheet.eof;
            this.heof = sheet.heof;
            this.mark = sheet.mark;
            this.lastRowMark = sheet.lastRowMark;
            this.sRow = sheet.sRow;
            sheet.reader = null;
            sheet.sRow = null;
        }

        public static Marker of(XMLSheet sheet) {
            return new Marker(sheet);
        }

        public void reset() {
            if (this.sheet.reader != null) {
                try {
                    this.sheet.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.sheet.reader = this.reader;
            this.sheet.cb = this.cb;
            this.sheet.nChar = this.nChar;
            this.sheet.length = this.length;
            this.sheet.eof = this.eof;
            this.sheet.heof = this.heof;
            this.sheet.mark = this.mark;
            this.sheet.lastRowMark = this.lastRowMark;
            this.sheet.sRow = this.sRow;
        }
    }
}

