/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.Closeable;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Supplier;
import org.ttzero.excel.entity.Picture;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.Storable;

public interface IWorksheetWriter
extends Closeable,
Cloneable,
Storable {
    public int getRowLimit();

    public int getColumnLimit();

    public void writeTo(Path var1, Supplier<RowBlock> var2) throws IOException;

    public IWorksheetWriter setWorksheet(Sheet var1);

    @Deprecated
    default public void writeEmptySheet(Path path) throws IOException {
        try {
            this.writeTo(path, () -> null);
        }
        finally {
            this.close();
        }
    }

    public IWorksheetWriter clone();

    public String getFileSuffix();

    default public void writePicture(Picture picture) throws IOException {
    }

    public static boolean isDate(Class<?> clazz) {
        return clazz == java.util.Date.class || clazz == Date.class;
    }

    public static boolean isDateTime(Class<?> clazz) {
        return clazz == Timestamp.class;
    }

    public static boolean isInt(Class<?> clazz) {
        return clazz == Integer.TYPE || clazz == Integer.class || clazz == Character.TYPE || clazz == Character.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class;
    }

    public static boolean isShort(Class<?> clazz) {
        return clazz == Short.TYPE || clazz == Short.class;
    }

    public static boolean isLong(Class<?> clazz) {
        return clazz == Long.TYPE || clazz == Long.class;
    }

    public static boolean isFloat(Class<?> clazz) {
        return clazz == Float.TYPE || clazz == Float.class;
    }

    public static boolean isDouble(Class<?> clazz) {
        return clazz == Double.TYPE || clazz == Double.class;
    }

    public static boolean isBool(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    public static boolean isString(Class<?> clazz) {
        return clazz == String.class || clazz == CharSequence.class;
    }

    public static boolean isChar(Class<?> clazz) {
        return clazz == Character.TYPE || clazz == Character.class;
    }

    public static boolean isBigDecimal(Class<?> clazz) {
        return clazz == BigDecimal.class;
    }

    public static boolean isLocalDate(Class<?> clazz) {
        return clazz == LocalDate.class;
    }

    public static boolean isLocalDateTime(Class<?> clazz) {
        return clazz == LocalDateTime.class;
    }

    public static boolean isTime(Class<?> clazz) {
        return clazz == Time.class;
    }

    public static boolean isLocalTime(Class<?> clazz) {
        return clazz == LocalTime.class;
    }
}

