/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.Panes;
import org.ttzero.excel.entity.Picture;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.e7.XMLWorksheetWriter;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.Col;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.FullSheet;
import org.ttzero.excel.reader.RowSetIterator;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.validation.ListValidation;
import org.ttzero.excel.validation.Validation;

public class TemplateSheet
extends Sheet {
    public static final String HYPERLINK_KEY = "@link:";
    public static final String MEDIA_KEY = "@media:";
    public static final String LIST_KEY = "@list:";
    protected String prefix = "${";
    protected String suffix = "}";
    protected Path templatePath;
    protected InputStream templateStream;
    protected ExcelReader reader;
    protected int originalSheetIndex;
    protected String originalSheetName;
    protected CommitRowSetIterator rowIterator;
    protected Map<Integer, Integer> styleMap;
    protected List<Drawings.Picture> pictures;
    protected boolean writeAsExcel;
    protected PreCell[][] preCells;
    protected int pf;
    protected int pi;
    protected int afr = -1;
    protected List<Dimension> mergeCells;
    protected Map<Long, Dimension> mergeCells0;
    protected Map<String, ValueWrapper> namespaceMapper = new HashMap<String, ValueWrapper>();
    protected int[] fontIndices = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public TemplateSheet(Path templatePath) {
        this(templatePath, 0);
    }

    public TemplateSheet(String name, Path templatePath) {
        this(name, templatePath, 0);
    }

    public TemplateSheet(Path templatePath, int originalSheetIndex) {
        this(null, templatePath, originalSheetIndex);
    }

    public TemplateSheet(String name, Path templatePath, int originalSheetIndex) {
        this.name = name;
        this.templatePath = templatePath;
        this.originalSheetIndex = originalSheetIndex;
    }

    public TemplateSheet(Path templatePath, String originalSheetName) {
        this(null, templatePath, originalSheetName);
    }

    public TemplateSheet(String name, Path templatePath, String originalSheetName) {
        this.name = name;
        this.templatePath = templatePath;
        this.originalSheetName = originalSheetName;
    }

    public TemplateSheet(InputStream templateStream) {
        this(templateStream, 0);
    }

    public TemplateSheet(String name, InputStream templateStream) {
        this(name, templateStream, 0);
    }

    public TemplateSheet(InputStream templateStream, int originalSheetIndex) {
        this(null, templateStream, originalSheetIndex);
    }

    public TemplateSheet(InputStream templateStream, String originalSheetName) {
        this(null, templateStream, originalSheetName);
    }

    public TemplateSheet(String name, InputStream templateStream, int originalSheetIndex) {
        this.name = name;
        this.templateStream = templateStream;
        this.originalSheetIndex = originalSheetIndex;
    }

    public TemplateSheet(String name, InputStream templateStream, String originalSheetName) {
        this.name = name;
        this.templateStream = templateStream;
        this.originalSheetName = originalSheetName;
    }

    public TemplateSheet setPrefix(String prefix) {
        if (StringUtil.isBlank(prefix)) {
            throw new IllegalArgumentException("Illegal prefix value");
        }
        this.prefix = prefix;
        return this;
    }

    public TemplateSheet setSuffix(String suffix) {
        if (StringUtil.isBlank(suffix)) {
            throw new IllegalArgumentException("Illegal suffix value");
        }
        this.suffix = suffix;
        return this;
    }

    public TemplateSheet setData(Object o) {
        return this.setData(null, o);
    }

    public TemplateSheet setData(String namespace, Object o) {
        ValueWrapper vw;
        if ("this".equals(namespace)) {
            namespace = null;
        }
        if ((vw = this.namespaceMapper.get(namespace)) == null) {
            vw = new ValueWrapper();
            this.namespaceMapper.put(namespace, vw);
        } else {
            this.LOGGER.warn("The namespace[{}] already exists.", (Object)namespace);
        }
        if (o == null) {
            vw.option = 0;
        } else {
            Class<?> clazz = o.getClass();
            if (Map.class.isAssignableFrom(clazz)) {
                vw.option = 2;
                Map map = (Map)o;
                if (vw.map == null) {
                    vw.map = map;
                } else {
                    vw.map.putAll(map);
                }
            } else if (List.class.isAssignableFrom(clazz)) {
                List list = (List)o;
                Object oo = TemplateSheet.getFirstObject(list);
                if (oo != null) {
                    int n = vw.option = Map.class.isAssignableFrom(oo.getClass()) ? 3 : 4;
                    if (vw.list == null) {
                        vw.list = list;
                    } else {
                        vw.list.addAll(list);
                    }
                    if (vw.option == 4) {
                        vw.accessibleObjectMap = this.parseClass(oo.getClass());
                    }
                } else {
                    vw.option = 0;
                }
            } else if (clazz.isArray()) {
                int len = Array.getLength(o);
                if (vw.list == null) {
                    vw.list = new ArrayList<Object>(len);
                }
                for (int i = 0; i < len; ++i) {
                    Object oo = Array.get(o, i);
                    vw.list.add(oo);
                    if (oo == null || vw.option != 0) continue;
                    int n = vw.option = Map.class.isAssignableFrom(oo.getClass()) ? 3 : 4;
                    if (vw.option != 4) continue;
                    vw.accessibleObjectMap = this.parseClass(oo.getClass());
                }
            } else {
                vw.o = o;
                vw.option = 1;
                vw.accessibleObjectMap = this.parseClass(clazz);
            }
        }
        return this;
    }

    public TemplateSheet setData(BiFunction<Integer, Object, List<?>> dataSupplier) {
        return this.setData(null, dataSupplier);
    }

    public TemplateSheet setData(String namespace, BiFunction<Integer, Object, List<?>> dataSupplier) {
        ValueWrapper vw;
        if ("this".equals(namespace)) {
            namespace = null;
        }
        if ((vw = this.namespaceMapper.get(namespace)) != null) {
            this.LOGGER.warn("The namespace[{}] already exists.", (Object)namespace);
        } else {
            vw = new ValueWrapper();
            this.namespaceMapper.put(namespace, vw);
        }
        vw.supplier = dataSupplier;
        if (dataSupplier != null) {
            List<?> list = dataSupplier.apply(0, null);
            Object oo = TemplateSheet.getFirstObject(list);
            if (oo != null) {
                vw.size += list.size();
                if (vw.list == null) {
                    vw.list = list;
                } else {
                    vw.list.addAll(list);
                }
                int n = vw.option = Map.class.isAssignableFrom(oo.getClass()) ? 3 : 4;
                if (vw.option == 4) {
                    vw.accessibleObjectMap = this.parseClass(oo.getClass());
                }
            } else {
                vw.option = 0;
            }
        }
        return this;
    }

    @Override
    public RowBlock nextBlock() {
        this.rowBlock.clear();
        this.resetBlockData();
        return this.rowBlock.flip();
    }

    @Override
    public Column[] getAndSortHeaderColumns() {
        if (!this.headerReady) {
            int size;
            try {
                size = this.init();
            }
            catch (IOException e) {
                throw new ExcelWriteException(e);
            }
            if (size <= 0) {
                this.columns = new Column[0];
            } else {
                this.sortColumns(this.columns);
                this.calculateRealColIndex();
                this.resetCommonProperties(this.columns);
            }
            this.markExtProp();
            this.headerReady = true;
        }
        return this.columns;
    }

    protected int init() throws IOException {
        if (this.templatePath != null) {
            this.reader = ExcelReader.read(this.templatePath);
        } else if (this.templateStream != null) {
            this.reader = ExcelReader.read(this.templateStream);
        }
        org.ttzero.excel.reader.Sheet[] sheets = this.reader.all();
        if (StringUtil.isNotBlank(this.originalSheetName)) {
            int index;
            for (index = 0; index < sheets.length && !this.originalSheetName.equals(sheets[index].getName()); ++index) {
            }
            if (index >= sheets.length) {
                throw new IOException("The original worksheet [" + this.originalSheetName + "] does not exist in template file.");
            }
            this.originalSheetIndex = index;
        } else if (this.originalSheetIndex < 0 || this.originalSheetIndex >= sheets.length) {
            throw new IOException("The original worksheet index [" + this.originalSheetIndex + "] is out of range in template file[0-" + sheets.length + "].");
        }
        FullSheet sheet = this.reader.sheet(this.originalSheetIndex).asFullSheet();
        this.writeAsExcel = this.sheetWriter != null && XMLWorksheetWriter.class.isAssignableFrom(this.sheetWriter.getClass());
        int n = this.prepareCommonData(sheet);
        this.rowIterator = this.prepare(sheet);
        this.pf = this.preCells == null ? -1 : this.preCells[0][0].row;
        super.ignoreHeader();
        return n;
    }

    @Override
    protected void resetBlockData() {
        Column emptyColumn = new Column();
        int rbs = this.rowBlock.capacity();
        int n = 0;
        int limit = this.sheetWriter.getRowLimit();
        while (n++ < rbs && this.rows < limit && this.rowIterator.hasNext()) {
            Object e;
            PreCell pn;
            int i;
            Row row = this.rowBlock.next();
            org.ttzero.excel.reader.Row row0 = this.rowIterator.next();
            row.index = this.rows = this.rowIterator.rows - 1;
            row.height = row0.getHeight();
            row.hidden = row0.isHidden();
            int len = Math.max(row0.getLastColumnIndex() - row0.getFirstColumnIndex(), 0);
            Cell[] cells = row.realloc(len);
            if (row0.getRowNum() == this.pf && !this.rowIterator.hasFillCell) {
                this.rowIterator.withPreNodes(this.preCells[this.pi], this.namespaceMapper);
            }
            boolean consumerEnd = true;
            for (i = 0; i < len; ++i) {
                Dimension mergeCell;
                Cell cell = cells[i];
                Cell cell0 = row0.getCell(i);
                cell.clear();
                boolean fillCell = false;
                switch (row0.getCellType(cell0)) {
                    case STRING: {
                        if (this.rowIterator.hasFillCell && (pn = this.rowIterator.preNodes[i]) != null) {
                            fillCell = true;
                            this.fillValue(row, cell, pn, emptyColumn);
                            if (pn.m == null) break;
                            if (pn.m > 0) {
                                this.mergeCells.add(new Dimension(this.rows + 1, (short)(i + 1), this.rows + 1, (short)(i + pn.m + 1)));
                                break;
                            }
                            this.mergeCells.add(new Dimension(this.rows + 1, (short)(i + 1), this.rows + ~pn.m.intValue(), (short)(i + 1)));
                            break;
                        }
                        cell.setString(row0.getString(cell0));
                        break;
                    }
                    case LONG: {
                        cell.setLong(row0.getLong(cell0));
                        break;
                    }
                    case INTEGER: {
                        cell.setInt(row0.getInt(cell0));
                        break;
                    }
                    case DECIMAL: {
                        cell.setDecimal(row0.getDecimal(cell0));
                        break;
                    }
                    case DOUBLE: {
                        cell.setDouble(row0.getDouble(cell0));
                        break;
                    }
                    case DATE: {
                        cell.setDateTime(DateUtil.toDateTimeValue(row0.getTimestamp(cell0)));
                        break;
                    }
                    case BOOLEAN: {
                        cell.setBool(row0.getBoolean(cell0));
                        break;
                    }
                    case BLANK: {
                        cell.emptyTag();
                        break;
                    }
                }
                if (!this.writeAsExcel) continue;
                if (row0.hasFormula(cell0)) {
                    cell.setFormula(row0.getFormula(cell0));
                }
                cell.xf = this.styleMap.getOrDefault(cell0.xf, 0);
                if (cell.h) {
                    cell.xf = this.hyperlinkStyle(this.workbook.getStyles(), cell.xf);
                }
                if (fillCell || this.mergeCells0 == null || (mergeCell = this.mergeCells0.get(TemplateSheet.dimensionKey(row0.getRowNum() - 1, i))) == null) continue;
                if (this.rows <= row0.getRowNum()) {
                    this.mergeCells.add(mergeCell);
                    continue;
                }
                int r = this.rows - row0.getRowNum() + 1;
                this.mergeCells.add(new Dimension(mergeCell.firstRow + r, mergeCell.firstColumn, mergeCell.lastRow + r, mergeCell.lastColumn));
            }
            if (!this.rowIterator.consumerNamespaces.isEmpty()) {
                for (String vwKey : this.rowIterator.consumerNamespaces) {
                    ValueWrapper vw = this.namespaceMapper.get(vwKey);
                    if (++vw.i < vw.list.size()) {
                        consumerEnd = false;
                        continue;
                    }
                    if (vw.supplier != null) {
                        List<?> list = vw.supplier.apply(vw.size, !vw.list.isEmpty() ? vw.list.get(vw.list.size() - 1) : null);
                        if (list != null && !list.isEmpty()) {
                            vw.list = list;
                            vw.i = 0;
                            vw.size += list.size();
                            consumerEnd = false;
                            continue;
                        }
                        vw.option = -1;
                        continue;
                    }
                    vw.option = -1;
                }
            }
            if (!consumerEnd) continue;
            if (this.rowIterator.hasFillCell) {
                for (i = row0.getFirstColumnIndex(); i < len; ++i) {
                    pn = this.rowIterator.preNodes[i];
                    if (pn == null || pn.validation == null) continue;
                    Dimension sqref = pn.validation.sqref;
                    pn.validation.sqref = new Dimension(sqref.firstRow, sqref.firstColumn, sqref.lastRow + pn.v, sqref.firstColumn);
                }
                ++this.pi;
                int n2 = this.pf = this.preCells.length > this.pi && this.preCells[this.pi] != null && this.preCells[this.pi].length >= 1 ? this.preCells[this.pi][0].row : -1;
            }
            if (this.afr == row0.getRowNum() && (e = this.getExtPropValue("auto_filter")) instanceof Dimension) {
                Dimension autoFilter = (Dimension)e;
                this.putExtProp("auto_filter", new Dimension(autoFilter.firstRow + row.getIndex() - this.afr + 1, autoFilter.firstColumn, autoFilter.getLastRow() + row.getIndex() - this.afr + 1, autoFilter.lastColumn));
                this.afr = -1;
            }
            this.rowIterator.commit();
        }
    }

    protected Object getNodeValue(Node node) {
        if ((node.option & 1) == 0) {
            return node.val;
        }
        ValueWrapper vw = this.namespaceMapper.get(node.namespace);
        Object e = null;
        if (vw != null) {
            switch (vw.option) {
                case 1: {
                    e = TemplateSheet.getObjectValue(vw.accessibleObjectMap.get(node.val), vw.o, this.LOGGER, node.val);
                    break;
                }
                case 2: {
                    e = vw.map.get(node.val);
                    break;
                }
                case 3: {
                    e = ((Map)vw.list.get(vw.i)).get(node.val);
                    break;
                }
                case 4: {
                    e = TemplateSheet.getObjectValue(vw.accessibleObjectMap.get(node.val), vw.list.get(vw.i), this.LOGGER, node.val);
                    break;
                }
            }
        }
        return e;
    }

    protected static Object getObjectValue(AccessibleObject ao, Object o, Logger logger, String key) {
        Object e = null;
        try {
            e = ao instanceof Method ? ((Method)ao).invoke(o, new Object[0]) : (ao instanceof Field ? ((Field)ao).get(o) : o);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            logger.warn("Invoke " + key + " value error", (Throwable)ex);
        }
        return e;
    }

    protected void fillValue(Row row, Cell cell, PreCell pn, Column emptyColumn) {
        if (pn.nodes.length == 1) {
            Object e = this.getNodeValue(pn.nodes[0]);
            if (e != null) {
                if (String.class == e.getClass()) {
                    switch (pn.nodes[0].getType()) {
                        case 1: {
                            cell.setHyperlink(e.toString());
                            break;
                        }
                        case 2: {
                            this.cellValueAndStyle.writeAsMedia(row, cell, e.toString(), emptyColumn, String.class);
                            break;
                        }
                        default: {
                            cell.setString(e.toString());
                            break;
                        }
                    }
                } else {
                    emptyColumn.setClazz(e.getClass());
                    this.cellValueAndStyle.setCellValue(row, cell, e, emptyColumn, e.getClass(), false);
                }
            } else {
                cell.emptyTag();
            }
            if (pn.nodes[0].getType() == 3) {
                PreCell preCell = pn;
                Integer n = preCell.v;
                Integer n2 = preCell.v = Integer.valueOf(preCell.v + 1);
            }
        } else {
            int k = 0;
            for (Node node : pn.nodes) {
                Object e = this.getNodeValue(node);
                if (e == null) continue;
                String s = e.toString();
                int vn = s.length();
                if (vn + k > pn.cb.length) {
                    pn.cb = Arrays.copyOf(pn.cb, vn + k + 128);
                }
                s.getChars(0, vn, pn.cb, k);
                k += vn;
            }
            cell.setString(new String(pn.cb, 0, k));
        }
    }

    @Override
    public void afterSheetDataWriter(int total) {
        Object o;
        super.afterSheetDataWriter(total);
        if (this.pictures != null) {
            try {
                for (Drawings.Picture p : this.pictures) {
                    if (p == null || p.isBackground()) continue;
                    this.sheetWriter.writePicture(TemplateSheet.toWritablePicture(p));
                }
            }
            catch (IOException e) {
                this.LOGGER.warn("Copy pictures failed.", (Throwable)e);
            }
        }
        if (this.mergeCells != null) {
            this.putExtProp("merge_cells", this.mergeCells);
        }
        if ((o = this.getExtPropValue("auto_filter")) instanceof Dimension) {
            Dimension autoFilter = (Dimension)o;
            this.putExtProp("auto_filter", autoFilter);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public static Picture toWritablePicture(Drawings.Picture pic) {
        Picture p = new Picture();
        p.localPath = pic.getLocalPath();
        p.row = pic.getDimension().firstRow - 1;
        p.col = pic.getDimension().firstColumn - 1;
        p.toRow = pic.getDimension().lastRow - 1;
        p.toCol = pic.getDimension().lastColumn - 1;
        p.padding = pic.getPadding();
        p.revolve = pic.getRevolve();
        p.property = pic.getProperty();
        p.effect = pic.getEffect();
        return p;
    }

    protected CommitRowSetIterator prepare(org.ttzero.excel.reader.Sheet originalSheet) {
        Styles styles0 = this.reader.getStyles();
        Styles styles = this.workbook.getStyles();
        this.styleMap = this.writeAsExcel ? new HashMap() : Collections.emptyMap();
        int prefixLen = this.prefix.length();
        int suffixLen = this.suffix.length();
        int pf = 0;
        Iterator<org.ttzero.excel.reader.Row> iter = originalSheet.iterator();
        while (iter.hasNext()) {
            org.ttzero.excel.reader.Row row = iter.next();
            int index = 0;
            int end = row.getLastColumnIndex();
            for (int i = row.getFirstColumnIndex(); i < end; ++i) {
                PreCell[] pns;
                Cell cell = row.getCell(i);
                if (this.writeAsExcel && !this.styleMap.containsKey(cell.xf)) {
                    NumFmt numFmt;
                    Border border;
                    Fill fill;
                    int style = row.getCellStyle(cell);
                    int xf = 0;
                    Font font = styles0.getFont(style);
                    if (font != null) {
                        xf |= styles.addFont(font.clone());
                    }
                    if ((fill = styles0.getFill(style)) != null) {
                        xf |= styles.addFill(fill.clone());
                    }
                    if ((border = styles0.getBorder(style)) != null) {
                        xf |= styles.addBorder(border.clone());
                    }
                    if ((numFmt = styles0.getNumFmt(style)) != null) {
                        xf |= styles.addNumFmt(numFmt.clone());
                    }
                    xf |= styles0.getHorizontal(style);
                    xf |= styles0.getVertical(style);
                    this.styleMap.put(cell.xf, styles.of(xf |= styles0.getWrapText(style)));
                }
                if (row.getCellType(cell) != CellType.STRING) continue;
                String v = row.getString(cell);
                PreCell preCell = this.prepareCellValue(row.getRowNum(), i, v, prefixLen, suffixLen);
                if (preCell == null) continue;
                if (this.preCells == null) {
                    this.preCells = new PreCell[10][];
                }
                if (index == 0) {
                    if (pf >= this.preCells.length) {
                        this.preCells = (PreCell[][])Arrays.copyOf(this.preCells, this.preCells.length + 10);
                    }
                    int n = pf++;
                    pns = new PreCell[Math.min(end - i, 10)];
                    this.preCells[n] = pns;
                } else {
                    pns = this.preCells[pf - 1];
                    if (index >= pns.length) {
                        pns = Arrays.copyOf(pns, pns.length + 10);
                        this.preCells[pf - 1] = pns;
                    }
                }
                pns[index++] = preCell;
            }
            if (index <= 0 || this.preCells[pf - 1].length <= index) continue;
            this.preCells[pf - 1] = Arrays.copyOf(this.preCells[pf - 1], index);
        }
        return new CommitRowSetIterator((RowSetIterator)originalSheet.reset().iterator());
    }

    protected int prepareCommonData(FullSheet originalSheet) {
        Integer zoomScale;
        Dimension dimension;
        List<Dimension> mergeCells0;
        int len = 0;
        List<Col> cols = originalSheet.getCols();
        if (cols != null && !cols.isEmpty()) {
            cols.sort(Comparator.comparingInt(a -> a.max));
            len = cols.get((int)(cols.size() - 1)).max;
            int i = 0;
            this.columns = new Column[len];
            for (Col col : cols) {
                Column c;
                if (i + 1 < col.min) {
                    for (int a2 = i + 1; a2 < col.min; ++a2) {
                        c = new Column();
                        c.colIndex = a2 - 1;
                        this.columns[i++] = c;
                    }
                }
                for (int a2 = col.min; a2 <= col.max; ++a2) {
                    c = new Column();
                    c.width = col.width;
                    c.colIndex = a2 - 1;
                    if (col.hidden) {
                        c.hide();
                    }
                    this.columns[i++] = c;
                }
            }
        }
        if (!this.writeAsExcel) {
            return len;
        }
        Panes panes = originalSheet.getFreezePanes();
        if (panes != null) {
            this.putExtProp("freeze", panes);
        }
        if ((mergeCells0 = originalSheet.getMergeCells()) != null) {
            this.mergeCells = new ArrayList<Dimension>(mergeCells0.size());
            this.mergeCells0 = new HashMap<Long, Dimension>(mergeCells0.size());
            for (Dimension dim : mergeCells0) {
                this.mergeCells0.put(TemplateSheet.dimensionKey(dim.firstRow - 1, dim.firstColumn - 1), dim);
            }
        }
        if ((dimension = originalSheet.getFilter()) != null) {
            this.afr = dimension.getFirstRow();
            this.putExtProp("auto_filter", dimension);
        }
        this.showGridLines = originalSheet.isShowGridLines();
        double defaultColWidth = originalSheet.getDefaultColWidth();
        double defaultRowHeight = originalSheet.getDefaultRowHeight();
        if (defaultColWidth >= 0.0) {
            this.putExtProp("defaultColWidth", defaultColWidth);
        }
        if (defaultRowHeight >= 0.0) {
            this.putExtProp("defaultRowHeight", defaultRowHeight);
        }
        if ((zoomScale = originalSheet.getZoomScale()) != null) {
            this.putExtProp("zoom_scale", zoomScale);
        }
        try {
            List<Drawings.Picture> pictures = originalSheet.listPictures();
            if (pictures != null && !pictures.isEmpty()) {
                this.pictures = pictures.size() > 1 || !pictures.get(0).isBackground() ? new ArrayList<Drawings.Picture>(pictures) : null;
                for (Drawings.Picture p : pictures) {
                    if (!FileUtil.exists(p.getLocalPath())) continue;
                    if (p.isBackground()) {
                        this.setWaterMark(WaterMark.of(p.getLocalPath()));
                        continue;
                    }
                    this.pictures.add(p);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return len;
    }

    protected PreCell prepareCellValue(int row, int col, String v, int prefixLen, int suffixLen) {
        int len = v.length();
        if (len <= prefixLen + suffixLen) {
            return null;
        }
        int pi = 0;
        int fi = v.indexOf(this.prefix);
        if (fi < 0) {
            return null;
        }
        int fn = fi + prefixLen;
        int li = v.indexOf(this.suffix, fn);
        if (li <= fn) {
            return null;
        }
        PreCell pn = new PreCell();
        pn.row = row;
        pn.col = col;
        do {
            int j;
            if (fi > pi) {
                Node node = new Node();
                if (pn.nodes == null) {
                    pn.nodes = new Node[]{node};
                } else {
                    pn.nodes = Arrays.copyOf(pn.nodes, pn.nodes.length + 1);
                    pn.nodes[pn.nodes.length - 1] = node;
                }
                node.val = v.substring(pi, fi);
            }
            for (j = fn; j < li && v.charAt(j) != '.'; ++j) {
            }
            Node node = new Node();
            node.option = 1;
            if (pn.nodes == null) {
                pn.nodes = new Node[]{node};
            } else {
                pn.nodes = Arrays.copyOf(pn.nodes, pn.nodes.length + 1);
                pn.nodes[pn.nodes.length - 1] = node;
            }
            if (j < li) {
                node.namespace = v.substring(fn, j).trim();
                node.val = v.substring(j + 1, li).trim();
            } else {
                node.val = v.substring(fn, li).trim();
            }
            pi = li + suffixLen;
        } while ((fi = v.indexOf(this.prefix, pi)) >= 0 && (li = v.indexOf(this.suffix, fn = fi + prefixLen)) > fn && fi < len);
        if (pi < len) {
            Node node = new Node();
            pn.nodes = Arrays.copyOf(pn.nodes, pn.nodes.length + 1);
            pn.nodes[pn.nodes.length - 1] = node;
            node.val = v.substring(pi);
        }
        if (pn.nodes.length > 1) {
            pn.cb = new char[Math.max(len + (len >> 1), 128)];
        }
        return this.afterParseCell(pn);
    }

    protected PreCell afterParseCell(PreCell pn) {
        Dimension mc;
        if (this.mergeCells0 != null && (mc = this.mergeCells0.get(TemplateSheet.dimensionKey(pn.row - 1, pn.col))) != null && mc.height == 1) {
            pn.m = mc.width - 1;
        }
        if (pn.nodes.length == 1 && (pn.nodes[0].option & 1) == 1) {
            String k;
            Node node = pn.nodes[0];
            boolean useNamespace = StringUtil.isNotEmpty(node.namespace);
            String string = k = useNamespace ? node.namespace : node.val;
            if (k.length() < 7 || k.charAt(0) != '@') {
                return pn;
            }
            String[] keys = new String[]{HYPERLINK_KEY, MEDIA_KEY, LIST_KEY};
            int p = TemplateSheet.prefixMatch(keys, k);
            if (p >= 0) {
                node.option = (byte)(node.option | p + 1 << 1);
                pn.v = 0;
                String innerFormulaStr = useNamespace ? node.namespace + '.' + node.val : node.val;
                int pLen = keys[p].length();
                if (useNamespace) {
                    node.namespace = node.namespace.substring(pLen);
                } else {
                    node.val = node.val.substring(pLen);
                }
                ValueWrapper vw = this.namespaceMapper.get(innerFormulaStr);
                if (vw != null && vw.option == 4) {
                    ArrayList<Validation> validations;
                    pn.validation = new ListValidation<Object>().in(vw.list).dimension(new Dimension(pn.row, (short)(pn.col + 1)));
                    Object o = this.getExtPropValue("data_validation");
                    if (o instanceof List) {
                        validations = (ArrayList<Validation>)o;
                    } else {
                        validations = new ArrayList<Validation>();
                        this.putExtProp("data_validation", validations);
                    }
                    validations.add(pn.validation);
                }
            }
        }
        return pn;
    }

    protected int hyperlinkStyle(Styles styles, int xf) {
        int fi;
        int style = styles.getStyleByIndex(xf);
        int fontIndex = Math.max(0, style << 8 >>> 26);
        if (fontIndex > this.fontIndices.length) {
            int n = this.fontIndices.length;
            this.fontIndices = Arrays.copyOf(this.fontIndices, Math.min(n + 16, fontIndex));
            Arrays.fill(this.fontIndices, n, this.fontIndices.length, -1);
        }
        if ((fi = this.fontIndices[fontIndex]) == -1) {
            Font font = styles.getFont(style).clone();
            font.setStyle(0).underline();
            font.setColor(ColorIndex.themeColors[10]);
            this.fontIndices[fontIndex] = fi = this.workbook.getStyles().addFont(font);
        }
        return this.workbook.getStyles().of(Styles.clearFont(style) | fi);
    }

    protected Map<String, AccessibleObject> parseClass(Class<?> clazz) {
        HashMap<String, AccessibleObject> tmp = new HashMap<String, AccessibleObject>();
        try {
            Field[] declaredFields;
            tmp.putAll(ReflectUtil.readMethodsMap(clazz, Object.class));
            for (Field f : declaredFields = ReflectUtil.listDeclaredFields(clazz)) {
                if (tmp.containsKey(f.getName())) continue;
                f.setAccessible(true);
                tmp.put(f.getName(), f);
            }
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get class {} methods failed.", clazz);
        }
        return tmp;
    }

    public static long dimensionKey(int row, int col) {
        return (long)(col & Short.MAX_VALUE) | (long)row << 16;
    }

    protected static Object getFirstObject(List<?> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        Object first = list.get(0);
        if (first != null) {
            return first;
        }
        int i = 1;
        int len = list.size();
        while ((first = list.get(i++)) == null && i < len) {
        }
        return first;
    }

    public static int prefixMatch(String[] array, String v) {
        int i;
        int len = array.length;
        for (i = 0; i < len && !v.startsWith(array[i]); ++i) {
        }
        return i < len ? i : -1;
    }

    public static class ValueWrapper {
        public int option;
        public int i;
        public int size;
        public Object o;
        public Map<String, Object> map;
        public BiFunction<Integer, Object, List<?>> supplier;
        public List<Object> list;
        public Map<String, AccessibleObject> accessibleObjectMap;
    }

    public static class Node {
        public byte option;
        public String namespace;
        public String val;

        public int getType() {
            return this.option >>> 1 & 7;
        }

        public String toString() {
            return (this.option & 1) == 0 ? this.val : '$' + (this.namespace != null ? this.namespace + "::" : "") + this.val;
        }
    }

    public static class PreCell {
        public int row;
        public int col;
        public Node[] nodes;
        public char[] cb;
        public Integer m;
        public Integer v;
        public Validation validation;
    }

    public static class CommitRowSetIterator
    implements Iterator<org.ttzero.excel.reader.Row> {
        public final RowSetIterator iterator;
        public org.ttzero.excel.reader.Row current;
        public int rows;
        public PreCell[] preNodes;
        public boolean hasFillCell;
        public Set<String> consumerNamespaces = new HashSet<String>();

        public CommitRowSetIterator(RowSetIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.current != null || this.iterator.hasNext();
        }

        @Override
        public org.ttzero.excel.reader.Row next() {
            org.ttzero.excel.reader.Row row = this.current != null ? this.current : (this.current = this.iterator.next());
            this.rows = Math.max(row.getRowNum(), this.rows + 1);
            return row;
        }

        public void withPreNodes(PreCell[] preNodes, Map<String, ValueWrapper> namespaceMapper) {
            int len = this.current.getLastColumnIndex();
            int len0 = preNodes[preNodes.length - 1].col + 1;
            this.preNodes = new PreCell[Math.max(len, len0)];
            PreCell[] preCellArray = preNodes;
            int n = preCellArray.length;
            for (int i = 0; i < n; ++i) {
                PreCell p;
                this.preNodes[p.col] = p = preCellArray[i];
            }
            this.hasFillCell = true;
            if (!namespaceMapper.isEmpty()) {
                for (PreCell pn : preNodes) {
                    for (Node node : pn.nodes) {
                        ValueWrapper vw;
                        if ((node.option & 1) != 1 || (vw = namespaceMapper.get(node.namespace)) == null || vw.option != 3 && vw.option != 4) continue;
                        this.consumerNamespaces.add(node.namespace);
                    }
                }
            }
        }

        public void commit() {
            this.current = null;
            this.preNodes = null;
            this.hasFillCell = false;
            this.consumerNamespaces.clear();
        }
    }
}

