/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.csv;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.csv.CSVCellValueAndStyle;
import org.ttzero.excel.entity.csv.CSVWorksheetWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.util.ZipUtil;

public class CSVWorkbookWriter
implements IWorkbookWriter {
    protected Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private Workbook workbook;
    private String suffix = ".csv";

    public CSVWorkbookWriter() {
    }

    public CSVWorkbookWriter(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        Path path = this.createTemp();
        Files.copy(path, os);
        this.cleanTmp(path);
    }

    @Override
    public void writeTo(File file) throws IOException {
        Path path = this.createTemp();
        FileUtil.cp(path, file);
        this.cleanTmp(path);
    }

    @Override
    public Path template() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(Path root) throws IOException {
        Path path = this.createTemp();
        this.reMarkPath(path, root);
        this.cleanTmp(path);
    }

    private void cleanTmp(Path path) {
        int i = 0;
        for (Path sub : path) {
            ++i;
            if (!sub.toString().startsWith("eec+")) continue;
            break;
        }
        if (i < path.getNameCount()) {
            FileUtil.rm_rf(path.getRoot().resolve(path.subpath(0, i)).toFile(), true);
            this.LOGGER.debug("Clean up temporary files");
        }
    }

    protected void reMarkPath(Path src, Path path) throws IOException {
        String name = this.workbook.getName();
        if (StringUtil.isEmpty(name)) {
            name = this.workbook.getI18N().getOrElse("non-name-file", "Non name");
        }
        Path resultPath = this.reMarkPath(src, path, name);
        this.LOGGER.debug("Write completed. {}", (Object)resultPath);
    }

    protected Path createTemp() throws IOException, ExcelWriteException {
        Sheet[] sheets = this.workbook.getSheets();
        for (int i = 0; i < sheets.length; ++i) {
            Sheet sheet = sheets[i];
            IWorksheetWriter worksheetWriter = this.getWorksheetWriter(sheet);
            sheet.setSheetWriter(worksheetWriter);
            sheet.setId(i + 1);
            if (StringUtil.isEmpty(sheet.getName())) {
                sheet.setName("Sheet" + (i + 1));
            }
            sheet.setCellValueAndStyle(new CSVCellValueAndStyle());
            if (this.workbook.getForceExport() <= sheet.getForceExport() || !ListSheet.class.isAssignableFrom(sheet.getClass())) continue;
            ((ListSheet)sheet).forceExport();
        }
        this.LOGGER.debug("Sheet initialization completed.");
        Path root = null;
        try {
            root = FileUtil.mktmp("eec+");
            this.LOGGER.debug("Create temporary folder {}", (Object)root);
            for (int i = 0; i < this.workbook.getSize(); ++i) {
                Sheet e = this.workbook.getSheetAt(i);
                e.writeTo(root);
                e.close();
            }
            if (this.workbook.getSize() > 1) {
                this.suffix = ".zip";
                Path zipFile = ZipUtil.zipExcludeRoot(root, root);
                this.LOGGER.debug("Compression completed. {}", (Object)zipFile);
                FileUtil.rm_rf(root.toFile(), true);
                return zipFile;
            }
            return root.resolve(this.workbook.getSheetAt(0).getName() + ".csv");
        }
        catch (IOException | ExcelWriteException e) {
            if (root != null) {
                FileUtil.rm_rf(root);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public IWorksheetWriter getWorksheetWriter(Sheet sheet) {
        return new CSVWorksheetWriter(sheet);
    }
}

