/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.manager;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, value="Relationships", uri={"http://schemas.openxmlformats.org/package/2006/relationships"})
public class RelManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Relationship> relationships;

    public static RelManager of(Relationship ... relationships) {
        RelManager relManager = new RelManager();
        relManager.relationships = new ArrayList<Relationship>(Arrays.asList(relationships));
        return relManager;
    }

    public synchronized Relationship add(Relationship rel) {
        int n;
        if (this.relationships == null) {
            this.relationships = new ArrayList<Relationship>();
        }
        if ((n = this.indexOf(rel.getTarget())) > -1) {
            rel.setId("rId" + (n + 1));
            this.relationships.set(n, rel);
        } else {
            rel.setId("rId" + (this.relationships.size() + 1));
            this.relationships.add(rel);
        }
        return rel;
    }

    private int indexOf(String target) {
        if (this.relationships == null || this.relationships.isEmpty()) {
            return -1;
        }
        int i = 0;
        for (Relationship rel : this.relationships) {
            if (rel.getTarget().equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Relationship getByTarget(String target) {
        int n = this.indexOf(target);
        return n == -1 ? null : this.relationships.get(n);
    }

    public Relationship likeByTarget(String target) {
        if (this.relationships == null || this.relationships.isEmpty()) {
            return null;
        }
        for (Relationship rel : this.relationships) {
            if (!rel.getTarget().contains(target)) continue;
            return rel;
        }
        return null;
    }

    public Relationship getById(String id) {
        if (this.relationships == null || this.relationships.isEmpty()) {
            return null;
        }
        for (Relationship rel : this.relationships) {
            if (!rel.getId().equals(id)) continue;
            return rel;
        }
        return null;
    }

    public Relationship getByType(String type) {
        if (this.relationships == null || this.relationships.isEmpty() || StringUtil.isEmpty(type)) {
            return null;
        }
        for (Relationship rel : this.relationships) {
            if (!type.equals(rel.getType())) continue;
            return rel;
        }
        return null;
    }

    public void write(Path parent, String name) throws IOException {
        if (this.relationships == null || this.relationships.isEmpty()) {
            return;
        }
        Path rels = parent.resolve("_rels");
        if (!FileUtil.exists(rels)) {
            FileUtil.mkdir(rels);
        }
        name = name == null || name.isEmpty() ? ".rels" : name + ".rels";
        TopNS topNS = this.getClass().getAnnotation(TopNS.class);
        DocumentFactory factory = DocumentFactory.getInstance();
        Element rootElement = factory.createElement(topNS.value(), topNS.uri()[0]);
        for (Relationship rel : this.relationships) {
            Field[] fields;
            Class<?> clazz = rel.getClass();
            String className = clazz.getSimpleName();
            Element ele = rootElement.addElement(className);
            for (Field field : fields = clazz.getDeclaredFields()) {
                Class<?> _clazz;
                if ("serialVersionUID".equals(field.getName())) continue;
                field.setAccessible(true);
                Object oo = null;
                try {
                    oo = field.get(rel);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (oo == null || (_clazz = field.getType()) == this.getClass()) continue;
                ele.addAttribute(StringUtil.uppFirstKey(field.getName()), oo.toString());
            }
        }
        Document doc = factory.createDocument(rootElement);
        FileUtil.writeToDiskNoFormat(doc, rels.resolve(name));
    }

    public RelManager deepClone() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return (RelManager)ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            RelManager rm = new RelManager();
            if (this.relationships != null) {
                for (Relationship r : this.relationships) {
                    rm.add(r.clone());
                }
            }
            return rm;
        }
    }
}

