/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.HeaderRow;
import org.ttzero.excel.reader.PreCalc;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.UncheckedTypeException;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

public class Row {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected int index = -1;
    protected int fc = 0;
    protected int lc = -1;
    protected Cell[] cells;
    protected SharedStrings sst;
    protected HeaderRow hr;
    protected boolean unknownLength;
    protected PreCalc[] sharedCalc;
    protected Styles styles;

    public int getRowNum() {
        return this.index;
    }

    public int getFirstColumnIndex() {
        return this.fc;
    }

    public int getLastColumnIndex() {
        return this.lc;
    }

    public Styles getStyles() {
        return this.styles;
    }

    public boolean isEmpty() {
        return this.lc - this.fc <= 0;
    }

    public boolean nonEmpty() {
        return this.lc > this.fc;
    }

    public boolean isBlank() {
        if (this.lc > this.fc) {
            for (int i = this.fc; i < this.lc; ++i) {
                Cell c = this.cells[i];
                if (this.isBlank(c)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean nonBlank() {
        return !this.isBlank();
    }

    public Double getHeight() {
        return null;
    }

    public boolean isHidden() {
        return false;
    }

    protected void rangeCheck(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + " is negative.");
        }
    }

    public Cell getCell(int i) {
        this.rangeCheck(i);
        return i < this.lc ? this.cells[i] : Cell.UNALLOCATED_CELL;
    }

    public Cell getCell(String name) {
        int i;
        return this.hr != null && (i = this.hr.getIndex(name)) >= 0 && i < this.lc ? this.cells[i] : Cell.UNALLOCATED_CELL;
    }

    public HeaderRow asHeader() {
        return new HeaderRow().with(this);
    }

    public Row setHeader(HeaderRow hr) {
        this.hr = hr;
        return this;
    }

    public HeaderRow getHeader() {
        return this.hr;
    }

    public SharedStrings getSharedStrings() {
        return this.sst;
    }

    public Boolean getBoolean(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getBoolean(c);
    }

    public Boolean getBoolean(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getBoolean(c);
    }

    public Boolean getBoolean(Cell c) {
        boolean v;
        switch (c.t) {
            case 'b': {
                v = c.boolVal;
                break;
            }
            case 'n': {
                v = c.intVal != 0;
                break;
            }
            case 'l': {
                v = c.longVal != 0L;
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                v = "true".equalsIgnoreCase(c.stringVal);
                break;
            }
            case 'm': {
                v = c.decimal.compareTo(BigDecimal.ZERO) != 0;
                break;
            }
            case 'd': {
                v = c.doubleVal != 0.0;
                break;
            }
            case '\u0000': 
            case 'e': 
            case 'k': {
                return null;
            }
            default: {
                v = false;
            }
        }
        return v;
    }

    public Byte getByte(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getByte(c);
    }

    public Byte getByte(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getByte(c);
    }

    public Byte getByte(Cell c) {
        byte b = 0;
        switch (c.t) {
            case 'n': {
                b = (byte)(b | c.intVal);
                break;
            }
            case 'l': {
                b = (byte)((long)b | c.longVal);
                break;
            }
            case 'm': {
                b = c.decimal.byteValue();
                break;
            }
            case 'd': {
                b = (byte)(b | (int)c.doubleVal);
                break;
            }
            case 'b': {
                b = (byte)(b | (c.boolVal ? 1 : 0));
                break;
            }
            default: {
                return null;
            }
        }
        return b;
    }

    public Character getChar(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getChar(c);
    }

    public Character getChar(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getChar(c);
    }

    public Character getChar(Cell c) {
        char cc = '\u0000';
        switch (c.t) {
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                if (!StringUtil.isNotEmpty(c.stringVal)) break;
                cc = c.stringVal.charAt(0);
                break;
            }
            case 'n': {
                cc = (char)(cc | c.intVal);
                break;
            }
            case 'l': {
                cc = (char)((long)cc | c.longVal);
                break;
            }
            case 'b': {
                cc = (char)(cc | (c.boolVal ? (char)'\u0001' : '\u0000'));
                break;
            }
            case 'm': {
                cc = (char)(cc | c.decimal.intValue());
                break;
            }
            case 'd': {
                cc = (char)(cc | (int)c.doubleVal);
                break;
            }
            default: {
                return null;
            }
        }
        return Character.valueOf(cc);
    }

    public Short getShort(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getShort(c);
    }

    public Short getShort(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getShort(c);
    }

    public Short getShort(Cell c) {
        short s = 0;
        block0 : switch (c.t) {
            case 'n': {
                s = (short)(s | c.intVal);
                break;
            }
            case 'l': {
                s = (short)((long)s | c.longVal);
                break;
            }
            case 'm': {
                s = c.decimal.shortValue();
                break;
            }
            case 'd': {
                s = (short)(s | (int)c.doubleVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                if (StringUtil.isEmpty(c.stringVal)) {
                    return null;
                }
                String ss = c.stringVal.trim();
                int t = Row.testNumberType(ss.toCharArray(), 0, ss.length());
                switch (t) {
                    case 1: {
                        s = (short)(s | Integer.parseInt(ss));
                        break block0;
                    }
                    case 2: {
                        s = (short)((long)s | Long.parseLong(ss));
                        break block0;
                    }
                    case 3: {
                        s = (short)Double.parseDouble(ss);
                        break block0;
                    }
                    case 0: {
                        return null;
                    }
                }
                throw new NumberFormatException("For input string: \"" + c.stringVal + "\"");
            }
            case 'b': {
                s = (short)(s | (c.boolVal ? 1 : 0));
                break;
            }
            default: {
                return null;
            }
        }
        return s;
    }

    public Integer getInt(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getInt(c);
    }

    public Integer getInt(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getInt(c);
    }

    public Integer getInt(Cell c) {
        int n = 0;
        block0 : switch (c.t) {
            case 'n': {
                n = c.intVal;
                break;
            }
            case 'l': {
                n = (int)c.longVal;
                break;
            }
            case 'm': {
                n = c.decimal.intValue();
                break;
            }
            case 'd': {
                n = (int)c.doubleVal;
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                if (StringUtil.isEmpty(c.stringVal)) {
                    return null;
                }
                String ss = c.stringVal.trim();
                int t = Row.testNumberType(ss.toCharArray(), 0, ss.length());
                switch (t) {
                    case 1: {
                        n = Integer.parseInt(ss);
                        break block0;
                    }
                    case 2: {
                        n = (int)((long)n | Long.parseLong(ss));
                        break block0;
                    }
                    case 3: {
                        n = (int)Double.parseDouble(ss);
                        break block0;
                    }
                    case 0: {
                        return null;
                    }
                }
                throw new NumberFormatException("For input string: \"" + c.stringVal + "\"");
            }
            case 'b': {
                n = c.boolVal ? 1 : 0;
                break;
            }
            default: {
                return null;
            }
        }
        return n;
    }

    public Long getLong(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getLong(c);
    }

    public Long getLong(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getLong(c);
    }

    public Long getLong(Cell c) {
        long l;
        block0 : switch (c.t) {
            case 'l': {
                l = c.longVal;
                break;
            }
            case 'n': {
                l = c.intVal;
                break;
            }
            case 'm': {
                l = c.decimal.longValue();
                break;
            }
            case 'd': {
                l = (long)c.doubleVal;
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                if (StringUtil.isEmpty(c.stringVal)) {
                    return null;
                }
                String ss = c.stringVal.trim();
                int t = Row.testNumberType(ss.toCharArray(), 0, ss.length());
                switch (t) {
                    case 1: 
                    case 2: {
                        l = Long.parseLong(ss);
                        break block0;
                    }
                    case 3: {
                        l = (long)Double.parseDouble(ss);
                        break block0;
                    }
                    case 0: {
                        return null;
                    }
                }
                throw new NumberFormatException("For input string: \"" + c.stringVal + "\"");
            }
            case 'b': {
                l = c.boolVal ? 1L : 0L;
                break;
            }
            default: {
                return null;
            }
        }
        return l;
    }

    public String getString(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getString(c);
    }

    public String getString(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getString(c);
    }

    public String getString(Cell c) {
        String s;
        switch (c.t) {
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                s = c.stringVal;
                break;
            }
            case '\u0000': 
            case 'e': 
            case 'k': {
                s = null;
                break;
            }
            case 'l': {
                s = String.valueOf(c.longVal);
                break;
            }
            case 'n': {
                s = String.valueOf(c.intVal);
                break;
            }
            case 'm': {
                s = c.decimal.toString();
                break;
            }
            case 'd': {
                s = String.valueOf(c.doubleVal);
                break;
            }
            case 'b': {
                s = c.boolVal ? "true" : "false";
                break;
            }
            default: {
                s = c.stringVal;
            }
        }
        return s;
    }

    public Float getFloat(int columnIndex) {
        Double d = this.getDouble(columnIndex);
        return d != null ? Float.valueOf(d.toString()) : null;
    }

    public Float getFloat(String columnName) {
        Double d = this.getDouble(columnName);
        return d != null ? Float.valueOf(d.toString()) : null;
    }

    public Float getFloat(Cell c) {
        Double d = this.getDouble(c);
        return d != null ? Float.valueOf(d.toString()) : null;
    }

    public Double getDouble(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getDouble(c);
    }

    public Double getDouble(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getDouble(c);
    }

    public Double getDouble(Cell c) {
        double d;
        switch (c.t) {
            case 'm': {
                d = c.decimal.doubleValue();
                break;
            }
            case 'd': {
                d = c.doubleVal;
                break;
            }
            case 'n': {
                d = c.intVal;
                break;
            }
            case 'l': {
                d = c.longVal;
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                if (StringUtil.isNotBlank(c.stringVal)) {
                    d = Double.parseDouble(c.stringVal.trim());
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        return d;
    }

    public BigDecimal getDecimal(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getDecimal(c);
    }

    public BigDecimal getDecimal(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getDecimal(c);
    }

    public BigDecimal getDecimal(Cell c) {
        BigDecimal bd;
        switch (c.t) {
            case 'm': {
                bd = c.decimal;
                break;
            }
            case 'd': {
                bd = BigDecimal.valueOf(c.doubleVal);
                break;
            }
            case 'n': {
                bd = BigDecimal.valueOf(c.intVal);
                break;
            }
            case 'l': {
                bd = BigDecimal.valueOf(c.longVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                bd = StringUtil.isNotBlank(c.stringVal) ? new BigDecimal(c.stringVal.trim()) : null;
                break;
            }
            default: {
                bd = null;
            }
        }
        return bd;
    }

    public Date getDate(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getDate(c);
    }

    public Date getDate(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getDate(c);
    }

    public Date getDate(Cell c) {
        Date date;
        switch (c.t) {
            case 'n': {
                date = DateUtil.toDate(c.intVal);
                break;
            }
            case 'm': {
                date = DateUtil.toDate(c.decimal.doubleValue());
                break;
            }
            case 'd': {
                date = DateUtil.toDate(c.doubleVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                date = StringUtil.isNotBlank(c.stringVal) ? DateUtil.toDate(c.stringVal.trim()) : null;
                break;
            }
            default: {
                date = null;
            }
        }
        return date;
    }

    public Timestamp getTimestamp(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getTimestamp(c);
    }

    public Timestamp getTimestamp(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getTimestamp(c);
    }

    public Timestamp getTimestamp(Cell c) {
        Timestamp ts;
        switch (c.t) {
            case 'n': {
                ts = DateUtil.toTimestamp(c.intVal);
                break;
            }
            case 'm': {
                ts = DateUtil.toTimestamp(c.decimal.doubleValue());
                break;
            }
            case 'd': {
                ts = DateUtil.toTimestamp(c.doubleVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                ts = StringUtil.isNotBlank(c.stringVal) ? DateUtil.toTimestamp(c.stringVal.trim()) : null;
                break;
            }
            default: {
                ts = null;
            }
        }
        return ts;
    }

    public Time getTime(int columnIndex) {
        return this.getTime(this.getCell(columnIndex));
    }

    public Time getTime(String columnName) {
        return this.getTime(this.getCell(columnName));
    }

    public Time getTime(Cell c) {
        Time t;
        switch (c.t) {
            case 'm': {
                t = DateUtil.toTime(c.decimal.doubleValue());
                break;
            }
            case 'd': {
                t = DateUtil.toTime(c.doubleVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                t = StringUtil.isNotBlank(c.stringVal) ? DateUtil.toTime(c.stringVal.trim()) : null;
                break;
            }
            default: {
                t = null;
            }
        }
        return t;
    }

    public LocalDateTime getLocalDateTime(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getLocalDateTime(c);
    }

    public LocalDateTime getLocalDateTime(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getLocalDateTime(c);
    }

    public LocalDateTime getLocalDateTime(Cell c) {
        LocalDateTime ldt;
        switch (c.t) {
            case 'n': {
                ldt = DateUtil.toLocalDateTime(c.intVal);
                break;
            }
            case 'm': {
                ldt = DateUtil.toLocalDateTime(c.decimal.doubleValue());
                break;
            }
            case 'd': {
                ldt = DateUtil.toLocalDateTime(c.doubleVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                ldt = StringUtil.isNotBlank(c.stringVal) ? DateUtil.toTimestamp(c.stringVal.trim()).toLocalDateTime() : null;
                break;
            }
            default: {
                ldt = null;
            }
        }
        return ldt;
    }

    public LocalDate getLocalDate(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getLocalDate(c);
    }

    public LocalDate getLocalDate(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getLocalDate(c);
    }

    public LocalDate getLocalDate(Cell c) {
        LocalDate ld;
        switch (c.t) {
            case 'n': {
                ld = DateUtil.toLocalDate(c.intVal);
                break;
            }
            case 'm': {
                ld = DateUtil.toLocalDate(c.decimal.intValue());
                break;
            }
            case 'd': {
                ld = DateUtil.toLocalDate((int)c.doubleVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                ld = StringUtil.isNotBlank(c.stringVal) ? DateUtil.toTimestamp(c.stringVal.trim()).toLocalDateTime().toLocalDate() : null;
                break;
            }
            default: {
                ld = null;
            }
        }
        return ld;
    }

    public LocalTime getLocalTime(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getLocalTime(c);
    }

    public LocalTime getLocalTime(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getLocalTime(c);
    }

    public LocalTime getLocalTime(Cell c) {
        LocalTime lt;
        switch (c.t) {
            case 'n': {
                lt = DateUtil.toLocalTime(c.intVal);
                break;
            }
            case 'm': {
                lt = DateUtil.toLocalTime(c.decimal.doubleValue());
                break;
            }
            case 'd': {
                lt = DateUtil.toLocalTime(c.doubleVal);
                break;
            }
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                if (StringUtil.isNotBlank(c.stringVal)) {
                    c.stringVal = c.stringVal.trim();
                    if (c.stringVal.length() == 8 && c.stringVal.charAt(2) == ':' && c.stringVal.charAt(5) == ':') {
                        lt = DateUtil.toLocalTime(c.stringVal);
                        break;
                    }
                    lt = DateUtil.toTimestamp(c.stringVal).toLocalDateTime().toLocalTime();
                    break;
                }
                lt = null;
                break;
            }
            default: {
                lt = null;
            }
        }
        return lt;
    }

    public String getFormula(int columnIndex) {
        return this.getCell((int)columnIndex).formula;
    }

    public String getFormula(String columnName) {
        return this.getCell((String)columnName).formula;
    }

    public String getFormula(Cell cell) {
        return cell.formula;
    }

    public boolean hasFormula(int columnIndex) {
        return this.getCell((int)columnIndex).f;
    }

    public boolean hasFormula(String columnName) {
        return this.getCell((String)columnName).f;
    }

    public boolean hasFormula(Cell cell) {
        return cell.f;
    }

    public CellType getCellType(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getCellType(c);
    }

    public CellType getCellType(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getCellType(c);
    }

    public CellType getCellType(Cell c) {
        CellType type;
        switch (c.t) {
            case 'r': 
            case 's': {
                type = CellType.STRING;
                break;
            }
            case 'c': 
            case 'n': {
                type = !this.styles.fastTestDateFmt(c.xf) ? CellType.INTEGER : CellType.DATE;
                break;
            }
            case 'l': {
                type = CellType.LONG;
                break;
            }
            case 'm': {
                type = !this.styles.fastTestDateFmt(c.xf) ? CellType.DECIMAL : CellType.DATE;
                break;
            }
            case 'd': {
                type = !this.styles.fastTestDateFmt(c.xf) ? CellType.DOUBLE : CellType.DATE;
                break;
            }
            case 'a': 
            case 'i': 
            case 't': {
                type = CellType.DATE;
                break;
            }
            case 'b': {
                type = CellType.BOOLEAN;
                break;
            }
            case 'e': 
            case 'k': {
                type = CellType.BLANK;
                break;
            }
            case '\u0000': {
                type = CellType.UNALLOCATED;
                break;
            }
            default: {
                type = CellType.STRING;
            }
        }
        return type;
    }

    public int getCellStyle(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.getCellStyle(c);
    }

    public int getCellStyle(String columnName) {
        Cell c = this.getCell(columnName);
        return this.getCellStyle(c);
    }

    public int getCellStyle(Cell c) {
        return this.styles.getStyleByIndex(c.xf);
    }

    public boolean isBlank(int columnIndex) {
        Cell c = this.getCell(columnIndex);
        return this.isBlank(c);
    }

    public boolean isBlank(String columnName) {
        Cell c = this.getCell(columnName);
        return this.isBlank(c);
    }

    public boolean isBlank(Cell c) {
        boolean blank;
        switch (c.t) {
            case 's': {
                if (c.stringVal == null) {
                    c.setString(this.sst.get(c.intVal));
                }
            }
            case 'r': {
                blank = StringUtil.isBlank(c.stringVal);
                break;
            }
            case '\u0000': 
            case 'e': 
            case 'k': {
                blank = true;
                break;
            }
            default: {
                blank = false;
            }
        }
        return blank;
    }

    public <T> T get() {
        if (this.hr != null && this.hr.getClazz() != null) {
            Object t;
            try {
                t = this.hr.getClazz().newInstance();
                this.hr.put(this, t);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new UncheckedTypeException(this.hr.getClazz() + " new instance error.", e);
            }
            return (T)t;
        }
        throw new ExcelReadException("It can only be used after binding with method `Sheet#bind`");
    }

    public <T> T geet() {
        if (this.hr != null && this.hr.getClazz() != null) {
            Object t = this.hr.getT();
            try {
                this.hr.put(this, t);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UncheckedTypeException("call set method error.", e);
            }
            return t;
        }
        throw new ExcelReadException("It can only be used after binding with method `Sheet#bind`");
    }

    public <T> T to(Class<T> clazz) {
        T t;
        if (this.hr == null) {
            this.hr = this.asHeader();
            return null;
        }
        if (!this.hr.is(clazz)) {
            this.hr.setClass(clazz);
        }
        try {
            t = clazz.newInstance();
            this.hr.put(this, t);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UncheckedTypeException(clazz + " new instance error.", e);
        }
        return t;
    }

    public <T> T too(Class<T> clazz) {
        if (this.hr == null) {
            this.hr = this.asHeader();
            return null;
        }
        if (!this.hr.is(clazz)) {
            try {
                this.hr.setClassOnce(clazz);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UncheckedTypeException(clazz + " new instance error.", e);
            }
        }
        Object t = this.hr.getT();
        try {
            this.hr.put(this, t);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new UncheckedTypeException("call set method error.", e);
        }
        return t;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringJoiner joiner = new StringJoiner(" | ");
        block10: for (int i = this.fc; i < this.lc; ++i) {
            Cell c = this.cells[i];
            switch (c.t) {
                case 's': {
                    if (c.stringVal == null) {
                        c.setString(this.sst.get(c.intVal));
                    }
                }
                case 'r': {
                    joiner.add(c.stringVal);
                    continue block10;
                }
                case 'n': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        joiner.add(String.valueOf(c.intVal));
                        continue block10;
                    }
                    joiner.add(DateUtil.toLocalDate(c.intVal).toString());
                    continue block10;
                }
                case 'l': {
                    joiner.add(String.valueOf(c.longVal));
                    continue block10;
                }
                case 'm': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        joiner.add(c.decimal.toString());
                        continue block10;
                    }
                    if (c.decimal.compareTo(BigDecimal.ONE) > 0) {
                        joiner.add(DateUtil.toTimestamp(c.decimal.doubleValue()).toString());
                        continue block10;
                    }
                    joiner.add(DateUtil.toLocalTime(c.decimal.doubleValue()).toString());
                    continue block10;
                }
                case 'd': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        joiner.add(String.valueOf(c.doubleVal));
                        continue block10;
                    }
                    if (c.doubleVal > 1.0) {
                        joiner.add(DateUtil.toTimestamp(c.doubleVal).toString());
                        continue block10;
                    }
                    joiner.add(DateUtil.toLocalTime(c.doubleVal).toString());
                    continue block10;
                }
                case 'e': 
                case 'k': {
                    joiner.add("");
                    continue block10;
                }
                case 'b': {
                    joiner.add(String.valueOf(c.boolVal));
                    continue block10;
                }
                default: {
                    joiner.add(null);
                }
            }
        }
        return joiner.toString();
    }

    public Map<String, Object> toMap() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean hasHeader = this.hr != null;
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(hasHeader ? Math.max(16, this.hr.lc - this.hr.fc) : 16);
        String[] names = hasHeader ? this.hr.names : null;
        int from = hasHeader ? this.hr.fc : this.fc;
        int to = hasHeader ? this.hr.lc : this.lc;
        block10: for (int i = from; i < to; ++i) {
            String key;
            Cell c = this.cells[i];
            String string = key = hasHeader ? names[i] : Integer.toString(i);
            if (key == null) continue;
            switch (c.t) {
                case 's': {
                    if (c.stringVal == null) {
                        c.setString(this.sst.get(c.intVal));
                    }
                }
                case 'r': {
                    data.put(key, c.stringVal);
                    continue block10;
                }
                case 'n': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        data.put(key, c.intVal);
                        continue block10;
                    }
                    data.put(key, DateUtil.toTimestamp(c.intVal));
                    continue block10;
                }
                case 'l': {
                    data.put(key, c.longVal);
                    continue block10;
                }
                case 'm': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        data.put(key, c.decimal);
                        continue block10;
                    }
                    if (c.decimal.compareTo(BigDecimal.ONE) > 0) {
                        data.put(key, DateUtil.toTimestamp(c.decimal.doubleValue()));
                        continue block10;
                    }
                    data.put(key, DateUtil.toTime(c.decimal.doubleValue()));
                    continue block10;
                }
                case 'd': {
                    if (!this.styles.fastTestDateFmt(c.xf)) {
                        data.put(key, c.doubleVal);
                        continue block10;
                    }
                    if (c.doubleVal > 1.0) {
                        data.put(key, DateUtil.toTimestamp(c.doubleVal));
                        continue block10;
                    }
                    data.put(key, DateUtil.toTime(c.doubleVal));
                    continue block10;
                }
                case 'e': 
                case 'k': {
                    data.put(key, "");
                    continue block10;
                }
                case 'b': {
                    data.put(key, c.boolVal);
                    continue block10;
                }
                default: {
                    data.put(key, null);
                }
            }
        }
        return data;
    }

    void addRef(int i, String ref) {
        if (StringUtil.isEmpty(ref) || ref.indexOf(58) < 0) {
            return;
        }
        if (this.sharedCalc == null) {
            this.sharedCalc = new PreCalc[Math.max(10, i + 1)];
        } else if (i >= this.sharedCalc.length) {
            this.sharedCalc = Arrays.copyOf(this.sharedCalc, i + 10);
        }
        Dimension dim = Dimension.of(ref);
        long l = 0L;
        l |= (long)(dim.firstRow & 0xFFFFF) << 42;
        l |= (long)(dim.firstColumn & 0x3FFF) << 28;
        if (dim.firstColumn == dim.lastColumn) {
            l |= (long)((dim.lastRow - dim.firstRow & 0xFFFFF) << 8);
            l |= 2L;
        } else if (dim.firstRow == dim.lastRow) {
            l |= (long)((dim.lastColumn - dim.firstColumn & 0x3FFF) << 14);
            l |= 1L;
        }
        this.sharedCalc[i] = new PreCalc(l);
    }

    void setCalc(int i, String calc) {
        if (this.sharedCalc == null || this.sharedCalc.length <= i || this.sharedCalc[i] == null || StringUtil.isEmpty(calc)) {
            return;
        }
        this.sharedCalc[i].setCalc(calc.toCharArray());
    }

    String getCalc(int i, long coordinate) {
        if (this.sharedCalc == null || this.sharedCalc.length <= i || this.sharedCalc[i] == null) {
            return "";
        }
        return this.sharedCalc[i].get(coordinate);
    }

    public Cell[] copyCells() {
        return this.copyCells(this.cells.length);
    }

    public Cell[] copyCells(int newLength) {
        Cell[] newCells = new Cell[newLength];
        int oldRow = this.cells.length;
        for (int k = 0; k < newLength; ++k) {
            newCells[k] = new Cell((short)(k + 1));
            if (k >= oldRow || this.cells[k] == null) continue;
            newCells[k].from(this.cells[k]);
        }
        return newCells;
    }

    public Row setCells(Cell[] cells) {
        this.cells = cells;
        this.fc = 0;
        this.lc = cells.length;
        return this;
    }

    public Row setCells(Cell[] cells, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > cells.length) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this.cells = cells;
        this.fc = fromIndex;
        this.lc = toIndex;
        return this;
    }

    public static int toCellIndex(char[] cb, int a, int b) {
        int n = 0;
        while (a <= b) {
            if (cb[a] <= 'Z' && cb[a] >= 'A') {
                n = n * 26 + cb[a] - 64;
            } else {
                if (cb[a] > 'z' || cb[a] < 'a') break;
                n = n * 26 + cb[a] - 12289;
            }
            ++a;
        }
        return n;
    }

    public static int testNumberType(char[] cb, int a, int b) {
        if (a == b) {
            return 0;
        }
        if (b - a == 1) {
            return cb[a] >= '0' && cb[a] <= '9' ? 1 : -1;
        }
        int dotIdx = -1;
        int eIdx = -1;
        int i = a;
        if (cb[i] == '-') {
            ++i;
        }
        int j = i;
        while (i < b) {
            char c;
            if ((c = cb[i++]) >= '0' && c <= '9') continue;
            if (c == '.') {
                if (dotIdx >= 0 || eIdx >= 0) {
                    return -1;
                }
                dotIdx = i - 1;
                continue;
            }
            if (c == 'e' || c == 'E') {
                if (eIdx > 0 || i == 1) {
                    return -1;
                }
                eIdx = i - 1;
                if (i + 1 > b) {
                    return -1;
                }
                if (!((c = cb[i++]) == '-' || c == '+' ? i + 1 > b : c < '0' || c > '9')) continue;
                return -1;
            }
            return -1;
        }
        if (b - j == 1 && dotIdx >= 0) {
            return -1;
        }
        return dotIdx >= 0 || eIdx > 1 ? 3 : (b - j >= 10 ? 2 : 1);
    }
}

