/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ttzero.excel.reader.CalcSheet;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.FullSheet;
import org.ttzero.excel.reader.MergeSheet;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.util.CSVUtil;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.FileUtil;

public interface Sheet
extends Closeable {
    public String getName();

    public int getIndex();

    public int getId();

    default public int getSize() {
        Dimension d = this.getDimension();
        return d != null ? d.lastRow - d.firstRow + 1 : -1;
    }

    public Dimension getDimension();

    public boolean isHidden();

    default public boolean isShow() {
        return !this.isHidden();
    }

    default public Sheet header(int fromRowNum) {
        return this.header(fromRowNum, fromRowNum);
    }

    public Sheet header(int var1, int var2);

    public Row getHeader();

    public Sheet bind(Class<?> var1);

    default public Sheet bind(Class<?> clazz, int fromRowNum) {
        return this.bind(clazz, this.header(fromRowNum).getHeader());
    }

    default public Sheet bind(Class<?> clazz, int fromRowNum, int toRowNum) {
        return this.bind(clazz, this.header(fromRowNum, toRowNum).getHeader());
    }

    public Sheet bind(Class<?> var1, Row var2);

    public Sheet load() throws IOException;

    public Iterator<Row> iterator();

    public Iterator<Row> dataIterator();

    public List<Drawings.Picture> listPictures();

    default public Sheet reset() {
        throw new UnsupportedOperationException();
    }

    default public Stream<Row> rows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 272), false);
    }

    default public Stream<Row> dataRows() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.dataIterator(), 272), false);
    }

    default public void saveAsCSV(Path path) throws IOException {
        this.saveAsCSV(path, StandardCharsets.UTF_8);
    }

    default public void saveAsCSV(Path path, Charset charset) throws IOException {
        if (!FileUtil.exists(path)) {
            FileUtil.mkdir(path);
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve(this.getName() + ".csv");
        }
        this.saveAsCSV(Files.newOutputStream(path, new OpenOption[0]), charset);
    }

    default public void saveAsCSV(OutputStream os) throws IOException {
        this.saveAsCSV(os, StandardCharsets.UTF_8);
    }

    default public void saveAsCSV(OutputStream os, Charset charset) throws IOException {
        this.saveAsCSV(new BufferedWriter(new OutputStreamWriter(os, charset)));
    }

    default public void saveAsCSV(BufferedWriter bw) throws IOException {
        try (CSVUtil.Writer writer = CSVUtil.newWriter(bw);){
            Iterator<Row> iter = this.iterator();
            while (iter.hasNext()) {
                Row row = iter.next();
                if (row.isEmpty()) {
                    writer.newLine();
                    continue;
                }
                block19: for (int i = 0; i < row.lc; ++i) {
                    Cell c = row.cells[i];
                    switch (c.t) {
                        case 's': {
                            if (c.stringVal == null) {
                                c.setString(row.sst.get(c.intVal));
                            }
                        }
                        case 'f': 
                        case 'r': {
                            writer.write(c.stringVal);
                            continue block19;
                        }
                        case 'n': {
                            if (!row.styles.fastTestDateFmt(c.xf)) {
                                writer.write(c.intVal);
                                continue block19;
                            }
                            writer.write(DateUtil.toLocalDate(c.intVal).toString());
                            continue block19;
                        }
                        case 'l': {
                            writer.write(c.longVal);
                            continue block19;
                        }
                        case 'm': {
                            if (!row.styles.fastTestDateFmt(c.xf)) {
                                writer.write(c.decimal.toString());
                                continue block19;
                            }
                            writer.write(DateUtil.toTimestamp(c.decimal.doubleValue()).toString());
                            continue block19;
                        }
                        case 'd': {
                            if (!row.styles.fastTestDateFmt(c.xf)) {
                                writer.write(c.doubleVal);
                                continue block19;
                            }
                            writer.write(DateUtil.toTimestamp(c.doubleVal).toString());
                            continue block19;
                        }
                        case 'b': {
                            writer.write(c.boolVal);
                            continue block19;
                        }
                        default: {
                            writer.writeEmpty();
                        }
                    }
                }
                writer.newLine();
            }
        }
    }

    default public Sheet forceImport() {
        return this.addHeaderColumnReadOption(1);
    }

    default public Sheet headerColumnIgnoreCase() {
        return this.addHeaderColumnReadOption(2);
    }

    default public Sheet headerColumnToCamelCase() {
        return this.addHeaderColumnReadOption(4);
    }

    default public Sheet addHeaderColumnReadOption(int option) {
        return this.setHeaderColumnReadOption(this.getHeaderColumnReadOption() | option);
    }

    public Sheet setHeaderColumnReadOption(int var1);

    public int getHeaderColumnReadOption();

    public Sheet asSheet();

    public CalcSheet asCalcSheet();

    public MergeSheet asMergeSheet();

    public FullSheet asFullSheet();
}

