/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class ExtBufferedWriter
extends BufferedWriter {
    private static final int defaultCharBufferSize = 8192;
    private final char[][] CACHE_CHAR_ARRAY = new char[25][];
    static final char[] MIN_INTEGER_CHARS = new char[]{'-', '2', '1', '4', '7', '4', '8', '3', '6', '4', '8'};
    static final char[] MIN_LONG_CHARS = "-9223372036854775808".toCharArray();
    private static final char[][] ESCAPE_CHARS = new char[63][];
    public static char MALFORMED_CHAR = (char)65533;
    private static final int[] sizeTable;

    public ExtBufferedWriter(Writer out) {
        this(out, 8192);
    }

    public ExtBufferedWriter(Writer out, int sz) {
        super(out, sz);
        for (int i = 0; i < this.CACHE_CHAR_ARRAY.length; ++i) {
            this.CACHE_CHAR_ARRAY[i] = new char[i + 1];
        }
    }

    public void writeInt(int n) throws IOException {
        char[] temp = this.toChars(n);
        this.write(temp);
    }

    public void write(long l) throws IOException {
        char[] temp = this.toChars(l);
        this.write(temp);
    }

    public void write(float f) throws IOException {
        this.write(Float.toString(f));
    }

    public void escapeWrite(char c) throws IOException {
        if (c > '>') {
            this.write(Character.isSurrogate(c) ? MALFORMED_CHAR : c);
        } else if (c >= ' ') {
            char[] ec = ESCAPE_CHARS[c];
            if (ec != null) {
                this.write(ec);
            } else {
                this.write(c);
            }
        } else {
            this.write(c == '\t' || c == '\n' || c == '\r' ? c : MALFORMED_CHAR);
        }
    }

    public void escapeWrite(String text) throws IOException {
        int i;
        char[] block = text.toCharArray();
        int last = 0;
        int size = text.length();
        for (i = 0; i < size; ++i) {
            char c = block[i];
            if (c > '>') continue;
            if (c < ' ') {
                if (i > last) {
                    this.writeUTF8(block, last, i - last);
                }
                this.write(c == '\t' || c == '\n' || c == '\r' ? c : MALFORMED_CHAR);
                last = i + 1;
                continue;
            }
            char[] ec = ESCAPE_CHARS[c];
            if (ec == null) continue;
            if (i > last) {
                this.writeUTF8(block, last, i - last);
            }
            this.write(ec);
            last = i + 1;
        }
        if (last < size) {
            this.writeUTF8(block, last, i - last);
        }
    }

    public void write(double d) throws IOException {
        this.write(Double.toString(d));
    }

    public void writeUTF8(char[] cb, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        int end = off + len;
        int i = ExtBufferedWriter.lookupMalformedUTF8Char(cb, off, end);
        if (i >= 0) {
            cb[i++] = MALFORMED_CHAR;
            while ((i = ExtBufferedWriter.lookupMalformedUTF8Char(cb, i, end)) >= 0) {
                cb[i++] = MALFORMED_CHAR;
            }
        }
        super.write(cb, off, len);
    }

    public char[] toChars(int i) {
        if (i == Integer.MIN_VALUE) {
            return MIN_INTEGER_CHARS;
        }
        int size = ExtBufferedWriter.stringSize(i);
        ExtBufferedWriter.getChars(i, size, this.CACHE_CHAR_ARRAY[size - 1]);
        return this.CACHE_CHAR_ARRAY[size - 1];
    }

    public static int stringSize(int x) {
        boolean negative;
        boolean bl = negative = x < 0;
        if (negative) {
            x = ~x + 1;
        }
        int i = 0;
        while (true) {
            if (x <= sizeTable[i]) break;
            ++i;
        }
        int l = i + 1;
        return negative ? l + 1 : l;
    }

    static void getChars(int i, int index, char[] buf) {
        boolean negative;
        if (i == 0) {
            buf[index - 1] = 48;
            return;
        }
        boolean bl = negative = i < 0;
        if (negative) {
            i = -i;
        }
        while (i > 0) {
            buf[--index] = (char)(i % 10 + 48);
            i /= 10;
        }
        if (negative) {
            buf[--index] = 45;
        }
    }

    public char[] toChars(long i) {
        if (i == Long.MIN_VALUE) {
            return MIN_LONG_CHARS;
        }
        int size = ExtBufferedWriter.stringSize(i);
        ExtBufferedWriter.getChars(i, size, this.CACHE_CHAR_ARRAY[size - 1]);
        return this.CACHE_CHAR_ARRAY[size - 1];
    }

    public static int stringSize(long x) {
        int i;
        boolean negative;
        boolean bl = negative = x < 0L;
        if (negative) {
            x = (x ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        }
        int l = 0;
        long p = 10L;
        for (i = 1; i < 19; ++i) {
            if (x < p) {
                l = i;
                break;
            }
            p = 10L * p;
        }
        if (i >= 19) {
            l = 19;
        }
        return negative ? l + 1 : l;
    }

    static void getChars(long i, int index, char[] buf) {
        boolean negative;
        if (i == 0L) {
            buf[index - 1] = 48;
            return;
        }
        boolean bl = negative = i < 0L;
        if (negative) {
            i = -i;
        }
        while (i > 0L) {
            buf[--index] = (char)(i % 10L + 48L);
            i /= 10L;
        }
        if (negative) {
            buf[--index] = 45;
        }
    }

    static int lookupMalformedUTF8Char(char[] cb, int from, int to) {
        while (from < to) {
            char c = cb[from];
            if (Character.isSurrogate(c)) {
                if (Character.isHighSurrogate(c)) {
                    if (to - from < 2 || !Character.isLowSurrogate(cb[from + 1])) {
                        return from;
                    }
                    ++from;
                } else if (Character.isLowSurrogate(c)) {
                    return from;
                }
            }
            ++from;
        }
        return -1;
    }

    static {
        ExtBufferedWriter.ESCAPE_CHARS[60] = "&lt;".toCharArray();
        ExtBufferedWriter.ESCAPE_CHARS[62] = "&gt;".toCharArray();
        ExtBufferedWriter.ESCAPE_CHARS[38] = "&amp;".toCharArray();
        ExtBufferedWriter.ESCAPE_CHARS[34] = "&quot;".toCharArray();
        sizeTable = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    }
}

