/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.ttzero.excel.util.FileUtil;

public class ZipUtil {
    private static final String suffix = ".zip";
    public static final int MIDDLE_COMPRESSION = 5;

    private ZipUtil() {
    }

    public static Path zip(Path destPath, Path ... srcPath) throws IOException {
        return ZipUtil.zip(destPath, true, srcPath);
    }

    public static Path zipExcludeRoot(Path destPath, Path ... srcPath) throws IOException {
        if (!destPath.toString().endsWith(suffix)) {
            destPath = Paths.get(destPath.toString() + suffix, new String[0]);
        }
        if (!FileUtil.exists(destPath.getParent())) {
            FileUtil.mkdir(destPath.getParent());
        }
        return ZipUtil.zip(destPath, false, srcPath);
    }

    private static Path zip(Path destPath, boolean compressRoot, Path ... srcPath) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(new CheckedOutputStream(Files.newOutputStream(destPath, StandardOpenOption.CREATE), new Adler32()));
        zos.setLevel(5);
        ArrayList<Path> paths = new ArrayList<Path>();
        int i = 0;
        int index = 0;
        int[] array = new int[srcPath.length];
        for (Path src : srcPath) {
            if (Files.isDirectory(src, new LinkOption[0])) {
                paths.addAll(ZipUtil.subPath(src));
                while (i < paths.size()) {
                    if (Files.isDirectory((Path)paths.get(i), new LinkOption[0])) {
                        paths.addAll(ZipUtil.subPath((Path)paths.get(i)));
                    }
                    ++i;
                }
            } else {
                paths.add(src);
            }
            array[index++] = ++i;
        }
        index = 0;
        Path basePath = compressRoot ? srcPath[index].getParent() : srcPath[index];
        int len = basePath.toString().length();
        for (int j = 0; j < i; ++j) {
            if (Files.isDirectory((Path)paths.get(j), new LinkOption[0])) continue;
            if (j < array[index]) {
                String name = ((Path)paths.get(j)).equals(srcPath[index]) ? (((Path)paths.get(j)).getNameCount() > 1 ? ((Path)paths.get(j)).toString().substring(((Path)paths.get(j)).getParent().toString().length() + 1) : ((Path)paths.get(j)).toString()) : ((Path)paths.get(j)).toString().substring(len + 1);
                zos.putNextEntry(new ZipEntry(name));
                Files.copy((Path)paths.get(j), zos);
                zos.closeEntry();
                continue;
            }
            basePath = compressRoot ? srcPath[++index].getParent() : srcPath[++index];
            len = basePath.toString().length();
            --j;
        }
        zos.close();
        return destPath;
    }

    private static List<Path> subPath(Path path) throws IOException {
        try (Stream<Path> fileStream = Files.list(path);){
            List<Path> list = fileStream.collect(Collectors.toList());
            return list;
        }
    }

    public static Path unzip(InputStream stream, Path destPath) throws IOException {
        if (!Files.isDirectory(destPath, new LinkOption[0])) {
            FileUtil.mkdir(destPath);
        }
        ZipInputStream zis = new ZipInputStream(stream);
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            Path sub = destPath.resolve(entry.getName());
            if (!FileUtil.exists(sub.getParent())) {
                FileUtil.mkdir(sub.getParent());
            }
            if (entry.isDirectory()) {
                FileUtil.mkdir(sub);
            } else {
                FileUtil.cp((InputStream)zis, sub);
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
        zis.close();
        return destPath;
    }

    public static Path xlsx(Path destPath, Path ... srcPath) throws IOException {
        if (!FileUtil.exists(destPath.getParent())) {
            FileUtil.mkdir(destPath.getParent());
        }
        return ZipUtil.zip(destPath, false, srcPath);
    }
}

