/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.SharedStringTable;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.hash.StringBloomFilter;
import org.ttzero.excel.manager.Const;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.reader.Cache;
import org.ttzero.excel.reader.FixSizeLRUCache;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, value="sst", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main"})
public class SharedStrings
implements Storable,
Closeable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private int count;
    private StringBloomFilter filter;
    private int[] ascii;
    private Path temp;
    private ExtBufferedWriter writer;
    private Cache<String, Integer> hot;
    private SharedStringTable sst;
    private int j;
    private int total_char_cache;
    private int total_sst_find;
    private int total_hot;
    private int filter_constructor = 1;
    private final long expectedInsertions = 131072L;

    public SharedStrings init() {
        if (this.sst == null) {
            this.hot = FixSizeLRUCache.create();
            this.ascii = new int[128];
            Arrays.fill(this.ascii, -1);
            this.filter = StringBloomFilter.create(131072L, 3.0E-4);
            try {
                this.temp = Files.createTempFile("~", "sst", new FileAttribute[0]);
                this.writer = new ExtBufferedWriter(Files.newBufferedWriter(this.temp, StandardCharsets.UTF_8, new OpenOption[0]));
                this.sst = new SharedStringTable();
            }
            catch (IOException e) {
                throw new ExcelWriteException(e);
            }
        }
        return this;
    }

    public int get(char c) throws IOException {
        if (c < '\u0080') {
            int n = this.ascii[c];
            if (n == -1) {
                this.ascii[c] = n = this.add(c);
            }
            ++this.count;
            ++this.total_char_cache;
            return n;
        }
        char[] cs = new char[]{c};
        return this.get(new String(cs));
    }

    public int get(String key) throws IOException {
        ++this.count;
        if (!this.filter.mightContain(key)) {
            if ((long)this.j >= 131072L) {
                this.resetBloomFilter();
            }
            this.filter.put(key);
            ++this.j;
            return this.add(key);
        }
        Integer n = this.hot.get(key);
        if (n == null) {
            if ((long)this.sst.size() <= 131072L) {
                n = this.sst.find(key);
                ++this.total_sst_find;
                if (n < 0) {
                    n = this.add(key);
                }
            } else {
                n = this.add(key);
            }
            this.hot.put(key, n);
        } else {
            ++this.total_hot;
        }
        return n;
    }

    private int add(String key) throws IOException {
        int n = this.sst.push(key);
        if (n >= 0) {
            this.writer.write("<si><t>");
            this.writer.escapeWrite(key);
            this.writer.write("</t></si>");
        }
        return n;
    }

    private int add(char c) throws IOException {
        this.writer.write("<si><t>");
        this.writer.escapeWrite(c);
        this.writer.write("</t></si>");
        return this.sst.push(c);
    }

    @Override
    public void writeTo(Path root) throws IOException {
        FileUtil.close(this.writer);
        if (!FileUtil.exists(root)) {
            FileUtil.mkdir(root);
        }
        int uniqueCount = this.sst != null ? this.sst.size() : 0;
        StringBuilder buf = new StringBuilder();
        TopNS topNS = this.getClass().getAnnotation(TopNS.class);
        if (topNS != null) {
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            buf.append(Const.lineSeparator);
            buf.append("<").append(topNS.value()).append(" xmlns=\"").append(topNS.uri()[0]).append("\"").append(" count=\"").append(this.count).append("\"").append(" uniqueCount=\"").append(uniqueCount).append("\">").append(Const.lineSeparator);
        } else {
            buf.append("<sst xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" count=\"").append(this.count).append("\" uniqueCount=\"").append(uniqueCount).append("\">").append(Const.lineSeparator);
        }
        Path dist = root.resolve(StringUtil.lowFirstKey(this.getClass().getSimpleName() + ".xml"));
        try (FileOutputStream fos = new FileOutputStream(dist.toFile());
             FileChannel channel = fos.getChannel();){
            ByteBuffer buffer = ByteBuffer.allocate(512);
            buffer.put(buf.toString().getBytes(StandardCharsets.UTF_8));
            buffer.flip();
            channel.write(buffer);
            if (uniqueCount > 0) {
                this.transfer(channel);
            }
            buffer.clear();
            buf.delete(0, buf.length());
            if (topNS != null) {
                buf.append("</").append(topNS.value()).append(">");
            } else {
                buf.append("</sst>");
            }
            buffer.put(buf.toString().getBytes(StandardCharsets.UTF_8));
            buffer.flip();
            channel.write(buffer);
        }
    }

    private void transfer(FileChannel channel) throws IOException {
        try (FileChannel tempChannel = FileChannel.open(this.temp, StandardOpenOption.READ);){
            tempChannel.transferTo(0L, tempChannel.size(), channel);
        }
    }

    private void resetBloomFilter() {
        ++this.filter_constructor;
        this.filter = StringBloomFilter.create(131072L, 3.0E-4);
        for (Cache.Entry entry : this.hot) {
            this.filter.put((String)entry.getKey());
        }
        this.j = this.hot.size();
    }

    @Override
    public void close() throws IOException {
        this.LOGGER.debug("Total: {}, Hot: {}, SST: {}, Char Cache: {}, Filter Constructor: {}", new Object[]{this.count, this.total_hot, this.total_sst_find, this.total_char_cache, this.filter_constructor});
        this.filter = null;
        if (this.hot != null) {
            this.hot.clear();
            this.hot = null;
        }
        if (this.sst != null) {
            this.sst.close();
        }
        if (this.temp != null) {
            FileUtil.rm(this.temp);
        }
    }
}

