/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.style;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.util.StringUtil;

public final class BuiltInNumFmt {
    private static final NumFmt[] buildInNumFmts;

    public static int indexOf(String code) {
        NumFmt v = BuiltInNumFmt.get(code);
        return v != null ? v.id : -1;
    }

    public static NumFmt get(String code) {
        NumFmt fmt = null;
        for (NumFmt nf : buildInNumFmts) {
            if (nf == null || !code.equals(nf.code)) continue;
            fmt = nf;
            break;
        }
        return fmt;
    }

    public static NumFmt get(int id) {
        return id >= 0 && id < buildInNumFmts.length ? buildInNumFmts[id] : null;
    }

    static {
        InputStream is = BuiltInNumFmt.class.getClassLoader().getResourceAsStream("numFmt");
        if (is != null) {
            ArrayList<NumFmt> list = new ArrayList<NumFmt>();
            int maxLen = 0;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String v;
                String lang = Locale.getDefault().toLanguageTag();
                boolean damaged = false;
                while ((v = br.readLine()) != null) {
                    int id;
                    int index;
                    if (StringUtil.isEmpty(v)) continue;
                    if ((v = v.trim()).charAt(0) == '[') {
                        int end = v.indexOf(93);
                        damaged = end == -1 || end == 1 || !lang.equalsIgnoreCase(v.substring(0, end).trim());
                        continue;
                    }
                    if (damaged || (index = v.indexOf(61)) <= 0) continue;
                    String v1 = v.substring(0, index).trim();
                    String v2 = v.substring(index + 1).trim();
                    try {
                        id = Integer.parseInt(v1);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    if (v2.charAt(0) != '\'' || v2.charAt(v2.length() - 1) != '\'') continue;
                    NumFmt fmt = new NumFmt();
                    fmt.id = id;
                    fmt.code = v2.substring(1, v2.length() - 1);
                    list.add(fmt);
                    if (fmt.id <= maxLen) continue;
                    maxLen = fmt.id;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            buildInNumFmts = new NumFmt[maxLen + 1];
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                NumFmt fmt;
                BuiltInNumFmt.buildInNumFmts[fmt.id] = fmt = (NumFmt)iterator.next();
            }
        } else {
            buildInNumFmts = new NumFmt[0];
        }
    }
}

