/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;

public class CSVUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSVUtil.class);
    private static final char QUOTE = '\"';
    private static final char HT = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char COMMA = ',';
    private static final String EMPTY = "";

    private CSVUtil() {
    }

    public static <T> List<T> read(Path path, Class<T> clazz) throws IOException {
        return CSVUtil.read(path, clazz, null);
    }

    public static List<String[]> read(Path path) throws IOException {
        return CSVUtil.read(path, (Charset)null);
    }

    public static List<String[]> read(Path path, char separator) throws IOException {
        return CSVUtil.read(path, separator, null);
    }

    public static <T> List<T> read(Path path, Class<T> clazz, Charset charset) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static List<String[]> read(Path path, Charset charset) throws IOException {
        return CSVUtil.read(path, '\u0000', charset);
    }

    public static List<String[]> read(Path path, char separator, Charset charset) throws IOException {
        O o = CSVUtil.init(path, separator, charset);
        if (o == null) {
            return Collections.emptyList();
        }
        try (RowsIterator iter = new RowsIterator(o, path, o.charset);){
            ArrayList<String[]> result = new ArrayList<String[]>();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
            ArrayList<String[]> arrayList = result;
            return arrayList;
        }
    }

    public static Reader newReader(Path path) {
        return CSVUtil.newReader(path, null);
    }

    public static Reader newReader(Path path, Charset charset) {
        return new Reader(path, charset);
    }

    public static Reader newReader(Path path, char separator) {
        Reader reader = CSVUtil.newReader(path);
        reader.separator = separator;
        return reader;
    }

    public static Reader newReader(Path path, char separator, Charset charset) {
        Reader reader = CSVUtil.newReader(path, charset);
        reader.separator = separator;
        return reader;
    }

    public static void writeTo(List<?> data, Path path) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static Writer newWriter(Path path) throws IOException {
        CSVUtil.testOrCreate(path);
        return new Writer(path);
    }

    public static Writer newWriter(Path path, Charset charset) throws IOException {
        CSVUtil.testOrCreate(path);
        return new Writer(path, charset);
    }

    public static Writer newWriter(Path path, char separator) throws IOException {
        CSVUtil.testOrCreate(path);
        Writer writer = new Writer(path);
        writer.separator = separator;
        return writer;
    }

    public static Writer newWriter(Path path, char separator, Charset charset) throws IOException {
        CSVUtil.testOrCreate(path);
        Writer writer = new Writer(path, charset);
        writer.separator = separator;
        return writer;
    }

    public static Writer newWriter(BufferedWriter writer) {
        return new Writer(writer);
    }

    public static Writer newWriter(OutputStream os) {
        return new Writer(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
    }

    private static void testOrCreate(Path path) throws IOException {
        if (!FileUtil.exists(path)) {
            FileUtil.mkdir(path.getParent());
        }
    }

    private static O init(Path path, char separator, Charset charset) throws IOException {
        Charset bom = CSVUtil.charsetTest(path);
        if (bom == null && charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        if (bom != null) {
            if (charset == null) {
                charset = bom;
            } else if (!charset.equals(bom)) {
                LOGGER.warn("Maybe the charset is " + bom);
            }
        }
        try (BufferedReader reader = Files.newBufferedReader(path, charset);){
            String[] stringArray;
            String s;
            int n = 0;
            String[] lines = new String[10];
            while ((s = reader.readLine()) != null && n < lines.length) {
                if (s.isEmpty()) continue;
                lines[n++] = s;
            }
            if (lines[0] == null || lines[0].isEmpty()) {
                O o = null;
                return o;
            }
            if (n < 10) {
                LOGGER.warn("No enough information to judge the separator.");
            }
            if (separator == '\u0000') {
                String[] stringArray2 = new String[3];
                stringArray2[0] = String.valueOf(',');
                stringArray2[1] = String.valueOf('\t');
                stringArray = stringArray2;
                stringArray2[2] = ";";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = String.valueOf(separator);
            }
            String[] commas = stringArray;
            int[][] columns = new int[commas.length][n];
            for (int i = 0; i < commas.length; ++i) {
                for (int j = 0; j < n; ++j) {
                    columns[i][j] = lines[j].length() - lines[j].replace(commas[i], EMPTY).length();
                }
            }
            int[] nc = new int[commas.length];
            for (int i = 0; i < columns.length; ++i) {
                HashMap<Integer, Integer> c = new HashMap<Integer, Integer>();
                for (int j : columns[i]) {
                    if (j == 0) continue;
                    Integer co = (Integer)c.get(j);
                    c.put(j, co != null ? co + 1 : 1);
                }
                if (c.isEmpty()) continue;
                if (c.size() == 1) {
                    Map.Entry entry = c.entrySet().iterator().next();
                    if ((Integer)entry.getKey() > 65535) {
                        throw new IOException("Too many columns occur. Max columns 65535 but has " + entry.getKey());
                    }
                    nc[i] = ((Integer)entry.getKey() << 4) + (Integer)entry.getValue();
                    continue;
                }
                int mv = 0;
                int mk = 0;
                for (Map.Entry entry : c.entrySet()) {
                    if ((Integer)entry.getValue() <= mv && ((Integer)entry.getValue() != mv || (Integer)entry.getKey() <= mk)) continue;
                    mv = (Integer)entry.getValue();
                    mk = (Integer)entry.getKey();
                    nc[i] = ((Integer)entry.getKey() << 4) + (Integer)entry.getValue();
                }
            }
            O o = new O(0);
            o.line = bom != null ? 1 : 0;
            o.charset = charset;
            n = 0;
            for (int i = 0; i < nc.length; ++i) {
                int size = nc[i] >>> 4;
                if (size++ == 0) continue;
                int count = nc[i] & 0xF;
                if (count > n) {
                    n = count;
                    o.offset = size;
                    o.value = commas[i];
                    continue;
                }
                if (count != n || size <= o.offset) continue;
                o.offset = size;
                o.value = commas[i];
            }
            if (o.offset == 0) {
                int count = 0;
                for (int c : nc) {
                    count += c;
                }
                if (count == 0) {
                    o.offset = 1;
                    o.value = commas[0];
                } else {
                    throw new IOException("Unknown comma character, Please specify a separator.");
                }
            }
            O o2 = o;
            return o2;
        }
    }

    private static Charset charsetTest(Path path) throws IOException {
        Charset bom = null;
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            byte[] header = new byte[8];
            int n = is.read(header);
            if (n < 1) {
                Charset charset = null;
                return charset;
            }
            if (n >= 2) {
                if ((header[0] & 0xFF) == 255 && (header[1] & 0xFF) == 254) {
                    bom = StandardCharsets.UTF_16LE;
                    if (n >= 4 && header[2] == 0 && header[3] == 0) {
                        bom = Charset.forName("UTF-32LE");
                    }
                } else if ((header[0] & 0xFF) == 254 && (header[1] & 0xFF) == 255) {
                    bom = StandardCharsets.UTF_16BE;
                }
            }
            if (n >= 3 && (header[0] & 0xFF) == 239 && (header[1] & 0xFF) == 187 && (header[2] & 0xFF) == 191) {
                bom = StandardCharsets.UTF_8;
            }
            if (n >= 4 && (header[0] & 0xFF) == 0 && (header[1] & 0xFF) == 0 && (header[2] & 0xFF) == 254 && (header[3] & 0xFF) == 255) {
                bom = Charset.forName("UTF-32BE");
            }
        }
        return bom;
    }

    private static boolean parse(char[] chars, int len, O o, char comma) {
        boolean last_block;
        int offset;
        int i = offset = o.offset;
        int iq = -1;
        int qn = 0;
        boolean quoted = chars[i] == '\"';
        boolean integral = false;
        boolean bl = last_block = len < chars.length;
        if (quoted) {
            ++i;
        }
        while (i < len) {
            block19: {
                char c;
                block16: {
                    block20: {
                        block17: {
                            block18: {
                                c = chars[i];
                                if (c != '\"') break block16;
                                if (i >= len - 1) {
                                    integral = true;
                                    ++i;
                                    break;
                                }
                                if (!quoted) break block17;
                                if (chars[i + 1] != '\"') break block18;
                                iq = ++i;
                                break block19;
                            }
                            if (chars[i + 1] != comma && chars[i + 1] != '\n' && (chars[i + 1] != '\r' || i >= len - 2 || chars[i + 2] != '\n')) {
                                throw new RuntimeException("line-number: " + o.line + " (zero-base). Comma-separated values format error.\nInvalid char between encapsulated token and delimiter.");
                            }
                            break block20;
                        }
                        ++qn;
                    }
                    if (!(last_block || chars[i + 1] == comma || chars[i + 1] == '\n' || chars[i + 1] == '\r' && i < len - 2 && chars[i + 2] == '\n')) {
                        throw new RuntimeException("line-number: " + o.line + " (zero-base). Comma-separated values format error.\nA (double) quote character in a field must be represented by two (double) quote characters.");
                    }
                    ++i;
                    if (qn == 0) {
                        integral = true;
                        break;
                    }
                    break block19;
                }
                if (!(c != comma && c != '\n' || quoted)) {
                    integral = true;
                    break;
                }
            }
            ++i;
        }
        if (!integral && last_block) {
            if (!quoted) {
                integral = true;
            } else {
                throw new RuntimeException("line-number: " + o.line + " (zero-base). Comma-separated values format error.\nEOF reached before encapsulated token finished.");
            }
        }
        if (integral) {
            if (quoted) {
                ++offset;
            }
            if (offset == i && chars[offset] == '\n' || offset - i == 1 && chars[offset] == '\r' && chars[i] == '\n') {
                o.value = null;
            } else {
                String string = i - offset > 0 ? CSVUtil.trim(chars, offset, quoted || chars[i - 1] == '\r' ? i - offset - 1 : i - offset, iq) : (o.value = EMPTY);
            }
            if (i < len - 1 && chars[i] == '\r' && chars[i + 1] == '\n') {
                ++i;
                o.newLine = true;
            } else {
                o.newLine = i < len ? chars[i] == '\n' : false;
            }
            o.offset = offset = i + 1;
        }
        return integral;
    }

    private static String trim(char[] chars, int offset, int size, int iq) {
        if (size > 0) {
            int len = offset + size;
            if (iq >= 0) {
                System.arraycopy(chars, iq, chars, iq - 1, len - iq);
                --len;
                for (int i = iq - 1; i > offset; --i) {
                    if (chars[i] != '\"' || chars[i - 1] != '\"') continue;
                    System.arraycopy(chars, i, chars, i - 1, len - i);
                    --i;
                    --len;
                }
            }
            return new String(chars, offset, len - offset);
        }
        return EMPTY;
    }

    public static class Writer
    implements Closeable {
        private final BufferedWriter writer;
        private char separator = (char)44;
        private int column;
        private int i;
        private char[] cb;
        private int offset;
        private static final int length = 8192;
        private final char[] lineSeparator = System.lineSeparator().toCharArray();

        private Writer(Path path) throws IOException {
            this(path, StandardCharsets.UTF_8);
        }

        private Writer(Path path, Charset charset) throws IOException {
            this.writer = Files.newBufferedWriter(path, charset, new OpenOption[0]);
            this.init();
        }

        private Writer(BufferedWriter writer) {
            this.writer = writer;
            this.init();
        }

        private void init() {
            this.cb = new char[8192];
        }

        public Writer writeWithBom() {
            if (this.offset == 0 && this.i == 0 && this.column == 0) {
                this.cb[this.offset++] = 65279;
            }
            return this;
        }

        public void writeChar(char c) throws IOException {
            this.test();
            if (c == '\"') {
                this.checkBound(4);
                this.cb[this.offset++] = 34;
                this.cb[this.offset++] = 34;
                this.cb[this.offset++] = 34;
                this.cb[this.offset++] = 34;
            } else if (c == '\n' || c == '\t' || c == this.separator || c == ',') {
                this.checkBound(3);
                this.cb[this.offset++] = 34;
                this.cb[this.offset++] = c;
                this.cb[this.offset++] = 34;
            } else {
                this.checkBound(1);
                this.cb[this.offset++] = c;
            }
        }

        public void write(boolean b) throws IOException {
            this.test();
            if (b) {
                this.checkBound(4);
                this.cb[this.offset++] = 84;
                this.cb[this.offset++] = 82;
                this.cb[this.offset++] = 85;
                this.cb[this.offset++] = 69;
            } else {
                this.checkBound(5);
                this.cb[this.offset++] = 70;
                this.cb[this.offset++] = 65;
                this.cb[this.offset++] = 76;
                this.cb[this.offset++] = 83;
                this.cb[this.offset++] = 69;
            }
        }

        public void write(int n) throws IOException {
            this.test();
            this.toChars(n);
        }

        public void write(long l) throws IOException {
            this.test();
            this.toChars(l);
        }

        public void write(float f) throws IOException {
            this.test();
            String fs = Float.toString(f);
            int len = fs.length();
            this.checkBound(len);
            fs.getChars(0, len, this.cb, this.offset);
            this.offset += len;
        }

        public void write(double d) throws IOException {
            this.test();
            String ds = Double.toString(d);
            int len = ds.length();
            this.checkBound(len);
            ds.getChars(0, len, this.cb, this.offset);
            this.offset += len;
        }

        public void write(String text) throws IOException {
            if (text != null && !text.isEmpty()) {
                this.write(text.toCharArray());
            } else {
                this.writeEmpty();
            }
        }

        public void write(char[] chars) throws IOException {
            this.write(chars, 0, chars.length);
        }

        public void write(char[] chars, int offset, int size) throws IOException {
            this.test();
            int i = 0;
            int last = offset;
            boolean quoted = false;
            boolean shouldBeQuoted = false;
            while (i < size) {
                char c;
                if ((c = chars[i++]) == '\"') {
                    quoted = true;
                    if (last == offset) {
                        this.checkBound(1);
                        this.cb[this.offset++] = 34;
                    }
                    this.checkBound(i - last + 1);
                    System.arraycopy(chars, last, this.cb, this.offset, i - last);
                    this.offset += i - last;
                    this.cb[this.offset++] = 34;
                    last = i;
                    continue;
                }
                if (c != '\n' && c != '\t' && c != this.separator && c != ',') continue;
                shouldBeQuoted = true;
            }
            if (quoted) {
                this.checkBound(i - last + 1);
                System.arraycopy(chars, last, this.cb, this.offset, i - last);
                this.offset += i - last;
                this.cb[this.offset++] = 34;
            } else if (shouldBeQuoted) {
                this.checkBound(size + 2);
                this.cb[this.offset++] = 34;
                System.arraycopy(chars, offset, this.cb, this.offset, size);
                this.offset += size;
                this.cb[this.offset++] = 34;
            } else {
                this.checkBound(size);
                System.arraycopy(chars, offset, this.cb, this.offset, size);
                this.offset += size;
            }
        }

        public void writeEmpty() throws IOException {
            this.test();
        }

        public void newLine() throws IOException {
            this.checkBound(this.lineSeparator.length);
            System.arraycopy(this.lineSeparator, 0, this.cb, this.offset, this.lineSeparator.length);
            this.offset += this.lineSeparator.length;
            if (this.column == 0) {
                this.column = this.i;
            }
            this.i = 0;
        }

        private boolean test() throws IOException {
            boolean first = this.i == 0;
            ++this.i;
            if (this.column > 0 && this.i > this.column) {
                LOGGER.warn("Each record should contain the same number of comma-separated fields.");
            }
            if (!first) {
                this.checkBound(1);
                this.cb[this.offset++] = this.separator;
            }
            return first;
        }

        private void flush() throws IOException {
            this.writer.write(this.cb, 0, this.offset);
            this.offset = 0;
        }

        private void checkBound(int size) throws IOException {
            if (this.offset + size > 8192) {
                this.flush();
            }
        }

        private void toChars(int i) throws IOException {
            if (i == Integer.MIN_VALUE) {
                this.checkBound(ExtBufferedWriter.MIN_INTEGER_CHARS.length);
                System.arraycopy(ExtBufferedWriter.MIN_INTEGER_CHARS, 0, this.cb, this.offset, ExtBufferedWriter.MIN_INTEGER_CHARS.length);
                this.offset += ExtBufferedWriter.MIN_INTEGER_CHARS.length;
            } else {
                int size = ExtBufferedWriter.stringSize(i);
                this.checkBound(size);
                ExtBufferedWriter.getChars(i, this.offset += size, this.cb);
            }
        }

        private void toChars(long i) throws IOException {
            if (i == Long.MIN_VALUE) {
                this.checkBound(ExtBufferedWriter.MIN_LONG_CHARS.length);
                System.arraycopy(ExtBufferedWriter.MIN_LONG_CHARS, 0, this.cb, this.offset, ExtBufferedWriter.MIN_LONG_CHARS.length);
                this.offset += ExtBufferedWriter.MIN_LONG_CHARS.length;
            } else {
                int size = ExtBufferedWriter.stringSize(i);
                this.checkBound(size);
                ExtBufferedWriter.getChars(i, this.offset += size, this.cb);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.writer != null) {
                if (this.offset > 0) {
                    this.flush();
                }
                this.writer.close();
            }
        }
    }

    public static class SharedRowsIterator
    extends RowsIterator {
        private boolean produced;

        protected SharedRowsIterator() {
        }

        SharedRowsIterator(O o, Path path, Charset charset) throws IOException {
            super(o, path, charset);
        }

        @Override
        public boolean hasNext() {
            if (this.produced) {
                return true;
            }
            this.nextRow[0] = null;
            this.produced = super.hasNext();
            return this.produced;
        }

        @Override
        public String[] next() {
            if (this.produced || this.hasNext()) {
                this.produced = false;
                return this.nextRow;
            }
            throw new NoSuchElementException();
        }

        public void retain() {
            this.produced = true;
        }
    }

    public static class RowsIterator
    implements Closeable,
    Iterator<String[]> {
        private int column;
        private final char comma;
        private BufferedReader reader;
        private char[] chars;
        private int offset;
        private int i;
        private int _i;
        private int n;
        String[] nextRow;
        private static final int length = 8192;
        private O o;
        boolean EOF;
        boolean load;

        RowsIterator() {
            this.comma = (char)44;
        }

        RowsIterator(O o, Path path, Charset charset) throws IOException {
            this.column = o.offset;
            this.comma = o.value.charAt(0);
            this.o = o;
            BufferedReader bufferedReader = this.reader = charset != null ? Files.newBufferedReader(path, charset) : Files.newBufferedReader(path);
            if (o.line > 0) {
                this.reader.skip(o.line);
                o.line = 0;
            }
            this.chars = new char[8192];
            this.nextRow = new String[this.column];
            o.offset = 0;
            this.offset = 0;
            this.load = true;
        }

        @Override
        public boolean hasNext() {
            if (this.EOF) {
                return false;
            }
            try {
                while (true) {
                    String[] _array;
                    if (this.load) {
                        this.n = this.reader.read(this.chars, this.offset, 8192 - this.offset);
                        if (this.n <= 0) {
                            this.EOF = true;
                            if (this.chars[this.o.offset - 1] == this.comma) {
                                if (this.i == this.column) {
                                    _array = new String[++this.column];
                                    System.arraycopy(this.nextRow, 0, _array, 0, this.column - 1);
                                    this.nextRow = _array;
                                }
                                this.nextRow[this.i++] = CSVUtil.EMPTY;
                                this._i = this.i;
                            }
                            return this.nextRow[0] != null;
                        }
                        this.n += this.offset;
                        this.o.offset = 0;
                        this.load = false;
                    }
                    while (CSVUtil.parse(this.chars, this.n, this.o, this.comma)) {
                        this.offset = this.o.offset;
                        if (this.i == this.column) {
                            _array = new String[++this.column];
                            System.arraycopy(this.nextRow, 0, _array, 0, this.column - 1);
                            this.nextRow = _array;
                        }
                        this.nextRow[this.i++] = this.o.value;
                        this._i = this.i;
                        if (this.offset >= this.n) {
                            if (!this.o.newLine) break;
                            ++this.o.line;
                            if (this.i <= 1 && this.nextRow[0] == null) break;
                            if (this.o.value == null) {
                                this.nextRow[this.i - 1] = CSVUtil.EMPTY;
                            }
                            this.i = 0;
                            this.load = true;
                            this.offset = 0;
                            return this.load;
                        }
                        if (!this.o.newLine) continue;
                        ++this.o.line;
                        if (this.i > 1 || this.nextRow[0] != null) {
                            if (this.o.value == null) {
                                this.nextRow[this.i - 1] = CSVUtil.EMPTY;
                            }
                            this.i = 0;
                            return true;
                        }
                        this.i = 0;
                    }
                    this.load = true;
                    if (this.offset < this.n) {
                        this.offset = this.n - this.offset;
                        System.arraycopy(this.chars, this.offset, this.chars, 0, this.offset);
                        continue;
                    }
                    this.offset = 0;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public String[] next() {
            if (this.nextRow[0] != null || this.hasNext()) {
                String[] next = Arrays.copyOf(this.nextRow, this._i);
                this.nextRow[0] = null;
                return next;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        static RowsIterator createEmptyIterator() {
            RowsIterator iterator = new RowsIterator();
            iterator.EOF = true;
            iterator.nextRow = new String[0];
            return iterator;
        }
    }

    private static class O {
        int offset;
        int line;
        String value;
        boolean newLine;
        Charset charset;

        O(int offset) {
            this.offset = offset;
        }
    }

    public static class Reader
    implements Closeable {
        private RowsIterator iterator;
        private final Path path;
        private final Charset charset;
        private char separator;
        private final Spliterator<String[]> emptySql = new Spliterator<String[]>(){

            @Override
            public boolean tryAdvance(Consumer<? super String[]> action) {
                return false;
            }

            @Override
            public Spliterator<String[]> trySplit() {
                return null;
            }

            @Override
            public long estimateSize() {
                return 0L;
            }

            @Override
            public int characteristics() {
                return 0;
            }
        };

        private Reader(Path path, Charset charset) {
            this.path = path;
            this.charset = charset;
            this.separator = '\u0000';
        }

        public <T> Stream<T> stream(Class<T> clazz) {
            throw new UnsupportedOperationException();
        }

        public Stream<String[]> stream() throws IOException {
            O o = CSVUtil.init(this.path, this.separator, this.charset);
            if (o == null) {
                return StreamSupport.stream(this.emptySql, false);
            }
            this.iterator = new RowsIterator(o, this.path, o.charset);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator, 272), false);
        }

        public Stream<String[]> sharedStream() throws IOException {
            return this.sharedStream('\u0000');
        }

        public Stream<String[]> sharedStream(char separator) throws IOException {
            O o = CSVUtil.init(this.path, separator, this.charset);
            if (o == null) {
                return StreamSupport.stream(this.emptySql, false);
            }
            this.iterator = new SharedRowsIterator(o, this.path, this.charset);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator, 272), false);
        }

        public RowsIterator iterator() throws IOException {
            O o = CSVUtil.init(this.path, this.separator, this.charset);
            if (o == null) {
                return RowsIterator.createEmptyIterator();
            }
            return new RowsIterator(o, this.path, o.charset);
        }

        public RowsIterator sharedIterator() throws IOException {
            O o = CSVUtil.init(this.path, this.separator, this.charset);
            if (o == null) {
                return SharedRowsIterator.createEmptyIterator();
            }
            return new SharedRowsIterator(o, this.path, this.charset);
        }

        @Override
        public void close() throws IOException {
            if (this.iterator != null) {
                try {
                    this.iterator.close();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        }
    }
}

