/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Base64;
import java.util.Date;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

public interface ICellValueAndStyle {
    default public void reset(Row row, Cell cell, Object e, Column hc) {
        this.setCellValue(row, cell, e, hc, hc.getClazz(), hc.getConversion() != null);
        cell.xf = this.getStyleIndex(row, hc, e);
    }

    default public int getStyleIndex(Row row, Column hc, Object o) {
        int style = hc.getCellStyle();
        if (hc.styleProcessor != null) {
            style = hc.styleProcessor.build(o, style, hc.styles);
        }
        return hc.styles.of(style);
    }

    default public <T> void setStyleDesign(T o, Cell cell, Column hc, StyleProcessor<T> styleProcessor) {
        if (styleProcessor != null && hc.styles != null) {
            cell.xf = hc.styles.of(styleProcessor.build(o, hc.styles.getStyleByIndex(cell.xf), hc.styles));
        }
    }

    default public void setCellValue(Row row, Cell cell, Object e, Column hc, Class<?> clazz, boolean hasConversion) {
        if (hasConversion) {
            this.conversion(row, cell, e, hc);
            return;
        }
        if (e == null) {
            this.setNullValue(row, cell, hc);
            return;
        }
        if (clazz == null) {
            clazz = e.getClass();
            hc.setClazz(clazz);
        }
        if (IWorksheetWriter.isString(clazz)) {
            switch (hc.getColumnType()) {
                case 0: {
                    cell.setString(e.toString());
                    break;
                }
                case 1: {
                    this.writeAsMedia(row, cell, e.toString(), hc, clazz);
                    break;
                }
                case 2: {
                    cell.setHyperlink(e.toString());
                    break;
                }
                default: {
                    cell.setString(e.toString());
                    break;
                }
            }
        } else if (IWorksheetWriter.isDate(clazz)) {
            cell.setDateTime(DateUtil.toDateTimeValue((Date)e));
        } else if (IWorksheetWriter.isDateTime(clazz)) {
            cell.setDateTime(DateUtil.toDateTimeValue((Timestamp)e));
        } else if (IWorksheetWriter.isChar(clazz)) {
            cell.setChar(((Character)e).charValue());
        } else if (IWorksheetWriter.isShort(clazz)) {
            cell.setInt(((Short)e).shortValue());
        } else if (IWorksheetWriter.isInt(clazz)) {
            cell.setInt((Integer)e);
        } else if (IWorksheetWriter.isLong(clazz)) {
            cell.setLong((Long)e);
        } else if (IWorksheetWriter.isFloat(clazz)) {
            cell.setDouble(((Float)e).floatValue());
        } else if (IWorksheetWriter.isDouble(clazz)) {
            cell.setDouble((Double)e);
        } else if (IWorksheetWriter.isBool(clazz)) {
            cell.setBool((Boolean)e);
        } else if (IWorksheetWriter.isBigDecimal(clazz)) {
            cell.setDecimal((BigDecimal)e);
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            cell.setDateTime(DateUtil.toDateValue((LocalDate)e));
        } else if (IWorksheetWriter.isLocalDateTime(clazz)) {
            cell.setDateTime(DateUtil.toDateTimeValue((LocalDateTime)e));
        } else if (IWorksheetWriter.isTime(clazz)) {
            cell.setTime(DateUtil.toTimeValue((Time)e));
        } else if (IWorksheetWriter.isLocalTime(clazz)) {
            cell.setTime(DateUtil.toTimeValue((LocalTime)e));
        } else if (hc.getColumnType() == 1) {
            if (Path.class.isAssignableFrom(clazz)) {
                cell.setPath((Path)e);
            } else if (File.class.isAssignableFrom(clazz)) {
                cell.setPath(((File)e).toPath());
            } else if (InputStream.class.isAssignableFrom(clazz)) {
                cell.setInputStream((InputStream)e);
            } else if (clazz == byte[].class) {
                cell.setBinary((byte[])e);
            } else if (ByteBuffer.class.isAssignableFrom(clazz)) {
                cell.setByteBuffer((ByteBuffer)e);
            }
        } else {
            this.unknownType(row, cell, e, hc, clazz);
        }
    }

    default public void setNullValue(Row row, Cell cell, Column hc) {
        boolean hasProcessor;
        boolean bl = hasProcessor = hc.getConversion() != null;
        if (hasProcessor) {
            this.conversion(row, cell, 0, hc);
        } else {
            cell.blank();
        }
    }

    default public void conversion(Row row, Cell cell, Object o, Column hc) {
        Object e = hc.getConversion().conversion(o);
        if (e != null) {
            this.setCellValue(row, cell, e, hc, e.getClass(), false);
        } else {
            cell.blank();
        }
    }

    default public void unknownType(Row row, Cell cell, Object e, Column hc, Class<?> clazz) {
        cell.setString(e.toString());
    }

    default public void writeAsMedia(Row row, Cell cell, String e, Column hc, Class<?> clazz) {
        int b;
        int len = e.length();
        if (len > 64 && e.startsWith("data:") && (b = StringUtil.indexOf(e, 44, 6, 64)) > 6 && e.charAt(b - 1) == '4' && e.charAt(b - 2) == '6' && e.charAt(b - 3) == 'e' && e.charAt(b - 4) == 's' && e.charAt(b - 5) == 'a' && e.charAt(b - 6) == 'b') {
            byte[] bytes = Base64.getDecoder().decode(e.substring(b + 1));
            cell.setBinary(bytes);
        } else if (len >= 10 && (b = StringUtil.indexOf(e, 58, 3, 6)) >= 3 && e.charAt(b + 1) == '/' && e.charAt(b + 2) == '/') {
            this.downloadRemoteResource(row, cell, e, hc, clazz);
        } else {
            cell.setString(e);
        }
    }

    default public void downloadRemoteResource(Row row, Cell cell, String e, Column hc, Class<?> clazz) {
        cell.setString(e);
        cell.mediaType = (char)117;
    }

    default public boolean isAllowDirectOutput(Class<?> clazz) {
        return clazz == null || IWorksheetWriter.isString(clazz) || IWorksheetWriter.isDate(clazz) || IWorksheetWriter.isDateTime(clazz) || IWorksheetWriter.isChar(clazz) || IWorksheetWriter.isShort(clazz) || IWorksheetWriter.isInt(clazz) || IWorksheetWriter.isLong(clazz) || IWorksheetWriter.isFloat(clazz) || IWorksheetWriter.isDouble(clazz) || IWorksheetWriter.isBool(clazz) || IWorksheetWriter.isBigDecimal(clazz) || IWorksheetWriter.isLocalDate(clazz) || IWorksheetWriter.isLocalDateTime(clazz) || IWorksheetWriter.isTime(clazz) || IWorksheetWriter.isLocalTime(clazz) || Path.class.isAssignableFrom(clazz) || File.class.isAssignableFrom(clazz) || InputStream.class.isAssignableFrom(clazz) || clazz == byte[].class || ByteBuffer.class.isAssignableFrom(clazz);
    }
}

