/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.hash;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AbstractStreamingHasher {
    private final ByteBuffer buffer;
    private final int bufferSize;
    private final int chunkSize;
    private ByteBuffer tmpBuffer = ByteBuffer.allocate(512).order(ByteOrder.LITTLE_ENDIAN);

    protected AbstractStreamingHasher(int chunkSize) {
        this(chunkSize, chunkSize);
    }

    protected AbstractStreamingHasher(int chunkSize, int bufferSize) {
        int mod = bufferSize % chunkSize;
        if (mod != 0) {
            bufferSize += chunkSize - mod;
        }
        this.buffer = ByteBuffer.allocate(bufferSize + 7).order(ByteOrder.LITTLE_ENDIAN);
        this.bufferSize = bufferSize;
        this.chunkSize = chunkSize;
    }

    protected abstract void process(ByteBuffer var1);

    protected void processRemaining(ByteBuffer bb) {
        bb.position(bb.limit());
        bb.limit(this.chunkSize + 7);
        while (bb.position() < this.chunkSize) {
            bb.putLong(0L);
        }
        bb.limit(this.chunkSize);
        bb.flip();
        this.process(bb);
    }

    public final AbstractStreamingHasher putBytes(byte[] bytes) {
        return this.putBytes(bytes, 0, bytes.length);
    }

    public final AbstractStreamingHasher putBytes(byte[] bytes, int off, int len) {
        if (this.tmpBuffer.capacity() >= len) {
            this.tmpBuffer.clear();
            this.tmpBuffer.put(bytes, off, len);
            this.tmpBuffer.flip();
        } else {
            this.tmpBuffer = ByteBuffer.wrap(bytes, off, len).order(ByteOrder.LITTLE_ENDIAN);
        }
        return this.putBytesInternal(this.tmpBuffer);
    }

    private AbstractStreamingHasher putBytesInternal(ByteBuffer readBuffer) {
        if (readBuffer.remaining() <= this.buffer.remaining()) {
            this.buffer.put(readBuffer);
            this.munchIfFull();
            return this;
        }
        int bytesToCopy = this.bufferSize - this.buffer.position();
        for (int i = 0; i < bytesToCopy; ++i) {
            this.buffer.put(readBuffer.get());
        }
        this.munch();
        while (readBuffer.remaining() >= this.chunkSize) {
            this.process(readBuffer);
        }
        this.buffer.put(readBuffer);
        return this;
    }

    public final byte[] hash() {
        this.munch();
        this.buffer.flip();
        if (this.buffer.remaining() > 0) {
            this.processRemaining(this.buffer);
            this.buffer.position(this.buffer.limit());
        }
        return this.makeHash();
    }

    protected abstract byte[] makeHash();

    private void munchIfFull() {
        if (this.buffer.remaining() < 8) {
            this.munch();
        }
    }

    private void munch() {
        this.buffer.flip();
        while (this.buffer.remaining() >= this.chunkSize) {
            this.process(this.buffer);
        }
        this.buffer.compact();
    }

    protected AbstractStreamingHasher clear() {
        this.buffer.clear();
        return this;
    }
}

