/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.manager.docProps;

import java.math.BigDecimal;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.manager.docProps.Tuple2;
import org.ttzero.excel.manager.docProps.XmlEntity;
import org.ttzero.excel.util.DateUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"", "vt"}, uri={"http://schemas.openxmlformats.org/officeDocument/2006/custom-properties", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes"}, value="Properties")
public class CustomProperties
extends XmlEntity {
    public static final String FORMAT_ID = "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}";
    private static final String MARK_AS_READ_ONLY = "_MarkAsFinal";
    private final Map<String, Tuple2<Object, Integer>> properties = new LinkedHashMap<String, Tuple2<Object, Integer>>();

    public void put(String key, Object value) {
        CustomProperties.check(key, value);
        this.properties.put(key, CustomProperties.toProValue(value));
    }

    public void putAll(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            CustomProperties.check(entry.getKey(), entry.getValue());
            this.properties.put(entry.getKey(), CustomProperties.toProValue(entry.getValue()));
        }
    }

    public void markAsReadOnly() {
        this.properties.put(MARK_AS_READ_ONLY, Tuple2.of(true, 4));
    }

    public boolean hasReadOnlyMark() {
        Tuple2<Object, Integer> v = this.properties.remove(MARK_AS_READ_ONLY);
        return v != null && (Boolean)v.v1 != false;
    }

    public Object remove(String key) {
        Tuple2<Object, Integer> v = this.properties.remove(key);
        return v != null ? v.v1 : null;
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.properties.size());
        for (Map.Entry<String, Tuple2<Object, Integer>> entry : this.properties.entrySet()) {
            if (MARK_AS_READ_ONLY.equals(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue().v1);
        }
        return result;
    }

    public Object get(String key) {
        Tuple2<Object, Integer> v = this.properties.get(key);
        return v != null ? v.v1 : null;
    }

    public boolean hasProperty() {
        return !this.properties.isEmpty();
    }

    @Override
    void toDom(Element root, Map<String, Namespace> namespaceMap) {
        int id = 2;
        Namespace vt = namespaceMap.get("vt");
        for (Map.Entry<String, Tuple2<Object, Integer>> entry : this.properties.entrySet()) {
            Element property = root.addElement("property").addAttribute("fmtid", FORMAT_ID).addAttribute("pid", Integer.toString(id++)).addAttribute("name", entry.getKey());
            Tuple2<Object, Integer> val = entry.getValue();
            switch ((Integer)val.v2) {
                case 0: {
                    property.addElement(QName.get((String)"lpwstr", (Namespace)vt)).addText(val.v1.toString());
                    break;
                }
                case 1: {
                    property.addElement(QName.get((String)"filetime", (Namespace)vt)).addText(DateUtil.toTString((Date)val.v1));
                    break;
                }
                case 2: {
                    property.addElement(QName.get((String)"i4", (Namespace)vt)).addText(val.v1.toString());
                    break;
                }
                case 3: {
                    property.addElement(QName.get((String)"r8", (Namespace)vt)).addText(val.v1.toString());
                    break;
                }
                case 4: {
                    property.addElement(QName.get((String)"bool", (Namespace)vt)).addText(val.v1.toString());
                    break;
                }
            }
        }
    }

    public static CustomProperties domToCustom(Element root) {
        List list = root.elements();
        if (list == null || list.isEmpty()) {
            return null;
        }
        CustomProperties custom = new CustomProperties();
        for (Element e : list) {
            String key = e.attributeValue("name");
            List sub = e.elements();
            if (sub != null && !sub.isEmpty()) {
                Element val = (Element)sub.get(0);
                String type = val.getName();
                String value = val.getText();
                switch (type) {
                    case "lpwstr": {
                        custom.properties.put(key, Tuple2.of(value, 0));
                        break;
                    }
                    case "filetime": {
                        custom.properties.put(key, Tuple2.of(DateUtil.utcDateTimeFormat.get().parse(value, new ParsePosition(0)), 1));
                        break;
                    }
                    case "i4": 
                    case "i2": {
                        custom.properties.put(key, Tuple2.of(Integer.parseInt(value), 2));
                        break;
                    }
                    case "i8": {
                        custom.properties.put(key, Tuple2.of(Long.parseLong(value), 3));
                        break;
                    }
                    case "r8": 
                    case "r4": 
                    case "ui8": {
                        custom.properties.put(key, Tuple2.of(new BigDecimal(value), 3));
                        break;
                    }
                    case "bool": {
                        custom.properties.put(key, Tuple2.of(Boolean.valueOf(value), 4));
                        break;
                    }
                    default: {
                        custom.properties.put(key, Tuple2.of(value, 0));
                        break;
                    }
                }
                continue;
            }
            custom.properties.put(key, Tuple2.of(null, 0));
        }
        return custom;
    }

    protected static void check(String key, Object val) {
        if (StringUtil.isEmpty(key)) {
            throw new IllegalArgumentException("Property name is required.");
        }
        if (key.length() > 256) {
            throw new IllegalArgumentException("Property name is too long, max=256 current=" + key.length());
        }
        if (val == null) {
            throw new IllegalArgumentException("Property value is required.");
        }
    }

    protected static Tuple2<Object, Integer> toProValue(Object val) {
        int t = val instanceof String ? 0 : (val instanceof Date ? 1 : (val instanceof Integer || val instanceof Short ? 2 : (val instanceof Long || val instanceof Double || val instanceof Float ? 3 : (val instanceof Boolean ? 4 : 0))));
        return Tuple2.of(val, t);
    }
}

