/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.beans.IntrospectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.ttzero.excel.annotation.ExcelColumn;
import org.ttzero.excel.annotation.ExcelColumns;
import org.ttzero.excel.annotation.IgnoreImport;
import org.ttzero.excel.annotation.RowNum;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.manager.Const;
import org.ttzero.excel.processor.Converter;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.CellType;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.TypeCastException;
import org.ttzero.excel.util.ReflectUtil;
import org.ttzero.excel.util.StringUtil;

public class HeaderRow
extends Row {
    public static final int FORCE_IMPORT = 1;
    public static final int IGNORE_CASE = 2;
    public static final int CAMEL_CASE = 4;
    protected String[] names;
    protected Class<?> clazz;
    protected Object t;
    protected Map<String, Integer> mapping;
    protected ListSheet.EntryColumn[] columns;
    protected int headRows;
    protected int option;

    public HeaderRow with(Row ... rows) {
        return this.with(null, rows.length, rows);
    }

    public HeaderRow with(int headRows, Row ... rows) {
        return this.with(null, headRows, rows);
    }

    public HeaderRow with(List<Dimension> mergeCells, Row ... rows) {
        return this.with(mergeCells, rows.length, rows);
    }

    public HeaderRow with(List<Dimension> mergeCells, int headRows, Row ... rows) {
        int i;
        this.headRows = headRows;
        Row row = rows[rows.length - 1];
        if (row == null) {
            return new HeaderRow();
        }
        this.names = new String[row.lc];
        this.mapping = new HashMap<String, Integer>();
        this.fc = row.fc;
        this.lc = row.lc;
        this.index = row.index;
        this.cells = new Cell[this.names.length];
        for (i = 0; i < row.fc; ++i) {
            this.cells[i] = new Cell(i);
        }
        if (headRows == 1) {
            for (i = row.fc; i < row.lc; ++i) {
                Cell hCell = row.getCell(i);
                this.names[i] = row.getString(hCell);
                this.mapping.put(this.makeKey(this.names[i]), i);
                Cell cell = new Cell(hCell.i);
                cell.xf = hCell.xf;
                cell.setString(this.names[i]);
                this.cells[i] = cell;
            }
        } else {
            this.mergeCellsIfNull(mergeCells, rows);
            StringBuilder buf = new StringBuilder();
            for (int i2 = row.fc; i2 < row.lc; ++i2) {
                buf.delete(0, buf.length());
                for (Row r : rows) {
                    String tmp = r.getString(i2);
                    if (!StringUtil.isNotEmpty(tmp)) continue;
                    buf.append(tmp).append(':');
                }
                if (buf.length() > 1) {
                    buf.deleteCharAt(buf.length() - 1);
                }
                this.names[i2] = buf.toString();
                this.mapping.put(this.makeKey(this.names[i2]), i2);
                Cell hCell = rows[rows.length - 1].getCell(i2);
                Cell cell = new Cell(hCell != null ? (int)hCell.i : i2);
                cell.xf = hCell != null ? hCell.xf : 0;
                cell.setString(this.names[i2]);
                this.cells[i2] = cell;
            }
        }
        return this;
    }

    public final boolean is(Class<?> clazz) {
        return this.clazz != null && this.clazz == clazz;
    }

    protected HeaderRow setClass(Class<?> clazz) {
        ListSheet.EntryColumn column;
        this.clazz = clazz;
        Field[] declaredFields = ReflectUtil.listDeclaredFields(clazz, c -> !this.ignoreColumn((AccessibleObject)c));
        HashMap<String, Method> tmp = new HashMap<String, Method>();
        try {
            tmp.putAll(ReflectUtil.writeMethodsMap(clazz, Object.class));
        }
        catch (IntrospectionException e2) {
            this.LOGGER.warn("Get class {} methods failed.", clazz);
        }
        final ArrayList<ListSheet.EntryColumn> list = new ArrayList<ListSheet.EntryColumn>();
        for (int i = 0; i < declaredFields.length; ++i) {
            ListSheet.EntryColumn tail;
            Iterator<Map.Entry<String, Method>> f = declaredFields[i];
            ((Field)((Object)f)).setAccessible(true);
            String string = ((Field)((Object)f)).getName();
            Method method = (Method)tmp.get(string);
            if (method != null && (column = this.createColumn(method)) != null) {
                tail = column.tail != null ? (ListSheet.EntryColumn)column.tail : column;
                tail.method = method;
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = method.getName();
                }
                if (tail.clazz == null) {
                    tail.clazz = method.getParameterTypes()[0];
                }
                if (tail.colIndex < 0) {
                    tail.colIndex = this.check(tail.name, string);
                }
                list.add(column);
                continue;
            }
            column = this.createColumn((AccessibleObject)((Object)f));
            if (column == null) continue;
            ListSheet.EntryColumn entryColumn = tail = column.tail != null ? (ListSheet.EntryColumn)column.tail : column;
            if (StringUtil.isEmpty(tail.name)) {
                tail.name = string;
            }
            if (method != null) {
                tail.method = method;
                if (tail.clazz == null) {
                    tail.clazz = method.getParameterTypes()[0];
                }
            } else {
                tail.field = f;
                if (tail.clazz == null) {
                    tail.clazz = declaredFields[i].getType();
                }
            }
            if (tail.colIndex < 0) {
                tail.colIndex = this.check(tail.name, string);
            }
            list.add(column);
        }
        Map<String, Method> otherColumns = this.attachOtherColumn(clazz);
        if (!otherColumns.isEmpty()) {
            for (Column column2 : list) {
                otherColumns.remove(column2.name);
            }
            for (Map.Entry<String, Method> entry : otherColumns.entrySet()) {
                ListSheet.EntryColumn tail;
                column = this.createColumn(entry.getValue());
                if (column == null) {
                    column = new ListSheet.EntryColumn(entry.getKey());
                }
                ListSheet.EntryColumn entryColumn = tail = column.tail != null ? (ListSheet.EntryColumn)column.tail : column;
                if (StringUtil.isEmpty(tail.name)) {
                    tail.name = entry.getKey();
                }
                tail.method = entry.getValue();
                if (tail.clazz == null) {
                    tail.clazz = entry.getValue().getParameterTypes()[0];
                }
                if (tail.colIndex < 0) {
                    tail.colIndex = this.getIndex(tail.name);
                }
                list.add(column);
            }
        }
        ListSheet<Object> listSheet = new ListSheet<Object>(){

            @Override
            public Column[] getAndSortHeaderColumns() {
                this.columns = new Column[list.size()];
                list.toArray(this.columns);
                this.headerReady = true;
                this.sortColumns(this.columns);
                this.calculateRealColIndex();
                this.reverseHeadColumn();
                this.mergeHeaderCellsIfEquals();
                return this.columns;
            }
        };
        Column[] columnArray = listSheet.getAndSortHeaderColumns();
        List mergeCells = (List)listSheet.getExtPropValue("merge_cells");
        List list2 = mergeCells = mergeCells != null && !mergeCells.isEmpty() ? mergeCells.stream().filter(c -> c.firstColumn < c.lastColumn).collect(Collectors.toList()) : null;
        if (mergeCells != null && !mergeCells.isEmpty()) {
            Grid mergedGrid = GridFactory.create(mergeCells);
            for (Column c2 : columnArray) {
                Column[] sub = c2.toArray();
                for (int j = sub.length - 1; j >= 0; --j) {
                    int t = sub.length - j;
                    if (!mergedGrid.test(t, c2.realColIndex) || !HeaderRow.isTopRow(mergeCells, t, c2.realColIndex)) continue;
                    Cell cell = new Cell((short)c2.realColIndex);
                    if (StringUtil.isNotEmpty(sub[j].getName())) {
                        cell.setString(sub[j].getName());
                    } else {
                        cell.t = (char)101;
                    }
                    mergedGrid.merge(t, cell);
                    sub[j].name = cell.stringVal;
                }
            }
        }
        int len = columnArray.length;
        for (int i = 0; i < len; ++i) {
            Column c3 = columnArray[i];
            if (c3.tail != null) {
                StringJoiner joiner = new StringJoiner(":");
                Column[] sub = c3.toArray();
                for (int j = sub.length - 1; j >= 0; --j) {
                    if (!StringUtil.isNotEmpty(sub[j].getName())) continue;
                    joiner.add(sub[j].getName());
                }
                c3.name = joiner.toString();
            } else if (!(c3 instanceof ListSheet.EntryColumn)) {
                columnArray[i] = c3 = new ListSheet.EntryColumn(c3);
            }
            if (c3.colIndex >= 0) continue;
            c3.colIndex = this.getIndex(c3.name);
            c3.realColIndex = c3.colIndex + 1;
        }
        this.columns = (ListSheet.EntryColumn[])Arrays.stream(columnArray).filter(c -> c.colIndex >= 0 || c.clazz == RowNum.class).sorted(Comparator.comparingInt(a -> a.colIndex)).map(e -> e instanceof ListSheet.EntryColumn ? (ListSheet.EntryColumn)e : new ListSheet.EntryColumn((Column)e)).toArray(ListSheet.EntryColumn[]::new);
        return this;
    }

    static boolean isTopRow(List<Dimension> mergeCells, int row, int col) {
        for (Dimension dim : mergeCells) {
            if (!dim.checkRange(row, col) || row != dim.firstRow) continue;
            return true;
        }
        return false;
    }

    protected int check(String first, String second) {
        int n = this.getIndex(first);
        if (n == -1) {
            n = this.getIndex(second);
        }
        if (n == -1) {
            this.LOGGER.warn("{} field [{}] can't find in header {}", new Object[]{this.clazz, first, Arrays.toString(this.names)});
        }
        return n;
    }

    protected HeaderRow setClassOnce(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        this.setClass(clazz);
        this.t = clazz.newInstance();
        return this;
    }

    protected ListSheet.EntryColumn[] getColumns() {
        return this.columns;
    }

    public <T> T getT() {
        return (T)this.t;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public CellType getCellType(int columnIndex) {
        return CellType.STRING;
    }

    public String get(int columnIndex) {
        this.rangeCheck(columnIndex);
        return this.names[columnIndex];
    }

    public String[] getNames() {
        return this.names;
    }

    public int getIndex(String columnName) {
        if (this.mapping != null) {
            Integer index;
            if ((this.option & 2) == 2) {
                columnName = columnName.toLowerCase();
            }
            return (index = this.mapping.get(columnName)) != null ? index : -1;
        }
        return -1;
    }

    @Override
    public String toString() {
        int i;
        StringJoiner joiner = new StringJoiner(" | ");
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < this.names.length && this.names[i] == null; ++i) {
        }
        char[] chars = new char[10];
        Arrays.fill(chars, 0, chars.length, '-');
        int j = i;
        while (i < this.names.length) {
            joiner.add(this.names[i]);
            int n = this.simpleTestLength(this.names[i]) + (j == i || i == this.names.length - 1 ? 1 : 2);
            if (n > chars.length) {
                chars = new char[n];
            }
            Arrays.fill(chars, 0, n, '-');
            if (this.columns != null && i < this.columns.length && this.columns[i].clazz != RowNum.class) {
                Class c = this.columns[i].clazz;
                if (IWorksheetWriter.isDate(c) || IWorksheetWriter.isLocalDate(c) || IWorksheetWriter.isLocalDateTime(c) || IWorksheetWriter.isLocalTime(c) || IWorksheetWriter.isChar(c) || IWorksheetWriter.isBool(c)) {
                    chars[n - 1] = 58;
                    chars[0] = 58;
                } else if (IWorksheetWriter.isInt(c)) {
                    chars[n - 1] = 58;
                }
            }
            buf.append(chars, 0, n).append('|');
            ++i;
        }
        buf.insert(0, joiner.toString() + Const.lineSeparator);
        return buf.toString();
    }

    protected int simpleTestLength(String name) {
        if (name == null) {
            return 4;
        }
        char[] chars = name.toCharArray();
        double d = 0.0;
        for (char c : chars) {
            if (c < '\u0080') {
                d += 1.0;
                continue;
            }
            d += 1.75;
        }
        return (int)d;
    }

    void put(Row row, Object t) throws IllegalAccessException, InvocationTargetException {
        int i;
        try {
            for (i = 0; i < this.columns.length; ++i) {
                if (this.columns[i].method != null) {
                    this.methodPut(i, row, t);
                    continue;
                }
                this.fieldPut(i, row, t);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ListSheet.EntryColumn c = this.columns[i];
            int rowNum = row.getRowNum();
            int colIndex = c.colIndex;
            int colNum = colIndex + 1;
            CellType excelType = row.getCellType(colIndex);
            Class javaType = c.clazz;
            String msg = "The value in cell '" + new String(Sheet.int2Col(colNum)) + rowNum + "' is \"" + row.getString(colIndex) + "\"(" + (Object)((Object)excelType) + "), cannot cast to " + javaType.getTypeName();
            throw new TypeCastException(rowNum, colNum, excelType, javaType, msg, ex);
        }
    }

    protected void fieldPut(int i, Row row, Object t) throws IllegalAccessException {
        ListSheet.EntryColumn ec = this.columns[i];
        int c = ec.colIndex;
        Class fieldClazz = ec.clazz;
        if (ec.converter != null) {
            ec.field.set(t, ec.converter.reversion(row.getString(c), fieldClazz));
        } else if (fieldClazz == String.class) {
            ec.field.set(t, row.getString(c));
        } else if (fieldClazz == Integer.class) {
            ec.field.set(t, row.getInt(c));
        } else if (fieldClazz == Long.class) {
            ec.field.set(t, row.getLong(c));
        } else if (fieldClazz == java.util.Date.class || fieldClazz == Date.class) {
            ec.field.set(t, row.getDate(c));
        } else if (fieldClazz == Timestamp.class) {
            ec.field.set(t, row.getTimestamp(c));
        } else if (fieldClazz == Double.class) {
            ec.field.set(t, row.getDouble(c));
        } else if (fieldClazz == Float.class) {
            ec.field.set(t, row.getFloat(c));
        } else if (fieldClazz == Boolean.class) {
            ec.field.set(t, row.getBoolean(c));
        } else if (fieldClazz == BigDecimal.class) {
            ec.field.set(t, row.getDecimal(c));
        } else if (fieldClazz == Integer.TYPE) {
            Integer v = row.getInt(c);
            ec.field.set(t, v != null ? v : 0);
        } else if (fieldClazz == Long.TYPE) {
            Long v = row.getLong(c);
            ec.field.set(t, v != null ? v : 0L);
        } else if (fieldClazz == Double.TYPE) {
            Double v = row.getDouble(c);
            ec.field.set(t, v != null ? v : 0.0);
        } else if (fieldClazz == Float.TYPE) {
            Float v = row.getFloat(c);
            ec.field.set(t, Float.valueOf(v != null ? v.floatValue() : 0.0f));
        } else if (fieldClazz == Boolean.TYPE) {
            Boolean v = row.getBoolean(c);
            ec.field.set(t, v != null ? v : false);
        } else if (fieldClazz == Time.class) {
            ec.field.set(t, row.getTime(c));
        } else if (fieldClazz == LocalDateTime.class) {
            ec.field.set(t, row.getLocalDateTime(c));
        } else if (fieldClazz == LocalDate.class) {
            ec.field.set(t, row.getLocalDate(c));
        } else if (fieldClazz == LocalTime.class) {
            ec.field.set(t, row.getLocalTime(c));
        } else if (fieldClazz == Character.class) {
            ec.field.set(t, row.getChar(c));
        } else if (fieldClazz == Byte.class) {
            ec.field.set(t, row.getByte(c));
        } else if (fieldClazz == Short.class) {
            ec.field.set(t, row.getShort(c));
        } else if (fieldClazz == Character.TYPE) {
            Character v = row.getChar(c);
            ec.field.set(t, Character.valueOf(v != null ? v.charValue() : (char)'\u0000'));
        } else if (fieldClazz == Byte.TYPE) {
            Byte v = row.getByte(c);
            ec.field.set(t, v != null ? v : (byte)0);
        } else if (fieldClazz == Short.TYPE) {
            Short v = row.getShort(c);
            ec.field.set(t, v != null ? v : (short)0);
        } else if (fieldClazz == RowNum.class) {
            ec.field.set(t, row.getRowNum());
        }
    }

    protected void methodPut(int i, Row row, Object t) throws IllegalAccessException, InvocationTargetException {
        ListSheet.EntryColumn ec = this.columns[i];
        int c = ec.colIndex;
        Class fieldClazz = ec.clazz;
        if (ec.converter != null) {
            ec.method.invoke(t, ec.converter.reversion(row.getString(c), fieldClazz));
        } else if (fieldClazz == String.class) {
            ec.method.invoke(t, row.getString(c));
        } else if (fieldClazz == Integer.class) {
            ec.method.invoke(t, row.getInt(c));
        } else if (fieldClazz == Long.class) {
            ec.method.invoke(t, row.getLong(c));
        } else if (fieldClazz == java.util.Date.class || fieldClazz == Date.class) {
            ec.method.invoke(t, row.getDate(c));
        } else if (fieldClazz == Timestamp.class) {
            ec.method.invoke(t, row.getTimestamp(c));
        } else if (fieldClazz == Double.class) {
            ec.method.invoke(t, row.getDouble(c));
        } else if (fieldClazz == Float.class) {
            ec.method.invoke(t, row.getFloat(c));
        } else if (fieldClazz == Boolean.class) {
            ec.method.invoke(t, row.getBoolean(c));
        } else if (fieldClazz == BigDecimal.class) {
            ec.method.invoke(t, row.getDecimal(c));
        } else if (fieldClazz == Integer.TYPE) {
            Integer v = row.getInt(c);
            ec.method.invoke(t, v != null ? v : 0);
        } else if (fieldClazz == Long.TYPE) {
            Long v = row.getLong(c);
            ec.method.invoke(t, v != null ? v : 0L);
        } else if (fieldClazz == Double.TYPE) {
            Double v = row.getDouble(c);
            ec.method.invoke(t, v != null ? v : 0.0);
        } else if (fieldClazz == Float.TYPE) {
            Float v = row.getFloat(c);
            ec.method.invoke(t, Float.valueOf(v != null ? v.floatValue() : 0.0f));
        } else if (fieldClazz == Boolean.TYPE) {
            Boolean v = row.getBoolean(c);
            ec.method.invoke(t, v != null ? v : false);
        } else if (fieldClazz == Time.class) {
            ec.method.invoke(t, row.getTime(c));
        } else if (fieldClazz == LocalDateTime.class) {
            ec.method.invoke(t, row.getLocalDateTime(c));
        } else if (fieldClazz == LocalDate.class) {
            ec.method.invoke(t, row.getLocalDate(c));
        } else if (fieldClazz == LocalTime.class) {
            ec.method.invoke(t, row.getLocalTime(c));
        } else if (fieldClazz == Character.class) {
            ec.method.invoke(t, row.getChar(c));
        } else if (fieldClazz == Byte.class) {
            ec.method.invoke(t, row.getByte(c));
        } else if (fieldClazz == Short.class) {
            ec.method.invoke(t, row.getShort(c));
        } else if (fieldClazz == Character.TYPE) {
            Character v = row.getChar(c);
            ec.method.invoke(t, Character.valueOf(v != null ? v.charValue() : (char)'\u0000'));
        } else if (fieldClazz == Byte.TYPE) {
            Byte v = row.getByte(c);
            ec.method.invoke(t, v != null ? v : (byte)0);
        } else if (fieldClazz == Short.TYPE) {
            Short v = row.getShort(c);
            ec.method.invoke(t, v != null ? v : (short)0);
        } else if (fieldClazz == RowNum.class) {
            ec.method.invoke(t, row.getRowNum());
        }
    }

    protected boolean ignoreColumn(AccessibleObject ao) {
        return ao.getAnnotation(IgnoreImport.class) != null;
    }

    protected Map<String, Method> attachOtherColumn(Class<?> clazz) {
        Method[] writeMethods;
        try {
            writeMethods = (this.option & 1) == 1 ? ReflectUtil.listDeclaredMethods(clazz) : ReflectUtil.listDeclaredMethods(clazz, method -> method.getAnnotation(ExcelColumn.class) != null || method.getAnnotation(RowNum.class) != null);
        }
        catch (IntrospectionException e) {
            this.LOGGER.warn("Get [" + clazz + "] read declared failed.", (Throwable)e);
            return Collections.emptyMap();
        }
        return Arrays.stream(writeMethods).filter(m -> m.getParameterCount() == 1).collect(Collectors.toMap(a -> {
            String k = a.getName();
            return k.startsWith("set") ? StringUtil.lowFirstKey(k.substring(3)) : k;
        }, a -> a, (a, b) -> b));
    }

    protected ListSheet.EntryColumn createColumn(AccessibleObject ao) {
        if (this.ignoreColumn(ao)) {
            return null;
        }
        ao.setAccessible(true);
        ExcelColumns cs = ao.getAnnotation(ExcelColumns.class);
        if (cs != null) {
            ExcelColumn[] ecs = cs.value();
            ListSheet.EntryColumn root = null;
            for (int i = Math.max(0, ecs.length - this.headRows); i < ecs.length; ++i) {
                ListSheet.EntryColumn column = this.createColumnByAnnotation(ecs[i]);
                if (root == null) {
                    root = column;
                    continue;
                }
                root.addSubColumn(column);
            }
            return root;
        }
        ExcelColumn ec = ao.getAnnotation(ExcelColumn.class);
        if (ec != null) {
            return this.createColumnByAnnotation(ec);
        }
        RowNum rowNum = ao.getAnnotation(RowNum.class);
        if (rowNum != null) {
            return this.createColumnByAnnotation(rowNum);
        }
        ListSheet.EntryColumn column = null;
        if ((this.option & 1) == 1) {
            if (Field.class.isAssignableFrom(ao.getClass())) {
                Field f = (Field)ao;
                column = new ListSheet.EntryColumn(f.getName());
                column.field = f;
                column.clazz = f.getType();
            } else if (Method.class.isAssignableFrom(ao.getClass())) {
                Method m = (Method)ao;
                String k = m.getName();
                column = new ListSheet.EntryColumn(k.startsWith("set") ? StringUtil.lowFirstKey(k.substring(3)) : k);
                column.method = m;
                if (m.getParameterCount() == 1) {
                    column.clazz = m.getParameterTypes()[0];
                }
            }
        }
        return column;
    }

    protected ListSheet.EntryColumn createColumnByAnnotation(Annotation anno) {
        ListSheet.EntryColumn column = null;
        if (anno instanceof ExcelColumn) {
            ExcelColumn ec = (ExcelColumn)anno;
            column = new ListSheet.EntryColumn(ec.value());
            column.setColIndex(ec.colIndex());
            if (ec.hide()) {
                column.hide();
            }
            if (!Converter.None.class.isAssignableFrom(ec.converter())) {
                try {
                    column.setConverter(ec.converter().newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.LOGGER.warn("Construct {} error occur, it will be ignore.", ec.converter(), (Object)e);
                }
            }
        } else if (anno instanceof RowNum) {
            column = new ListSheet.EntryColumn("", RowNum.class);
        }
        return column;
    }

    protected void mergeCellsIfNull(List<Dimension> mergeCells, Row[] rows) {
        if (mergeCells == null || mergeCells.isEmpty()) {
            return;
        }
        int fr = rows[0].getRowNum();
        int lr = rows[rows.length - 1].getRowNum();
        Map<Long, Dimension> map = mergeCells.stream().filter(m -> m.getLastRow() >= fr && m.getFirstRow() <= lr).collect(Collectors.toMap(a -> (long)a.firstRow << 16 | (long)a.firstColumn, a -> a, (a, b) -> a));
        if (map.isEmpty()) {
            return;
        }
        for (int r = 0; r < rows.length; ++r) {
            Row row = rows[r];
            int i = row.fc;
            while (i < row.lc) {
                Cell cell = row.cells[i];
                Dimension d = map.get((long)row.getRowNum() << 16 | (long)cell.i);
                if (d != null) {
                    Cell copyCell = new Cell();
                    copyCell.from(cell);
                    if (d.lastColumn > row.lc) {
                        row.cells = row.copyCells(d.lastColumn);
                        row.lc = d.lastColumn;
                    }
                    int b2 = d.lastRow - row.getRowNum();
                    int c = Math.min(r + b2, rows.length);
                    if (b2 > 0) {
                        for (int a2 = r; a2 < c; ++a2) {
                            Row t = rows[a2];
                            int j = d.firstColumn - 1;
                            while (j < d.lastColumn) {
                                t.cells[j++].setString(null);
                            }
                        }
                    }
                    Row lastRow = rows[c];
                    for (int j = d.firstColumn - 1; j < d.lastColumn; ++j) {
                        lastRow.cells[i++].from(copyCell);
                    }
                    continue;
                }
                ++i;
            }
        }
    }

    public HeaderRow setOptions(int option) {
        this.option = option;
        if (this.mapping != null && (option & 6) > 0) {
            HashMap<String, Integer> m = new HashMap<String, Integer>(this.mapping.size());
            for (Map.Entry<String, Integer> entry : this.mapping.entrySet()) {
                m.put(this.makeKey(entry.getKey()), entry.getValue());
            }
            this.mapping = m;
        }
        return this;
    }

    protected String makeKey(String key) {
        if ((this.option & 4) == 4) {
            key = StringUtil.toCamelCase(key);
        }
        if ((this.option & 2) == 2) {
            key = key.toLowerCase();
        }
        return key;
    }
}

