/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.validation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.validation.Validation;

public class ListValidation<T>
extends Validation {
    public List<T> options;
    public Dimension referer;

    public ListValidation<T> in(List<T> options) {
        this.options = options;
        return this;
    }

    @SafeVarargs
    public final ListValidation<T> in(T ... options) {
        this.options = Arrays.asList(options);
        return this;
    }

    public ListValidation<T> in(Dimension referer) {
        this.referer = referer;
        return this;
    }

    @Override
    public String getType() {
        return "list";
    }

    @Override
    public String validationFormula() {
        return "<formula1>\"" + (this.options != null ? this.options.stream().map(String::valueOf).collect(Collectors.joining(",")) : this.referer) + "\"</formula1>";
    }
}

