/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.annotation.TopNS;
import org.ttzero.excel.entity.Comments;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.TooManyColumnsException;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.e7.XMLWorksheetWriter;
import org.ttzero.excel.entity.style.Border;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.NumFmt;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.processor.ConversionProcessor;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"", "r"}, value="worksheet", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main", "http://schemas.openxmlformats.org/officeDocument/2006/relationships"})
public abstract class Sheet
implements Cloneable,
Storable {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Workbook workbook;
    protected String name;
    protected org.ttzero.excel.entity.Column[] columns;
    protected WaterMark waterMark;
    protected RelManager relManager;
    protected int id;
    protected Comments comments;
    protected int autoSize;
    protected double width = 20.0;
    protected int rows;
    protected boolean hidden;
    protected int headStyleIndex = -1;
    protected int headStyle;
    protected int autoOdd = -1;
    protected int oddFill;
    protected boolean copySheet;
    protected int copyCount;
    protected RowBlock rowBlock;
    protected IWorksheetWriter sheetWriter;
    protected boolean headerReady;
    protected boolean shouldClose = true;
    protected ICellValueAndStyle cellValueAndStyle;
    protected int forceExport;
    protected int nonHeader = -1;
    private int rowLimit;
    protected Map<String, Object> extProp = new HashMap<String, Object>();
    protected int extPropMark;
    private static final ThreadLocal<char[][]> cache = ThreadLocal.withInitial(() -> new char[][]{{'A'}, {'A', 'A'}, {'A', 'A', 'A'}});

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setSheetWriter(IWorksheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
    }

    public void setCellValueAndStyle(ICellValueAndStyle cellValueAndStyle) {
        this.cellValueAndStyle = cellValueAndStyle;
    }

    public Sheet() {
        this(null);
    }

    public Sheet(String name) {
        this.name = name;
        this.relManager = new RelManager();
    }

    public Sheet(String name, org.ttzero.excel.entity.Column ... columns) {
        this(name, (WaterMark)null, columns);
    }

    public Sheet(String name, WaterMark waterMark, org.ttzero.excel.entity.Column ... columns) {
        this.name = name;
        this.columns = columns;
        this.waterMark = waterMark;
        this.relManager = new RelManager();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet setWorkbook(Workbook workbook) {
        this.workbook = workbook;
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].styles = workbook.getStyles();
            }
        }
        return this;
    }

    public void what(String code) {
        this.workbook.what(code);
    }

    public void what(String code, String ... args) {
        this.workbook.what(code, args);
    }

    public SharedStrings getSst() {
        return this.workbook.getSst();
    }

    public double getDefaultWidth() {
        return this.width;
    }

    public Sheet autoSize() {
        this.autoSize = 1;
        return this;
    }

    public Sheet fixSize() {
        this.autoSize = 2;
        return this;
    }

    public Sheet fixSize(double width) {
        this.autoSize = 2;
        this.width = width;
        if (this.headerReady) {
            for (org.ttzero.excel.entity.Column hc : this.columns) {
                hc.setWidth(width);
            }
        }
        return this;
    }

    public int getAutoSize() {
        return this.autoSize;
    }

    public boolean isAutoSize() {
        return this.autoSize == 1;
    }

    public Sheet cancelOddStyle() {
        this.autoOdd = 1;
        return this;
    }

    public int getAutoOdd() {
        return this.autoOdd;
    }

    public Sheet setAutoOdd(int autoOdd) {
        this.autoOdd = autoOdd;
        return this;
    }

    public Sheet setOddFill(Fill fill) {
        this.oddFill = this.workbook.getStyles().addFill(fill);
        return this;
    }

    public int getOddFill() {
        return this.oddFill;
    }

    public String getName() {
        return this.name;
    }

    public Sheet setName(String name) {
        this.name = name;
        return this;
    }

    public Comments getComments() {
        return this.comments;
    }

    public Comments createComments() {
        if (this.comments == null) {
            this.comments = new Comments(this.id, this.workbook.getCreator());
            this.addRel(new Relationship("../drawings/vmlDrawing" + this.id + ".vml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing"));
            this.addRel(new Relationship("../comments" + this.id + ".xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments"));
        }
        return this.comments;
    }

    protected org.ttzero.excel.entity.Column[] getHeaderColumns() {
        if (!this.headerReady && this.columns == null) {
            this.columns = new org.ttzero.excel.entity.Column[0];
        }
        return this.columns;
    }

    public org.ttzero.excel.entity.Column[] getAndSortHeaderColumns() {
        if (!this.headerReady) {
            this.columns = this.getHeaderColumns();
            this.resetCommonProperties(this.columns);
            this.sortColumns(this.columns);
            for (int i = 0; i < this.columns.length; ++i) {
                if (i > 0 && this.columns[i - 1].colIndex >= this.columns[i].colIndex) {
                    this.columns[i].colIndex = this.columns[i - 1].colIndex + 1;
                    continue;
                }
                if (this.columns[i].colIndex <= i) {
                    this.columns[i].colIndex = i + 1;
                    continue;
                }
                ++this.columns[i].colIndex;
            }
            this.checkColumnLimit();
            this.headerReady |= this.columns.length > 0;
            this.markExtProp();
        }
        return this.columns;
    }

    protected void resetCommonProperties(org.ttzero.excel.entity.Column[] columns) {
        for (org.ttzero.excel.entity.Column column : columns) {
            if (column == null || column.styles != null) continue;
            column.styles = this.workbook.getStyles();
        }
    }

    protected void sortColumns(org.ttzero.excel.entity.Column[] columns) {
        if (columns.length <= 1) {
            return;
        }
        int j = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].colIndex < 0) continue;
            int n = this.search(columns, j, columns[i].colIndex);
            if (n < i) {
                this.insert(columns, n, i);
            }
            ++j;
        }
        if (j == columns.length) {
            return;
        }
        int n = columns[0].colIndex;
        int i = 0;
        while (i < columns.length && j < columns.length) {
            if (n > i) {
                int k = Math.min(n - i, columns.length - j);
                while (k > 0) {
                    this.insert(columns, i++, j);
                    --k;
                    ++j;
                }
            } else {
                ++i;
            }
            if (i >= columns.length) continue;
            n = columns[i].colIndex;
        }
    }

    protected int search(org.ttzero.excel.entity.Column[] columns, int n, int k) {
        int i;
        for (i = 0; i < n && columns[i].colIndex <= k; ++i) {
        }
        return i;
    }

    private void insert(org.ttzero.excel.entity.Column[] columns, int n, int k) {
        org.ttzero.excel.entity.Column t = columns[k];
        System.arraycopy(columns, n, columns, n + 1, k - n);
        columns[n] = t;
    }

    public Sheet setColumns(org.ttzero.excel.entity.Column[] columns) {
        this.columns = columns;
        return this;
    }

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public Sheet setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Sheet hidden() {
        this.hidden = true;
        return this;
    }

    public Sheet forceExport() {
        this.forceExport = 1;
        return this;
    }

    public Sheet cancelForceExport() {
        this.forceExport = 2;
        return this;
    }

    public int getForceExport() {
        return this.forceExport;
    }

    public void close() throws IOException {
        if (this.sheetWriter != null) {
            this.sheetWriter.close();
        }
    }

    @Override
    public void writeTo(Path path) throws IOException {
        if (this.sheetWriter == null) {
            throw new ExcelWriteException("Worksheet writer is not instanced.");
        }
        if (!this.headerReady) {
            this.getAndSortHeaderColumns();
        }
        if (this.rowBlock == null) {
            this.rowBlock = new RowBlock(this.getRowBlockSize());
        } else {
            this.rowBlock.reopen();
        }
        if (!this.copySheet) {
            this.paging();
        }
        this.sheetWriter.writeTo(path);
    }

    protected void paging() {
    }

    public Sheet addRel(Relationship rel) {
        this.relManager.add(rel);
        return this;
    }

    public Relationship findRel(String key) {
        return this.relManager.likeByTarget(key);
    }

    public String getFileName() {
        return "sheet" + this.id + this.cellValueAndStyle.getFileSuffix();
    }

    public Sheet setHeadStyle(Font font, Fill fill, Border border) {
        return this.setHeadStyle(null, font, fill, border, 0, 6);
    }

    public Sheet setHeadStyle(Font font, Fill fill, Border border, int vertical, int horizontal) {
        return this.setHeadStyle(null, font, fill, border, vertical, horizontal);
    }

    public Sheet setHeadStyle(NumFmt numFmt, Font font, Fill fill, Border border, int vertical, int horizontal) {
        Styles styles = this.workbook.getStyles();
        this.headStyle = (numFmt != null ? styles.addNumFmt(numFmt) : 0) | (font != null ? styles.addFont(font) : 0) | (fill != null ? styles.addFill(fill) : 0) | (border != null ? styles.addBorder(border) : 0) | vertical | horizontal;
        this.headStyleIndex = styles.of(this.headStyle);
        return this;
    }

    public Sheet setHeadStyle(int style) {
        this.headStyle = style;
        this.headStyleIndex = this.workbook.getStyles().of(style);
        return this;
    }

    public Sheet setHeadStyleIndex(int styleIndex) {
        this.headStyleIndex = styleIndex;
        this.headStyle = this.workbook.getStyles().getStyleByIndex(styleIndex);
        return this;
    }

    public int getHeadStyle() {
        return this.headStyle;
    }

    public int getHeadStyleIndex() {
        return this.headStyleIndex;
    }

    public int buildHeadStyle(String fontColor, String fillBgColor) {
        Styles styles = this.workbook.getStyles();
        Font font = new Font(this.workbook.getI18N().getOrElse("local-font-family", "Arial"), 12, 2, Styles.toColor(fontColor));
        return styles.addFont(font) | styles.addFill(Fill.parse(fillBgColor)) | styles.addBorder(Border.parse("thin black")) | 0 | 6;
    }

    public int defaultHeadStyle() {
        return this.headStyle != 0 ? this.headStyle : (this.headStyle = this.buildHeadStyle("#ffffff", "#666699"));
    }

    public int defaultHeadStyleIndex() {
        if (this.headStyleIndex == -1) {
            this.setHeadStyle(this.buildHeadStyle("#ffffff", "#666699"));
        }
        return this.headStyleIndex;
    }

    protected static boolean nonOrIntDefault(int style) {
        return style == -1 || style == Styles.defaultIntBorderStyle() || style == Styles.defaultIntStyle();
    }

    public int size() {
        return -1;
    }

    public RowBlock nextBlock() {
        this.rowBlock.clear();
        if (this.columns.length > 0) {
            this.resetBlockData();
        }
        return this.rowBlock.flip();
    }

    public int getRowBlockSize() {
        return 32;
    }

    public void afterSheetAccess(Path workSheetPath) throws IOException {
        if (this.sheetWriter instanceof XMLWorksheetWriter) {
            this.relManager.write(workSheetPath, this.getFileName());
        }
    }

    protected String getCopySheetName() {
        int sub = this.copyCount;
        String _name = this.name;
        int i = this.name.lastIndexOf(40);
        if (i > 0) {
            int fs = Integer.parseInt(this.name.substring(i + 1, this.name.lastIndexOf(41)));
            _name = this.name.substring(0, this.name.charAt(i - 1) == ' ' ? i - 1 : i);
            if (++fs > sub) {
                sub = fs;
            }
        }
        return _name + " (" + sub + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sheet clone() {
        Sheet copy = null;
        try {
            copy = (Sheet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(bos);
                oos.writeObject(this);
                ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
                copy = (Sheet)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e1) {
                try {
                    try {
                        copy = (Sheet)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    FileUtil.close(oos);
                    FileUtil.close(ois);
                    throw throwable;
                }
                FileUtil.close(oos);
                FileUtil.close(ois);
            }
            FileUtil.close(oos);
            FileUtil.close(ois);
        }
        if (copy != null) {
            copy.copyCount = ++this.copyCount;
            copy.name = this.getCopySheetName();
            copy.relManager = this.relManager.deepClone();
            copy.sheetWriter = this.sheetWriter.clone().setWorksheet(copy);
            copy.copySheet = true;
            copy.rows = 0;
        }
        return copy;
    }

    public void checkColumnLimit() {
        boolean noneHeader;
        int b;
        int a = this.columns.length > 0 ? this.columns[this.columns.length - 1].colIndex : 0;
        if (a > (b = this.sheetWriter.getColumnLimit())) {
            throw new TooManyColumnsException(a, b);
        }
        boolean bl = noneHeader = this.columns == null || this.columns.length == 0;
        if (!noneHeader) {
            int n = 0;
            for (org.ttzero.excel.entity.Column column : this.columns) {
                if (!StringUtil.isEmpty(column.name)) continue;
                ++n;
            }
            boolean bl2 = noneHeader = n == this.columns.length;
        }
        if (noneHeader) {
            if (this.rows > 0) {
                --this.rows;
            }
            this.ignoreHeader();
        } else {
            this.nonHeader = 0;
        }
        this.rowLimit = this.sheetWriter.getRowLimit() - (this.nonHeader ^ 1);
    }

    public boolean hasHeaderColumns() {
        return this.columns != null && this.columns.length > 0;
    }

    public static char[] int2Col(int n) {
        char[] c;
        char[][] cache_col = cache.get();
        int A = 65;
        if (n <= 26) {
            c = cache_col[0];
            c[0] = (char)(n - 1 + A);
        } else if (n <= 702) {
            int t = n / 26;
            int w = n % 26;
            if (w == 0) {
                --t;
                w = 26;
            }
            c = cache_col[1];
            c[0] = (char)(t - 1 + A);
            c[1] = (char)(w - 1 + A);
        } else {
            int tt = n / 26;
            int t = tt / 26;
            int w = n % 26;
            int m = tt % 26;
            if (w == 0) {
                --m;
                w = 26;
            }
            if (m <= 0) {
                --t;
                m += 26;
            }
            c = cache_col[2];
            c[0] = (char)(t - 1 + A);
            c[1] = (char)(m - 1 + A);
            c[2] = (char)(w - 1 + A);
        }
        return c;
    }

    public Sheet ignoreHeader() {
        this.nonHeader = 1;
        return this;
    }

    public int getNonHeader() {
        return this.nonHeader;
    }

    protected int getRowLimit() {
        return this.rowLimit;
    }

    public Sheet putExtProp(String key, Object value) {
        this.extProp.put(key, value);
        return this;
    }

    public Sheet putExtPropIfAbsent(String key, Object value) {
        this.extProp.putIfAbsent(key, value);
        return this;
    }

    public Sheet putAllExtProp(Map<String, Object> m) {
        this.extProp.putAll(m);
        return this;
    }

    public Object getExtPropValue(String key) {
        return this.extProp.get(key);
    }

    public Map<String, Object> getExtPropAsMap() {
        return new HashMap<String, Object>(this.extProp);
    }

    protected void markExtProp() {
        this.extPropMark |= this.getExtPropValue("freeze") != null ? 1 : 0;
        this.extPropMark |= this.getExtPropValue("style_design") != null ? 2 : 0;
    }

    protected abstract void resetBlockData();

    @Deprecated
    public static class Column
    extends org.ttzero.excel.entity.Column {
        public Column() {
        }

        public Column(String name, Class<?> clazz) {
            super(name, clazz);
        }

        public Column(String name, String key) {
            super(name, key);
        }

        public Column(String name, String key, Class<?> clazz) {
            super(name, key, clazz);
        }

        public Column(String name, Class<?> clazz, ConversionProcessor processor) {
            super(name, clazz, processor);
        }

        public Column(String name, String key, ConversionProcessor processor) {
            super(name, key, processor);
        }

        public Column(String name, Class<?> clazz, boolean share) {
            super(name, clazz, share);
        }

        public Column(String name, String key, boolean share) {
            super(name, key, share);
        }

        public Column(String name, Class<?> clazz, ConversionProcessor processor, boolean share) {
            super(name, clazz, processor, share);
        }

        public Column(String name, String key, Class<?> clazz, ConversionProcessor processor) {
            super(name, key, clazz, processor);
        }

        public Column(String name, String key, ConversionProcessor processor, boolean share) {
            super(name, key, processor, share);
        }

        public Column(String name, Class<?> clazz, int cellStyle) {
            super(name, clazz, cellStyle);
        }

        public Column(String name, String key, int cellStyle) {
            super(name, key, cellStyle);
        }

        public Column(String name, Class<?> clazz, int cellStyle, boolean share) {
            super(name, clazz, cellStyle, share);
        }

        public Column(String name, String key, int cellStyle, boolean share) {
            super(name, key, cellStyle, share);
        }

        @Deprecated
        public org.ttzero.excel.entity.Column setType(int type) {
            switch (type) {
                case 1: {
                    this.setNumFmt("0.00%_);[Red]-0.00% ");
                    break;
                }
                case 2: {
                    this.setNumFmt("\u00a50.00_);[Red]-\u00a50.00 ");
                    break;
                }
            }
            return this;
        }
    }
}

