/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.util.Iterator;
import org.ttzero.excel.entity.Row;

public class RowBlock
implements Iterator<Row> {
    private final Row[] rows;
    private int position;
    private int limit;
    private int total = 0;
    private boolean eof;
    private final int capacity;

    public RowBlock() {
        this(32);
    }

    public RowBlock(int capacity) {
        this.capacity = capacity;
        this.rows = new Row[capacity];
        for (int i = 0; i < capacity; ++i) {
            this.rows[i] = new Row();
        }
    }

    public final RowBlock reopen() {
        this.eof = false;
        this.total = 0;
        return this.clear();
    }

    public final RowBlock clear() {
        this.position = 0;
        this.limit = this.capacity;
        return this;
    }

    public int getTotal() {
        return this.total;
    }

    public void markEOF() {
        this.eof = true;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public final RowBlock flip() {
        if (this.position < this.capacity) {
            this.markEOF();
        }
        this.limit = this.position;
        this.total += this.limit;
        this.position = 0;
        return this;
    }

    public final int capacity() {
        return this.capacity;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.limit;
    }

    @Override
    public Row next() {
        return this.rows[this.position++];
    }

    public Row firstRow() {
        return this.rows[0];
    }

    public Row lastRow() {
        Row row;
        if (this.limit >= 1) {
            row = this.rows[this.limit - 1];
        } else {
            int i;
            int len = this.rows.length - 1;
            for (i = 0; i < len && this.rows[i] != null && this.rows[i].index < this.rows[i + 1].index; ++i) {
            }
            row = this.rows[i];
        }
        return row;
    }

    public Row get(int position) {
        return this.rows[position];
    }

    @Deprecated
    public int size() {
        return this.limit();
    }

    public int limit() {
        return this.limit;
    }

    public void position(int position) {
        if (position < 0 || position >= this.limit) {
            throw new ArrayIndexOutOfBoundsException("Index: " + position + ", Size: " + this.limit);
        }
        this.position = position;
    }

    public int position() {
        return this.position;
    }
}

