/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.csv.CSVWorkbookWriter;
import org.ttzero.excel.entity.e7.ContentType;
import org.ttzero.excel.entity.e7.XMLWorkbookWriter;
import org.ttzero.excel.entity.style.Fill;
import org.ttzero.excel.entity.style.PatternType;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.docProps.Core;
import org.ttzero.excel.manager.docProps.CustomProperties;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public class Workbook
implements Storable {
    private String name;
    private Sheet[] sheets;
    private WaterMark waterMark;
    private int size;
    private boolean autoSize;
    private String creator;
    private Core core;
    private String company;
    private Fill zebraFill;
    private BiConsumer<Sheet, Integer> progressConsumer;
    private SharedStrings sst;
    private Styles styles;
    private IWorkbookWriter workbookWriter;
    private int forceExport;
    private final ContentType contentType;
    private int drawingCounter;
    private int mediaCounter;
    private CustomProperties customProperties;

    public Workbook() {
        this(null);
    }

    public Workbook(String name) {
        this(name, null);
    }

    public Workbook(String name, String creator) {
        this.name = name;
        this.creator = creator;
        this.sheets = new Sheet[3];
        this.contentType = new ContentType();
    }

    public String getName() {
        return this.name;
    }

    public Workbook setName(String name) {
        this.name = name;
        return this;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getCompany() {
        return this.company;
    }

    public int getSize() {
        return this.size;
    }

    public Core getCore() {
        return this.core;
    }

    public Workbook setCore(Core core) {
        this.core = core;
        return this;
    }

    public SharedStrings getSharedStrings() {
        if (!(this.workbookWriter instanceof CSVWorkbookWriter) && this.sst == null) {
            this.sst = new SharedStrings();
        }
        return this.sst;
    }

    public final Sheet[] getSheets() {
        return Arrays.copyOf(this.sheets, this.size);
    }

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public Workbook setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
        return this;
    }

    public Workbook setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        return this;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public Workbook forceExport() {
        this.forceExport = 1;
        return this;
    }

    public int getForceExport() {
        return this.forceExport;
    }

    public Styles getStyles() {
        if (this.styles == null && !(this.workbookWriter instanceof CSVWorkbookWriter)) {
            this.styles = Styles.create();
        }
        return this.styles;
    }

    public Workbook setStyles(Styles styles) {
        this.styles = styles;
        return this;
    }

    public Workbook setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public Workbook setCompany(String company) {
        this.company = company;
        return this;
    }

    public Workbook setZebraLine(Fill fill) {
        this.zebraFill = fill;
        return this;
    }

    public Workbook cancelZebraLine() {
        this.zebraFill = null;
        return this;
    }

    public Workbook defaultZebraLine() {
        return this.setZebraLine(new Fill(PatternType.solid, new Color(233, 234, 236)));
    }

    public Fill getZebraFill() {
        return this.zebraFill;
    }

    public boolean hasZebraFill() {
        return this.zebraFill != null && this.zebraFill.getPatternType() != PatternType.none;
    }

    public IWorkbookWriter getWorkbookWriter() {
        if (this.workbookWriter == null) {
            this.workbookWriter = new XMLWorkbookWriter(this);
        }
        return this.workbookWriter;
    }

    public Workbook addSheet(Sheet sheet) {
        this.ensureCapacityInternal();
        sheet.setWorkbook(this);
        this.sheets[this.size++] = sheet;
        return this;
    }

    public Workbook insertSheet(int index, Sheet sheet) {
        this.ensureCapacityInternal();
        if (this.sheets[index] != null) {
            for (int _size = this.size; _size > index; --_size) {
                this.sheets[_size] = this.sheets[_size - 1];
                this.sheets[_size].setId(this.sheets[_size].getId() + 1);
            }
        }
        this.sheets[index] = sheet;
        sheet.setId(index + 1);
        sheet.setWorkbook(this);
        ++this.size;
        return this;
    }

    public Workbook remove(int index) {
        if (index < 0 || index >= this.size) {
            return this;
        }
        if (index == this.size - 1) {
            this.sheets[index] = null;
        } else {
            while (index < this.size - 1) {
                this.sheets[index] = this.sheets[index + 1];
                this.sheets[index].setId(this.sheets[index].getId() - 1);
                ++index;
            }
        }
        --this.size;
        return this;
    }

    public Sheet getSheetAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.sheets[index];
    }

    public Sheet getSheet(String sheetName) {
        if (StringUtil.isEmpty(sheetName)) {
            return null;
        }
        for (Sheet sheet : this.sheets) {
            if (!sheetName.equals(sheet.getName())) continue;
            return sheet;
        }
        return null;
    }

    public Workbook onProgress(BiConsumer<Sheet, Integer> progressConsumer) {
        this.progressConsumer = progressConsumer;
        return this;
    }

    public BiConsumer<Sheet, Integer> getProgressConsumer() {
        return this.progressConsumer;
    }

    public Workbook saveAsCSV() {
        this.workbookWriter = new CSVWorkbookWriter(this);
        return this;
    }

    public Workbook saveAsCSVWithBom() {
        this.workbookWriter = new CSVWorkbookWriter(this, true);
        return this;
    }

    public Workbook saveAsCSV(Charset charset) {
        this.workbookWriter = new CSVWorkbookWriter(this).setCharset(charset);
        return this;
    }

    public Workbook saveAsCSVWithBom(Charset charset) {
        this.workbookWriter = new CSVWorkbookWriter(this, true).setCharset(charset);
        return this;
    }

    private void ensureCapacityInternal() {
        if (this.size >= this.sheets.length) {
            this.sheets = Arrays.copyOf(this.sheets, this.size + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(Path path) throws IOException {
        this.checkAndInitWriter();
        if (!FileUtil.exists(path)) {
            String name = path.getFileName().toString();
            if (name.indexOf(46) > 0) {
                Path parent = path.getParent();
                FileUtil.mkdir(parent);
                this.writeTo(path.toFile());
                return;
            }
            FileUtil.mkdir(path);
        } else if (!Files.isDirectory(path, new LinkOption[0])) {
            this.writeTo(path.toFile());
            return;
        }
        try {
            this.workbookWriter.writeTo(path);
        }
        finally {
            this.workbookWriter.close();
        }
    }

    public void writeTo(OutputStream os) throws IOException, ExcelWriteException {
        this.checkAndInitWriter();
        try {
            this.workbookWriter.writeTo(os);
        }
        finally {
            this.workbookWriter.close();
        }
    }

    public void writeTo(File file) throws IOException, ExcelWriteException {
        this.checkAndInitWriter();
        if (!file.getParentFile().exists()) {
            FileUtil.mkdir(file.toPath().getParent());
        }
        try {
            this.workbookWriter.writeTo(file);
        }
        finally {
            this.workbookWriter.close();
        }
    }

    public Workbook setWorkbookWriter(IWorkbookWriter workbookWriter) {
        this.workbookWriter = workbookWriter;
        this.workbookWriter.setWorkbook(this);
        return this;
    }

    @Deprecated
    protected void init() {
        if (this.sst == null) {
            this.sst = new SharedStrings();
        }
        if (this.styles == null) {
            this.styles = Styles.create();
        }
    }

    protected void checkAndInitWriter() {
        if (this.workbookWriter == null) {
            this.workbookWriter = new XMLWorkbookWriter(this);
        }
    }

    public Workbook addContentType(ContentType.Type type) {
        this.contentType.add(type);
        return this;
    }

    public Workbook addContentTypeRel(Relationship rel) {
        this.contentType.addRel(rel);
        return this;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public int incrementDrawingCounter() {
        return ++this.drawingCounter;
    }

    public int getDrawingCounter() {
        return this.drawingCounter;
    }

    public int incrementMediaCounter() {
        return ++this.mediaCounter;
    }

    public int getMediaCounter() {
        return this.mediaCounter;
    }

    public Workbook putCustomProperty(String key, Object value) {
        if (this.customProperties == null) {
            this.customProperties = new CustomProperties();
        }
        this.customProperties.put(key, value);
        return this;
    }

    public Workbook putCustomProperties(Map<String, Object> properties) {
        if (this.customProperties == null) {
            this.customProperties = new CustomProperties();
        }
        this.customProperties.putAll(properties);
        return this;
    }

    public Object removeCustomProperty(String key) {
        return this.customProperties != null ? this.customProperties.remove(key) : null;
    }

    public CustomProperties getCustomProperties() {
        return this.customProperties;
    }

    public Workbook markAsReadOnly() {
        if (this.customProperties == null) {
            this.customProperties = new CustomProperties();
        }
        this.customProperties.markAsReadOnly();
        return this;
    }
}

