/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.csv;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ICellValueAndStyle;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.processor.StyleProcessor;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.util.DateUtil;

public class CSVCellValueAndStyle
implements ICellValueAndStyle {
    @Override
    public <T> void setStyleDesign(T o, Cell cell, Column hc, StyleProcessor<T> styleProcessor) {
    }

    @Override
    public void setCellValue(Row row, Cell cell, Object e, Column hc, Class<?> clazz, boolean hasConversion) {
        if (hasConversion) {
            this.conversion(row, cell, e, hc);
            return;
        }
        if (e == null) {
            this.setNullValue(row, cell, hc);
            return;
        }
        if (IWorksheetWriter.isString(clazz)) {
            cell.setString(e.toString());
        } else if (IWorksheetWriter.isDate(clazz)) {
            cell.setString(DateUtil.toDateString((Date)e));
        } else if (IWorksheetWriter.isDateTime(clazz)) {
            cell.setString(DateUtil.toString((Timestamp)e));
        } else if (IWorksheetWriter.isChar(clazz)) {
            cell.setChar(((Character)e).charValue());
        } else if (IWorksheetWriter.isShort(clazz)) {
            cell.setInt(((Short)e).shortValue());
        } else if (IWorksheetWriter.isInt(clazz)) {
            cell.setInt((Integer)e);
        } else if (IWorksheetWriter.isLong(clazz)) {
            cell.setLong((Long)e);
        } else if (IWorksheetWriter.isFloat(clazz)) {
            cell.setDouble(((Float)e).floatValue());
        } else if (IWorksheetWriter.isDouble(clazz)) {
            cell.setDouble((Double)e);
        } else if (IWorksheetWriter.isBool(clazz)) {
            cell.setBool((Boolean)e);
        } else if (IWorksheetWriter.isBigDecimal(clazz)) {
            cell.setDecimal((BigDecimal)e);
        } else if (IWorksheetWriter.isLocalDate(clazz)) {
            cell.setString(((LocalDate)e).toString());
        } else if (IWorksheetWriter.isLocalDateTime(clazz)) {
            cell.setString(DateUtil.LOCAL_DATE_TIME.format((LocalDateTime)e));
        } else if (IWorksheetWriter.isTime(clazz)) {
            cell.setString(DateTimeFormatter.ISO_TIME.format(((Time)e).toLocalTime()));
        } else if (IWorksheetWriter.isLocalTime(clazz)) {
            cell.setString(DateTimeFormatter.ISO_TIME.format((LocalTime)e));
        } else {
            cell.setString(e.toString());
        }
    }

    @Override
    public int getStyleIndex(Row row, Column hc, Object o) {
        return 0;
    }
}

