/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.SharedStrings;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.util.StringUtil;

public interface CalcSheet
extends Sheet {
    public static long[][] parseCalcChain(InputStream is) {
        Element calcChain;
        SAXReader reader = SAXReader.createDefault();
        try {
            calcChain = reader.read(is).getRootElement();
        }
        catch (DocumentException e) {
            ExcelReader.LOGGER.warn("Part of `calcChain` has be damaged, It will be ignore all formulas.");
            return null;
        }
        Iterator ite = calcChain.elementIterator();
        int i = 1;
        int n = 10;
        long[][] array = new long[n][];
        int[] indices = new int[n];
        while (ite.hasNext()) {
            long[] sub;
            Element e = (Element)ite.next();
            String si = e.attributeValue("i");
            String r = e.attributeValue("r");
            if (StringUtil.isNotEmpty(si)) {
                i = SharedStrings.toInt(si.toCharArray(), 0, si.length());
            }
            if (!StringUtil.isNotEmpty(r)) continue;
            if (n < i) {
                indices = Arrays.copyOf(indices, n <<= 1);
                long[][] _array = new long[n][];
                for (int j = 0; j < n; ++j) {
                    _array[j] = array[j];
                }
                array = _array;
            }
            if ((sub = array[i - 1]) == null) {
                array[i - 1] = sub = new long[10];
            }
            int n2 = i - 1;
            indices[n2] = indices[n2] + 1;
            if (indices[n2] > sub.length) {
                long[] _sub = new long[sub.length << 1];
                System.arraycopy(sub, 0, _sub, 0, sub.length);
                sub = _sub;
                array[i - 1] = _sub;
            }
            sub[indices[i - 1] - 1] = ExcelReader.coordinateToLong(r);
        }
        for (i = 0; i < n; ++i) {
            if (indices[i] > 0) {
                long[] a = Arrays.copyOf(array[i], indices[i]);
                Arrays.sort(a);
                array[i] = a;
                continue;
            }
            array[i] = null;
        }
        return array;
    }
}

