/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.CellType;

public class TypeCastException
extends IllegalArgumentException {
    public final int row;
    public final int col;
    public final CellType from;
    public final Class<?> to;

    public TypeCastException(int row, int col, CellType from, Class<?> to) {
        super("Can't cast " + (Object)((Object)from) + "to " + to + " in cell '" + new String(Sheet.int2Col(col)) + row + "'");
        this.row = row;
        this.col = col;
        this.from = from;
        this.to = to;
    }

    public TypeCastException(int row, int col, CellType from, Class<?> to, String message) {
        super(message);
        this.row = row;
        this.col = col;
        this.from = from;
        this.to = to;
    }

    public TypeCastException(int row, int col, CellType from, Class<?> to, String message, Throwable cause) {
        super(message, cause);
        this.row = row;
        this.col = col;
        this.from = from;
        this.to = to;
    }

    public TypeCastException(int row, int col, CellType from, Class<?> to, Throwable cause) {
        super(cause);
        this.row = row;
        this.col = col;
        this.from = from;
        this.to = to;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public CellType getFrom() {
        return this.from;
    }

    public Class<?> getTo() {
        return this.to;
    }

    public String toColumnLetter() {
        return new String(Sheet.int2Col(this.col));
    }
}

