/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

public class StringUtil {
    public static final String EMPTY = "";

    private StringUtil() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static int indexOf(String[] array, String v) {
        if (v != null) {
            for (int i = 0; i < array.length; ++i) {
                if (!v.equals(array[i])) continue;
                return i;
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        }
        return -1;
    }

    public static String uppFirstKey(String key) {
        char first = key.charAt(0);
        if (first >= 'a' && first <= 'z') {
            char[] _v = key.toCharArray();
            _v[0] = (char)(_v[0] - 32);
            return new String(_v);
        }
        return key;
    }

    public static String lowFirstKey(String key) {
        char first = key.charAt(0);
        if (first >= 'A' && first <= 'Z') {
            char[] _v = key.toCharArray();
            _v[0] = (char)(_v[0] + 32);
            return new String(_v);
        }
        return key;
    }

    public static String toCamelCase(String name) {
        int i;
        if (name.indexOf(95) < 0) {
            return name.toLowerCase();
        }
        char[] oldValues = name.toLowerCase().toCharArray();
        int len = oldValues.length;
        int idx = i = 1;
        int n = len - 1;
        while (i < n) {
            char c = oldValues[i];
            char cc = oldValues[i + 1];
            if (c == '_') {
                if (cc != '_') {
                    ++i;
                    oldValues[idx++] = cc >= 'a' && cc <= 'z' ? (char)(cc - 32) : cc;
                }
            } else {
                oldValues[idx++] = c;
            }
            ++i;
        }
        if (i < len) {
            oldValues[idx++] = oldValues[i];
        }
        return new String(oldValues, 0, idx);
    }

    public static void swap(String[] values, int a, int b) {
        String t = values[a];
        values[a] = values[b];
        values[b] = t;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static String formatBinarySize(long size) {
        long kb = 1024L;
        long mb = kb << 10;
        long gb = mb << 10;
        String s = size >= gb ? String.format("%.2fGB", (double)size / (double)gb) : (size >= mb ? String.format("%.2fMB", (double)size / (double)mb) : (size >= kb ? String.format("%.2fKB", (double)size / (double)kb) : String.format("%dB", size)));
        return s.replace(".00", EMPTY);
    }

    public static String timeToString(long t) {
        int n = (int)t / 1000;
        int h = n / 3600;
        int m = (n - h * 3600) / 60;
        int s = n - h * 3600 - m * 60;
        int ms = (int)(t - (long)(n * 1000));
        return (h > 0 ? h + "h" : EMPTY) + (m > 0 ? (h > 0 ? ":" : EMPTY) + m + "m" : EMPTY) + (s > 0 ? (h + m > 0 ? ":" : EMPTY) + s + "s" : EMPTY) + (ms > 0 ? (h + m + s > 0 ? ":" : EMPTY) + ms + "ms" : (h + m + s > 0 ? EMPTY : "0ms"));
    }

    public static int indexOf(String str, int ch, int fromIndex, int toIndex) {
        int max = Math.min(str.length(), toIndex);
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        char[] value = str.toCharArray();
        if (ch < 65536) {
            for (int i = fromIndex; i < max; ++i) {
                if (value[i] != ch) continue;
                return i;
            }
            return -1;
        }
        return StringUtil.indexOfSupplementary(value, ch, fromIndex, max);
    }

    private static int indexOfSupplementary(char[] value, int ch, int fromIndex, int toIndex) {
        if (Character.isValidCodePoint(ch)) {
            char hi = Character.highSurrogate(ch);
            char lo = Character.lowSurrogate(ch);
            int max = toIndex - 1;
            for (int i = fromIndex; i < max; ++i) {
                if (value[i] != hi || value[i + 1] != lo) continue;
                return i;
            }
        }
        return -1;
    }
}

