/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity.e7;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.Comments;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.IWorkbookWriter;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.entity.SharedStrings;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.entity.e7.ContentType;
import org.ttzero.excel.entity.e7.XMLCellValueAndStyle;
import org.ttzero.excel.entity.e7.XMLWorksheetWriter;
import org.ttzero.excel.entity.e7.XMLZebraLineCellValueAndStyle;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.manager.docProps.App;
import org.ttzero.excel.manager.docProps.Core;
import org.ttzero.excel.manager.docProps.CustomProperties;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;
import org.ttzero.excel.util.ZipUtil;

@TopNS(prefix={"", "r"}, value="workbook", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main", "http://schemas.openxmlformats.org/officeDocument/2006/relationships"})
public class XMLWorkbookWriter
implements IWorkbookWriter {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected Workbook workbook;
    protected final RelManager relManager;

    public XMLWorkbookWriter() {
        this.relManager = new RelManager();
    }

    public XMLWorkbookWriter(Workbook workbook) {
        this.workbook = workbook;
        this.relManager = new RelManager();
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public RelManager getRelManager() {
        return this.relManager;
    }

    @Override
    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    @Override
    public String getSuffix() {
        return ".xlsx";
    }

    @Override
    public void writeTo(Path path) throws IOException {
        Path zip = this.createTemp();
        this.reMarkPath(zip, path);
        FileUtil.rm(zip);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        Path zip = this.createTemp();
        Files.copy(zip, os);
        FileUtil.rm(zip);
    }

    @Override
    public void writeTo(File file) throws IOException {
        Path zip = this.createTemp();
        FileUtil.cp(zip, file);
        FileUtil.rm(zip);
    }

    protected void writeGlobalAttribute(Path root) throws IOException {
        ContentType contentType = this.workbook.getContentType();
        contentType.add(new ContentType.Default("application/vnd.openxmlformats-package.relationships+xml", "rels"));
        contentType.add(new ContentType.Default("application/xml", "xml"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", "/xl/workbook.xml"));
        contentType.addRel(new Relationship("xl/workbook.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"));
        this.writeApp(root);
        this.writeCore(root);
        this.writeCustomProperties(root);
        Path themeP = root.resolve("theme");
        if (!FileUtil.exists(themeP)) {
            Files.createDirectory(themeP, new FileAttribute[0]);
        }
        try {
            InputStream theme = this.getClass().getClassLoader().getResourceAsStream("template/theme1.xml");
            if (theme != null) {
                Files.copy(theme, themeP.resolve("theme1.xml"), new CopyOption[0]);
            }
        }
        catch (IOException theme) {
            // empty catch block
        }
        this.relManager.add(new Relationship("theme/theme1.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.theme+xml", "/xl/theme/theme1.xml"));
        this.writeWorkbook(root);
        this.workbook.getStyles().writeTo(root.resolve("styles.xml"));
        this.relManager.add(new Relationship("styles.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", "/xl/styles.xml"));
        try (SharedStrings sst = this.workbook.getSharedStrings();){
            sst.writeTo(root);
        }
        this.relManager.add(new Relationship("sharedStrings.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings"));
        contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", "/xl/sharedStrings.xml"));
        contentType.writeTo(root.getParent());
        TopNS topNS = this.getClass().getAnnotation(TopNS.class);
        String name = topNS != null ? topNS.value() : "workbook";
        this.relManager.write(root, name + ".xml");
    }

    protected void writeApp(Path root) throws IOException {
        App app = new App();
        if (StringUtil.isNotEmpty(this.workbook.getCompany())) {
            app.setCompany(this.workbook.getCompany());
        }
        Properties pom = IWorkbookWriter.pom();
        app.setApplication(pom.getProperty("groupId") + "." + pom.getProperty("artifactId"));
        app.setAppVersion(pom.getProperty("version"));
        int size = this.workbook.getSize();
        ArrayList<String> titleParts = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            titleParts.add(sheet.getName());
            this.relManager.add(new Relationship("worksheets/sheet" + sheet.getId() + ".xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet"));
        }
        app.setTitlePards(titleParts);
        app.writeTo(root.getParent().resolve("docProps/app.xml"));
        this.workbook.addContentType(new ContentType.Override("application/vnd.openxmlformats-officedocument.extended-properties+xml", "/docProps/app.xml")).addContentTypeRel(new Relationship("docProps/app.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties"));
    }

    protected void writeCore(Path root) throws IOException {
        Core core;
        Core core2 = core = this.workbook.getCore() != null ? this.workbook.getCore() : new Core();
        if (StringUtil.isEmpty(core.getCreator())) {
            if (this.workbook.getCreator() != null) {
                core.setCreator(this.workbook.getCreator());
            } else {
                core.setCreator(System.getProperty("user.name"));
            }
        }
        if (StringUtil.isEmpty(core.getTitle())) {
            core.setTitle(this.workbook.getName());
        }
        if (core.getCreated() == null) {
            core.setCreated(new Date());
        }
        if (core.getModified() == null) {
            core.setModified(new Date());
        }
        core.writeTo(root.getParent().resolve("docProps/core.xml"));
        this.workbook.addContentType(new ContentType.Override("application/vnd.openxmlformats-package.core-properties+xml", "/docProps/core.xml")).addContentTypeRel(new Relationship("docProps/core.xml", "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties"));
    }

    protected void writeCustomProperties(Path root) throws IOException {
        CustomProperties custom = this.workbook.getCustomProperties();
        if (custom != null && custom.hasProperty()) {
            custom.writeTo(root.getParent().resolve("docProps/custom.xml"));
            this.workbook.addContentType(new ContentType.Override("application/vnd.openxmlformats-officedocument.custom-properties+xml", "/docProps/custom.xml")).addContentTypeRel(new Relationship("docProps/custom.xml", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties"));
        }
    }

    @Deprecated
    protected void writeSelf(Path root) throws IOException {
        this.writeWorkbook(root);
    }

    protected void writeWorkbook(Path root) throws IOException {
        int i;
        boolean hasTopNs;
        DocumentFactory factory = DocumentFactory.getInstance();
        Element rootElement = null;
        String[] prefixs = null;
        String[] uris = null;
        String rootName = null;
        TopNS topNs = this.getClass().getAnnotation(TopNS.class);
        boolean bl = hasTopNs = topNs != null;
        if (hasTopNs) {
            prefixs = topNs.prefix();
            uris = topNs.uri();
            rootName = topNs.value();
            for (i = 0; i < prefixs.length; ++i) {
                if (!prefixs[i].isEmpty()) continue;
                rootElement = factory.createElement(rootName, uris[i]);
                break;
            }
        }
        if (rootElement == null) {
            if (hasTopNs) {
                rootElement = factory.createElement(rootName);
            } else {
                this.LOGGER.error("Workbook missing necessary information.");
                return;
            }
        }
        if (prefixs.length > 0) {
            for (i = 0; i < prefixs.length; ++i) {
                rootElement.add(Namespace.get((String)prefixs[i], (String)uris[i]));
            }
        }
        rootElement.addElement("bookViews").addElement("workbookView").addAttribute("activeTab", "0");
        Element sheetEle = rootElement.addElement("sheets");
        for (int i2 = 0; i2 < this.workbook.getSize(); ++i2) {
            Relationship rs;
            Sheet sheetInfo = this.workbook.getSheetAt(i2);
            Element st = sheetEle.addElement("sheet").addAttribute("sheetId", String.valueOf(sheetInfo.getId())).addAttribute("name", sheetInfo.getName());
            if (sheetInfo.isHidden()) {
                st.addAttribute("state", "hidden");
            }
            if ((rs = this.relManager.getByTarget("worksheets/sheet" + sheetInfo.getId() + ".xml")) == null) continue;
            st.addAttribute(QName.get((String)"id", (Namespace)Namespace.get((String)"r", (String)uris[StringUtil.indexOf(prefixs, "r")])), rs.getId());
        }
        Document doc = factory.createDocument(rootElement);
        FileUtil.writeToDiskNoFormat(doc, root.resolve(rootName + ".xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeWorksheets(Path root) throws IOException {
        this.LOGGER.debug("Start to write Sheet.");
        ContentType contentType = this.workbook.getContentType();
        for (int i = 0; i < this.workbook.getSize(); ++i) {
            WaterMark wm;
            Sheet sheet = this.workbook.getSheetAt(i);
            sheet.setId(i + 1);
            if (StringUtil.isEmpty(sheet.getName())) {
                sheet.setName("Sheet" + sheet.getId());
            }
            if (sheet.getSheetWriter() == null) {
                sheet.setSheetWriter(this.getWorksheetWriter(sheet));
            }
            if (this.workbook.isAutoSize() && sheet.getAutoSize() == 0) {
                sheet.autoSize();
            }
            if (this.workbook.getZebraFill() != null && sheet.getZebraFillStyle() < 0) {
                sheet.setZebraLine(this.workbook.getZebraFill());
            }
            if (sheet.getCellValueAndStyle() == null) {
                int zebraFillStyle = sheet.getZebraFillStyle();
                XMLCellValueAndStyle cvas = zebraFillStyle > 0 ? new XMLZebraLineCellValueAndStyle(zebraFillStyle) : new XMLCellValueAndStyle();
                sheet.setCellValueAndStyle(cvas);
            }
            if (this.workbook.getForceExport() > sheet.getForceExport() && ListSheet.class.isAssignableFrom(sheet.getClass())) {
                ((ListSheet)sheet).forceExport();
            }
            if (this.workbook.getProgressConsumer() != null && sheet.getProgressConsumer() == null) {
                sheet.onProgress(this.workbook.getProgressConsumer());
            }
            try {
                sheet.writeTo(root);
            }
            finally {
                sheet.close();
            }
            contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", "/xl/worksheets/sheet" + sheet.getId() + ".xml"));
            Comments comments = sheet.getComments();
            if (comments != null) {
                comments.writeTo(root);
                contentType.add(new ContentType.Override("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml", "/xl/comments" + sheet.getId() + ".xml"));
                contentType.add(new ContentType.Default("application/vnd.openxmlformats-officedocument.vmlDrawing", "vml"));
            }
            if ((wm = sheet.getWaterMark()) == null || !wm.canWrite()) continue;
            contentType.add(new ContentType.Default(wm.getContentType(), wm.getSuffix().substring(1)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Path createTemp() throws IOException, ExcelWriteException {
        Path root = null;
        try {
            root = FileUtil.mktmp("eec+");
            this.LOGGER.debug("Create temporary folder {}", (Object)root);
            Path xl = Files.createDirectory(root.resolve("xl"), new FileAttribute[0]);
            this.writeWorksheets(xl);
            this.writeGlobalAttribute(xl);
            this.LOGGER.debug("All sheets have completed writing, starting to compression ...");
            Path zipFile = ZipUtil.zipExcludeRoot(root, root);
            this.LOGGER.debug("Compression completed. {}", (Object)zipFile);
            Path path = zipFile;
            return path;
        }
        finally {
            if (root != null) {
                FileUtil.rm_rf(root);
            }
        }
    }

    protected void reMarkPath(Path zip, Path path) throws IOException {
        String name = this.workbook.getName();
        if (StringUtil.isEmpty(name)) {
            name = "\u65b0\u5efa\u6587\u4ef6";
        }
        Path resultPath = this.reMarkPath(zip, path, name);
        this.LOGGER.debug("Write completed. {}", (Object)resultPath);
    }

    @Override
    public void close() throws IOException {
        for (Sheet sheet : this.workbook.getSheets()) {
            if (sheet == null || sheet.getWaterMark() == null) continue;
            sheet.getWaterMark().delete();
        }
        if (this.workbook.getWaterMark() != null) {
            this.workbook.getWaterMark().delete();
        }
        this.workbook.getSharedStrings().close();
    }

    @Override
    public IWorksheetWriter getWorksheetWriter(Sheet sheet) {
        return new XMLWorksheetWriter(sheet);
    }
}

