/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.reader.ExcelReader;

public class Dimension {
    public final int firstRow;
    public final int lastRow;
    public final short firstColumn;
    public final short lastColumn;
    public final int width;
    public final int height;

    public Dimension(int firstRow, short firstColumn) {
        this(firstRow, firstColumn, firstRow, firstColumn);
    }

    public Dimension(int firstRow, short firstColumn, int lastRow, short lastColumn) {
        this.firstRow = Math.max(firstRow, 1);
        this.firstColumn = (short)Math.max(firstColumn, 1);
        this.lastRow = lastRow > 0 ? lastRow : this.firstRow;
        this.lastColumn = lastColumn > 0 ? lastColumn : this.firstColumn;
        this.width = this.lastColumn - this.firstColumn + 1;
        this.height = this.lastRow - this.firstRow + 1;
        if (this.width < 1 || this.height < 1) {
            throw new IllegalArgumentException("Dimension(firstRow:" + firstRow + ",firstColumn:" + firstColumn + ",lastRow=" + lastRow + ",lastColumn=" + lastColumn + ") contains invalid range");
        }
    }

    public static Dimension of(String range) {
        int i = range.indexOf(58);
        long f = 0L;
        long t = 0L;
        if (i < 0) {
            f = ExcelReader.coordinateToLong(range);
        } else if (i == 0) {
            t = ExcelReader.coordinateToLong(range.substring(i + 1));
        } else {
            f = ExcelReader.coordinateToLong(range.substring(0, i));
            t = ExcelReader.coordinateToLong(range.substring(i + 1));
        }
        return new Dimension((int)(f >> 16), (short)f, (int)(t >> 16), (short)t);
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public short getFirstColumn() {
        return this.firstColumn;
    }

    public short getLastColumn() {
        return this.lastColumn;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return Sheet.toCoordinate(this.firstRow, this.firstColumn) + (this.lastRow > this.firstRow || this.lastColumn > this.firstColumn ? ":" + Sheet.toCoordinate(this.lastRow, this.lastColumn) : "");
    }

    public boolean checkRange(int r, int c) {
        return r >= this.firstRow && r <= this.lastRow && c >= this.firstColumn && c <= this.lastColumn;
    }

    public int hashCode() {
        return (this.firstColumn << 24 | this.lastColumn) ^ (this.firstRow << 24 | this.lastRow);
    }

    public boolean equals(Object o) {
        if (o instanceof Dimension) {
            Dimension other = (Dimension)o;
            return other.firstRow == this.firstRow && other.firstColumn == this.firstColumn && other.lastRow == this.lastRow && other.lastColumn == this.lastColumn;
        }
        return false;
    }
}

