/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.reader;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ttzero.excel.entity.Relationship;
import org.ttzero.excel.manager.RelManager;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.reader.Drawings;
import org.ttzero.excel.reader.ExcelReadException;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.reader.Row;
import org.ttzero.excel.reader.Sheet;
import org.ttzero.excel.reader.XMLSheet;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public class XMLDrawings
implements Drawings {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final ExcelReader excelReader;
    protected List<Drawings.Picture> pictures;
    protected boolean parsed;

    public XMLDrawings(ExcelReader reader) {
        this.excelReader = reader;
    }

    @Override
    public List<Drawings.Picture> listPictures() {
        return this.parsed ? this.pictures : this.parse();
    }

    protected List<Drawings.Picture> parse() {
        List<Drawings.Picture> list;
        Path imagesPath;
        this.parsed = true;
        if (this.excelReader.sheets == null) {
            return null;
        }
        ZipFile zipFile = this.excelReader.zipFile;
        if (zipFile == null) {
            return null;
        }
        if (this.excelReader.tempDir == null) {
            try {
                this.excelReader.tempDir = FileUtil.mktmp("eec-");
            }
            catch (IOException e) {
                throw new ExcelReadException("Create temp directory failed.", e);
            }
        }
        if (!Files.exists(imagesPath = this.excelReader.tempDir.resolve("media"), new LinkOption[0])) {
            try {
                Files.createDirectory(imagesPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ExcelReadException("Create temp directory failed.", e);
            }
        }
        ArrayList<Drawings.Picture> pictures = new ArrayList<Drawings.Picture>();
        for (Sheet sheet : this.excelReader.sheets) {
            Map<String, Path> cellImagesMapper;
            XMLSheet xmlSheet = (XMLSheet)sheet;
            List<Relationship> list2 = xmlSheet.getRelManager().getAllByTypes("http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image");
            for (Relationship e : list2) {
                List<Drawings.Picture> subPictures;
                String target = e.getTarget();
                String type = e.getType();
                ZipEntry entry = ExcelReader.getEntry(zipFile, "xl/" + ExcelReader.toZipPath(target));
                if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image".equals(type)) {
                    Drawings.Picture picture = new Drawings.Picture();
                    pictures.add(picture);
                    picture.sheet = sheet;
                    picture.background = true;
                    try {
                        Path targetPath = imagesPath.resolve(target);
                        Files.copy(zipFile.getInputStream(entry), targetPath, StandardCopyOption.REPLACE_EXISTING);
                        picture.localPath = targetPath;
                    }
                    catch (IOException ex) {
                        this.LOGGER.error("Copy image into {} failed", (Object)target, (Object)ex);
                    }
                    continue;
                }
                if (!"http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing".equals(type) || (subPictures = this.parseDrawings(zipFile, entry, imagesPath)) == null) continue;
                for (Drawings.Picture picture : subPictures) {
                    picture.sheet = sheet;
                    pictures.add(picture);
                }
            }
            ZipEntry cellImagesEntry = ExcelReader.getEntry(zipFile, "xl/cellimages.xml");
            Map<String, Path> map = cellImagesMapper = cellImagesEntry != null ? this.listCellImages(zipFile, cellImagesEntry) : null;
            if (cellImagesMapper == null || cellImagesMapper.isEmpty()) continue;
            try {
                pictures.addAll(this.quickFindCellImages(sheet, cellImagesMapper));
            }
            catch (IOException e) {
                this.LOGGER.error("Parse build-in cell-images failed", (Throwable)e);
            }
        }
        if (!pictures.isEmpty()) {
            this.pictures = pictures;
            list = this.pictures;
        } else {
            list = null;
        }
        return list;
    }

    protected List<Drawings.Picture> parseDrawings(ZipFile zipFile, ZipEntry entry, Path imagesPath) {
        Document document;
        int i = entry.getName().lastIndexOf(47);
        String relsKey = i > 0 ? entry.getName().substring(0, i) + "/_rels" + entry.getName().substring(i) : ((i = entry.getName().lastIndexOf(92)) > 0 ? entry.getName().substring(0, i) + "\\_rels" + entry.getName().substring(i) : entry.getName());
        String key = relsKey + ".rels";
        ZipEntry entry1 = ExcelReader.getEntry(zipFile, key);
        if (entry1 == null) {
            return null;
        }
        SAXReader reader = SAXReader.createDefault();
        try {
            document = reader.read(zipFile.getInputStream(entry1));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [" + key + "]");
        }
        List list = document.getRootElement().elements();
        Relationship[] rels = new Relationship[list.size()];
        i = 0;
        for (Element e : list) {
            rels[i++] = new Relationship(e.attributeValue("Id"), e.attributeValue("Target"), e.attributeValue("Type"));
        }
        RelManager relManager = RelManager.of(rels);
        try {
            document = reader.read(zipFile.getInputStream(entry));
        }
        catch (IOException | DocumentException e) {
            throw new ExcelReadException("The file format is incorrect or corrupted. [" + entry.getName() + "]");
        }
        Element root = document.getRootElement();
        Namespace xdr = root.getNamespaceForPrefix("xdr");
        Namespace a = root.getNamespaceForPrefix("a");
        List elements = root.elements();
        ArrayList<Drawings.Picture> pictures = new ArrayList<Drawings.Picture>(elements.size());
        for (Element e : root.elements()) {
            Element extLst;
            String rot;
            Element xfrm;
            Namespace r;
            String embed;
            Relationship rel;
            Element blip;
            Element blipFill;
            Element pic = e.element(QName.get((String)"pic", (Namespace)xdr));
            if (pic == null || (blipFill = pic.element(QName.get((String)"blipFill", (Namespace)xdr))) == null || (blip = blipFill.element(QName.get((String)"blip", (Namespace)a))) == null || (rel = relManager.getById(embed = blip.attributeValue(QName.get((String)"embed", (Namespace)(r = blip.getNamespaceForPrefix("r")))))) == null || !"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image".equals(rel.getType())) continue;
            Drawings.Picture picture = new Drawings.Picture();
            pictures.add(picture);
            entry = ExcelReader.getEntry(zipFile, "xl/" + ExcelReader.toZipPath(rel.getTarget()));
            if (entry != null) {
                try {
                    Path targetPath = imagesPath.resolve(rel.getTarget());
                    Files.copy(zipFile.getInputStream(entry), targetPath, StandardCopyOption.REPLACE_EXISTING);
                    picture.localPath = targetPath;
                }
                catch (IOException targetPath) {
                    // empty catch block
                }
            }
            int[][] ft = XMLDrawings.parseDimension(e, xdr);
            picture.dimension = new Dimension(ft[0][2] + 1, (short)(ft[0][0] + 1), ft[1][2] + 1, (short)(ft[1][0] + 1));
            picture.padding = new short[]{(short)ft[0][3], (short)ft[1][1], (short)ft[1][3], (short)ft[0][1]};
            String editAs = e.attributeValue("editAs");
            int property = -1;
            if (StringUtil.isNotEmpty(editAs)) {
                switch (editAs) {
                    case "twoCell": {
                        property = 0;
                        break;
                    }
                    case "oneCell": {
                        property = 1;
                        break;
                    }
                    case "absolute": {
                        property = 2;
                        break;
                    }
                }
            }
            picture.property = property;
            Element spPr = pic.element(QName.get((String)"spPr", (Namespace)xdr));
            if (spPr != null && (xfrm = spPr.element(QName.get((String)"xfrm", (Namespace)a))) != null && StringUtil.isNotBlank(rot = xfrm.attributeValue("rot"))) {
                try {
                    picture.revolve = Integer.parseInt(rot) / 60000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((extLst = blip.element(QName.get((String)"extLst", (Namespace)a))) == null) continue;
            for (Element ext : extLst.elements()) {
                Element srcUrl = ext.element("picAttrSrcUrl");
                if (srcUrl == null || (rel = relManager.getById(srcUrl.attributeValue(QName.get((String)"id", (Namespace)r)))) == null || !"http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink".equals(rel.getType())) continue;
                picture.srcUrl = rel.getTarget();
            }
        }
        return !pictures.isEmpty() ? pictures : null;
    }

    protected static int[][] parseDimension(Element e, Namespace xdr) {
        Element fromEle = e.element(QName.get((String)"from", (Namespace)xdr));
        int[] f = XMLDrawings.dimEle(fromEle, xdr);
        Element toEle = e.element(QName.get((String)"to", (Namespace)xdr));
        int[] t = XMLDrawings.dimEle(toEle, xdr);
        return new int[][]{f, t};
    }

    protected static int[] dimEle(Element e, Namespace xdr) {
        int c = 0;
        int r = 0;
        int co = 0;
        int ro = 0;
        if (e != null) {
            String col = e.element(QName.get((String)"col", (Namespace)xdr)).getText();
            String colOff = e.element(QName.get((String)"colOff", (Namespace)xdr)).getText();
            String row = e.element(QName.get((String)"row", (Namespace)xdr)).getText();
            String rowOff = e.element(QName.get((String)"rowOff", (Namespace)xdr)).getText();
            c = Integer.parseInt(col);
            r = Integer.parseInt(row);
            co = (int)((double)Integer.parseInt(colOff) / 12700.0 + 0.5);
            ro = (int)((double)Integer.parseInt(rowOff) / 12700.0 + 0.5);
        }
        return new int[]{c, co, r, ro};
    }

    public Map<String, Path> listCellImages(ZipFile zipFile, ZipEntry entry) {
        Element cellImages;
        Document document;
        SAXReader reader = SAXReader.createDefault();
        ZipEntry refEntry = ExcelReader.getEntry(zipFile, "xl/_rels/cellimages.xml.rels");
        if (refEntry == null) {
            return Collections.emptyMap();
        }
        try {
            document = reader.read(zipFile.getInputStream(refEntry));
        }
        catch (IOException | DocumentException e) {
            this.LOGGER.warn("Read [xl/_rels/cellimages.xml.rels] failed.", e);
            return null;
        }
        List list = document.getRootElement().elements();
        Relationship[] rels = new Relationship[list.size()];
        int i = 0;
        for (Element e : list) {
            rels[i++] = new Relationship(e.attributeValue("Id"), e.attributeValue("Target"), e.attributeValue("Type"));
        }
        RelManager relManager = RelManager.of(rels);
        try {
            cellImages = reader.read(zipFile.getInputStream(entry)).getRootElement();
        }
        catch (IOException | DocumentException e) {
            this.LOGGER.warn("Read [xl/cellimages.xml] failed.", e);
            return null;
        }
        List images = cellImages.elements();
        Namespace xdr = cellImages.getNamespaceForPrefix("xdr");
        Namespace a = cellImages.getNamespaceForPrefix("a");
        if (this.excelReader.tempDir == null) {
            try {
                this.excelReader.tempDir = FileUtil.mktmp("eec-");
            }
            catch (IOException e) {
                throw new ExcelReadException("Create temp directory failed.", e);
            }
        }
        HashMap<String, Path> cellImageMapper = new HashMap<String, Path>(images.size());
        for (Element e : images) {
            Element blip;
            Element cNvPr;
            Element nvPicPr;
            Element pic = e.element(QName.get((String)"pic", (Namespace)xdr));
            if (pic == null || (nvPicPr = pic.element(QName.get((String)"nvPicPr", (Namespace)xdr))) == null || (cNvPr = nvPicPr.element(QName.get((String)"cNvPr", (Namespace)xdr))) == null) continue;
            String name = cNvPr.attributeValue("name");
            Element blipFill = pic.element(QName.get((String)"blipFill", (Namespace)xdr));
            if (blipFill == null || (blip = blipFill.element(QName.get((String)"blip", (Namespace)a))) == null) continue;
            Namespace r = blip.getNamespaceForPrefix("r");
            String embed = blip.attributeValue(QName.get((String)"embed", (Namespace)r));
            Relationship rel = relManager.getById(embed);
            if (r == null || !"http://schemas.openxmlformats.org/officeDocument/2006/relationships/image".equals(rel.getType())) continue;
            Path localPath = null;
            entry = ExcelReader.getEntry(zipFile, "xl/" + rel.getTarget());
            if (entry == null) continue;
            try {
                Path targetPath = this.excelReader.tempDir.resolve(rel.getTarget());
                if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(targetPath, new FileAttribute[0]);
                }
                Files.copy(zipFile.getInputStream(entry), targetPath, StandardCopyOption.REPLACE_EXISTING);
                localPath = targetPath;
            }
            catch (IOException ex) {
                this.LOGGER.warn("Copy picture error.", (Throwable)ex);
            }
            cellImageMapper.put(name, localPath);
        }
        return cellImageMapper;
    }

    protected List<Drawings.Picture> quickFindCellImages(Sheet sheet, Map<String, Path> cellImageMapper) throws IOException {
        ArrayList<Drawings.Picture> pictures = new ArrayList<Drawings.Picture>();
        Iterator<Row> iter = sheet.asCalcSheet().load().iterator();
        while (iter.hasNext()) {
            Row row = iter.next();
            int len = row.getLastColumnIndex();
            for (int i = row.getFirstColumnIndex(); i < len; ++i) {
                Path path;
                String formula = row.getFormula(i);
                if (formula == null || !formula.startsWith("_xlfn.DISPIMG(\"") || (path = cellImageMapper.get(formula = formula.substring(15, formula.lastIndexOf(34)))) == null) continue;
                Drawings.Picture pic = new Drawings.Picture();
                pic.sheet = sheet;
                pic.localPath = path;
                pic.dimension = new Dimension(row.getRowNum(), (short)(i + 1), row.getRowNum() + 1, (short)(i + 2));
                pic.padding = new short[]{1, -1, -1, 1};
                pictures.add(pic);
            }
        }
        return pictures;
    }
}

