/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.entity.Comment;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.style.ColorIndex;
import org.ttzero.excel.entity.style.Font;
import org.ttzero.excel.entity.style.Styles;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.reader.ExcelReader;
import org.ttzero.excel.util.ExtBufferedWriter;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={""}, value="comments", uri={"http://schemas.openxmlformats.org/spreadsheetml/2006/main"})
public class Comments
implements Storable,
Closeable {
    public List<C> commentList = new ArrayList<C>();
    public int id;
    public String author;
    protected static final Pr DEFAULT_PR = new Pr("\u5b8b\u4f53", 9);
    protected static final Pr DEFAULT_TITLE_PR = new Pr(new Font("\u5b8b\u4f53", 9, 2, Color.BLACK));

    public Comments(int id) {
        this(id, "-");
    }

    public Comments(int id, String author) {
        this.id = id;
        this.author = author;
    }

    public C addComment(String ref, String title, String value) {
        return this.addComment(ref, new Comment(title, value));
    }

    public C addComment(String ref, Comment comment) {
        C c = new C();
        c.ref = ref;
        c.width = comment.getWidth();
        c.height = comment.getHeight();
        c.style = comment.style;
        boolean hasTitle = StringUtil.isNotEmpty(comment.getTitle());
        boolean hasValue = StringUtil.isNotEmpty(comment.getValue());
        c.nodes = new R[hasTitle && hasValue ? 2 : 1];
        int i = 0;
        if (hasTitle) {
            c.nodes[i++] = this.toR(comment.getTitle(), true, comment.getTitleFont());
        }
        if (hasValue) {
            c.nodes[i] = this.toR(comment.getValue(), false, comment.getValueFont());
        }
        this.commentList.add(c);
        return c;
    }

    public C addComment(int row, int col, String value) {
        return this.addComment(Sheet.toCoordinate(row, col), new Comment(null, value));
    }

    public C addComment(int row, int col, String title, String value) {
        return this.addComment(Sheet.toCoordinate(row, col), new Comment(title, value));
    }

    public C addComment(int row, int col, Comment comment) {
        return this.addComment(Sheet.toCoordinate(row, col), comment);
    }

    protected R toR(String val, boolean isTitle, Font font) {
        R r = new R();
        r.rPr = font == null ? (isTitle ? DEFAULT_TITLE_PR : DEFAULT_PR) : new Pr(font);
        r.t = val;
        return r;
    }

    @Override
    public void close() {
    }

    @Override
    public void writeTo(Path root) throws IOException {
        if (this.commentList.isEmpty()) {
            return;
        }
        try (ExtBufferedWriter writer = new ExtBufferedWriter(Files.newBufferedWriter(root.resolve("comments" + this.id + ".xml"), new OpenOption[0]));){
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            writer.newLine();
            TopNS topNS = this.getClass().getAnnotation(TopNS.class);
            writer.write(60);
            writer.write(topNS.value());
            writer.write(" xmlns=\"");
            writer.write(topNS.uri()[0]);
            writer.write("\"><authors><author>");
            writer.escapeWrite(StringUtil.isNotEmpty(this.author) ? this.author : System.getProperty("user.name"));
            writer.write("</author></authors><commentList>");
            for (C c : this.commentList) {
                writer.write("<comment ref=\"");
                writer.write(c.ref);
                writer.write("\" authorId=\"0\"><text>");
                boolean alf = c.nodes.length == 2;
                for (R r : c.nodes) {
                    writer.write("<r>");
                    writer.write(r.rPr.toString());
                    writer.write("<t");
                    writer.write(alf || r.t.indexOf(10) >= 0 ? " xml:space=\"preserve\">" : ">");
                    writer.escapeWrite(r.t);
                    if (alf) {
                        writer.write(10);
                        alf = false;
                    }
                    writer.write("</t></r>");
                }
                writer.write("</text></comment>");
            }
            writer.write("</commentList></comments>");
        }
        this.vml(root);
    }

    protected void vml(Path root) throws IOException {
        Path parent = root.resolve("drawings");
        if (!Files.exists(parent, new LinkOption[0])) {
            FileUtil.mkdir(parent);
        }
        try (ExtBufferedWriter writer = new ExtBufferedWriter(Files.newBufferedWriter(parent.resolve("vmlDrawing" + this.id + ".vml"), new OpenOption[0]));){
            writer.write("<xml xmlns:v=\"urn:schemas-microsoft-com:vml\"");
            writer.write(" xmlns:o=\"urn:schemas-microsoft-com:office:office\"");
            writer.write(" xmlns:x=\"urn:schemas-microsoft-com:office:excel\">");
            writer.write(" <o:shapelayout v:ext=\"edit\">");
            writer.write("  <o:idmap v:ext=\"edit\" data=\"1\"/>");
            writer.write(" </o:shapelayout>");
            writer.write(" <v:shapetype id=\"_x0000_t202\" coordsize=\"21600,21600\" o:spt=\"202\"");
            writer.write("  path=\"m,l,21600r21600,l21600,xe\">");
            writer.write("  <v:stroke joinstyle=\"miter\"/>");
            writer.write("  <v:path gradientshapeok=\"t\" o:connecttype=\"rect\"/>");
            writer.write(" </v:shapetype>");
            int i = 1;
            for (C c : this.commentList) {
                long cr = ExcelReader.coordinateToLong(c.ref);
                writer.write("<v:shape id=\"_x0000_s");
                writer.writeInt(100 + i);
                writer.write("\" type=\"#_x0000_t202\" style='");
                if (StringUtil.isEmpty(c.style)) {
                    writer.write("width:");
                    writer.write(c.width != null ? c.width : 100.8);
                    writer.write("pt;height:");
                    writer.write(c.height != null ? c.height : 60.6);
                    writer.write("pt;z-index:");
                    writer.writeInt(i++);
                    writer.write(";visibility:hidden");
                } else {
                    writer.write(c.style);
                }
                writer.write("' fillcolor=\"#ffffe1\" o:insetmode=\"auto\">");
                writer.write("<v:shadow on=\"t\" color=\"black\" obscured=\"t\"/>");
                writer.write("<x:ClientData ObjectType=\"Note\">");
                writer.write("<x:Row>");
                writer.write((cr >> 16) - 1L);
                writer.write("</x:Row>");
                writer.write("<x:Column>");
                writer.write((cr & 0x7FFFL) - 1L);
                writer.write("</x:Column>");
                writer.write("</x:ClientData></v:shape>");
            }
            writer.write("</xml>");
        }
    }

    public static Map<Long, Comment> parseComments(InputStream commentEntry, InputStream vmlEntry) throws IOException {
        Comment c;
        if (commentEntry == null) {
            return Collections.emptyMap();
        }
        SAXReader reader = SAXReader.createDefault();
        List comments = null;
        try {
            Document document = reader.read(commentEntry);
            Element commentList = document.getRootElement().element("commentList");
            if (commentList != null) {
                comments = commentList.elements();
            }
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        if (comments == null || comments.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Comment> commentMap = new HashMap<Long, Comment>(comments.size());
        for (Element e : comments) {
            Element text;
            if (!"comment".equals(e.getName()) || (text = e.element("text")) == null || (c = Comments.parseComment(text)) == null) continue;
            commentMap.put(ExcelReader.coordinateToLong(e.attributeValue("ref")), c);
        }
        if (vmlEntry != null) {
            List vmls = null;
            try {
                Document vmlDoc = reader.read(vmlEntry);
                vmls = vmlDoc.getRootElement().elements("shape");
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
            if (vmls != null && !vmls.isEmpty()) {
                for (Element vml : vmls) {
                    Element clientData = vml.element("ClientData");
                    if (clientData == null) continue;
                    String row = clientData.elementText("Row");
                    String col = clientData.elementText("Column");
                    long k = Long.parseLong(col) + 1L & 0x7FFFL | Long.parseLong(row) + 1L << 16;
                    c = (Comment)commentMap.get(k);
                    if (c == null) continue;
                    c.style = vml.attributeValue("style");
                }
            }
        }
        return commentMap;
    }

    static Comment parseComment(Element text) {
        boolean h0;
        List rs = text.elements("r");
        if (rs == null || rs.isEmpty()) {
            return null;
        }
        Comment c = new Comment();
        Element r0 = (Element)rs.get(0);
        Font f0 = Comments.parseFont(r0.element("rPr"));
        boolean bl = h0 = f0 != null && f0.isBold();
        if (h0) {
            c.setTitleFont(f0);
            String v0 = r0.elementText("t");
            c.setTitle(StringUtil.isNotEmpty(v0) && v0.charAt(v0.length() - 1) == '\n' ? v0.substring(0, v0.length() - 1) : v0);
        }
        if (rs.size() > 1 || !h0) {
            int i;
            StringBuilder buf = new StringBuilder();
            int n = i = h0 ? 1 : 0;
            while (i < rs.size()) {
                Element t = (Element)rs.get(i);
                String txt = t.elementText("t");
                if (h0 && i == 1 && StringUtil.isNotEmpty(txt) && txt.charAt(0) == '\n') {
                    txt = txt.substring(1);
                }
                buf.append(txt);
                Font f1 = Comments.parseFont(t.element("rPr"));
                if (f1 != null) {
                    c.setValueFont(f1);
                }
                ++i;
            }
            c.setValue(buf.toString());
        }
        return c;
    }

    static Font parseFont(Element rPr) {
        if (rPr == null) {
            return null;
        }
        Font font = Font.parseFontTag(rPr);
        font.setName(Styles.getAttr(rPr.element("rFont"), "val"));
        return font;
    }

    public static class Pr
    extends Font {
        public static final String[] STYLE = new String[]{"", "<u/>", "<b/>", "<u/><b/>", "<i/>", "<i/><u/>", "<b/><i/>", "<i/><b/><u/>"};

        public Pr(String name, int size) {
            super(name, size);
        }

        public Pr(Font font) {
            super(font);
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder("<rPr>");
            if (this.getStyle() > 0 && this.getStyle() < 8) {
                buf.append(STYLE[this.getStyle() & 7]);
            }
            buf.append("<rFont val=\"").append(this.getName()).append("\"/>");
            buf.append("<sz val=\"").append(this.getSize()).append("\"/>");
            if (this.getCharset() > 0) {
                buf.append("<charset val=\"").append(this.getCharset()).append("\"/>");
            }
            if (this.getColor() != null) {
                buf.append("<color rgb=\"").append(ColorIndex.toARGB(this.getColor().getRGB())).append("\"/>");
            }
            if (this.getFamily() > 0) {
                buf.append("<family val=\"").append(this.getFamily()).append("\"/>");
            }
            buf.append("</rPr>");
            return buf.toString();
        }
    }

    public static class R {
        public Pr rPr;
        public String t;

        public String toString() {
            return "<r>" + this.rPr + "<t" + (this.t.indexOf(10) > 0 ? " xml:space=\"preserve\">" : ">") + this.t + "</t></r>";
        }
    }

    public static class C {
        public String ref;
        public String style;
        public R[] nodes;
        public Double width;
        public Double height;

        public String toString() {
            StringBuilder buf = new StringBuilder("<comment ref=\"").append(this.ref).append("\" authorId=\"0\"><text>");
            for (R r : this.nodes) {
                buf.append(r);
            }
            buf.append("</text>").append("</comment>");
            return buf.toString();
        }
    }
}

