/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.ttzero.excel.entity.IWorksheetWriter;
import org.ttzero.excel.entity.Sheet;
import org.ttzero.excel.entity.Storable;
import org.ttzero.excel.entity.Workbook;
import org.ttzero.excel.util.FileUtil;
import org.ttzero.excel.util.StringUtil;

public interface IWorkbookWriter
extends Storable,
Closeable {
    public void setWorkbook(Workbook var1);

    public String getSuffix();

    public void writeTo(OutputStream var1) throws IOException;

    public void writeTo(File var1) throws IOException;

    public IWorksheetWriter getWorksheetWriter(Sheet var1);

    default public Path reMarkPath(Path src, Path rootPath, String fileName) throws IOException {
        String suffix = this.getSuffix();
        Path o = rootPath.resolve(fileName + suffix);
        if (FileUtil.exists(o)) {
            String fname = fileName;
            Path parent = o.getParent();
            if (parent != null && FileUtil.exists(parent)) {
                String new_name;
                String[] os = parent.toFile().list((dir, name) -> new File(dir, name).isFile() && name.startsWith(fname) && name.endsWith(suffix));
                if (os != null) {
                    int n;
                    int len = os.length;
                    while ((n = StringUtil.indexOf(os, new_name = fname + " (" + len++ + ")" + suffix)) > -1) {
                    }
                } else {
                    new_name = fname + suffix;
                }
                o = parent.resolve(new_name);
            } else {
                Files.move(src, o, StandardCopyOption.REPLACE_EXISTING);
                return o;
            }
        }
        Files.move(src, o, new CopyOption[0]);
        return o;
    }

    public static Properties pom() {
        Properties pom = new Properties();
        try {
            URL url;
            InputStream is = IWorkbookWriter.class.getClassLoader().getResourceAsStream("META-INF/maven/org.ttzero/eec/pom.properties");
            if (is == null && (url = IWorkbookWriter.class.getClassLoader().getResource(".")) != null) {
                Path targetPath = (FileUtil.isWindows() ? Paths.get(url.getFile().substring(1), new String[0]) : Paths.get(url.getFile(), new String[0])).getParent();
                Path pomPath = targetPath.resolve("maven-archiver/pom.properties");
                if (FileUtil.exists(pomPath)) {
                    is = Files.newInputStream(pomPath, new OpenOption[0]);
                } else {
                    pomPath = targetPath.getParent().resolve("pom.xml");
                    SAXReader reader = SAXReader.createDefault();
                    try {
                        Document document = reader.read(Files.newInputStream(pomPath, new OpenOption[0]));
                        Element pomRoot = document.getRootElement();
                        pom.setProperty("groupId", pomRoot.elementText("groupId"));
                        pom.setProperty("artifactId", pomRoot.elementText("artifactId"));
                        pom.setProperty("version", pomRoot.elementText("version"));
                    }
                    catch (IOException | DocumentException throwable) {
                        // empty catch block
                    }
                }
            }
            if (is != null) {
                pom.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtil.isEmpty(pom.getProperty("version"))) {
            pom.setProperty("groupId", "org.ttzero");
            pom.setProperty("artifactId", "eec");
            pom.setProperty("version", "1.0.0");
        }
        return pom;
    }
}

