/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.ttzero.excel.entity.Column;
import org.ttzero.excel.entity.ExcelWriteException;
import org.ttzero.excel.entity.ListSheet;
import org.ttzero.excel.entity.Row;
import org.ttzero.excel.entity.RowBlock;
import org.ttzero.excel.entity.WaterMark;
import org.ttzero.excel.reader.Cell;
import org.ttzero.excel.reader.Grid;
import org.ttzero.excel.reader.GridFactory;
import org.ttzero.excel.util.StringUtil;

public class ListMapSheet<T>
extends ListSheet<Map<String, T>> {
    public ListMapSheet() {
    }

    public ListMapSheet(String name) {
        super(name);
    }

    public ListMapSheet(Column ... columns) {
        super(columns);
    }

    public ListMapSheet(String name, Column ... columns) {
        super(name, columns);
    }

    public ListMapSheet(String name, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
    }

    public ListMapSheet(List<Map<String, T>> data) {
        this((String)null, data);
    }

    public ListMapSheet(String name, List<Map<String, T>> data) {
        super(name);
        this.setData(data);
    }

    public ListMapSheet(List<Map<String, T>> data, Column ... columns) {
        this((String)null, data, columns);
    }

    public ListMapSheet(String name, List<Map<String, T>> data, Column ... columns) {
        this(name, data, (WaterMark)null, columns);
    }

    public ListMapSheet(List<Map<String, T>> data, WaterMark waterMark, Column ... columns) {
        this((String)null, data, waterMark, columns);
    }

    public ListMapSheet(String name, List<Map<String, T>> data, WaterMark waterMark, Column ... columns) {
        super(name, waterMark, columns);
        this.setData(data);
    }

    @Override
    protected void resetBlockData() {
        boolean hasGlobalStyleProcessor;
        if (!this.eof && this.left() < this.rowBlock.capacity()) {
            this.append();
        }
        int end = this.getEndIndex();
        int len = this.columns.length;
        boolean bl = hasGlobalStyleProcessor = (this.extPropMark & 2) == 2;
        while (this.start < end) {
            Row row = this.rowBlock.next();
            row.index = this.rows;
            row.height = this.getRowHeight();
            Cell[] cells = row.realloc(len);
            Map rowDate = (Map)this.data.get(this.start);
            for (int i = 0; i < len; ++i) {
                Column hc = this.columns[i];
                Object e = rowDate != null ? (Object)rowDate.get(hc.key) : null;
                Cell cell = cells[i];
                cell.clear();
                if (e != null && e.getClass() != hc.getClazz()) {
                    hc.setClazz(e.getClass());
                }
                this.cellValueAndStyle.reset(row, cell, e, hc);
                if (!hasGlobalStyleProcessor) continue;
                this.cellValueAndStyle.setStyleDesign(rowDate, cell, hc, this.getStyleProcessor());
            }
            ++this.rows;
            ++this.start;
        }
    }

    @Override
    protected Column[] getHeaderColumns() {
        if (this.headerReady) {
            return this.columns;
        }
        Map first = (Map)this.getFirst();
        if (first == null) {
            if (this.columns == null) {
                this.columns = new Column[0];
            }
        } else if (!this.hasHeaderColumns()) {
            int size = first.size();
            int i = 0;
            this.columns = new Column[size];
            for (Map.Entry entry : first.entrySet()) {
                Column hc = this.createColumn(entry);
                if (hc == null) continue;
                this.columns[i++] = hc;
            }
            if (i < size) {
                this.columns = Arrays.copyOf(this.columns, i);
            }
        } else {
            for (int i = 0; i < this.columns.length; ++i) {
                Column hc = this.columns[i].getTail();
                boolean emptyKey = StringUtil.isEmpty(hc.key);
                boolean emptyName = StringUtil.isEmpty(hc.name);
                if (emptyKey && emptyName) {
                    throw new ExcelWriteException(this.getClass() + " must specify the 'key' name.");
                }
                if (emptyKey) {
                    hc.key = hc.name;
                } else if (emptyName) {
                    hc.name = hc.key;
                }
                if (hc.getClazz() != null) continue;
                Object o = first.get(hc.key);
                hc.setClazz(o != null ? o.getClass() : String.class);
            }
        }
        return this.columns;
    }

    protected Column createColumn(Map.Entry<String, T> entry) {
        T value;
        if (StringUtil.isEmpty(entry.getKey())) {
            return null;
        }
        return new Column(entry.getKey(), entry.getKey(), (value = entry.getValue()) != null ? value.getClass() : String.class);
    }

    @Override
    protected void mergeHeaderCellsIfEquals() {
        super.mergeHeaderCellsIfEquals();
        List existsMergeCells = (List)this.getExtPropValue("merge_cells");
        if (existsMergeCells != null) {
            Grid grid = GridFactory.create(existsMergeCells);
            for (Column col : this.columns) {
                if (!StringUtil.isEmpty(col.key) || !grid.test(1, col.realColIndex)) continue;
                Column next = col.next;
                while (next != null && StringUtil.isEmpty(next.key)) {
                    next = next.next;
                }
                if (next == null) continue;
                col.key = next.key;
            }
        }
    }

    @Override
    public RowBlock nextBlock() {
        this.rowBlock.clear();
        this.resetBlockData();
        return this.rowBlock.flip();
    }
}

