/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.hash;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Predicate;
import org.ttzero.excel.hash.LockFreeBitArray;
import org.ttzero.excel.hash.Murmur3_128Hasher;

public final class StringBloomFilter
implements Predicate<String>,
Serializable {
    private final LockFreeBitArray bits;
    private final int numHashFunctions;
    private final Charset charset;
    private final Strategy strategy;

    @Override
    public boolean test(String t) {
        return this.mightContain(t);
    }

    private StringBloomFilter(LockFreeBitArray bits, int numHashFunctions, Charset charset, Strategy strategy) {
        this.bits = bits;
        this.numHashFunctions = numHashFunctions;
        this.charset = charset;
        this.strategy = strategy;
    }

    public StringBloomFilter copy() {
        return new StringBloomFilter(this.bits.copy(), this.numHashFunctions, this.charset, this.strategy);
    }

    public boolean mightContain(String object) {
        return this.strategy.mightContain(object, this.charset, this.numHashFunctions, this.bits);
    }

    public boolean put(String object) {
        return this.strategy.put(object, this.charset, this.numHashFunctions, this.bits);
    }

    public void putAll(StringBloomFilter that) {
        this.bits.putAll(that.bits);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StringBloomFilter) {
            StringBloomFilter that = (StringBloomFilter)object;
            return this.numHashFunctions == that.numHashFunctions && this.charset.equals(that.charset) && this.bits.equals(that.bits) && this.strategy.equals(that.strategy);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.numHashFunctions, this.charset, this.strategy, this.bits});
    }

    public static StringBloomFilter create(long expectedInsertions, double fpp) {
        return StringBloomFilter.create(StandardCharsets.UTF_8, expectedInsertions, fpp);
    }

    public static StringBloomFilter create(Charset charset, long expectedInsertions, double fpp) {
        if (expectedInsertions == 0L) {
            expectedInsertions = 1L;
        }
        long numBits = StringBloomFilter.optimalNumOfBits(expectedInsertions, fpp);
        int numHashFunctions = StringBloomFilter.optimalNumOfHashFunctions(expectedInsertions, numBits);
        try {
            return new StringBloomFilter(new LockFreeBitArray(numBits), numHashFunctions, charset, new Strategy());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Could not create BloomFilter of " + numBits + " bits", e);
        }
    }

    static int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    static long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    static class Strategy {
        private final Murmur3_128Hasher hasher = new Murmur3_128Hasher(0);

        Strategy() {
        }

        public boolean put(String object, Charset charset, int numHashFunctions, LockFreeBitArray bits) {
            long bitSize = bits.bitSize();
            byte[] bytes = this.hasher.clear().putBytes(object.getBytes(charset)).hash();
            long hash1 = Strategy.fromBytes(bytes[7], bytes[6], bytes[5], bytes[4], bytes[3], bytes[2], bytes[1], bytes[0]);
            long hash2 = Strategy.fromBytes(bytes[15], bytes[14], bytes[13], bytes[12], bytes[11], bytes[10], bytes[9], bytes[8]);
            boolean bitsChanged = false;
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                bitsChanged |= bits.set((combinedHash & Long.MAX_VALUE) % bitSize);
                combinedHash += hash2;
            }
            return bitsChanged;
        }

        public boolean mightContain(String object, Charset charset, int numHashFunctions, LockFreeBitArray bits) {
            long bitSize = bits.bitSize();
            byte[] bytes = this.hasher.clear().putBytes(object.getBytes(charset)).hash();
            long hash1 = Strategy.fromBytes(bytes[7], bytes[6], bytes[5], bytes[4], bytes[3], bytes[2], bytes[1], bytes[0]);
            long hash2 = Strategy.fromBytes(bytes[15], bytes[14], bytes[13], bytes[12], bytes[11], bytes[10], bytes[9], bytes[8]);
            long combinedHash = hash1;
            for (int i = 0; i < numHashFunctions; ++i) {
                if (!bits.get((combinedHash & Long.MAX_VALUE) % bitSize)) {
                    return false;
                }
                combinedHash += hash2;
            }
            return true;
        }

        public static long fromBytes(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
            return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
        }
    }
}

