/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.manager.docProps;

import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.ttzero.excel.manager.TopNS;
import org.ttzero.excel.manager.docProps.XmlEntity;
import org.ttzero.excel.util.StringUtil;

@TopNS(prefix={"", "vt"}, uri={"http://schemas.openxmlformats.org/officeDocument/2006/extended-properties", "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes"}, value="Properties")
public class App
extends XmlEntity {
    private String application;
    private boolean scaleCrop;
    private String company;
    private boolean linksUpToDate;
    private boolean sharedDoc;
    private boolean hyperlinksChanged;
    private String appVersion;
    private List<String> titlesOfParts;

    public void setTitlePards(List<String> list) {
        this.titlesOfParts = list;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public void setScaleCrop(boolean scaleCrop) {
        this.scaleCrop = scaleCrop;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setLinksUpToDate(boolean linksUpToDate) {
        this.linksUpToDate = linksUpToDate;
    }

    public void setSharedDoc(boolean sharedDoc) {
        this.sharedDoc = sharedDoc;
    }

    public void setHyperlinksChanged(boolean hyperlinksChanged) {
        this.hyperlinksChanged = hyperlinksChanged;
    }

    public void setAppVersion(String appVersion) {
        if (StringUtil.isEmpty(appVersion)) {
            this.appVersion = "1.0.0";
        } else {
            char[] chars = appVersion.toCharArray();
            int i = 0;
            int n = 0;
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] >= '0' && chars[j] <= '9') {
                    chars[i++] = chars[j];
                    continue;
                }
                if (chars[j] != '.' || i <= 0 || chars[i - 1] == '.' || n >= 2) break;
                chars[i++] = chars[j];
                ++n;
            }
            this.appVersion = i > 0 ? new String(chars, 0, chars[i - 1] != '.' ? i : i - 1) : "1.0.0";
        }
    }

    public String getApplication() {
        return this.application;
    }

    public String getCompany() {
        return this.company;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    @Override
    void toDom(Element rootElement, Map<String, Namespace> namespaceMap) {
        rootElement.addElement("Application").addText(this.application);
        rootElement.addElement("AppVersion").addText(this.appVersion);
        if (this.company != null) {
            rootElement.addElement("Company").addText(this.company);
        }
        rootElement.addElement("DocSecurity").addText("0");
        rootElement.addElement("ScaleCrop").addText(Boolean.toString(this.scaleCrop));
        rootElement.addElement("LinksUpToDate").addText(Boolean.toString(this.linksUpToDate));
        rootElement.addElement("SharedDoc").addText(Boolean.toString(this.sharedDoc));
        rootElement.addElement("HyperlinksChanged").addText(Boolean.toString(this.hyperlinksChanged));
        Element titleVector = rootElement.addElement("TitlesOfParts").addElement(QName.get((String)"vector", (Namespace)namespaceMap.get("vt")));
        titleVector.addAttribute("size", Integer.toString(this.titlesOfParts.size())).addAttribute("baseType", "lpstr");
        for (String title : this.titlesOfParts) {
            titleVector.addElement(QName.get((String)"lpstr", (Namespace)namespaceMap.get("vt"))).addText(title);
        }
        Element hpVector = rootElement.addElement("HeadingPairs").addElement(QName.get((String)"vector", (Namespace)namespaceMap.get("vt")));
        hpVector.addAttribute("size", "2").addAttribute("baseType", "variant");
        hpVector.addElement(QName.get((String)"variant", (Namespace)namespaceMap.get("vt"))).addElement(QName.get((String)"lpstr", (Namespace)namespaceMap.get("vt"))).addText("\u5de5\u4f5c\u8868");
        hpVector.addElement(QName.get((String)"variant", (Namespace)namespaceMap.get("vt"))).addElement(QName.get((String)"i4", (Namespace)namespaceMap.get("vt"))).addText(Integer.toString(this.titlesOfParts.size()));
    }
}

