/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.util;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSignatures {
    static final Logger LOGGER = LoggerFactory.getLogger(FileSignatures.class);
    public static Map<String, String> whitelist = new HashMap<String, String>(){
        {
            this.put("png", "image/png");
            this.put("jpg", "image/jpg");
            this.put("gif", "image/gif");
            this.put("tiff", "image/tiff");
            this.put("bmp", "image/bmp");
            this.put("ico", "image/x-ico");
            this.put("tif", "image/tiff");
            this.put("emf", "image/x-emf");
            this.put("wmf", "image/x-wmf");
            this.put("webp", "image/webp");
        }
    };

    private FileSignatures() {
    }

    public static Signature test(Path path) {
        Signature signature = null;
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            byte[] bytes = new byte[512];
            int n = is.read(bytes);
            signature = FileSignatures.test(ByteBuffer.wrap(bytes, 0, n));
        }
        catch (Exception ex) {
            LOGGER.warn("Test file signature occur error.", (Throwable)ex);
        }
        if (signature == null) {
            String name = path.getFileName().toString();
            int i = name.lastIndexOf(46);
            String uncertainExtensionName = i > 0 && i < name.length() - 1 ? name.substring(i + 1) : "unknown";
            signature = new Signature(uncertainExtensionName, whitelist.getOrDefault(uncertainExtensionName, "image/unknown"), 0, 0);
        }
        return signature;
    }

    public static Signature test(ByteBuffer buffer) {
        if (buffer.remaining() < 32) {
            return null;
        }
        int t0 = buffer.getShort() & 0xFFFF;
        String extension = null;
        int width = 0;
        int height = 0;
        if (t0 == 65496) {
            extension = "jpg";
            while (buffer.remaining() >= 4) {
                int t1 = buffer.getShort() & 0xFFFF;
                int n = buffer.getShort() & 0xFFFF;
                if (t1 == 65472) {
                    if (buffer.remaining() >= 5) {
                        buffer.get();
                        height = buffer.getShort() & 0xFFFF;
                        width = buffer.getShort() & 0xFFFF;
                    }
                } else if (buffer.remaining() >= n) {
                    buffer.position(buffer.position() + n - 2);
                    continue;
                }
                break;
            }
        } else if (t0 == 16973) {
            extension = "bmp";
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.position(buffer.position() + 16);
            width = buffer.getInt();
            height = buffer.getInt();
        }
        if (extension != null) {
            return new Signature(extension, whitelist.getOrDefault(extension, "image/unknown"), width, height);
        }
        buffer.position(0);
        t0 = buffer.getInt();
        switch (t0) {
            case -1991225785: {
                int t1 = buffer.getInt();
                if (t1 != 218765834) break;
                extension = "png";
                buffer.getLong();
                width = buffer.getInt();
                height = buffer.getInt();
                break;
            }
            case 1229531648: {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            case 1296891946: 
            case 1296891947: {
                return FileSignatures.tiff(buffer);
            }
            case 1195984440: {
                extension = "gif";
                buffer.getShort();
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                width = buffer.getShort() & 0xFFFF;
                height = buffer.getShort() & 0xFFFF;
                break;
            }
            case 256: {
                extension = "ico";
                buffer.getShort();
                byte v = buffer.get();
                width = v != 0 ? v & 0xFF : 256;
                v = buffer.get();
                height = v != 0 ? v & 0xFF : 256;
                break;
            }
            case 0x1000000: {
                extension = "emf";
                buffer.getInt();
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int left = buffer.getInt();
                int top = buffer.getInt();
                int right = buffer.getInt();
                int bottom = buffer.getInt();
                width = Math.max(0, right - left + 1);
                height = Math.max(0, bottom - top + 1);
                break;
            }
            case -674380134: 
            case 0x1000900: {
                extension = "wmf";
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                buffer.getShort();
                int left = buffer.getShort() & 0xFFFF;
                int top = buffer.getShort() & 0xFFFF;
                int right = buffer.getShort() & 0xFFFF;
                int bottom = buffer.getShort() & 0xFFFF;
                int inch = buffer.getShort() & 0xFFFF;
                double coeff = inch > 0 ? 72.0 / (double)inch : 1.0;
                width = (int)Math.round((double)(right - left) * coeff);
                height = (int)Math.round((double)(bottom - top) * coeff);
                break;
            }
            case 1380533830: {
                extension = "webp";
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int size = buffer.getInt();
                int x = 1346520407;
                if (buffer.getInt() != x) break;
                int chunkType = buffer.getInt();
                int blockSize = buffer.getInt();
                switch (chunkType) {
                    case 540561494: {
                        int tmp = buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 16;
                        tmp = buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 16;
                        if (tmp != 2752925) break;
                        width = buffer.getShort() & 0x3FFF;
                        height = buffer.getShort() & 0x3FFF;
                        break;
                    }
                    case 1480085590: {
                        buffer.getInt();
                        width = 1 + (buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 16);
                        height = 1 + (buffer.get() & 0xFF | (buffer.get() & 0xFF) << 8 | (buffer.get() & 0xFF) << 16);
                    }
                }
                break;
            }
        }
        if (extension != null) {
            return new Signature(extension, whitelist.getOrDefault(extension, "image/unknown"), width, height);
        }
        return null;
    }

    public static Signature tiff(ByteBuffer buffer) {
        int t1;
        int width = 0;
        int height = 0;
        block0: while (buffer.hasRemaining() && (t1 = buffer.getInt()) != 0 && t1 < buffer.limit()) {
            buffer.position(t1);
            int n = buffer.getShort();
            for (int i = 0; i < n; ++i) {
                short tag = buffer.getShort();
                if (tag == 256) {
                    buffer.position(buffer.position() + 6);
                    width = buffer.getInt();
                    continue;
                }
                if (tag == 257) {
                    buffer.position(buffer.position() + 6);
                    height = buffer.getInt();
                    break block0;
                }
                buffer.position(buffer.position() + 10);
            }
        }
        return new Signature("tiff", whitelist.getOrDefault("tiff", "image/unknown"), width, height);
    }

    public static class Signature {
        public int width;
        public int height;
        public String contentType;
        public String extension;

        public String toString() {
            return this.extension + "(" + this.contentType + "): " + this.width + "x" + this.height;
        }

        public Signature(String extension, String contentType) {
            this(extension, contentType, 0, 0);
        }

        public Signature(String extension, String contentType, int width, int height) {
            this.extension = extension;
            this.contentType = contentType;
            this.width = width;
            this.height = height;
        }

        public boolean isTrusted() {
            return this.extension != null && this.contentType != null && whitelist.containsKey(this.extension) && !"image/unknown".equals(this.contentType);
        }
    }
}

