/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.validation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.validation.Validation;

public class ListValidation<T>
extends Validation {
    public List<T> options;
    public Dimension referer;

    public ListValidation<T> in(List<T> options) {
        this.options = options;
        return this;
    }

    @SafeVarargs
    public final ListValidation<T> in(T ... options) {
        this.options = Arrays.asList(options);
        return this;
    }

    public ListValidation<T> in(Dimension referer) {
        this.referer = referer;
        return this;
    }

    public ListValidation<T> in(String otherSheetName, Dimension referer) {
        this.otherSheetName = otherSheetName;
        this.referer = referer;
        return this;
    }

    @Override
    public String getType() {
        return "list";
    }

    @Override
    public String validationFormula() {
        String val = this.isExtension() ? "<x14:formula1><xm:f>" + this.otherSheetName + "!" + this.referer.toReferer() + "</xm:f></x14:formula1><xm:sqref>" + this.sqref + "</xm:sqref>" : (this.options != null ? "<formula1>\"" + this.options.stream().map(String::valueOf).collect(Collectors.joining(",")) + "\"</formula1>" : (this.referer != null ? "<formula1>" + this.referer.toReferer() + "</formula1>" : "<formula1>\"\"</formula1>"));
        return val;
    }
}

