/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.validation;

import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.validation.Validation;

public abstract class Tuple2Validation<V1, V2>
extends Validation {
    public V1 v1;
    public V2 v2;

    public Tuple2Validation<V1, V2> equal(V1 v1) {
        this.operator = Validation.Operator.equal;
        this.v1 = v1;
        return this;
    }

    public Tuple2Validation<V1, V2> nowEqual(V1 v1) {
        this.operator = Validation.Operator.notEqual;
        this.v1 = v1;
        return this;
    }

    public Tuple2Validation<V1, V2> greaterThan(V1 v1) {
        this.operator = Validation.Operator.greaterThan;
        this.v1 = v1;
        return this;
    }

    public Tuple2Validation<V1, V2> greaterThanOrEqual(V1 v1) {
        this.operator = Validation.Operator.greaterThanOrEqual;
        this.v1 = v1;
        return this;
    }

    public Tuple2Validation<V1, V2> lessThan(V2 v2) {
        this.operator = Validation.Operator.lessThan;
        this.v2 = v2;
        return this;
    }

    public Tuple2Validation<V1, V2> lessThanOrEqual(V2 v2) {
        this.operator = Validation.Operator.lessThanOrEqual;
        this.v2 = v2;
        return this;
    }

    public Tuple2Validation<V1, V2> between(V1 v1, V2 v2) {
        this.operator = Validation.Operator.between;
        this.v1 = v1;
        this.v2 = v2;
        return this;
    }

    public Tuple2Validation<V1, V2> notBetween(V1 v1, V2 v2) {
        this.operator = Validation.Operator.notBetween;
        this.v1 = v1;
        this.v2 = v2;
        return this;
    }

    @Override
    public String validationFormula() {
        String v;
        boolean b2;
        boolean ext = this.isExtension();
        boolean b1 = this.v1 != null && this.v1 instanceof Dimension;
        boolean bl = b2 = this.v2 != null && this.v2 instanceof Dimension;
        if (ext && !b1 && !b2) {
            throw new IllegalArgumentException("Extension validation must setting dimension values");
        }
        if (this.operator == null) {
            this.operator = Validation.Operator.between;
        }
        switch (this.operator) {
            case equal: 
            case notEqual: 
            case greaterThan: 
            case greaterThanOrEqual: {
                v = ext && b1 ? "<x14:formula1><xm:f>" + this.otherSheetName + ":" + ((Dimension)this.v1).toReferer() + " </xm:f></x14:formula1>" : "<formula1>" + this.v1 + "</formula1>";
                break;
            }
            case lessThan: 
            case lessThanOrEqual: {
                v = ext && b2 ? "<x14:formula1><xm:f>" + this.otherSheetName + ":" + ((Dimension)this.v2).toReferer() + " </xm:f></x14:formula1>" : "<formula1>" + this.v2 + "</formula1>";
                break;
            }
            default: {
                String string = v = ext ? "<x14:formula1><xm:f>" + this.otherSheetName + ":" + ((Dimension)this.v1).toReferer() + " </xm:f></x14:formula1><x14:formula2><xm:f>" + this.otherSheetName + ":" + ((Dimension)this.v2).toReferer() + " </xm:f></x14:formula2>" : "<formula1>" + this.v1 + "</formula1><formula2>" + this.v2 + "</formula2>";
            }
        }
        if (ext) {
            v = v + "<xm:sqref>" + this.sqref + "</xm:sqref>";
        }
        return v;
    }
}

