/*
 * Decompiled with CFR 0.152.
 */
package org.ttzero.excel.validation;

import org.ttzero.excel.reader.Dimension;
import org.ttzero.excel.util.StringUtil;

public abstract class Validation {
    public boolean allowBlank = true;
    public boolean showInputMessage = true;
    public boolean showErrorMessage = true;
    public Dimension sqref;
    public Operator operator;
    public String otherSheetName;

    public abstract String getType();

    public abstract String validationFormula();

    public boolean isExtension() {
        return StringUtil.isNotEmpty(this.otherSheetName);
    }

    public Validation dimension(Dimension sqref) {
        this.sqref = sqref;
        return this;
    }

    public String toString() {
        return "<" + (this.isExtension() ? "x14:" : "") + "dataValidation type=\"" + this.getType() + (this.operator == null || this.operator == Operator.between ? "" : "\" operator=\"" + (Object)((Object)this.operator)) + "\" allowBlank=\"" + (this.allowBlank ? 1 : 0) + "\" showInputMessage=\"" + (this.showInputMessage ? 1 : 0) + "\" showErrorMessage=\"" + (this.showErrorMessage ? 1 : 0) + (this.isExtension() ? "\">" : "\" sqref=\"" + this.sqref + "\">") + this.validationFormula() + "</" + (this.isExtension() ? "x14:" : "") + "dataValidation>";
    }

    public static enum Operator {
        between,
        notBetween,
        equal,
        notEqual,
        greaterThan,
        lessThan,
        greaterThanOrEqual,
        lessThanOrEqual;

    }
}

